/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repui.RepMainFrame;
import ch.steph.reputil.CopyUtil;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptDir
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> language;
    private JTextField dataDir;
    private JButton templButton;
    private JCheckBox overwriteTemplates;
    private JTextField backupDir;

    public OptDir(KeyListener keyListener) {
        Object object;
        Log.write(4, this.getClass().getName(), "start");
        this.addKeyListener(keyListener);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        this.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        JLabel jLabel = new JLabel(" " + StringResource.getString("option_language") + " ");
        jPanel.add(jLabel);
        this.language = new JComboBox();
        this.language.addItem(StringResource.getString("option_lang_de"));
        this.language.addItem(StringResource.getString("option_lang_en"));
        try {
            object = User.instance().getProperty("Language", Locale.getDefault().getLanguage());
            if (((String)object).equals(Locale.ENGLISH.getLanguage())) {
                this.language.setSelectedIndex(1);
            } else {
                this.language.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        jPanel.add(this.language);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.language.addKeyListener(keyListener);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jLabel = new JLabel(" ");
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 0, 0));
        jLabel = new JLabel(" ");
        jPanel.add(jLabel);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 2));
        object = this.getFontMetrics(this.getFont());
        Object object2 = StringResource.getString("option_data_dir");
        String string = StringResource.getString("option_backup_dir");
        int n = ((FontMetrics)object).stringWidth((String)object2);
        int n2 = ((FontMetrics)object).stringWidth(string);
        while (n < n2) {
            object2 = (String)object2 + " ";
            n = ((FontMetrics)object).stringWidth((String)object2);
        }
        jLabel = new JLabel((String)object2);
        jPanel.add(jLabel);
        this.dataDir = new JTextField("", 22);
        this.dataDir.setEditable(false);
        this.dataDir.setText(GetDataFile.getDataPath());
        this.dataDir.addKeyListener(keyListener);
        jPanel.add(this.dataDir);
        JButton jButton = new JButton(StringResource.getString("button_search_dir"));
        jButton.addActionListener(actionEvent -> this.buttonDataAction());
        jButton.addKeyListener(keyListener);
        jPanel.add(jButton);
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 5, 2));
        jLabel = new JLabel(string);
        jPanel.add(jLabel);
        this.backupDir = new JTextField("", 22);
        this.backupDir.setText(User.instance().getProperty("DataBackup", ""));
        this.backupDir.addKeyListener(keyListener);
        jPanel.add(this.backupDir);
        jButton = new JButton(StringResource.getString("button_search_dir"));
        jButton.addActionListener(actionEvent -> this.buttonBackupAction());
        jButton.addKeyListener(keyListener);
        jPanel.add(jButton);
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jLabel = new JLabel(" ");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        jPanel = new JPanel();
        jPanel.add(new JLabel(StringResource.getString("button_between_middle")));
        this.templButton = new JButton(StringResource.getString("button_copy_template"));
        this.templButton.addActionListener(actionEvent -> this.copyTemplateAction());
        this.templButton.addKeyListener(keyListener);
        jPanel.add(this.templButton);
        this.overwriteTemplates = new JCheckBox(StringResource.getString("option_overwrite") + "  " + StringResource.getString("second_wait"));
        this.overwriteTemplates.setSelected(false);
        jPanel.add(this.overwriteTemplates);
        this.overwriteTemplates.addKeyListener(keyListener);
        jPanel.add(new JLabel(StringResource.getString("button_between_middle")));
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel.addKeyListener(keyListener);
        jLabel = new JLabel(" ");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        jLabel = new JLabel(" ");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        jLabel = new JLabel(" ");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        jPanel = new JPanel();
        JButton jButton2 = new JButton("Daten-Verzeichnis \u00f6ffnen");
        jButton2.addActionListener(actionEvent -> this.dataDirAction());
        jButton2.addKeyListener(keyListener);
        jPanel.add(jButton2);
        jPanel.add(new JLabel(StringResource.getString("button_between_middle")));
        jButton2 = new JButton("Einstellungs-Verzeichnis \u00f6ffnen");
        jButton2.addActionListener(actionEvent -> this.propDirAction());
        jButton2.addKeyListener(keyListener);
        jPanel.add(jButton2);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.setTemplButtonText();
    }

    private void setTemplButtonText() {
        if (this.dataDir.getText().length() > 0) {
            this.templButton.setText(StringResource.getString("button_copy_template"));
        } else {
            this.templButton.setText(StringResource.getString("button_copy_datadir"));
        }
    }

    protected void copyTemplateAction() {
        User.instance().setProperty("overwriteTemplates", this.overwriteTemplates.isSelected());
        if (this.dataDir.getText().length() > 0) {
            GetDataFile.setDataPath(this.dataDir.getText());
            String string = GetDataFile.getDataPath();
            this.dataDir.setText(string);
            CopyUtil.copyListToExt(string);
        } else {
            String string = FileProcedures.addDirName(System.getProperty("user.home"), "jRepData");
            FileProcSync.makeDir(string);
            if (FileProcedures.exists(string)) {
                GetDataFile.setDataPath(string);
                string = GetDataFile.getDataPath();
                this.dataDir.setText(string);
                this.setTemplButtonText();
            } else {
                JOptionPane.showInternalMessageDialog(RepMainFrame.getRepInstance().getDesktop(), StringResource.getString("option_data_remark"), "jRep  " + StringResource.getString("button_copy_template"), 1);
            }
        }
        User.instance().setProperty("overwriteTemplates", false);
    }

    protected void saveOptions() {
        if (this.language != null) {
            if (this.language.getSelectedIndex() == 1) {
                User.instance().setProperty("Language", Locale.ENGLISH.getLanguage());
            } else {
                User.instance().setProperty("Language", Locale.GERMAN.getLanguage());
            }
        }
        if (this.dataDir != null) {
            GetDataFile.setDataPath(this.dataDir.getText());
        }
        if (this.backupDir != null) {
            User.instance().setProperty("DataBackup", this.backupDir.getText());
        }
    }

    protected void buttonDataAction() {
        JFileChooser jFileChooser = new JFileChooser(this.dataDir.getText());
        jFileChooser.setDialogTitle(StringResource.getString("dialog_file"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            this.dataDir.setText(string);
        }
        this.setTemplButtonText();
    }

    protected void buttonBackupAction() {
        JFileChooser jFileChooser = new JFileChooser(this.backupDir.getText());
        jFileChooser.setDialogTitle(StringResource.getString("dialog_file"));
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this.getParent());
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            if (string.length() > 0) {
                string = FileProcedures.addDirName(string, "jRepData");
            }
            this.backupDir.setText(string);
        }
    }

    protected void dataDirAction() {
        try {
            File file = new File(GetDataFile.getDataPath());
            if (file.exists()) {
                Desktop.getDesktop().open(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void propDirAction() {
        try {
            File file = new File(GetDataFile.getUserPath());
            if (file.exists()) {
                Desktop.getDesktop().open(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

