/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.reputil.PatientUtil;
import ch.steph.util.FileProcedures;
import ch.steph.util.Log;
import ch.steph.util.PwHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class OptPatient
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String PW_IS_HERE = "\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022";
    private JTextField[] showText = new JTextField[4];
    private JTextField[] dataDir = new JTextField[4];
    private JButton[] searchButton = new JButton[4];
    private JCheckBox withImage;
    private JCheckBox startWithPat;
    private JTextField patPw;

    public OptPatient(KeyListener keyListener) {
        Log.write(4, this.getClass().getName(), "start");
        this.addKeyListener(keyListener);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(" "), "North");
        jPanel.add((Component)new JLabel(" " + StringResource.getString("pat_pw_opt") + "  "), "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.patPw = new JTextField(26);
        if (User.instance().getProperty("patPw", "").length() > 0) {
            this.patPw.setText(PW_IS_HERE);
        }
        jPanel2.add((Component)this.patPw, "West");
        jPanel.add((Component)jPanel2, "Center");
        jPanel2 = new JPanel();
        JButton jButton = new JButton(StringResource.getString("pat_pw_button"));
        jButton.addActionListener(actionEvent -> this.patPw.setText(PwHelper.generateSecureRandomPassword(17)));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        this.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.setLayout(gridBagLayout);
        this.startWithPat = new JCheckBox(StringResource.getString("option_pat_start"));
        this.startWithPat.setSelected(User.instance().getProperty("startWithPatWindow", false));
        this.startWithPat.addKeyListener(keyListener);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.startWithPat, gridBagConstraints);
        jPanel3.add(this.startWithPat);
        this.withImage = new JCheckBox(StringResource.getString("option_pat_image"));
        this.withImage.setSelected(User.instance().getProperty("PatientWithImage", true));
        this.withImage.addKeyListener(keyListener);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.withImage, gridBagConstraints);
        jPanel3.add(this.withImage);
        JLabel jLabel = new JLabel(" ");
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        jLabel = new JLabel(StringResource.getString("option_pat_label"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        jLabel = new JLabel(StringResource.getString("option_pat_dir"));
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        for (int i = 0; i < 4; ++i) {
            gridBagConstraints.gridy = i + 4;
            jLabel = new JLabel(" " + (i + 1) + " ");
            gridBagConstraints.gridx = 0;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel3.add(jLabel);
            this.showText[i] = new JTextField("", 12);
            gridBagConstraints.gridx = 1;
            gridBagLayout.setConstraints(this.showText[i], gridBagConstraints);
            this.showText[i].addKeyListener(keyListener);
            jPanel3.add(this.showText[i]);
            this.dataDir[i] = new JTextField("", 24);
            gridBagConstraints.gridx = 2;
            gridBagLayout.setConstraints(this.dataDir[i], gridBagConstraints);
            this.dataDir[i].addKeyListener(keyListener);
            jPanel3.add(this.dataDir[i]);
            this.searchButton[i] = new JButton(StringResource.getString("button_search_dir"));
            this.searchButton[i].addActionListener(this::buttonSearchAction);
            gridBagConstraints.gridx = 3;
            gridBagLayout.setConstraints(this.searchButton[i], gridBagConstraints);
            this.searchButton[i].addKeyListener(keyListener);
            jPanel3.add(this.searchButton[i]);
        }
        this.add((Component)jPanel3, "Center");
        PatientUtil.prepareOptions();
        String[] stringArray = PatientUtil.getPatButtons(false);
        for (int i = 0; i < 4; ++i) {
            if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
            this.showText[i].setText(stringArray[i]);
            this.dataDir[i].setText(PatientUtil.getPatDir(stringArray[i]));
        }
    }

    protected void saveOptions() {
        if (!PW_IS_HERE.equals(this.patPw.getText())) {
            if (this.patPw.getText().length() == 0) {
                User.instance().setProperty("patPw", "");
            } else {
                User.instance().setProperty("patPw", PwHelper.hashPassword(this.patPw.getText()));
            }
        }
        User.instance().setProperty("PatientWithImage", this.withImage.isSelected());
        User.instance().setProperty("startWithPatWindow", this.startWithPat.isSelected());
        for (int i = 0; i < 4; ++i) {
            PatientUtil.setPatDir(i, this.showText[i].getText(), this.dataDir[i].getText());
        }
    }

    protected void buttonSearchAction(ActionEvent actionEvent) {
        int n = -1;
        Object object = actionEvent.getSource();
        for (int i = 0; i < 4; ++i) {
            if (!object.equals(this.searchButton[i])) continue;
            n = i;
        }
        if (n >= 0) {
            String string = PatientUtil.getPatDir(this.showText[n].getText());
            if (string == null || string.length() == 0) {
                string = PatientUtil.getPatRoot();
            }
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.setDialogTitle(StringResource.getString("dialog_file"));
            jFileChooser.setFileSelectionMode(1);
            int n2 = jFileChooser.showOpenDialog(this.getParent());
            if (n2 == 0) {
                string = jFileChooser.getSelectedFile().getPath();
                this.dataDir[n].setText(string);
                if (this.showText[n].getText().length() == 0) {
                    this.showText[n].setText(FileProcedures.getFileName(string));
                }
            }
        }
    }
}

