/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.repui.OptDir;
import ch.steph.repui.OptMain;
import ch.steph.repui.OptPatient;
import ch.steph.repui.OptRep;
import ch.steph.repui.OptWeb;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class OptionBox
extends JDialog {
    private static final long serialVersionUID = 1L;
    private OptMain optMain;
    private OptDir optDir;
    private OptPatient optPatient;
    private OptWeb optWeb;
    private OptRep optRep;

    public OptionBox(JFrame jFrame) {
        super((Frame)jFrame, true);
        Log.write(4, this.getClass().getName(), "start");
        this.setTitle(StringResource.getString("option_title"));
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                OptionBox.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addKeyListener(keyListener);
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.optMain = new OptMain(keyListener);
        this.optMain.addKeyListener(keyListener);
        jTabbedPane.addTab(StringResource.getString("option_title_main"), this.optMain);
        this.optDir = new OptDir(keyListener);
        this.optDir.addKeyListener(keyListener);
        jTabbedPane.addTab(StringResource.getString("option_title_dir"), this.optDir);
        this.optPatient = new OptPatient(keyListener);
        this.optPatient.addKeyListener(keyListener);
        jTabbedPane.addTab(StringResource.getString("option_title_pat"), this.optPatient);
        this.optWeb = new OptWeb(keyListener);
        this.optWeb.addKeyListener(keyListener);
        jTabbedPane.addTab(StringResource.getString("option_title_web"), this.optWeb);
        this.optRep = new OptRep(keyListener);
        this.optRep.addKeyListener(keyListener);
        jTabbedPane.addTab(StringResource.getString("option_title_rep"), this.optRep);
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(StringResource.getString("button_ok"));
        jButton.addActionListener(actionEvent -> this.buttonOkAction());
        jButton.addKeyListener(keyListener);
        jPanel.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add(new JLabel(StringResource.getString("button_between_middle")));
        jButton = new JButton(StringResource.getString("button_cancel"));
        jButton.addActionListener(actionEvent -> this.closeAction());
        jButton.addKeyListener(keyListener);
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.addKeyListener(keyListener);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                OptionBox.this.closeAction();
            }
        });
        Rectangle rectangle = this.getParent().getBounds();
        Rectangle rectangle2 = this.getBounds();
        rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
        rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
        if (rectangle2.x + rectangle2.width > rectangle.x + rectangle.width) {
            rectangle2.x = rectangle.x + rectangle.width - rectangle2.width;
        }
        if (rectangle2.x < 0) {
            rectangle2.x = 0;
        }
        if (rectangle2.y < 0) {
            rectangle2.y = 0;
        }
        this.setBounds(rectangle2);
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        try {
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                char c = Character.toUpperCase(keyEvent.getKeyChar());
                if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (c == '\n') {
                    keyEvent.consume();
                    this.buttonOkAction();
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    protected void buttonOkAction() {
        this.optMain.saveOptions();
        this.optDir.saveOptions();
        this.optPatient.saveOptions();
        this.optWeb.saveOptions();
        this.optRep.saveOptions();
        this.closeAction();
    }

    protected void closeAction() {
        this.setVisible(false);
        Log.write(4, this.getClass().getName(), "end");
    }
}

