/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiMainFrame;
import ch.steph.apputil.MdiModalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.PanelKeyListener;
import ch.steph.rep.Rep;
import ch.steph.repdata.FileSynch;
import ch.steph.repmodel.SearchCaseThreadListener;
import ch.steph.repmodel.SortedListModel;
import ch.steph.repmodel.SortedShowEntryModel;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.SimpleShowPanel;
import ch.steph.reputil.FontUtil;
import ch.steph.reputil.PatientUtil;
import ch.steph.tableview.TableEditWindow;
import ch.steph.tableview.TableToHtml;
import ch.steph.util.Constants;
import ch.steph.util.FileCsv;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import ch.steph.util.ShowListEntry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class PatientBox
extends MdiModalFrame
implements PanelKeyListener,
SearchCaseThreadListener {
    private static final long serialVersionUID = 1L;
    JButton[] patRootButton;
    private SortedListModel patListModel;
    private JList<String> patList;
    private JSplitPane patSplitPane;
    private JSplitPane caseSplitPane;
    private JSplitPane imgSplitPane;
    private JSplitPane imgListSplitPane;
    private JButton caseNewButton;
    private JButton caseWorkButton;
    private JButton caseRenameButton;
    private JMenuItem caseWorkMenu;
    private JMenuItem caseRenameMenu;
    private JMenuItem caseDelMenu;
    private JMenuItem noteMenuItem;
    private SortedShowEntryModel caseListModel;
    private JList<ShowListEntry> caseList;
    private SortedListModel imgListModel;
    private JList<String> imgList;
    private JTextField caseSearchField;
    private JButton caseResetButton;
    private JButton noteButton;
    SimpleShowPanel notePanel;
    SimpleShowPanel imgPanel = null;
    JPopupMenu patPopupMenu;
    JPopupMenu casePopupMenu;
    JPopupMenu imgPopupMenu;
    JFileChooser fileDialog;
    boolean boxStart = true;
    boolean isCase = true;
    boolean isCsv = false;
    private URL extEditedFile;
    private long extEditedDate;
    private URL checkedEditedFile;

    public PatientBox() {
        super(StringResource.getString("pat_title"));
        Object object;
        JPanel jPanel;
        Object object2;
        JComponent jComponent;
        User.instance().setProperty("cPatBox", User.instance().getProperty("cPatBox", 0) + 1);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                PatientBox.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        Rectangle rectangle = ScreenUtil.getPatientWindowSize();
        this.setBounds(rectangle);
        JPanel jPanel2 = new JPanel(new GridLayout(1, 8));
        this.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton(StringResource.getString("pat_button_new_pat"));
        jButton.addKeyListener(keyListener);
        jButton.addActionListener(actionEvent -> {
            String string = JOptionPane.showInputDialog(this.getContentPane(), (Object)StringResource.getString("pat_button_new_pat"));
            this.addNewPatient(string);
        });
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(jButton);
        this.caseNewButton = new JButton(StringResource.getString("pat_button_new_consult"));
        this.caseNewButton.addKeyListener(keyListener);
        this.caseNewButton.addActionListener(actionEvent -> this.newConsultationAction());
        this.caseNewButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.caseNewButton);
        this.caseNewButton = new JButton(StringResource.getString("pat_button_new_case"));
        this.caseNewButton.addKeyListener(keyListener);
        this.caseNewButton.addActionListener(actionEvent -> {
            RepMainFrame.getRepInstance().newCaseAction();
            this.closeAction();
        });
        this.caseNewButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.caseNewButton);
        this.caseRenameButton = new JButton(StringResource.getString("pat_button_rename_case"));
        this.caseRenameButton.addKeyListener(keyListener);
        this.caseRenameButton.addActionListener(actionEvent -> this.renameCase());
        this.caseRenameButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.caseRenameButton);
        this.caseWorkButton = new JButton(StringResource.getString("pat_button_change_case"));
        this.caseWorkButton.setEnabled(false);
        this.caseWorkButton.addKeyListener(keyListener);
        this.caseWorkButton.addActionListener(actionEvent -> this.selectCase());
        this.caseWorkButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add(this.caseWorkButton);
        this.noteButton = new JButton(StringResource.getString("pat_button_change_note"));
        this.noteButton.addKeyListener(keyListener);
        this.noteButton.addActionListener(actionEvent -> this.editNote());
        jPanel2.add(this.noteButton);
        if (User.instance().getProperty("PatientWithImage", true)) {
            jComponent = new JButton(StringResource.getString("pat_button_import_image"));
            jComponent.addKeyListener(keyListener);
            ((AbstractButton)jComponent).addActionListener(actionEvent -> this.imageImportAction());
            ((AbstractButton)jComponent).setMargin(new Insets(0, 0, 0, 0));
            jPanel2.add(jComponent);
            jComponent = new JButton(StringResource.getString("clipboard"));
            jComponent.addKeyListener(keyListener);
            ((AbstractButton)jComponent).addActionListener(actionEvent -> this.imageBufferAction());
            ((AbstractButton)jComponent).setMargin(new Insets(0, 0, 0, 0));
            jPanel2.add(jComponent);
        }
        jComponent = new JPanel();
        jComponent.setLayout(new BorderLayout());
        int n = PatientUtil.countPatDir();
        if (n > 1) {
            object2 = PatientUtil.getPatRoot();
            jPanel = new JPanel(new GridLayout(n, 1));
            object = PatientUtil.getPatButtons(true);
            this.patRootButton = new JButton[n];
            int n2 = 0;
            for (int i = 0; i < 4; ++i) {
                if (object[i] == null || object[i].length() <= 0) continue;
                this.patRootButton[n2] = new JButton(object[i]);
                this.patRootButton[n2].addKeyListener(keyListener);
                if (!((String)object2).equals(PatientUtil.getPatDir(object[i]))) {
                    this.patRootButton[n2].setFont(FontUtil.getChangedFont());
                } else {
                    this.patRootButton[n2].setFont(FontUtil.getBoldChangedFont());
                }
                this.patRootButton[n2].addActionListener(this::patButtonAction);
                jPanel.add(this.patRootButton[n2]);
                ++n2;
            }
            jComponent.add((Component)jPanel, "North");
        }
        object2 = new JScrollPane();
        this.patListModel = new SortedListModel(PatientUtil.getActualizedPatList(), false);
        this.patList = new JList<String>(this.patListModel);
        this.patList.setSelectedIndex(this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
        this.patList.addKeyListener(keyListener);
        ((JScrollPane)object2).getViewport().add(this.patList);
        jComponent.add((Component)object2, "Center");
        jPanel = new JPanel(new BorderLayout());
        this.patSplitPane = new JSplitPane(1, jComponent, jPanel);
        this.patSplitPane.setContinuousLayout(true);
        this.getContentPane().add(this.patSplitPane);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this.caseListModel = new SortedShowEntryModel(PatientUtil.getActualizedCaseList(true), true);
        this.caseList = new JList<ShowListEntry>(this.caseListModel);
        this.caseList.addKeyListener(keyListener);
        jScrollPane.getViewport().add(this.caseList);
        ((Container)object).add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        this.caseSearchField = new JTextField();
        jPanel3.add((Component)this.caseSearchField, "Center");
        this.caseSearchField.addKeyListener(keyListener);
        this.caseSearchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                PatientBox.this.searchFieldTextValueChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PatientBox.this.searchFieldTextValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PatientBox.this.searchFieldTextValueChanged();
            }
        });
        this.caseResetButton = new JButton("X");
        jPanel3.add((Component)this.caseResetButton, "East");
        this.caseResetButton.setEnabled(false);
        this.caseResetButton.addKeyListener(keyListener);
        this.caseResetButton.addActionListener(actionEvent -> {
            this.caseSearchField.setText("");
            this.caseListModel.resetFilter();
        });
        ((Container)object).add((Component)jPanel3, "South");
        this.caseList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                String string = ((ShowListEntry)object).getFilename();
                if (!bl) {
                    if (string.endsWith(".repp")) {
                        this.setBackground(Color.YELLOW.brighter());
                    }
                    if (string.endsWith(".rep")) {
                        this.setBackground(Color.CYAN.brighter());
                    }
                    if (string.endsWith(".htm")) {
                        this.setBackground(Color.GREEN.brighter());
                    }
                    if (string.endsWith(".rtf")) {
                        this.setBackground(Color.GREEN.brighter());
                    }
                    if (string.endsWith(".csv")) {
                        this.setBackground(Color.ORANGE);
                    }
                    if (string.endsWith(".pdf")) {
                        this.setBackground(Color.PINK);
                    }
                }
                return component;
            }
        });
        JPanel jPanel4 = new JPanel(new BorderLayout());
        this.caseSplitPane = new JSplitPane(1, (Component)object, jPanel4);
        this.caseSplitPane.setContinuousLayout(true);
        jPanel.add(this.caseSplitPane);
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.noteMenuItem = new JMenuItem(StringResource.getString("pat_menu_edit_note"));
        this.noteMenuItem.addActionListener(actionEvent -> this.editNoteOrConsult());
        jPopupMenu.add(this.noteMenuItem);
        this.notePanel = new SimpleShowPanel(jPopupMenu);
        if (!User.instance().getProperty("PatientWithImage", true)) {
            jPanel4.add(this.notePanel);
        } else {
            JScrollPane jScrollPane2 = new JScrollPane();
            this.imgListModel = new SortedListModel(PatientUtil.getActImageFileList(), false);
            this.imgList = new JList<String>(this.imgListModel);
            this.imgList.addKeyListener(keyListener);
            jScrollPane2.getViewport().add(this.imgList);
            this.imgPanel = new SimpleShowPanel(null);
            this.imgListSplitPane = new JSplitPane(1, jScrollPane2, this.imgPanel);
            this.imgSplitPane = new JSplitPane(0, this.imgListSplitPane, this.notePanel);
            jPanel4.add(this.imgSplitPane);
            this.imgList.addListSelectionListener(listSelectionEvent -> {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    this.imgSelectionChanged();
                }
            });
        }
        this.patList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.patSelectionChanged();
            }
        });
        this.caseList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.caseSelectionChanged();
            }
        });
        this.setTitleText();
        try {
            int n3 = User.instance().getProperty("PatientDivider", 0);
            if (n3 == 0) {
                this.patSplitPane.setDividerLocation(0.25);
            } else {
                this.patSplitPane.setDividerLocation(n3);
            }
            n3 = User.instance().getProperty("PatCaseDivider", 0);
            if (n3 == 0) {
                this.caseSplitPane.setDividerLocation(0.33);
            } else {
                this.caseSplitPane.setDividerLocation(n3);
            }
            if (this.imgSplitPane != null) {
                n3 = User.instance().getProperty("PatImageDivider", 0);
                if (n3 == 0) {
                    this.imgSplitPane.setDividerLocation(0.33);
                } else {
                    this.imgSplitPane.setDividerLocation(n3);
                }
            }
            if (this.imgListSplitPane != null) {
                n3 = User.instance().getProperty("PatImgListDivider", 0);
                if (n3 == 0) {
                    this.imgListSplitPane.setDividerLocation(0.33);
                } else {
                    this.imgListSplitPane.setDividerLocation(n3);
                }
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "setMenuEnables ", exception);
        }
        this.fileDialog = new JFileChooser(System.getProperty("user.home"));
        this.fileDialog.setFileFilter(new FileNameExtensionFilter("Images " + Constants.getImageFileExtensions(), Constants.imgExt));
        this.fileDialog.setDialogTitle(StringResource.getString("load_image"));
        this.patPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("pat_button_new_pat"));
        jMenuItem.addActionListener(actionEvent -> {
            String string = JOptionPane.showInputDialog(this.getContentPane(), (Object)StringResource.getString("pat_button_new_pat"));
            this.addNewPatient(string);
        });
        this.patPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("pat_menu_pat_rename"));
        jMenuItem.addActionListener(actionEvent -> this.renamePat());
        this.patPopupMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(StringResource.getString("pat_menu_pat_delete"));
        jMenuItem.addActionListener(actionEvent -> {
            if (0 == JOptionPane.showConfirmDialog(this.getContentPane(), StringResource.getString("pat_patdelconfirm1") + PatientUtil.getPatientName() + StringResource.getString("pat_patdelconfirm2"), StringResource.getString("pat_menu_pat_delete"), 0)) {
                this.deleteActPatient();
            }
        });
        this.patPopupMenu.add(jMenuItem);
        this.patList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    PatientBox.this.selectPatient();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = PatientBox.this.patList.locationToIndex(mouseEvent.getPoint());
                PatientBox.this.patList.setSelectedIndex(n);
                if (mouseEvent.isPopupTrigger()) {
                    PatientBox.this.patPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                if (mouseEvent.isPopupTrigger()) {
                    PatientBox.this.patPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.casePopupMenu = new JPopupMenu();
        JMenuItem jMenuItem2 = new JMenuItem(StringResource.getString("pat_button_new_consult"));
        jMenuItem2.addActionListener(actionEvent -> this.newConsultationAction());
        this.casePopupMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(StringResource.getString("pat_button_new_case"));
        jMenuItem3.addActionListener(actionEvent -> {
            RepMainFrame.getRepInstance().newCaseAction();
            this.closeAction();
        });
        this.casePopupMenu.add(jMenuItem3);
        this.caseRenameMenu = new JMenuItem(StringResource.getString("pat_menu_rename_case"));
        this.caseRenameMenu.addActionListener(actionEvent -> this.renameCase());
        this.casePopupMenu.add(this.caseRenameMenu);
        this.caseWorkMenu = new JMenuItem(StringResource.getString("pat_menu_case_edit"));
        this.caseWorkMenu.addActionListener(actionEvent -> this.selectCase());
        this.casePopupMenu.add(this.caseWorkMenu);
        this.caseDelMenu = new JMenuItem(StringResource.getString("pat_menu_case_delete"));
        this.caseDelMenu.addActionListener(actionEvent -> {
            ShowListEntry showListEntry = this.caseListModel.getElementAt(this.caseList.getSelectedIndex());
            String string = StringResource.getString("pat_menu_consult_delete");
            if (this.isCsv) {
                string = StringResource.getString("pat_menu_table_delete");
            }
            if (this.isCase) {
                string = StringResource.getString("pat_menu_case_delete");
            }
            if (0 == JOptionPane.showConfirmDialog(null, StringResource.getString("pat_patdelconfirm1") + showListEntry.getShowname() + StringResource.getString("pat_patdelconfirm2"), string, 0)) {
                this.deleteCase();
            }
        });
        this.casePopupMenu.add(this.caseDelMenu);
        this.caseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    PatientBox.this.selectCase();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = PatientBox.this.caseList.locationToIndex(mouseEvent.getPoint());
                PatientBox.this.caseList.setSelectedIndex(n);
                if (mouseEvent.isPopupTrigger()) {
                    PatientBox.this.casePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                if (mouseEvent.isPopupTrigger()) {
                    PatientBox.this.casePopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        if (User.instance().getProperty("PatientWithImage", true)) {
            this.imgPopupMenu = new JPopupMenu();
            jMenuItem = new JMenuItem(StringResource.getString("pat_menu_image_import"));
            jMenuItem.addActionListener(actionEvent -> this.imageImportAction());
            this.imgPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(StringResource.getString("pat_menu_image_clipboard"));
            jMenuItem.addActionListener(actionEvent -> this.imageBufferAction());
            this.imgPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(StringResource.getString("pat_menu_image_rename"));
            jMenuItem.addActionListener(actionEvent -> this.imageRenameAction());
            this.imgPopupMenu.add(jMenuItem);
            jMenuItem = new JMenuItem(StringResource.getString("pat_menu_image_delete"));
            jMenuItem.addActionListener(actionEvent -> this.imageDeleteAction());
            this.imgPopupMenu.add(jMenuItem);
            this.imgList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                    if (mouseEvent.getClickCount() >= 2) {
                        PatientBox.this.selectImg();
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                    int n = PatientBox.this.imgList.locationToIndex(mouseEvent.getPoint());
                    PatientBox.this.imgList.setSelectedIndex(n);
                    if (mouseEvent.isPopupTrigger()) {
                        PatientBox.this.imgPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                    if (mouseEvent.isPopupTrigger()) {
                        PatientBox.this.imgPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PatientBox.this.patList.setSelectedIndex(PatientBox.this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
                    PatientUtil.setShowPatName(true);
                    PatientBox.this.patSelectionChanged();
                    PatientBox.this.boxStart = false;
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "setMenuEnables ", exception);
                }
            }
        });
    }

    @Override
    public void requestFocus() {
        if (this.patList != null) {
            this.patList.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setTitleText() {
        SwingUtilities.invokeLater(() -> {
            String string = PatientUtil.getPatientName();
            if (string != null) {
                this.setTitle(StringResource.getString("pat_title") + " : " + string);
            } else {
                this.setTitle(StringResource.getString("pat_title"));
            }
        });
    }

    protected void searchFieldTextValueChanged() {
        this.caseListModel.filterEntriesBySearch(this.caseSearchField.getText());
        this.caseResetButton.setEnabled(this.caseSearchField.getText().length() != 0);
    }

    private void newConsultationAction() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd ");
        String string = simpleDateFormat.format(new Date()) + StringResource.getString("pat_filename_consult") + ".rtf";
        RepMainFrame.getRepInstance().extConsultFrameAction(string);
        this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(true));
    }

    @Override
    public void closeAction() {
        this.extEditedFile = null;
        User.instance().setProperty("PatientDivider", this.patSplitPane.getDividerLocation());
        User.instance().setProperty("PatCaseDivider", this.caseSplitPane.getDividerLocation());
        if (User.instance().getProperty("PatientWithImage", true)) {
            User.instance().setProperty("PatImageDivider", this.imgSplitPane.getDividerLocation());
            User.instance().setProperty("PatImgListDivider", this.imgListSplitPane.getDividerLocation());
        }
        super.closeAction();
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c = keyEvent.getKeyChar();
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                if (c == '\n') {
                    keyEvent.consume();
                    if (this.patList.hasFocus()) {
                        this.selectPatient();
                    } else if (this.caseList.hasFocus()) {
                        this.selectCase();
                    }
                } else if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (keyEvent.getKeyCode() == 112) {
                    keyEvent.consume();
                    RepMainFrame.getRepInstance().helpContextAction("Patienten-Liste");
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    protected void patSelectionChanged() {
        int n = this.patList.getSelectedIndex();
        if (n >= 0) {
            PatientUtil.setSelectedPatient(this.patListModel.getElementAt(n));
            this.setTitleText();
            this.caseList.clearSelection();
            this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(true));
            URL uRL = FileProcedures.nameDirToUrl(PatientUtil.getActPatDir(), "Notiz.htm");
            if (uRL == null) {
                uRL = FileProcedures.nameDirToUrl(PatientUtil.getActPatDir(), "Notiz.rtf");
            }
            this.notePanel.initPanel(this, uRL);
            if (this.imgPanel != null) {
                this.selectLastImage();
            }
        } else {
            this.caseList.clearSelection();
            this.caseListModel.setNewList(new Vector<ShowListEntry>());
            this.notePanel.initPanel(this, null);
            if (this.imgPanel != null) {
                this.imgListModel.setNewList(new Vector<String>());
                this.imgPanel.initWithImage(null, null);
            }
        }
    }

    protected void selectPatient() {
        this.patSelectionChanged();
        int n = this.patList.getSelectedIndex();
        if (n >= 0) {
            this.caseList.setSelectedIndex(0);
            this.caseList.requestFocus();
        }
    }

    protected void addNewPatient(String string) {
        if ((string = PatientUtil.addPatient(string)) != null && string.length() > 0) {
            Log.write(3, this.getClass().getName(), "addNewPatient " + string);
            this.patList.clearSelection();
            this.patListModel.setNewList(PatientUtil.getActualizedPatList());
            PatientUtil.setSelectedPatient(string);
            this.patList.setSelectedIndex(this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
            this.setTitleText();
            this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(true));
            this.caseList.setSelectedIndex(0);
            this.caseList.requestFocus();
        }
        this.updatePatButtonText();
    }

    protected void renamePat() {
        String string = JOptionPane.showInputDialog(this.getContentPane(), StringResource.getString("pat_button_rename_text"), PatientUtil.getPatientName());
        if (string != null && string.length() > 0) {
            string = PatientUtil.renameActPatient(string);
            this.patList.clearSelection();
            this.patListModel.setNewList(PatientUtil.getActualizedPatList());
            PatientUtil.setSelectedPatient(string);
            this.patList.setSelectedIndex(this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
            this.setTitleText();
            this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(true));
            this.caseList.setSelectedIndex(0);
            this.caseList.requestFocus();
        }
        this.updatePatButtonText();
    }

    protected void deleteActPatient() {
        int n = this.patList.getSelectedIndex();
        if (n >= 0) {
            Log.write(3, this.getClass().getName(), "deleteActPatient" + n);
            this.patList.clearSelection();
            PatientUtil.deleteActPatient();
            this.patListModel.setNewList(PatientUtil.getActualizedPatList());
            if (n < this.patListModel.getSize()) {
                PatientUtil.setSelectedPatient(this.patListModel.getElementAt(n));
            } else {
                PatientUtil.setSelectedPatient(this.patListModel.getElementAt(0));
            }
            this.updatePatButtonText();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        PatientBox.this.patList.setSelectedIndex(PatientBox.this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
                        PatientBox.this.patSelectionChanged();
                        PatientBox.this.patList.requestFocus();
                    }
                    catch (Exception exception) {
                        Log.write(3, this.getClass().getName(), "setMenuEnables ", exception);
                    }
                }
            });
        }
    }

    protected void selectCase() {
        int n = this.caseList.getSelectedIndex();
        if (n >= 0) {
            ShowListEntry showListEntry = this.caseListModel.getElementAt(n);
            Log.write(3, this.getClass().getName(), "selectCase " + showListEntry.getShowname());
            String string = showListEntry.getFilename();
            if (string.endsWith(".repp") || string.endsWith(".repa")) {
                RepMainFrame.getRepInstance().formBrowseActionWithData(PatientUtil.getPatientName(), string.substring(0, string.length() - 5));
                this.closeAction();
            } else if (string.endsWith(".htm")) {
                this.editNoteOrConsult();
            } else if (string.endsWith(".rtf")) {
                this.editNoteOrConsult();
            } else if (string.endsWith(".csv")) {
                this.editNoteOrConsult();
            } else {
                string = FileProcedures.addDirName(PatientUtil.getActPatDir(), string);
                RepMainFrame.getRepInstance().newCaseAction();
                RepMainFrame.getRepInstance().loadFileAction(string);
                this.closeAction();
            }
        }
    }

    protected void renameCase() {
        int n = this.caseList.getSelectedIndex();
        if (n >= 0) {
            String string;
            ShowListEntry showListEntry = this.caseListModel.getElementAt(n);
            String string2 = showListEntry.getFilename();
            String string3 = "";
            int n2 = string2.lastIndexOf(46);
            if (n2 > 0) {
                string3 = string2.substring(n2);
                string2 = string2.substring(0, n2);
            }
            String string4 = StringResource.getString("pat_menu_rename_consult");
            if (this.isCsv) {
                string4 = StringResource.getString("pat_menu_rename_table");
            }
            if (this.isCase) {
                string4 = StringResource.getString("pat_menu_rename_case");
            }
            if ((string = JOptionPane.showInputDialog(this.getContentPane(), string4, string2)) != null && string.length() > 0 && !string.equals(string2)) {
                Log.write(4, this.getClass().getName(), "renameCase to " + string);
                PatientUtil.renameCase(string2 + string3, string + string3);
                this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(true));
                this.caseList.requestFocus();
            }
        }
    }

    protected void deleteCase() {
        int n = this.caseList.getSelectedIndex();
        if (n >= 0) {
            ShowListEntry showListEntry = this.caseListModel.getElementAt(n);
            Log.write(4, this.getClass().getName(), "deleteCase " + showListEntry.getShowname());
            PatientUtil.deleteCase(showListEntry);
            this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(true));
            if (n >= this.caseListModel.getSize() && this.caseListModel.getSize() > 0) {
                n = this.caseListModel.getSize() - 1;
            }
            this.caseList.setSelectedIndex(0);
            this.caseList.requestFocus();
        }
    }

    public void caseSelectionChanged() {
        int n = this.caseList.getSelectedIndex();
        if (n >= 0) {
            this.isCsv = false;
            this.caseWorkButton.setEnabled(true);
            this.caseRenameButton.setEnabled(true);
            ShowListEntry showListEntry = this.caseListModel.getElementAt(n);
            String string = showListEntry.getUrlString();
            if (string.endsWith(".htm") || string.endsWith(".rtf") || string.endsWith(".pdf") || string.endsWith(".csv")) {
                this.isCase = false;
                if (string.endsWith(".csv")) {
                    this.isCsv = true;
                    URL uRL = FileProcedures.nameToUrl(showListEntry.getUrlString());
                    try {
                        FileCsv fileCsv = new FileCsv();
                        fileCsv.openRead(uRL.openStream());
                        String string2 = "<html><head><style type=\"text/css\">body{font-family:sans-serif;}td{text-align:left;vertical-align:top;}</style></head><body>" + TableToHtml.convert(fileCsv) + "</body></html>";
                        fileCsv.close();
                        this.notePanel.initPanelHtm(this, string2);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.caseWorkButton.setText(StringResource.getString("pat_button_change_table"));
                    this.caseRenameButton.setText(StringResource.getString("pat_button_rename_table"));
                    this.caseRenameMenu.setText(StringResource.getString("pat_menu_rename_table"));
                    this.caseWorkMenu.setText(StringResource.getString("pat_menu_table_edit"));
                    this.caseDelMenu.setText(StringResource.getString("pat_menu_table_delete"));
                    this.noteMenuItem.setText(StringResource.getString("pat_menu_edit_table"));
                } else {
                    this.extEditedFile = FileProcedures.nameToUrl(string);
                    this.notePanel.initPanel(this, this.extEditedFile);
                    this.checkExtEditedFile();
                    this.caseWorkButton.setText(StringResource.getString("pat_button_change_consult"));
                    this.caseRenameButton.setText(StringResource.getString("pat_button_rename_consult"));
                    this.caseRenameMenu.setText(StringResource.getString("pat_menu_rename_consult"));
                    this.caseWorkMenu.setText(StringResource.getString("pat_menu_consult_edit"));
                    this.caseDelMenu.setText(StringResource.getString("pat_menu_consult_delete"));
                    this.noteMenuItem.setText(StringResource.getString("pat_menu_edit_consult"));
                }
            } else {
                this.isCase = true;
                this.extEditedFile = FileProcedures.nameDirToUrl(PatientUtil.getActPatDir(), "Notiz.htm");
                if (this.extEditedFile == null) {
                    this.extEditedFile = FileProcedures.nameDirToUrl(PatientUtil.getActPatDir(), "Notiz.rtf");
                }
                this.notePanel.initPanel(this, this.extEditedFile);
                this.checkExtEditedFile();
                this.caseWorkButton.setText(StringResource.getString("pat_button_change_case"));
                this.caseRenameButton.setText(StringResource.getString("pat_button_rename_case"));
                this.caseRenameMenu.setText(StringResource.getString("pat_menu_rename_case"));
                this.caseWorkMenu.setText(StringResource.getString("pat_menu_case_edit"));
                this.caseDelMenu.setText(StringResource.getString("pat_menu_case_delete"));
                this.noteMenuItem.setText(StringResource.getString("pat_menu_edit_note"));
            }
        } else {
            this.caseWorkButton.setEnabled(false);
            this.caseRenameButton.setEnabled(false);
        }
    }

    protected void editNoteOrConsult() {
        if (this.isCase) {
            this.extEditedFile = RepMainFrame.getRepInstance().extNoteFrameAction();
            this.checkExtEditedFile();
        } else if (this.isCsv) {
            ShowListEntry showListEntry = this.caseListModel.getElementAt(this.caseList.getSelectedIndex());
            MdiMainFrame.getInstance().addAndSelect(new TableEditWindow(showListEntry.getFilenameNoExtension(), showListEntry.getUrlString()));
            this.closeAction();
        } else {
            int n = this.caseList.getSelectedIndex();
            ShowListEntry showListEntry = this.caseListModel.getElementAt(n);
            String string = showListEntry.getFilename();
            this.extEditedFile = RepMainFrame.getRepInstance().extConsultFrameAction(string);
            this.checkExtEditedFile();
        }
    }

    protected void editNote() {
        this.extEditedFile = RepMainFrame.getRepInstance().extNoteFrameAction();
        this.checkExtEditedFile();
    }

    protected void checkExtEditedFile() {
        if (this.extEditedFile != null && !this.extEditedFile.equals(this.checkedEditedFile)) {
            this.extEditedDate = FileProcedures.getFileDate(this.extEditedFile);
            Rep.getExecutor().execute(() -> {
                try {
                    this.checkedEditedFile = this.extEditedFile;
                    Log.write(5, this.getClass().getName(), "start checking file: " + String.valueOf(this.checkedEditedFile));
                    while (this.extEditedFile != null && this.notePanel != null && this.checkedEditedFile.equals(this.extEditedFile)) {
                        if (FileProcedures.getFileDate(this.extEditedFile) != this.extEditedDate) {
                            this.extEditedDate = FileProcedures.getFileDate(this.extEditedFile);
                            SwingUtilities.invokeLater(() -> this.notePanel.refresh());
                        }
                        Thread.sleep(253L);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    protected void selectImg() {
    }

    protected void imgSelectionChanged() {
        int n = this.imgList.getSelectedIndex();
        if (n >= 0) {
            URL uRL = PatientUtil.getActImageFromList(this.imgListModel.getElementAt(n));
            this.imgPanel.initWithImage(null, uRL);
        }
    }

    protected void patButtonAction(ActionEvent actionEvent) {
        try {
            JButton jButton = (JButton)actionEvent.getSource();
            if (PatientUtil.activatePatDir(jButton.getText())) {
                for (JButton jButton2 : this.patRootButton) {
                    if (jButton.equals(jButton2)) {
                        jButton2.setFont(FontUtil.getBoldChangedFont());
                        Log.write(4, this.getClass().getName(), "change to: " + jButton2.getText());
                        continue;
                    }
                    jButton2.setFont(FontUtil.getChangedFont());
                }
                this.patList.clearSelection();
                this.patListModel.setNewList(PatientUtil.getActualizedPatList());
                this.patList.requestFocus();
                this.patList.setSelectedIndex(0);
                this.patSelectionChanged();
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "patButtonAction", exception);
        }
    }

    protected void imageImportAction() {
        int n = this.fileDialog.showOpenDialog(MdiMainFrame.getInstance().getDesktop());
        if (n == 0) {
            BufferedImage bufferedImage = IconUtil.getBufferedImageExtern(FileProcedures.nameToUrl(this.fileDialog.getSelectedFile().getAbsolutePath()));
            long l = FileProcedures.getFileDate(this.fileDialog.getSelectedFile().getAbsolutePath());
            IconUtil.saveReduced(bufferedImage, 800, 600, FileProcedures.addDirName(PatientUtil.getActPatDir(), this.fileDialog.getSelectedFile().getName()));
            FileProcedures.setFileDate(PatientUtil.getActPatDir(), this.fileDialog.getSelectedFile().getName(), l);
            FileSynch.instance().checkFile(FileProcedures.addDirName(PatientUtil.getActPatDir(), this.fileDialog.getSelectedFile().getName()));
            this.selectLastImage();
            Log.write(4, this.getClass().getName(), "load image: " + this.fileDialog.getSelectedFile().getAbsolutePath());
        }
    }

    protected void imageBufferAction() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            BufferedImage bufferedImage = (BufferedImage)clipboard.getData(DataFlavor.imageFlavor);
            if (bufferedImage != null) {
                Object object = JOptionPane.showInputDialog(this.getContentPane(), StringResource.getString("msg_name_of_picture"), StringResource.getString("clipboard") + ".jpg");
                if (!((String)object).contains(".")) {
                    object = (String)object + ".jpg";
                }
                String string = object;
                int n = 1;
                while (FileProcedures.exists(PatientUtil.getActPatDir(), string)) {
                    string = ((String)object).replace(".", "(" + n + ").");
                    ++n;
                }
                object = string;
                IconUtil.saveReduced(bufferedImage, 800, 600, FileProcedures.addDirName(PatientUtil.getActPatDir(), (String)object));
                FileSynch.instance().checkFile(FileProcedures.addDirName(PatientUtil.getActPatDir(), (String)object));
                this.selectLastImage();
                Log.write(4, this.getClass().getName(), "load clipboard image: " + (String)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void imageRenameAction() {
        int n = this.imgList.getSelectedIndex();
        if (n >= 0) {
            int n2 = this.imgList.getSelectedIndex();
            URL uRL = PatientUtil.getActImageFromList(this.imgListModel.getElementAt(n));
            String string = FileProcedures.getFileName(uRL);
            String string2 = JOptionPane.showInputDialog(this.getContentPane(), StringResource.getString("pat_new_name"), string);
            FileProcSync.rename(FileProcedures.addDirName(PatientUtil.getActPatDir(), string), FileProcedures.addDirName(PatientUtil.getActPatDir(), string2));
            FileSynch.instance().checkFile(FileProcedures.addDirName(PatientUtil.getActPatDir(), string2));
            Vector<String> vector = PatientUtil.getActImageFileList();
            this.imgList.clearSelection();
            this.imgListModel.setNewList(vector, false);
            this.imgList.setSelectedIndex(n2);
        }
    }

    private void imageDeleteAction() {
        int n = this.imgList.getSelectedIndex();
        if (n >= 0) {
            URL uRL = PatientUtil.getActImageFromList(this.imgListModel.getElementAt(n));
            FileProcSync.delete(uRL);
            this.selectLastImage();
        }
    }

    private void selectLastImage() {
        Vector<String> vector = PatientUtil.getActImageFileList();
        this.imgList.clearSelection();
        this.imgListModel.setNewList(vector, false);
        if (vector.size() > 0) {
            this.imgList.setSelectedIndex(0);
        } else {
            this.imgPanel.initWithImage(null, null);
        }
    }

    private void updatePatButtonText() {
        if (this.patRootButton != null) {
            String[] stringArray = PatientUtil.getPatButtons(true);
            for (int i = 0; i < this.patRootButton.length; ++i) {
                if (this.patRootButton[i] == null) continue;
                this.patRootButton[i].setText(stringArray[i]);
            }
        }
    }

    @Override
    public void searchDone() {
        this.caseResetButton.setEnabled(true);
    }

    @Override
    public void historyChanged(Object object, int n) {
    }

    @Override
    public void copyToClipboard() {
    }
}

