/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.CaseResult;
import ch.steph.reputil.FontUtil;
import ch.steph.util.PrintablePage;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PrintResult
extends PrintablePage {
    private CaseResult caseResult;
    private String dossier;
    private String patient;
    private String user;
    private boolean withLines;
    private boolean secondValueLines;
    private int lineH = 0;
    private int emptyLineH;
    private int pagesToPrint;
    private int actualOutPage;
    private int numberWidth;
    private int titleWidth;
    private int columnWidth;
    private int columnCountWithTitle;
    private int columnCountOnlyValues;
    private static final int PX_GAP = 3;

    public PrintResult(CaseResult caseResult, String string, String string2, String string3) {
        this.caseResult = caseResult;
        this.dossier = string;
        this.patient = string2;
        this.user = string3;
        this.withLines = User.instance().getProperty("printLines", false);
        this.secondValueLines = User.instance().getProperty("print2parts", false);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Cloneable cloneable;
        int n2 = 1;
        if (this.lineH == 0) {
            cloneable = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            this.prepareHeader(graphics, pageFormat, this.dossier + " : " + this.patient, ((DateFormat)cloneable).format(new Date()), StringResource.getString("www_app_adr"), "jRep " + this.user, FontUtil.getProgFont().getFamily(), User.instance().getProperty("PrintCharSize", 8));
            Rectangle rectangle = new Rectangle(this.getInnerBounds());
            this.lineH = this.getNormalHeight() + 1;
            this.pagesToPrint = 1;
            this.computeWidth(graphics, rectangle);
        }
        this.printHeader(graphics, pageFormat, n);
        cloneable = new Rectangle(this.getInnerBounds());
        ((Rectangle)cloneable).y += 3;
        ((Rectangle)cloneable).height -= 6;
        this.actualOutPage = 0;
        if (n < this.pagesToPrint) {
            int n3;
            if (!this.secondValueLines) {
                for (int i = 0; i < this.caseResult.titleSize(); ++i) {
                    if (this.checkPrinting((Rectangle)cloneable, this.lineH, n)) {
                        this.printLineHeader(graphics, (Rectangle)cloneable, i, 0, this.columnCountWithTitle);
                    }
                    this.prepareNextLine((Rectangle)cloneable, this.lineH);
                }
            }
            for (n3 = this.caseResult.titleSize(); n3 < this.caseResult.getRowCount(); ++n3) {
                if (this.checkPrinting((Rectangle)cloneable, this.lineH, n)) {
                    this.printLineRubrics(graphics, (Rectangle)cloneable, n3, 0, this.columnCountWithTitle);
                }
                this.prepareNextLine((Rectangle)cloneable, this.lineH);
            }
            if (this.secondValueLines && this.columnCountWithTitle < this.caseResult.getColumnCount()) {
                this.prepareNextLine((Rectangle)cloneable, 3);
                for (n3 = 0; n3 < this.caseResult.titleSize(); ++n3) {
                    if (this.checkPrinting((Rectangle)cloneable, this.lineH, n)) {
                        this.printLineHeader(graphics, (Rectangle)cloneable, n3, this.columnCountWithTitle, this.columnCountWithTitle + this.columnCountOnlyValues);
                    }
                    this.prepareNextLine((Rectangle)cloneable, this.lineH);
                }
                for (n3 = this.caseResult.titleSize(); n3 < this.caseResult.getRowCount(); ++n3) {
                    if (this.checkPrinting((Rectangle)cloneable, this.lineH, n)) {
                        this.printLineRubrics(graphics, (Rectangle)cloneable, n3, this.columnCountWithTitle, this.columnCountWithTitle + this.columnCountOnlyValues);
                    }
                    this.prepareNextLine((Rectangle)cloneable, this.lineH);
                }
            }
            n2 = 0;
        }
        if (n == this.pagesToPrint - 1 && this.withLines) {
            int n4 = ((Rectangle)cloneable).height / this.emptyLineH;
            if (n4 > 6) {
                n4 = 6;
            }
            for (int i = 0; i < n4; ++i) {
                if (!this.secondValueLines) {
                    this.printLineEmpty(graphics, (Rectangle)cloneable, this.emptyLineH, 0, this.columnCountWithTitle);
                } else {
                    this.printLineEmpty(graphics, (Rectangle)cloneable, this.emptyLineH, this.columnCountWithTitle, this.columnCountWithTitle + this.columnCountOnlyValues);
                }
                this.prepareNextLine((Rectangle)cloneable, this.emptyLineH);
            }
        }
        return n2;
    }

    private void computeWidth(Graphics graphics, Rectangle rectangle) {
        int n = 1;
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getNormalFont());
        this.numberWidth = this.secondValueLines ? fontMetrics.stringWidth("12. ") + n : 0;
        this.columnWidth = n;
        int n2 = 0;
        int n3 = this.numberWidth;
        while (n2 <= this.caseResult.getColumnCount() && n3 < rectangle.width) {
            int n4;
            int n5;
            if (n2 == 0) {
                if (this.secondValueLines) {
                    this.titleWidth = 0;
                } else {
                    this.titleWidth = n;
                    for (n5 = 0; n5 < this.caseResult.getRowCount(); ++n5) {
                        n4 = fontMetrics.stringWidth(this.caseResult.getValueAt(n5, n2)) + n;
                        if (n4 <= this.titleWidth) continue;
                        this.titleWidth = n4;
                    }
                    if (this.titleWidth > rectangle.width * 2 / 5) {
                        this.titleWidth = rectangle.width * 2 / 5;
                    }
                }
            } else {
                n5 = fontMetrics.stringWidth(this.caseResult.getValueAt(0, n2)) + n;
                n4 = fontMetrics.stringWidth(this.caseResult.getValueAt(1, n2)) + n;
                if (n4 > n5) {
                    n5 = n4;
                }
                if (n5 > this.columnWidth) {
                    this.columnWidth = n5;
                }
            }
            this.columnCountWithTitle = n2++;
            n3 = this.numberWidth + this.titleWidth + this.columnWidth * this.columnCountWithTitle;
        }
        if (this.secondValueLines) {
            this.titleWidth = rectangle.width - this.numberWidth;
            this.columnCountWithTitle = 1;
        }
        this.columnCountOnlyValues = (rectangle.width - this.numberWidth - n - n) / this.columnWidth;
        Font font = new Font("Dialog", 0, 12);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(font);
        this.emptyLineH = fontMetrics2.getHeight() + 2;
        if (this.lineH > this.emptyLineH) {
            this.emptyLineH = this.lineH;
        }
    }

    private boolean checkPrinting(Rectangle rectangle, int n, int n2) {
        if (rectangle.height < n) {
            Rectangle rectangle2 = new Rectangle(this.getInnerBounds());
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.y + 3;
            rectangle.width = rectangle2.width;
            rectangle.height = rectangle2.height - 6;
            ++this.actualOutPage;
            if (this.actualOutPage >= this.pagesToPrint) {
                this.pagesToPrint = this.actualOutPage + 1;
            }
        }
        return this.actualOutPage == n2;
    }

    private void prepareNextLine(Rectangle rectangle, int n) {
        rectangle.height -= n;
        rectangle.y += n;
    }

    private void printLineHeader(Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        int n4;
        int n5 = rectangle.x + 1;
        int n6 = rectangle.y + 1;
        int n7 = this.lineH - 1;
        int n8 = 0;
        if (this.secondValueLines) {
            n5 += this.numberWidth;
        }
        if (n2 == 0) {
            n4 = this.titleWidth - 1;
            Object object = this.caseResult.getValueAt(n, 0);
            if (n == 1) {
                object = (String)object + this.caseResult.getFilterAt(0);
            }
            if (n == 0) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.LIGHT_GRAY);
            }
            graphics.fillRect(n5 - 1, n6 - 1, n4 + 1, n7 + 1);
            graphics.setColor(Color.BLACK);
            this.printNormalRight(graphics, (String)object, n5, n6, n4, n7);
            graphics.drawLine(n5 - 1, n6 - 1, n5 + n4, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n7);
            graphics.drawLine(n5 + n4, n6 - 1, n5 + n4, n6 + n7);
            graphics.drawLine(n5 - 1, n6 + n7, n5 + n4, n6 + n7);
            n8 = 1;
            n5 += this.titleWidth;
        }
        for (n4 = n2 + n8; n4 < n3 && n4 <= this.caseResult.getColumnCount(); ++n4) {
            int n9 = this.columnWidth - 1;
            Object object = this.caseResult.getValueAt(n, n4);
            if (n == 1) {
                object = (String)object + this.caseResult.getFilterAt(n4);
            }
            if (n == 0) {
                graphics.setColor(Color.WHITE);
            } else {
                graphics.setColor(Color.LIGHT_GRAY);
            }
            graphics.fillRect(n5 - 1, n6 - 1, n9 + 1, n7 + 1);
            graphics.setColor(Color.BLACK);
            this.printNormalCenter(graphics, (String)object, n5, n6, n9, n7);
            graphics.drawLine(n5 - 1, n6 - 1, n5 + n9, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n7);
            graphics.drawLine(n5 + n9, n6 - 1, n5 + n9, n6 + n7);
            graphics.drawLine(n5 - 1, n6 + n7, n5 + n9, n6 + n7);
            n5 += this.columnWidth;
        }
    }

    private void printLineRubrics(Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        Object object;
        int n4;
        int n5 = rectangle.x + 1;
        int n6 = rectangle.y + 1;
        int n7 = this.lineH - 1;
        int n8 = 0;
        if (this.secondValueLines) {
            n4 = this.numberWidth - 1;
            object = n - this.caseResult.titleSize() + 1 + ".";
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n5 - 1, n6 - 1, n4 + 1, n7 + 1);
            graphics.setColor(Color.BLACK);
            this.printNormalRight(graphics, (String)object, n5, n6, n4, n7);
            graphics.drawLine(n5 - 1, n6 - 1, n5 + n4, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n7);
            graphics.drawLine(n5 + n4, n6 - 1, n5 + n4, n6 + n7);
            graphics.drawLine(n5 - 1, n6 + n7, n5 + n4, n6 + n7);
            n5 += this.numberWidth;
        }
        if (n2 == 0) {
            n4 = this.titleWidth - 1;
            object = this.caseResult.getValueAt(n, 0);
            if (((String)object).startsWith("P*") || ((String)object).startsWith("0*")) {
                graphics.setColor(Color.LIGHT_GRAY);
            } else {
                graphics.setColor(Color.WHITE);
            }
            graphics.fillRect(n5 - 1, n6 - 1, n4 + 1, n7 + 1);
            graphics.setColor(Color.BLACK);
            this.printNormalLeft(graphics, (String)object, n5, n6, n4, n7);
            graphics.drawLine(n5 - 1, n6 - 1, n5 + n4, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n7);
            graphics.drawLine(n5 + n4, n6 - 1, n5 + n4, n6 + n7);
            graphics.drawLine(n5 - 1, n6 + n7, n5 + n4, n6 + n7);
            n8 = 1;
            n5 += this.titleWidth;
        }
        for (n4 = n2 + n8; n4 < n3 && n4 < this.caseResult.getColumnCount(); ++n4) {
            int n9 = this.columnWidth - 1;
            String string = this.caseResult.getValueAt(n, n4);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n5 - 1, n6 - 1, n9 + 1, n7 + 1);
            graphics.setColor(Color.BLACK);
            this.printNormalCenter(graphics, string, n5, n6, n9, n7);
            graphics.drawLine(n5 - 1, n6 - 1, n5 + n9, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n7);
            graphics.drawLine(n5 + n9, n6 - 1, n5 + n9, n6 + n7);
            graphics.drawLine(n5 - 1, n6 + n7, n5 + n9, n6 + n7);
            n5 += this.columnWidth;
        }
    }

    private void printLineEmpty(Graphics graphics, Rectangle rectangle, int n, int n2, int n3) {
        int n4;
        int n5 = rectangle.x + 1;
        if (this.secondValueLines) {
            n5 += this.numberWidth;
        }
        int n6 = rectangle.y + 1;
        int n7 = n - 1;
        if (n2 == 0) {
            n4 = this.titleWidth - 1;
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n5 - 1, n6 - 1, n4 + 1, n7 + 1);
            graphics.setColor(Color.BLACK);
            this.printNormalLeft(graphics, "", n5, n6, n4, n7);
            graphics.drawLine(n5 - 1, n6 - 1, n5 + n4, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n7);
            graphics.drawLine(n5 + n4, n6 - 1, n5 + n4, n6 + n7);
            graphics.drawLine(n5 - 1, n6 + n7, n5 + n4, n6 + n7);
            n5 += this.titleWidth;
            ++n2;
        }
        for (n4 = n2; n4 < n3 && n4 <= this.caseResult.getColumnCount(); ++n4) {
            int n8 = this.columnWidth - 1;
            graphics.setColor(Color.WHITE);
            graphics.fillRect(n5 - 1, n6 - 1, n8 + 1, n7 + 1);
            graphics.setColor(Color.BLACK);
            this.printNormalCenter(graphics, "", n5, n6, n8, n7);
            graphics.drawLine(n5 - 1, n6 - 1, n5 + n8, n6 - 1);
            graphics.drawLine(n5 - 1, n6 - 1, n5 - 1, n6 + n7);
            graphics.drawLine(n5 + n8, n6 - 1, n5 + n8, n6 + n7);
            graphics.drawLine(n5 - 1, n6 + n7, n5 + n8, n6 + n7);
            n5 += this.columnWidth;
        }
    }
}

