/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.ToolData;
import ch.steph.util.Constants;
import ch.steph.util.Log;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RegBox
extends JDialog {
    public static final String nameZeichen = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890 !\"#$%&'()*+,-./:;<=>?@[\\]_{}";
    private static final long serialVersionUID = 1L;
    private JTextField nameText;
    private JCheckBox aboBox;
    private JTextField key1Text;
    private JTextField key2Text;
    private JTextField key3Text;
    private JTextField key4Text;
    private JTextField key5Text;
    private JTextField key6Text;
    private JTextField key7Text;
    private JTextField key8Text;
    private JTextField key9Text;
    private JTextField keyAText;
    private JTextField keyBText;
    private JButton okButton;
    private JButton cancelButton;
    private JFrame parent;
    private String[] text = new String[]{StringResource.getString("reg_1"), StringResource.getString("reg_2")};
    private JTextField changeField;
    private String changeText;

    public RegBox(JFrame jFrame) {
        super((Frame)jFrame, true);
        JComponent jComponent;
        this.parent = jFrame;
        Log.write(4, this.getClass().getName(), "start");
        this.setTitle(StringResource.getString("reg_title") + " V" + Constants.getVersion());
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                RegBox.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().setLayout(gridBagLayout);
        for (String string : this.text) {
            jComponent = new JLabel(string, 0);
            gridBagLayout.setConstraints(jComponent, gridBagConstraints);
            this.getContentPane().add(jComponent);
        }
        JLabel jLabel = new JLabel(StringResource.getString("reg_name"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        this.nameText = new JTextField(User.instance().getUserName());
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.nameText, gridBagConstraints);
        this.getContentPane().add(this.nameText);
        this.nameText.addKeyListener(keyListener);
        JLabel jLabel2 = new JLabel(StringResource.getString("reg_code"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        this.getContentPane().add(jLabel2);
        String string = ToolData.getTestKey();
        JTextField jTextField = new JTextField(string);
        jTextField.setEditable(false);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        this.getContentPane().add(jTextField);
        jTextField.addKeyListener(keyListener);
        JLabel jLabel3 = new JLabel(" ");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        this.getContentPane().add(jLabel3);
        boolean bl = User.instance().getProperty("LicFromNet", false);
        JLabel jLabel4 = new JLabel(" Abonnement");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        this.getContentPane().add(jLabel4);
        this.aboBox = new JCheckBox();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.aboBox, gridBagConstraints);
        this.getContentPane().add(this.aboBox);
        this.aboBox.setSelected(bl);
        this.aboBox.addActionListener(actionEvent -> this.setAboBox(this.aboBox.isSelected()));
        JLabel jLabel5 = new JLabel(" ");
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel5, gridBagConstraints);
        this.getContentPane().add(jLabel5);
        this.key1Text = new JTextField(User.instance().getProperty("Key", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_rep") + "1"), this.key1Text, gridBagLayout, gridBagConstraints, keyListener);
        this.key2Text = new JTextField(User.instance().getProperty("Key2", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_mm") + "1"), this.key2Text, gridBagLayout, gridBagConstraints, keyListener);
        this.key3Text = new JTextField(User.instance().getProperty("Key3", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_rep") + "2"), this.key3Text, gridBagLayout, gridBagConstraints, keyListener);
        this.key4Text = new JTextField(User.instance().getProperty("Key4", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_mm") + "2"), this.key4Text, gridBagLayout, gridBagConstraints, keyListener);
        this.key6Text = new JTextField(User.instance().getProperty("Key6", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_rep") + "3"), this.key6Text, gridBagLayout, gridBagConstraints, keyListener);
        this.key7Text = new JTextField(User.instance().getProperty("Key7", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_mm") + "3"), this.key7Text, gridBagLayout, gridBagConstraints, keyListener);
        this.key8Text = new JTextField(User.instance().getProperty("Key8", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_rep") + "4"), this.key8Text, gridBagLayout, gridBagConstraints, keyListener);
        this.key9Text = new JTextField(User.instance().getProperty("Key9", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_mm") + "4"), this.key9Text, gridBagLayout, gridBagConstraints, keyListener);
        this.keyAText = new JTextField(User.instance().getProperty("KeyA", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_rep") + "5"), this.keyAText, gridBagLayout, gridBagConstraints, keyListener);
        this.keyBText = new JTextField(User.instance().getProperty("KeyB", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_mm") + "5"), this.keyBText, gridBagLayout, gridBagConstraints, keyListener);
        this.key5Text = new JTextField(User.instance().getProperty("Key5", ""));
        this.initOneKeyLine(new JLabel(StringResource.getString("reg_key_year")), this.key5Text, gridBagLayout, gridBagConstraints, keyListener);
        jComponent = new JPanel();
        this.okButton = new JButton(StringResource.getString("button_ok"));
        this.okButton.addActionListener(actionEvent -> this.buttonOkAction());
        jComponent.add(this.okButton);
        this.okButton.addKeyListener(keyListener);
        this.getRootPane().setDefaultButton(this.okButton);
        jComponent.add(new JLabel(StringResource.getString("button_between_small")));
        this.cancelButton = new JButton(StringResource.getString("button_cancel"));
        this.cancelButton.addActionListener(actionEvent -> this.closeAction());
        jComponent.add(this.cancelButton);
        this.cancelButton.addKeyListener(keyListener);
        jComponent.add(new JLabel(StringResource.getString("button_between_small")));
        JButton jButton = new JButton("    Import    ");
        jButton.addActionListener(actionEvent -> this.importAction());
        jComponent.add(jButton);
        jButton.addKeyListener(keyListener);
        gridBagConstraints.weightx = 4.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jComponent, gridBagConstraints);
        this.getContentPane().add(jComponent);
        this.nameText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RegBox.this.nameTextChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RegBox.this.nameTextChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RegBox.this.nameTextChanged();
            }
        });
        this.nameTextChanged();
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                RegBox.this.closeAction();
            }
        });
        Rectangle rectangle = this.getParent().getBounds();
        Rectangle rectangle2 = this.getBounds();
        rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
        rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
        this.setBounds(rectangle2);
        this.setAboBox(bl);
    }

    private void initOneKeyLine(JLabel jLabel, final JTextField jTextField, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, KeyListener keyListener) {
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(jTextField, gridBagConstraints);
        this.getContentPane().add(jTextField);
        jTextField.addKeyListener(keyListener);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RegBox.this.keyTextValueChanged(jTextField);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RegBox.this.keyTextValueChanged(jTextField);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RegBox.this.keyTextValueChanged(jTextField);
            }
        });
        jLabel = new JLabel(" ");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.getContentPane().add(jLabel);
    }

    protected void keyTextValueChanged(JTextField jTextField) {
        String string = jTextField.getText();
        String string2 = string.trim();
        if (string2.length() > 8) {
            string2 = string2.substring(0, 8);
        }
        if (!string.equals(string2)) {
            this.changeField = jTextField;
            this.changeText = string2;
            SwingUtilities.invokeLater(() -> this.changeField.setText(this.changeText));
        }
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        try {
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                char c = Character.toUpperCase(keyEvent.getKeyChar());
                if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (c == '\n') {
                    keyEvent.consume();
                    this.buttonOkAction();
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    protected void setAboBox(boolean bl) {
        this.key1Text.setEditable(!bl);
        this.key2Text.setEditable(!bl);
        this.key3Text.setEditable(!bl);
        this.key4Text.setEditable(!bl);
        this.key5Text.setEditable(!bl);
        this.key6Text.setEditable(!bl);
        this.key7Text.setEditable(!bl);
        this.key8Text.setEditable(!bl);
        this.key9Text.setEditable(!bl);
        this.keyAText.setEditable(!bl);
        this.keyBText.setEditable(!bl);
        User.instance().setProperty("LicFromNet", bl);
    }

    protected void buttonOkAction() {
        User.instance().setProperty("Name", this.nameText.getText());
        User.instance().setProperty("Key", this.key1Text.getText());
        User.instance().setProperty("Key2", this.key2Text.getText());
        User.instance().setProperty("Key3", this.key3Text.getText());
        User.instance().setProperty("Key4", this.key4Text.getText());
        User.instance().setProperty("Key5", this.key5Text.getText());
        User.instance().setProperty("Key6", this.key6Text.getText());
        User.instance().setProperty("Key7", this.key7Text.getText());
        User.instance().setProperty("Key8", this.key8Text.getText());
        User.instance().setProperty("Key9", this.key9Text.getText());
        User.instance().setProperty("KeyA", this.keyAText.getText());
        User.instance().setProperty("KeyB", this.keyBText.getText());
        this.closeAction();
    }

    protected void closeAction() {
        this.setVisible(false);
        Log.write(4, this.getClass().getName(), "end");
    }

    protected void importAction() {
        Object object = JOptionPane.showInputDialog(this.parent.getContentPane(), (Object)"Import Registrierung: Kopieren Sie hier bitte die lange Zeichenfolge aus der Registrierungs-Mail (mit Strg/ctrl+V)");
        if (object != null && ((String)object).length() >= 8) {
            object = ((String)object).trim();
            while (((String)object).length() < 88) {
                object = (String)object + "0";
            }
            this.setField(this.key1Text, (String)object, 0);
            this.setField(this.key2Text, (String)object, 8);
            this.setField(this.key3Text, (String)object, 16);
            this.setField(this.key4Text, (String)object, 24);
            this.setField(this.key5Text, (String)object, 32);
            this.setField(this.key6Text, (String)object, 40);
            this.setField(this.key7Text, (String)object, 48);
            this.setField(this.key8Text, (String)object, 56);
            this.setField(this.key9Text, (String)object, 64);
            this.setField(this.keyAText, (String)object, 72);
            this.setField(this.keyBText, (String)object, 80);
        }
    }

    private void setField(JTextField jTextField, String string, int n) {
        String string2 = string.substring(n, n + 8);
        if ("00000000".equals(string2)) {
            jTextField.setText("");
        } else {
            jTextField.setText(string2);
        }
    }

    private void nameTextChanged() {
        String string;
        String string2 = this.nameText.getText();
        if (!string2.equals(string = RegBox.name32FieldTextValueChanged(string2))) {
            SwingUtilities.invokeLater(() -> {
                this.nameText.setText(string);
                this.nameText.setCaretPosition(string.length());
            });
        }
        if (string.length() > 4) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    public static String name32FieldTextValueChanged(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length() && i < 32; ++i) {
                char c = string.charAt(i);
                for (int j = 0; j < nameZeichen.length(); ++j) {
                    if (c != nameZeichen.charAt(j)) continue;
                    stringBuilder.append(c);
                }
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }
}

