/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.InfoBox;
import ch.steph.apputil.MdiMainFrame;
import ch.steph.apputil.MdiModalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.apputil.VersionHint;
import ch.steph.rep.CaseResult;
import ch.steph.rep.MasterProp;
import ch.steph.rep.Rep;
import ch.steph.rep.ToolData;
import ch.steph.repdata.CaseRubric;
import ch.steph.repdata.FileSynch;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repform.BuildForm;
import ch.steph.repui.CaseReadOnly;
import ch.steph.repui.CaseShow;
import ch.steph.repui.ConsultShow;
import ch.steph.repui.CrAuthorSelect;
import ch.steph.repui.FirstIni;
import ch.steph.repui.FormChooserBox;
import ch.steph.repui.HelpShowJ;
import ch.steph.repui.InputAll;
import ch.steph.repui.InputRubr;
import ch.steph.repui.InputValue;
import ch.steph.repui.MediCompare;
import ch.steph.repui.MultiFrame;
import ch.steph.repui.OptionBox;
import ch.steph.repui.PatientBox;
import ch.steph.repui.RegBox;
import ch.steph.repui.RepMainMenu;
import ch.steph.repui.RubricChange;
import ch.steph.repui.RubricShow;
import ch.steph.repui.SearchMedica;
import ch.steph.repui.WebBox;
import ch.steph.reputil.HelpUtil;
import ch.steph.reputil.MmMedis;
import ch.steph.reputil.MmUtil;
import ch.steph.reputil.NoteUtil;
import ch.steph.reputil.PatientUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricChangeFile;
import ch.steph.reputil.RubricOwnFile;
import ch.steph.reputil.RubricPublicFile;
import ch.steph.reputil.RubricShowUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.reputil.SuperUserActions;
import ch.steph.servrep.BrowseHtm;
import ch.steph.servrep.GetServlet;
import ch.steph.util.Constants;
import ch.steph.util.CryptBase64Service;
import ch.steph.util.CryptHexService;
import ch.steph.util.DesktopUtils;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.MemCache;
import ch.steph.util.PwHelper;
import ch.steph.util.StartEkit;
import ch.steph.util.StartRtfProcessor;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class RepMainFrame
extends MdiMainFrame {
    private static final long serialVersionUID = 1L;
    private static final String CLASS_NAME = "ch.steph.repui.RepMainFrame";
    private InputRubr inputRubr = null;
    private InputValue inputValue = null;
    private MediCompare compareRubric = null;
    private InputAll inputAll = null;
    protected CaseShow caseShow;
    private MultiFrame multiFrame;
    private RubricShow rubricShow;
    private ConsultShow consultShow;
    private ToolData toolData;
    private VersionHint versionHint;
    private boolean noAddonText = true;
    private boolean exitLongThreads = false;
    private boolean searching = false;
    private JFrame extNoteFrame = null;
    private String showWaitingText = null;
    private boolean waitingActive = false;
    private String titleText = "";
    private static FileFilter importFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".asc");
        }

        @Override
        public String getDescription() {
            return "jRep   *.asc";
        }
    };
    private static String[] messageText2 = new String[]{StringResource.getString("message_reinit_1"), StringResource.getString("message_reinit_2")};
    private static String[] messageTextReg = new String[]{StringResource.getString("message_reinit_1"), StringResource.getString("message_reinit_4")};
    private static FileFilter repFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".rep");
        }

        @Override
        public String getDescription() {
            return "jRep   *.rep";
        }
    };
    private Rubric selectedRubricParameter;
    private boolean menuEnableStarted = false;

    public RepMainFrame() {
        RepMainMenu repMainMenu = new RepMainMenu(this, this.getLookAndFeelMenu());
        this.setJMenuBar(repMainMenu);
        Log.write(5, CLASS_NAME, "Constructor end");
    }

    public static RepMainFrame getRepInstance() {
        return (RepMainFrame)MdiMainFrame.getInstance();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            Log.write(5, CLASS_NAME, "setVisible");
            this.toolData = new ToolData(MdiMainFrame.getInstance().getMainFrame());
            ToolData.checkOk(1, 0);
            this.toolData.checkTool();
            this.setMainTitle(null);
            this.startEarlyBackgroundJobs();
            this.inputRubr = new InputRubr();
            this.addAndSelect(this.inputRubr);
            this.setMainTopWindow(this.inputRubr);
            this.rubricShow = new RubricShow(false);
            this.add(this.rubricShow);
            this.multiFrame = new MultiFrame();
            MdiMainFrame.getInstance().add(this.multiFrame);
            User.instance().getNewCaseResult(this.multiFrame);
            this.caseShow = new CaseShow();
            this.add(this.caseShow);
            this.newCaseAction();
            if (Rep.loadFileName != null) {
                this.caseShow.loadFile(Rep.loadFileName);
                Log.write(5, this.getClass().getName(), "Load File: " + Rep.loadFileName);
                Rep.loadFileName = null;
            }
        }
        if (!User.instance().getProperty("HelpShowed", false)) {
            User.instance().setProperty("HelpShowed", true);
            this.helpAction();
        }
        User.instance().setProperty("cStarted", User.instance().getProperty("cStarted", 0) + 1);
        this.startEndTimer(System.currentTimeMillis() + 900L);
        SwingUtilities.invokeLater(() -> RepMainFrame.getRepInstance().setMainRubric(null));
        Log.write(5, CLASS_NAME, "setVisible end");
    }

    private void setMainTitle(String string) {
        String string2 = Constants.getVersion();
        if (string == null || string.length() == 0) {
            this.noAddonText = true;
            this.titleText = "jRep " + string2 + "  " + ToolData.getRegString();
        } else {
            this.noAddonText = false;
            this.titleText = "jRep " + string2 + "  " + string;
        }
        SwingUtilities.invokeLater(() -> this.getMainFrame().setTitle(this.titleText));
    }

    @Override
    public void additionalExitAction() {
        super.additionalExitAction();
        this.exitLongThreads = true;
    }

    @Override
    public void remove(JInternalFrame jInternalFrame) {
        super.remove(jInternalFrame);
        if (jInternalFrame instanceof InputValue) {
            this.inputValue = null;
        }
        if (jInternalFrame instanceof InputAll) {
            this.inputAll = null;
        }
        if (jInternalFrame instanceof MediCompare) {
            this.compareRubric = null;
        }
        if (jInternalFrame instanceof ConsultShow) {
            this.consultShow = null;
        }
    }

    public void checkCaseShowChanged() throws Exception {
        if (this.caseShow != null) {
            this.caseShow.checkDataChanged(CaseShow.BoxDef.STANDARD);
        }
    }

    public void checkAndGetFocus() {
        if (this.inputRubr == null) {
            this.selectLastTopWindow();
        } else {
            this.selectFrame(this.inputRubr);
            this.inputRubr.requestFocus();
        }
    }

    private void preMenuAction() {
        try {
            this.closeMdiModalFrame();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "preMenuAction", exception);
        }
    }

    public void newCaseAction() {
        this.preMenuAction();
        try {
            if (this.caseShow != null) {
                this.caseShow.checkDataChanged(CaseShow.BoxDef.STANDARD);
                User.instance().getNewCaseResult(this.multiFrame);
                this.caseShow.newCaseAction();
            }
            this.setMenuEnables(null);
            if (this.inputRubr != null) {
                this.inputRubr.newCaseAction();
            }
            if (this.caseShow != null) {
                this.caseShow.focusToParent();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newCaseAction", exception);
        }
    }

    public void loadAction() {
        this.preMenuAction();
        try {
            this.toolMainCheck();
            this.caseShow.loadCase();
            this.checkAndGetFocus();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "loadAction", exception);
        }
    }

    public void loadFileAction(String string) {
        this.preMenuAction();
        try {
            this.caseShow.loadFile(string);
            this.checkAndGetFocus();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "loadAction", exception);
        }
    }

    public void saveAction(boolean bl) {
        this.preMenuAction();
        try {
            this.toolMainCheck();
            if (User.instance().getCaseResultLength() > 0) {
                this.caseShow.saveCase(bl);
            }
            this.checkAndGetFocus();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "saveAction", exception);
        }
    }

    public void saveResultAction() {
        this.preMenuAction();
        try {
            this.toolMainCheck();
            if (User.instance().getCaseResultLength() > 0) {
                this.caseShow.saveResult();
            }
            this.checkAndGetFocus();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "saveResultAction", exception);
        }
    }

    public void patientAction() {
        JComponent jComponent;
        if (User.instance().getProperty("patPw", "").length() > 0 && User.instance().getProperty("askPw", true)) {
            jComponent = new JPasswordField("", 16);
            JOptionPane.showInternalMessageDialog(this.getDesktop(), jComponent, StringResource.getString("pat_pw_opt"), 3);
            if (!User.instance().getProperty("patPw", "This1Is2Not3A4Password").equals(PwHelper.hashPassword(String.valueOf(((JPasswordField)jComponent).getPassword())))) {
                JOptionPane.showInternalMessageDialog(this.getDesktop(), StringResource.getString("pat_pw_not_ok"), "jRep", 1);
                return;
            }
            User.instance().setProperty("askPw", false);
        }
        this.preMenuAction();
        try {
            if (GetDataFile.getDataPath() == null) {
                JOptionPane.showInternalMessageDialog(this.getDesktop(), StringResource.getString("message_define_datapath"), "jRep", 1);
                this.optionAction();
            }
            if (PatientUtil.isPatientActive() && !this.addAndSelectModal((MdiModalFrame)(jComponent = new PatientBox()))) {
                ((JInternalFrame)jComponent).dispose();
                Log.write(5, this.getClass().getName(), "no patient, because other modal window");
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "patientAction", exception);
        }
    }

    public void webAction() {
        this.preMenuAction();
        try {
            WebBox webBox;
            if (GetDataFile.getDataPath() == null) {
                JOptionPane.showInternalMessageDialog(this.getDesktop(), StringResource.getString("message_define_datapath"), "jRep", 1);
                this.optionAction();
            }
            if (PatientUtil.isPatientActive() && !this.addAndSelectModal(webBox = new WebBox())) {
                webBox.dispose();
                Log.write(5, this.getClass().getName(), "no patient, because other modal window");
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "patientAction", exception);
        }
    }

    public void printResultAction() {
        this.preMenuAction();
        try {
            User.instance().setProperty("cPrinted", User.instance().getProperty("cPrinted", 0) + 1);
            if (User.instance().getCaseResultLength() > 0) {
                this.caseShow.printResultAction(ToolData.getRegString());
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "saveResultAction", exception);
        }
    }

    public void newSearchAction() {
        this.preMenuAction();
        try {
            if (!(this.compareRubric != null && this.compareRubric.isSelected() || this.inputValue != null && this.inputValue.isSelected())) {
                if (this.inputAll != null && this.inputAll.isSelected()) {
                    this.inputAll.newSearchAction();
                } else {
                    this.inputRubr.newSearchAction(true);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newSearchAction", exception);
        }
    }

    public void oldSearchAction() {
        this.preMenuAction();
        try {
            this.inputRubr.oldSearchAction();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "oldSearchAction", exception);
        }
    }

    public void showAction() {
        this.preMenuAction();
        try {
            if (this.compareRubric == null || !this.compareRubric.isSelected()) {
                if (this.inputValue != null && this.inputValue.isSelected()) {
                    this.inputValue.showAction();
                } else if (this.inputAll != null && this.inputAll.isSelected()) {
                    this.inputAll.showAction();
                } else {
                    this.inputRubr.showAction();
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "showAction", exception);
        }
    }

    public void selectAction() {
        try {
            if (this.compareRubric != null && this.compareRubric.isSelected()) {
                this.compareRubric.selectForCaseResult();
            } else if (this.inputValue != null && this.inputValue.isSelected()) {
                this.inputValue.selectForCaseResult();
            } else if (this.inputAll != null && this.inputAll.isSelected()) {
                this.inputAll.selectForCaseResult();
            } else {
                this.inputRubr.selectForCaseResult();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "selectAction", exception);
        }
    }

    public void selectHierarchic() {
        try {
            if (!(this.compareRubric != null && this.compareRubric.isSelected() || this.inputValue != null && this.inputValue.isSelected() || this.inputAll != null && this.inputAll.isSelected())) {
                this.inputRubr.selectHierarchic(true);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "selectHierarchic", exception);
        }
    }

    public void selectHierarchicForCaseResult() {
        try {
            if (!(this.compareRubric != null && this.compareRubric.isSelected() || this.inputValue != null && this.inputValue.isSelected() || this.inputAll != null && this.inputAll.isSelected())) {
                this.inputRubr.selectHierarchicForCaseResult();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "selectHierarchicForCaseResult", exception);
        }
    }

    private Rubric findSelectedRubric() {
        Rubric rubric = this.compareRubric != null && this.compareRubric.isSelected() ? this.compareRubric.getSelectedRubric() : (this.inputValue != null && this.inputValue.isSelected() ? this.inputValue.getSelectedRubric() : (this.inputAll != null && this.inputAll.isSelected() ? this.inputAll.getSelectedRubric() : this.inputRubr.getSelectedRubric()));
        return rubric;
    }

    public void exportRubricAction() {
        this.preMenuAction();
        try {
            String[] stringArray;
            Rubric rubric = this.findSelectedRubric();
            if (rubric != null && (stringArray = RubricUtil.exportRubric(this.getMainFrame().getToolkit(), rubric)) != null) {
                JOptionPane.showInternalMessageDialog(this.getDesktop(), stringArray, "jRep", 1);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "exportRubricAction", exception);
        }
    }

    public void copyToClipboard() {
        try {
            if (this.compareRubric == null || !this.compareRubric.isSelected()) {
                if (this.inputValue != null && this.inputValue.isSelected()) {
                    this.inputValue.copyToClipboard();
                } else if (this.inputAll != null && this.inputAll.isSelected()) {
                    this.inputAll.copyToClipboard();
                } else {
                    this.inputRubr.copyToClipboard();
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "copyToClipboard", exception);
        }
    }

    public void changeActRubric() {
        this.preMenuAction();
        try {
            Rubric rubric = this.findSelectedRubric();
            if (rubric != null) {
                this.addAndSelect(new RubricChange(StringResource.getString("rep_change"), rubric));
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "changeActRubric", exception);
        }
    }

    protected void newRubric() {
        this.preMenuAction();
        try {
            this.toolMainCheck();
            String string = RepDataPool.getInstance().getRepHeader(User.instance().getActRepIndex()).getRepId();
            this.addAndSelect(new RubricChange(StringResource.getString("rep_new"), User.instance().getActRepIndex(), string, RepUtil.getFullMediArray()));
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newRubric", exception);
        }
    }

    protected void newRubric(String string, String[] stringArray, int[] nArray) {
        this.preMenuAction();
        try {
            this.toolMainCheck();
            String string2 = RepDataPool.getInstance().getRepHeader(User.instance().getActRepIndex()).getRepId();
            this.addAndSelect(new RubricChange(StringResource.getString("rep_new"), User.instance().getActRepIndex(), string2, string, stringArray, nArray));
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newRubric", exception);
        }
    }

    public void deleteRubric() {
        this.preMenuAction();
        try {
            int n = JOptionPane.showConfirmDialog(this, StringResource.getString("rep_deleteconfirm"), StringResource.getString("rep_delete"), 0);
            if (n == 0) {
                Rubric rubric = this.findSelectedRubric();
                if (rubric != null) {
                    String string = rubric.getRubricKey();
                    int n2 = User.instance().getActRepIndex();
                    if (!RepDataPool.getInstance().getRepFile(n2).isEditExtern()) {
                        RubricOwnFile.deleteRubric(n2, string);
                    }
                    RubricPublicFile.deleteInPublicFile(n2, string);
                    RubricChangeFile.checkFileChangedForDelete(n2);
                    RepDataPool.getInstance().reloadRepFile(n2);
                }
                this.searchAgain();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "deleteRubric", exception);
        }
    }

    private String[] getCaseMedis() {
        CaseResult caseResult = User.instance().getCaseResult();
        String[] stringArray = new String[caseResult.getColumnCount() - 1];
        for (int i = 1; i < caseResult.getColumnCount(); ++i) {
            stringArray[i - 1] = caseResult.getValueAt(0, i);
        }
        return stringArray;
    }

    public void newCaseRubric(String string) {
        this.preMenuAction();
        try {
            this.addAndSelect(new RubricChange(this.caseShow, User.instance().getActRepIndex(), this.getCaseMedis(), null, string, false));
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newRubric", exception);
        }
    }

    protected void newCaseRubricAll() {
        this.preMenuAction();
        try {
            this.addAndSelect(new RubricChange(this.caseShow, User.instance().getActRepIndex(), RepUtil.getFullMediArray(), null, null, true));
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newRubric", exception);
        }
    }

    protected void caseShowDeleteRowAction() {
        this.preMenuAction();
        try {
            this.caseShow.deleteRow();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowDeleteRowAction", exception);
        }
    }

    public void changeCaseRubric(boolean bl) {
        this.preMenuAction();
        try {
            CaseRubric caseRubric;
            if (User.instance().getCaseResultLength() > 0 && (caseRubric = this.caseShow.getActRubric()) != null) {
                String[] stringArray = bl ? RepUtil.getFullMediArray() : User.instance().getCaseResult().getMedisSorted();
                this.addAndSelect(new RubricChange(this.caseShow, User.instance().getActRepIndex(), stringArray, caseRubric, null, bl));
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newRubric", exception);
        }
    }

    protected void caseShowMoveRowUpAction() {
        try {
            this.caseShow.moveRowUp();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowMoveRowUpAction", exception);
        }
    }

    protected void caseShowMoveRowDownAction() {
        try {
            this.caseShow.moveRowDown();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowMoveRowDownAction", exception);
        }
    }

    protected void caseShowDoubleRubricAction() {
        try {
            this.caseShow.doubleRubric();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowDoubleRubricAction", exception);
        }
    }

    protected void caseShowDivRubricRowAction() {
        try {
            this.caseShow.divRubric();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowDivRubricRowAction", exception);
        }
    }

    public void joinAction() {
        this.preMenuAction();
        try {
            this.caseShow.joinAction();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowJoinAction", exception);
        }
    }

    public void caseShowCopyToClipboard() {
        try {
            this.caseShow.copyToClipboard();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowCopyToClipboard", exception);
        }
    }

    public void caseShowCopyTabsToClipboard() {
        try {
            this.caseShow.copyTabsToClipboard();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowCopyToClipboard", exception);
        }
    }

    public void copyToTableEdit() {
        try {
            this.caseShow.copyToTableEdit();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowCopyToClipboard", exception);
        }
    }

    public void caseShowSortAgain(String string) {
        try {
            if (this.caseShow != null && User.instance().getCaseResultLength() > 0) {
                this.inputRubr.setTitle("jRep" + StringResource.getString("title_sort_byRating"));
                this.caseShow.sortAgain();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowSortAgain", exception);
        }
    }

    public void sortByRubricAction() {
        try {
            this.caseShow.sortByRubric();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "sortByRubricAction", exception);
        }
    }

    public void sortByPolarAction() {
        try {
            this.caseShow.sortByPolar();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "sortByPolarAction", exception);
        }
    }

    public void caseShowBuildRatingAndSortAgain() {
        try {
            if (this.caseShow != null && User.instance().getCaseResultLength() > 0) {
                this.caseShow.buildRatingAndSortAgain();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "caseShowBuildRatingAndSortAgain", exception);
        }
    }

    public void filterAction(String string) {
        this.preMenuAction();
        try {
            this.caseShow.filterAction(string);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "filterAction", exception);
        }
    }

    public void newMedicaFrameAction(String string) {
        this.preMenuAction();
        try {
            Serializable serializable;
            String[] stringArray = null;
            if (string == null) {
                string = "MM-Info";
                stringArray = MmMedis.getMediArray();
            }
            if (stringArray == null) {
                if (this.caseShow != null && this.caseShow.isSelected() && ((CaseResult)(serializable = User.instance().getCaseResult())).getColumnCount() > 1) {
                    stringArray = new String[((CaseResult)serializable).getColumnCount()];
                    for (int i = 1; i < ((CaseResult)serializable).getColumnCount(); ++i) {
                        stringArray[i] = ((CaseResult)serializable).getValueAt(0, i);
                    }
                    stringArray[0] = "";
                }
                if (stringArray == null) {
                    stringArray = MmMedis.getMediArray();
                }
            }
            serializable = new SearchMedica(string, true, stringArray);
            this.addAndSelect((JInternalFrame)serializable);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newMedicaFrameAction", exception);
        }
    }

    public void searchByValue() {
        this.preMenuAction();
        try {
            if (this.inputValue == null) {
                this.inputValue = new InputValue(User.instance().getActRepIndex());
                this.addAndSelect(this.inputValue);
            } else {
                this.inputValue.toFront();
                this.selectFrame(this.inputValue);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "searchMedStart", exception);
        }
    }

    public void searchAllRep() {
        this.preMenuAction();
        try {
            if (RepMainMenu.searchInAllRep.isEnabled()) {
                if (this.inputAll == null) {
                    this.inputAll = new InputAll(this.inputRubr.getSearchString());
                    this.addAndSelect(this.inputAll);
                } else {
                    this.inputAll.toFront();
                    this.selectFrame(this.inputAll);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "searchAllRep", exception);
        }
    }

    protected void compareMediAction() {
        this.preMenuAction();
        try {
            if (this.compareRubric == null) {
                this.compareRubric = new MediCompare(User.instance().getActRepIndex());
                this.addAndSelect(this.compareRubric);
            } else {
                this.compareRubric.toFront();
                this.selectFrame(this.compareRubric);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "compareMediAction", exception);
        }
    }

    public void rubricAction() {
        try {
            Rubric rubric = this.findSelectedRubric();
            if (rubric != null) {
                this.newRubricWindowAction(rubric);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "rubricAction", exception);
        }
    }

    public void resultAction() {
        try {
            this.caseShow.checkAndGetFocusFromMain();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "resultAction", exception);
        }
    }

    public void medicaDynaAction() {
        try {
            if (this.multiFrame != null) {
                this.multiFrame.activateWindows();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "medicaDynaAction", exception);
        }
    }

    public void formBuilderAction() {
        this.preMenuAction();
        try {
            BuildForm buildForm;
            if (GetDataFile.getDataPath() == null) {
                JOptionPane.showInternalMessageDialog(this.getDesktop(), StringResource.getString("message_define_datapath"), "jRep", 1);
                this.optionAction();
            }
            if (!this.addAndSelectModal(buildForm = new BuildForm())) {
                buildForm.dispose();
                Log.write(5, this.getClass().getName(), "no formBuild, because other modal window");
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "formBuilderAction", exception);
        }
    }

    public void formSelectAction() {
        this.preMenuAction();
        try {
            FormChooserBox formChooserBox = new FormChooserBox();
            this.addAndSelectModal(formChooserBox);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "formSelectAction", exception);
        }
    }

    public void formImportAction(String string) {
        block23: {
            this.preMenuAction();
            try {
                String string2;
                int n;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.addChoosableFileFilter(importFileFilter);
                jFileChooser.setFileFilter(importFileFilter);
                jFileChooser.setDialogTitle(string);
                jFileChooser.setCurrentDirectory(FileProcedures.getFile(User.instance().getProperty("webImportDir", "")));
                int n2 = jFileChooser.showOpenDialog(MdiMainFrame.getInstance().getDesktop());
                if (n2 != 0) break block23;
                File file = jFileChooser.getSelectedFile();
                User.instance().setProperty("webImportDir", jFileChooser.getCurrentDirectory().getAbsolutePath());
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = ((InputStream)fileInputStream).read(byArray, 0, 1024)) >= 0) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                ((InputStream)fileInputStream).close();
                byteArrayOutputStream.close();
                if (byArray2.length <= 0) break block23;
                String string3 = new String(byArray2, 0, byArray2.length);
                try {
                    string2 = CryptBase64Service.getInstance("S!.Rae$$?").decryptFromString(string3);
                }
                catch (Exception exception) {
                    string2 = "";
                }
                if (string2.length() == 0) {
                    try {
                        string2 = CryptHexService.getInstance("S!.Rae$$?").decryptFromString(string3);
                    }
                    catch (Exception exception) {
                        string2 = "";
                    }
                }
                if (string2.length() > 0) {
                    FileLn fileLn = new FileLn();
                    fileLn.openReadWithInputString(string2);
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = "";
                    String string5 = "";
                    String string6 = "form";
                    Object object = fileLn.readLn();
                    while (object != null) {
                        if (((String)object).startsWith("#2")) {
                            string5 = ((String)object).substring(3);
                        } else if (((String)object).startsWith("#3")) {
                            string4 = ((String)object).substring(3);
                        } else if (((String)object).startsWith("#4")) {
                            string6 = ((String)object).substring(3);
                        } else if (!((String)object).startsWith("#")) {
                            stringBuilder.append((String)object).append('\n');
                        }
                        object = fileLn.readLn();
                    }
                    if ("form".equals(string6) && string4.length() > 0) {
                        if (FileProcedures.exists(string4)) {
                            PatientUtil.setActPatDir(string4);
                        }
                        FileProcSync.delete(string4, string5 + ".repp");
                        FileProcSync.delete(string4, string5 + ".repa");
                        object = GetDataFile.getFormFileWr(FileProcedures.addDirName(PatientUtil.getActPatDir(), string5 + ".repp"));
                        if (((FileLn)object).isOpenWrite()) {
                            ((FileLn)object).write(stringBuilder.toString());
                            ((FileLn)object).close();
                        }
                        FileProcSync.delete(file.getAbsolutePath());
                        SwingUtilities.invokeLater(this::patientAction);
                    } else if ("case".equals(string6)) {
                        this.caseShow.checkDataChanged(CaseShow.BoxDef.STANDARD);
                        this.caseShow.newCaseAction();
                        object = new FileCsvKey();
                        ((FileLn)object).openReadWithInputString(stringBuilder.toString());
                        if (User.instance().getCaseResult().loadCaseThenBuild((FileCsvKey)object)) {
                            User.instance().getCaseResult().buildResult();
                            User.instance().getCaseResult().setChanged(true);
                            FileProcSync.delete(file.getAbsolutePath());
                            this.caseShow.sortAgain();
                        }
                    }
                }
            }
            catch (Exception exception) {
                Log.write(2, CLASS_NAME, "formImportAction", exception);
            }
        }
    }

    public void formBrowseAction() {
        this.preMenuAction();
        try {
            String string = "http://127.0.0.1:" + User.instance().getProperty("ServerPort", 8222) + "/";
            BrowseHtm browseHtm = new BrowseHtm(string);
            browseHtm.setVisible(true);
            browseHtm.toFront();
            User.instance().setProperty("cFormBrowse", User.instance().getProperty("cFormBrowse", 0) + 1);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "formBrowseAction", exception);
        }
    }

    public void formExtBrowseAction() {
        this.preMenuAction();
        try {
            String string = "http://127.0.0.1:" + User.instance().getProperty("ServerPort", 8222) + "/";
            DesktopUtils.callSystemBrowserAvailable(string);
            User.instance().setProperty("cFormBrowse", User.instance().getProperty("cFormBrowse", 0) + 1);
        }
        catch (Throwable throwable) {
            Log.write(3, CLASS_NAME, "formExtBrowseAction", throwable);
        }
    }

    public void formBrowseActionWithData(String string, String string2) {
        this.preMenuAction();
        try {
            GetServlet.setNextGetForm(string, string2);
            String string3 = "http://127.0.0.1:" + User.instance().getProperty("ServerPort", 8222) + "/get";
            if (DesktopUtils.systemBrowserAvailable()) {
                DesktopUtils.callSystemBrowserAvailable(string3);
            } else {
                BrowseHtm browseHtm = new BrowseHtm(string3);
                browseHtm.setVisible(true);
                browseHtm.toFront();
            }
            User.instance().setProperty("cFormBrowse", User.instance().getProperty("cFormBrowse", 0) + 1);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "formBrowseAction", exception);
        }
    }

    protected void helpAction() {
        this.preMenuAction();
        try {
            this.addAndSelect(new HelpShowJ(null));
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "helpAction", exception);
        }
    }

    public void helpContextAction(String string) {
        this.preMenuAction();
        try {
            URL uRL = HelpUtil.getHelpUrl(string);
            this.addAndSelect(new HelpShowJ(uRL));
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "helpAction", exception);
        }
    }

    protected void infoDataAction() {
        this.preMenuAction();
        try {
            this.addAndSelect(new HelpShowJ(User.instance().getActRepIndex()));
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "infoDataAction", exception);
        }
    }

    protected void infoProgramAction() {
        this.preMenuAction();
        try {
            InfoBox infoBox = new InfoBox(this.getMainFrame());
            infoBox.setVisible(true);
            infoBox.dispose();
            Log.writeSystemConstants(4, this.getMainFrame());
            Log.write(4, CLASS_NAME, MemCache.getLogString());
            this.checkAndGetFocus();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "infoProgramAction", exception);
        }
    }

    protected void optionAction() {
        this.preMenuAction();
        try {
            String string = User.instance().getProperty("Language", Locale.getDefault().getLanguage());
            boolean bl = User.instance().getProperty("repId", false);
            int n = User.instance().getProperty("mmColumns", 2);
            int n2 = User.instance().getProperty("fontDeltaNormal2", 3);
            boolean bl2 = User.instance().getProperty("ColorForFamily", true);
            boolean bl3 = User.instance().getProperty("ColorForMiasma", false);
            boolean bl4 = User.instance().getProperty("externalRubric", true);
            boolean bl5 = User.instance().getProperty("withPolar", true);
            boolean bl6 = User.instance().getProperty("alphabticalSort", false);
            int n3 = User.instance().getProperty("PolarFactor", 10);
            boolean bl7 = User.instance().getProperty("polarAtEnd", false);
            int n4 = User.instance().getProperty("PolarFactorFrom", 4);
            boolean bl8 = User.instance().getProperty("sortPolarSimple", false);
            String string2 = User.instance().getProperty("DataDir", "");
            boolean bl9 = User.instance().getProperty("polarRelative", true);
            String string3 = User.instance().getProperty("DataBackup", "");
            boolean bl10 = User.instance().getProperty("ShowMediWithRubric", false);
            boolean bl11 = User.instance().getProperty("highlightInResult", true);
            boolean bl12 = User.instance().getProperty("CutAllRubrics", true);
            boolean bl13 = User.instance().getProperty("ShowMedplus", true);
            OptionBox optionBox = new OptionBox(this.getMainFrame());
            optionBox.setVisible(true);
            if (n != User.instance().getProperty("mmColumns", 2)) {
                if (this.caseShow != null) {
                    this.caseShow.checkDataChanged(CaseShow.BoxDef.STANDARD);
                    this.caseShow.closeAction();
                    this.remove(this.caseShow);
                    this.caseShow.dispose();
                }
                this.caseShow = new CaseShow();
                this.add(this.caseShow);
                this.newCaseAction();
            } else if (bl != User.instance().getProperty("repId", false) || n3 != User.instance().getProperty("PolarFactor", 10) || n4 != User.instance().getProperty("PolarFactorFrom", 4) || bl7 != User.instance().getProperty("polarAtEnd", false) || bl10 != User.instance().getProperty("ShowMediWithRubric", false) || bl11 != User.instance().getProperty("highlightInResult", true)) {
                this.inputRubr.searchAgain();
            } else if (bl6 != User.instance().getProperty("alphabticalSort", false) || bl8 != User.instance().getProperty("sortPolarSimple", false) || bl9 != User.instance().getProperty("polarRelative", true) || bl2 != User.instance().getProperty("ColorForFamily", true) || bl3 != User.instance().getProperty("ColorForMiasma", false) || bl12 != User.instance().getProperty("CutAllRubrics", true) || bl13 != User.instance().getProperty("ShowMedplus", true)) {
                this.inputRubr.searchAgain();
                CaseResult caseResult = User.instance().getCaseResult();
                if (caseResult != null && caseResult.getResultCount() > 0) {
                    caseResult.changeActRep(User.instance().getActRepIndex());
                    if (this.caseShow != null) {
                        this.caseShow.sortAgain();
                    }
                }
            }
            if (bl4 != User.instance().getProperty("externalRubric", true) || bl5 != User.instance().getProperty("withPolar", true) || !string2.equalsIgnoreCase(User.instance().getProperty("DataDir", "")) || !string3.equalsIgnoreCase(User.instance().getProperty("DataBackup", ""))) {
                this.setMainRubric(null);
                this.newCaseAction();
                JOptionPane.showInternalMessageDialog(this.getDesktop(), messageTextReg, "jRep", 1);
            }
            if (!string.equals(User.instance().getProperty("Language", Locale.getDefault().getLanguage())) || n2 != User.instance().getProperty("fontDeltaNormal2", 3)) {
                JOptionPane.showInternalMessageDialog(this.getDesktop(), messageText2, "jRep", 1);
            }
            this.checkAndGetFocus();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "optionAction", exception);
        }
    }

    protected void crAuthorAction() {
        this.preMenuAction();
        try {
            CrAuthorSelect crAuthorSelect = new CrAuthorSelect(User.instance().getActRepIndex());
            this.addAndSelect(crAuthorSelect);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "regAction", exception);
        }
    }

    protected void regAction() {
        this.preMenuAction();
        try {
            String string = User.instance().getUserName();
            String string2 = User.instance().getProperty("Key", "").toUpperCase();
            String string3 = User.instance().getProperty("Key2", "").toUpperCase();
            String string4 = User.instance().getProperty("Key3", "").toUpperCase();
            String string5 = User.instance().getProperty("Key4", "").toUpperCase();
            String string6 = User.instance().getProperty("Key5", "").toUpperCase();
            String string7 = User.instance().getProperty("Key6", "").toUpperCase();
            String string8 = User.instance().getProperty("Key7", "").toUpperCase();
            RegBox regBox = new RegBox(this.getMainFrame());
            regBox.setVisible(true);
            regBox.dispose();
            if (User.instance().getProperty("LicFromNet", false) && ToolData.checkLicenseFromWeb(1, 0, true)) {
                JOptionPane.showInternalMessageDialog(this.getDesktop(), messageTextReg, "jRep", 1);
            }
            this.inputRubr.setNewTitleText(null);
            this.setMainTitle(null);
            if (!string.equals(User.instance().getUserName())) {
                if (this.caseShow != null) {
                    this.caseShow.checkDataChanged(CaseShow.BoxDef.STANDARD);
                }
                JOptionPane.showInternalMessageDialog(this.getDesktop(), messageTextReg, "jRep", 1);
                this.exitAction();
            }
            if (!(string2.equals(User.instance().getProperty("Key", "").toUpperCase()) && string3.equals(User.instance().getProperty("Key2", "").toUpperCase()) && string4.equals(User.instance().getProperty("Key3", "").toUpperCase()) && string5.equals(User.instance().getProperty("Key4", "").toUpperCase()) && string6.equals(User.instance().getProperty("Key5", "").toUpperCase()) && string7.equals(User.instance().getProperty("Key6", "").toUpperCase()) && string8.equals(User.instance().getProperty("Key7", "").toUpperCase()))) {
                if (this.caseShow != null) {
                    this.caseShow.checkDataChanged(CaseShow.BoxDef.STANDARD);
                }
                if (this.caseShow != null) {
                    this.remove(this.caseShow);
                }
                this.caseShow = new CaseShow();
                this.add(this.caseShow);
                JOptionPane.showInternalMessageDialog(this.getDesktop(), messageTextReg, "jRep", 1);
            }
            this.checkAndGetFocus();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "regAction", exception);
        }
    }

    public void changeRepAction(int n) {
        try {
            if (User.instance().getActRepIndex() != n) {
                User.instance().setActRepIndex(n);
                if (this.caseShow != null) {
                    User.instance().getCaseResult().changeActRep(n);
                    this.caseShow.sortAgain();
                }
                RepMainMenu.checkActRepIndex(n);
            }
        }
        catch (Exception exception) {
            Log.write(3, CLASS_NAME, "changeRepAction", exception);
        }
    }

    public void addCombinedLine(CaseRubric caseRubric) {
        if (this.caseShow != null) {
            this.caseShow.addCombinedLine(caseRubric);
        }
    }

    public void selectRubricAction(Rubric rubric) {
        this.selectRubricAction(rubric, false);
    }

    public void selectRubricAction(Rubric rubric, boolean bl) {
        if (rubric != null && rubric.hasValues()) {
            Object object = rubric.getShowRubric(true);
            if (object != null && ((String)object).length() > 20) {
                object = ((String)object).substring(0, 20) + "...";
            }
            this.inputRubr.setNewTitleText(User.instance().getCaseResultLength() + " + '" + (String)object + "'");
            this.toolMainCheck();
            if (this.caseShow != null) {
                this.caseShow.addLine(rubric, bl);
            }
        }
    }

    public void reinitAction() {
        this.preMenuAction();
        MasterProp.removeInstance();
        new FirstIni(this);
        ScreenUtil.getFrameJWindowSize(this.getToolkit().getScreenSize(), null);
        this.arrangeAction();
        int n = User.instance().getProperty("RepNr", 1);
        this.inputRubr.chooseRepAction(n);
        int n2 = User.instance().getProperty("actMM", 1);
        this.multiFrame.chooseMm(n2);
        User.instance().setProperty("PatientRoot", "");
    }

    public void setMainRubric(Rubric rubric) {
        try {
            if (this.rubricShow != null) {
                if (rubric != null) {
                    if (!this.rubricShow.setRubric(rubric, null)) {
                        this.rubricShow.setText(rubric, this.getSelectedRubricText(rubric));
                    }
                } else {
                    String string = RepDataPool.getInstance().getRepHeader(User.instance().getActRepIndex()).getRepId();
                    if (string != null) {
                        this.rubricShow.setStartRubric(string);
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "setMainRubric", exception);
        }
    }

    public void searchAgain() {
        try {
            this.inputRubr.searchAgain();
            if (this.inputValue != null) {
                this.inputValue.searchAgain();
            }
            if (this.compareRubric != null) {
                this.compareRubric.searchAgain();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "searchAgain", exception);
        }
    }

    public void showHierarchicIfWanted() {
        this.inputRubr.showHierarchicPanelAndSetVar();
        this.inputRubr.setHierarchicSearch();
    }

    public void showSelectedRubric(Rubric rubric) {
        try {
            if (rubric != null) {
                if (this.rubricShow == null) {
                    this.rubricShow = new RubricShow(false);
                    this.add(this.rubricShow);
                    if (!this.rubricShow.setRubric(rubric, null)) {
                        this.rubricShow.setText(rubric, this.getSelectedRubricText(rubric));
                    }
                } else if (!this.rubricShow.setRubric(rubric, null)) {
                    this.rubricShow.setText(rubric, this.getSelectedRubricText(rubric));
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "showRubricWindowAction", exception);
        }
    }

    private String[] getSelectedRubricText(Rubric rubric) {
        if (rubric != null) {
            int n = rubric.getRepIndex();
            if (n < 1 || n > 62) {
                n = User.instance().getActRepIndex();
            }
            String string = RubricChangeFile.getRubricRemarks(rubric);
            return RubricShowUtil.makeRubricHtml(rubric, string);
        }
        return null;
    }

    protected void newRubricWindowAction(Rubric rubric) {
        try {
            if (rubric != null) {
                RubricShow rubricShow = new RubricShow(true);
                this.add(rubricShow);
                if (!rubricShow.setRubric(rubric, null)) {
                    rubricShow.setText(rubric, this.getSelectedRubricText(rubric));
                }
                rubricShow.toFront();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newRubricWindowAction", exception);
        }
    }

    protected void newRubricWindowAction(Rubric rubric, String[] stringArray, String string) {
        try {
            if (rubric != null) {
                RubricShow rubricShow = new RubricShow(true);
                this.add(rubricShow);
                if (!rubricShow.setRubric(rubric, string) && stringArray != null) {
                    rubricShow.setText(rubric, stringArray);
                }
                rubricShow.toFront();
                rubricShow.requestFocus();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "newRubricWindowAction", exception);
        }
    }

    protected void loadReadOnlyCase() {
        JFileChooser jFileChooser = new JFileChooser(PatientUtil.getActPatDir());
        jFileChooser.addChoosableFileFilter(repFileFilter);
        jFileChooser.setFileFilter(repFileFilter);
        jFileChooser.setDialogTitle(StringResource.getString("menu_file_show2"));
        int n = jFileChooser.showOpenDialog(this.getDesktop());
        if (n == 0) {
            CaseReadOnly caseReadOnly = new CaseReadOnly(User.instance().getActRepIndex());
            caseReadOnly.loadFile(FileProcedures.addDirName(jFileChooser.getSelectedFile().getParent(), jFileChooser.getSelectedFile().getName()));
            this.add(caseReadOnly);
            caseReadOnly.toFront();
        }
    }

    public void imageForRubricAction(String string, URL uRL) {
        try {
            this.rubricShow.setImage(string, uRL);
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "imageForRubricAction", exception);
        }
    }

    public void openCaseNoteAction(String string) {
        try {
            String string2 = "Notiz.htm";
            if (FileProcedures.exists(FileProcedures.addDirName(string, string2))) {
                new StartEkit(string, string2, ScreenUtil.getCaseNoteWindowSize(this.getToolkit().getScreenSize()));
            } else {
                string2 = "Notiz.rtf";
                if (FileProcedures.exists(FileProcedures.addDirName(string, string2))) {
                    new StartRtfProcessor(string, string2, ScreenUtil.getCaseNoteWindowSize(this.getToolkit().getScreenSize()));
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "openCaseNoteAction", exception);
        }
    }

    public void startAnalysing() {
        this.searching = true;
        this.setMenuEnables(null);
    }

    public void endAnalysing() {
        this.searching = false;
        this.setMenuEnables(null);
        this.inputRubr.setNewTitleText(null);
    }

    public void setMenuEnables(Rubric rubric) {
        this.selectedRubricParameter = rubric;
        if (!this.menuEnableStarted) {
            this.menuEnableStarted = true;
            try {
                SwingUtilities.invokeLater(() -> {
                    try {
                        boolean bl = false;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        boolean bl6 = false;
                        boolean bl7 = false;
                        this.menuEnableStarted = false;
                        if (!this.searching) {
                            if (this.compareRubric != null && this.compareRubric.isSelected()) {
                                if (this.compareRubric.getShowListCount() > 0) {
                                    // empty if block
                                }
                                if (this.selectedRubricParameter == null) {
                                    this.selectedRubricParameter = this.compareRubric.getSelectedRubric();
                                }
                            } else if (this.inputValue != null && this.inputValue.isSelected()) {
                                if (this.inputValue.showCount != this.inputValue.getShowListCount() && this.inputValue.showCount > 0) {
                                    bl = true;
                                }
                                if (this.selectedRubricParameter == null) {
                                    this.selectedRubricParameter = this.inputValue.getSelectedRubric();
                                }
                            } else if (this.inputAll != null && this.inputAll.isSelected()) {
                                if (this.inputAll.showCount != this.inputAll.getShowListCount() && this.inputAll.showCount > 0) {
                                    bl = true;
                                }
                                if (this.selectedRubricParameter == null) {
                                    this.selectedRubricParameter = this.inputAll.getSelectedRubric();
                                }
                            } else if (this.inputRubr != null) {
                                if (this.inputRubr.hasShowListEntries()) {
                                    bl = true;
                                }
                                if (this.selectedRubricParameter == null) {
                                    this.selectedRubricParameter = this.inputRubr.getSelectedRubric();
                                }
                            }
                            if (this.caseShow != null && User.instance().getCaseResultLength() > 0) {
                                bl3 = true;
                            }
                            if (GetDataFile.getDataPath() != null && User.instance().getActRepIndex() < 62) {
                                bl5 = true;
                            }
                            if (this.selectedRubricParameter != null) {
                                bl2 = true;
                                bl4 = this.selectedRubricParameter.hasHierarchic();
                                if (GetDataFile.getDataPath() != null && User.instance().getActRepIndex() < 62) {
                                    bl6 = true;
                                    bl7 = this.selectedRubricParameter.isChanged();
                                    if (!RepDataPool.getInstance().getRepFile(User.instance().getActRepIndex()).isEditExtern()) {
                                        bl7 = true;
                                    }
                                }
                            }
                        }
                        RepMainMenu.setShowMenus(bl);
                        RepMainMenu.setSelectMenus(bl2);
                        RepMainMenu.setResultMenus(bl3);
                        RepMainMenu.setSelectHierarchicMenus(bl4);
                        RepMainMenu.setNewRubricMenu(bl5);
                        RepMainMenu.setChangeRubricMenu(bl6);
                        RepMainMenu.setDeleteRubricMenu(bl7);
                    }
                    catch (Exception exception) {
                        Log.write(3, CLASS_NAME, "setMenuEnables ", exception);
                    }
                });
            }
            catch (Exception exception) {
                Log.write(3, CLASS_NAME, "Exception in setMenuEnables ", exception);
            }
        }
    }

    public void toolMainCheck() {
        this.toolData.checkTool();
        if (this.noAddonText) {
            this.setMainTitle(null);
        }
    }

    public void setExtNoteFrame(JFrame jFrame) {
        this.extNoteFrame = jFrame;
        SwingUtilities.invokeLater(() -> {
            this.extNoteFrame.toFront();
            this.extNoteFrame = null;
        });
    }

    public URL extNoteFrameAction() {
        try {
            this.extNoteFrame = null;
            String string = PatientUtil.getActPatDir();
            String string2 = "Notiz.htm";
            if (NoteUtil.existsNote(string, string2)) {
                new StartEkit(string, string2, ScreenUtil.getCaseNoteWindowSize(this.getToolkit().getScreenSize()));
                return FileProcedures.nameDirToUrl(string, string2);
            }
            string2 = "Notiz.rtf";
            String string3 = NoteUtil.generateNote(string, string2);
            if (FileProcedures.exists(FileProcedures.addDirName(string3, string2))) {
                new StartRtfProcessor(string3, string2, ScreenUtil.getCaseNoteWindowSize(this.getToolkit().getScreenSize()));
                return FileProcedures.nameDirToUrl(string3, string2);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "extNoteFrameAction", exception);
        }
        return null;
    }

    public URL extConsultFrameAction() {
        try {
            String string = PatientUtil.getActPatDir();
            String string2 = PatientUtil.findNewestConsultFile();
            if (string2 != null) {
                if (string2.endsWith(".htm")) {
                    new StartEkit(string, string2, ScreenUtil.getCaseNoteWindowSize(this.getToolkit().getScreenSize()));
                } else if (string2.endsWith(".rtf")) {
                    new StartRtfProcessor(string, string2, ScreenUtil.getCaseNoteWindowSize(this.getToolkit().getScreenSize()));
                }
                return FileProcedures.nameDirToUrl(string, string2);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "extConsultFrameAction", exception);
        }
        return null;
    }

    public void consultShowAction() {
        try {
            String string = PatientUtil.getActPatDir();
            String string2 = PatientUtil.findNewestConsultFile();
            if (string2 != null && string2.length() > 0) {
                if (this.consultShow == null) {
                    this.consultShow = new ConsultShow();
                    this.add(this.consultShow);
                }
                this.consultShow.setFile(string, string2);
                this.consultShow.toFront();
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "consultShowAction", exception);
        }
    }

    public URL extConsultFrameAction(String string) {
        try {
            this.extNoteFrame = null;
            String string2 = PatientUtil.getPatientName();
            String string3 = PatientUtil.getActPatDir();
            String string4 = NoteUtil.generateConsultation(string2, string3, string);
            if (FileProcedures.exists(FileProcedures.addDirName(string4, string))) {
                if (string.endsWith(".rtf")) {
                    new StartRtfProcessor(string4, string, ScreenUtil.getConsultWindowSize(this.getToolkit().getScreenSize()));
                } else {
                    new StartEkit(string4, string, ScreenUtil.getConsultWindowSize(this.getToolkit().getScreenSize()));
                }
                return FileProcedures.nameDirToUrl(string4, string);
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "extNoteFrameAction", exception);
        }
        return null;
    }

    public void setNewPatientName() {
        if (this.caseShow != null) {
            this.caseShow.setCaseShowTitle(null);
        }
    }

    public void generateHtmlPages() {
        try {
            SuperUserActions.generateHtmlPages(User.instance().getActRepIndex(), User.instance().getInputSearchThread().getSearchResult());
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "generateHtmlPages", exception);
        }
    }

    public int getActMm() {
        if (this.multiFrame != null) {
            return this.multiFrame.getActMm();
        }
        return -1;
    }

    @Override
    public void endLoadAction() {
        super.endLoadAction();
        Rep.getExecutor().execute(() -> {
            try {
                RubricUtil.getMedNameForRubric("zzzz");
                MmUtil.getAllData();
            }
            catch (Exception exception) {
                Log.write(3, this.getClass().getName(), "Problem while additionalLoadAction", exception);
            }
        });
    }

    @Override
    public void additionalLoadAction() {
        super.additionalLoadAction();
        if (User.instance().getProperty("LoadAllRep", true)) {
            this.setWaitingTextDoExit("Start Lade");
            RepDataPool.getInstance().loadAllRep(null);
        } else {
            this.startIsOver();
        }
        FileSynch fileSynch = FileSynch.instance();
        if (fileSynch.isActive()) {
            this.setWaitingTextDoExit("Start Synch Dir");
            fileSynch.synchronizeNow();
        }
        this.versionHint = new VersionHint(this);
        Rep.getScheduledExecutor().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                RepMainFrame.this.toolMainCheck();
                RepMainFrame.this.versionHint.sendStat();
            }
        }, 59L, 61L, TimeUnit.MINUTES);
    }

    public void setWaitingEnd() {
        this.showWaitingText = null;
    }

    public void startEarlyBackgroundJobs() {
        Rep.getExecutor().execute(() -> {
            try {
                PatientUtil.getPatRoot();
                PatientUtil.getActualizedPatList();
            }
            catch (Exception exception) {
                Log.write(3, this.getClass().getName(), "Problem while startEarlyBackgroundJobs", exception);
            }
        });
    }

    public void repLoadDone() {
        this.showWaitingText = null;
        this.startIsOver();
        RepMainMenu.searchInAllRep.setEnabled(true);
    }

    public boolean setWaitingTextDoExit(String string) {
        if (this.showWaitingText == null && !this.waitingActive) {
            this.waitingActive = true;
            long l = new Date().getTime();
            Rep.getExecutor().execute(() -> {
                Object object = "";
                Thread.currentThread().setPriority(1);
                while (this.showWaitingText != null) {
                    String string = (new Date().getTime() - l) / 1000L + "  " + this.showWaitingText;
                    if (!((String)object).equals(string)) {
                        object = string;
                        this.setMainTitle(string);
                    }
                    try {
                        Thread.sleep(195L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.setMainTitle(null);
                this.waitingActive = false;
            });
        }
        this.showWaitingText = string;
        return this.exitLongThreads;
    }
}

