/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repdata.CaseRubric;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repdata.RubricChangeValues;
import ch.steph.repmodel.RubricChangeTableModel;
import ch.steph.repui.CaseShow;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.repui.RubricChangeTable;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricPublicFile;
import ch.steph.reputil.RubricUtil;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.FileCsv;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RubricChange
extends MdiNormalFrame {
    private static final long serialVersionUID = 1L;
    protected JScrollPane scrollPane;
    private RubricChangeTableModel rubricChangeTableModel;
    private RubricChangeTable rubricChangeTable;
    private CaseRubric caseRubricToChange;
    private int repIndex;
    private JTextField searchField;
    private String repIdent;
    private JTextField codeEl;
    private JTextField textEl;
    private String orgTitle;
    private boolean isNewRubric;

    public RubricChange(String string, Rubric rubric) {
        super(true, string + StringResource.getString("rubric_title_plus"), 10, "change");
        this.orgTitle = string;
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        this.repIndex = User.instance().getActRepIndex();
        this.repIdent = rubric.getRepIdent();
        String[] stringArray = RepUtil.getFullMediArray();
        Rubric rubric2 = rubric.getCopy(stringArray);
        Rubric rubric3 = RepUtil.getOriginalRubric(rubric);
        if (rubric3 != null) {
            rubric3 = rubric3.getCopy(stringArray);
        }
        this.initWindow(rubric2, stringArray, rubric3, null, null, true);
        User.instance().setProperty("cRubChange", User.instance().getProperty("cRubChange", 0) + 1);
    }

    public RubricChange(String string, int n, String string2, String[] stringArray) {
        super(true, string + StringResource.getString("rubric_title_plus"), 10, "change");
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        this.repIndex = n;
        this.repIdent = string2;
        this.initWindow(null, stringArray, null, null, null, true);
        User.instance().setProperty("cRubChange", User.instance().getProperty("cRubChange", 0) + 1);
    }

    public RubricChange(CaseShow caseShow, int n, String[] stringArray, CaseRubric caseRubric, String string, boolean bl) {
        super(true, StringResource.getString("case_rubric_new") + StringResource.getString("rubric_title_plus"), 10, "change");
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        this.repIndex = n;
        this.repIdent = "MyRub";
        this.caseRubricToChange = caseRubric;
        Rubric rubric = null;
        if (this.caseRubricToChange != null) {
            rubric = this.caseRubricToChange.getRubric();
        }
        this.initWindow(null, stringArray, rubric, caseShow, string, bl);
        User.instance().setProperty("cRubChange", User.instance().getProperty("cRubChange", 0) + 1);
    }

    public RubricChange(String string, int n, String string2, String string3, String[] stringArray, int[] nArray) {
        super(true, string + StringResource.getString("rubric_title_plus"), 10, "change");
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        this.repIndex = n;
        this.repIdent = string2;
        this.initWindow(null, stringArray, null, null, null, true);
        this.textEl.setText(Character.toUpperCase(string3.charAt(0)) + string3.substring(1));
        for (int i = 0; i < stringArray.length; ++i) {
            if (nArray[i] <= 0) continue;
            int n2 = nArray[i];
            if (n2 > 9) {
                n2 = 9;
            }
            this.rubricChangeTableModel.setNewValueForMedi(stringArray[i], "" + n2);
        }
        User.instance().setProperty("cRubChange", User.instance().getProperty("cRubChange", 0) + 1);
    }

    private void initWindow(Rubric rubric, String[] stringArray, Rubric rubric2, CaseShow caseShow, String string, boolean bl) {
        Iterator<Object> iterator;
        String[] stringArray2;
        int n;
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        String string2;
        Object object4;
        this.isNewRubric = false;
        boolean bl2 = !RepDataPool.getInstance().getRepFile(this.repIndex).isEditExtern();
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                RubricChange.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 2));
        JButton jButton = new JButton(StringResource.getString("button_select"));
        jButton.addActionListener(actionEvent -> this.okAction(true));
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(jButton);
        if (caseShow == null) {
            jButton = new JButton(StringResource.getString("button_select") + " (" + StringResource.getString("without_loading") + ")");
            jButton.addActionListener(actionEvent -> this.okAction(false));
            jButton.setEnabled(true);
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add(jButton);
        }
        jButton = new JButton(StringResource.getString("button_cancel"));
        jButton.addActionListener(actionEvent -> this.closeAction());
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.addKeyListener(keyListener);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.addKeyListener(keyListener);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel3.add((Component)jPanel4, "West");
        jPanel4.addKeyListener(keyListener);
        JLabel jLabel = new JLabel("  Filter:");
        jPanel4.add((Component)jLabel, "West");
        this.searchField = new JTextField(16);
        jPanel4.add((Component)this.searchField, "Center");
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RubricChange.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RubricChange.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RubricChange.this.searchFieldTextValueChanged(documentEvent);
            }
        });
        this.searchField.addKeyListener(keyListener);
        this.searchField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                char c;
                if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown() || (c = keyEvent.getKeyChar()) != '\uffff' && c != '\u0000' || (n = keyEvent.getKeyCode()) != 40 && n != 225)) {
                    keyEvent.consume();
                    RubricChange.this.rubricChangeTable.requestFocusInWindow();
                    RubricChange.this.rubricChangeTable.changeSelection(0, 3, false, false);
                }
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        if (rubric != null) {
            object4 = rubric.getRubricKey();
            string2 = rubric.getSimpleRubric();
            this.codeEl = new JTextField(" " + (String)object4 + " ");
            this.codeEl.setEditable(true);
            this.codeEl.addKeyListener(keyListener);
        } else {
            if (this.caseRubricToChange == null) {
                this.isNewRubric = true;
                object4 = this.repIdent + " " + RepUtil.getSingleCounterForRubric(this.repIndex);
                serializable = RepDataPool.getInstance().getRepFile(this.repIndex).getRubricWithKey("++" + (String)object4);
                while (serializable != null) {
                    RepUtil.saveSingleCounterForRubric(this.repIndex);
                    object4 = this.repIdent + " " + RepUtil.getSingleCounterForRubric(this.repIndex);
                    serializable = RepDataPool.getInstance().getRepFile(this.repIndex).getRubricWithKey("++" + (String)object4);
                }
                string2 = string != null ? string : "";
            } else {
                object4 = this.caseRubricToChange.getRubric().getRubricKey();
                string2 = this.caseRubricToChange.getRubric().getSimpleRubric();
            }
            this.codeEl = new JTextField((String)object4, 12);
            this.codeEl.addKeyListener(keyListener);
            if (caseShow != null || string != null) {
                this.codeEl.setEditable(false);
            }
        }
        jPanel4.add((Component)this.codeEl, "East");
        serializable = new TreeMap();
        boolean bl3 = true;
        boolean bl4 = true;
        if (rubric != null) {
            if (rubric2 != null) {
                bl3 = false;
                for (int i = 0; i < stringArray.length; ++i) {
                    object3 = new RubricChangeValues(stringArray[i], this.getSearchString(stringArray[i]));
                    if (rubric2.getValue(i) > 0) {
                        ((RubricChangeValues)object3).setOrgValue("" + rubric2.getValue(i));
                    }
                    ((TreeMap)serializable).put(((RubricChangeValues)object3).getMedi().toLowerCase(), object3);
                }
            }
        } else if (this.caseRubricToChange != null && User.instance().getCaseResult() != null) {
            String[] stringArray3 = User.instance().getCaseResult().getMedisForRubric();
            if (rubric2 != null) {
                bl3 = false;
                object3 = stringArray;
                int n2 = ((String[])object3).length;
                for (int i = 0; i < n2; ++i) {
                    object2 = object3[i];
                    if (object2 == null) continue;
                    object = new RubricChangeValues((String)object2, this.getSearchString((String)object2));
                    for (n = 1; n < stringArray3.length; ++n) {
                        if (!object2.toLowerCase().equals(stringArray3[n].toLowerCase()) || rubric2.getValue(n) <= 0) continue;
                        ((RubricChangeValues)object).setOrgValue("" + rubric2.getValue(n));
                    }
                    ((TreeMap)serializable).put(((RubricChangeValues)object).getMedi().toLowerCase(), object);
                }
            }
        }
        if (((TreeMap)serializable).size() == 0) {
            for (String string3 : stringArray) {
                object2 = new RubricChangeValues(string3, this.getSearchString(string3));
                ((TreeMap)serializable).put(object2.getMedi().toLowerCase(), object2);
            }
        }
        if ((stringArray2 = RubricPublicFile.getPublicLinesStartingWithKey(this.repIndex, (String)object4)) != null) {
            bl4 = false;
            FileCsv fileCsv = new FileCsv();
            String[] stringArray4 = fileCsv.changeCSVtoArray(stringArray2[0]);
            String[] stringArray5 = fileCsv.changeCSVtoArray(stringArray2[1]);
            object2 = fileCsv.changeCSVtoArray(stringArray2[2]);
            object = fileCsv.changeCSVtoArray(stringArray2[3]);
            for (n = 1; n < stringArray4.length; ++n) {
                RubricChangeValues rubricChangeValues = (RubricChangeValues)((TreeMap)serializable).get(stringArray4[n].toLowerCase());
                if (rubricChangeValues == null) continue;
                if (n < stringArray5.length) {
                    if (bl3) {
                        rubricChangeValues.setOrgValue(stringArray5[n]);
                    }
                    rubricChangeValues.setNewValue(stringArray5[n]);
                }
                if (n < ((String[])object2).length) {
                    rubricChangeValues.setNewRemark(object2[n]);
                }
                if (n >= ((Object)object).length) continue;
                rubricChangeValues.setNewDate((String)object[n]);
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n3;
            RubricChangeValues rubricChangeValues;
            String string4 = stringArray[i];
            if (string4 == null || (rubricChangeValues = (RubricChangeValues)((TreeMap)serializable).get(string4.toLowerCase())) == null || rubric == null || (n3 = rubric.getValue(i)) <= 0) continue;
            object = "" + n3;
            if (n3 > 9) {
                object = "" + n3 / User.instance().getProperty("PolarFactor", 10);
            }
            if (bl3) {
                rubricChangeValues.setOrgValue((String)object);
            }
            rubricChangeValues.setNewValue((String)object);
        }
        if (this.caseRubricToChange != null && this.caseRubricToChange.getRemarkMedis() != null) {
            String[] stringArray6 = this.caseRubricToChange.getRemarkMedis();
            String[] stringArray7 = this.caseRubricToChange.getRemarkArray();
            String[] stringArray8 = this.caseRubricToChange.getRemarkDates();
            for (int i = 1; i < stringArray6.length; ++i) {
                object = (RubricChangeValues)((TreeMap)serializable).get(stringArray6[i].toLowerCase());
                if (object == null) continue;
                if (i < stringArray7.length) {
                    ((RubricChangeValues)object).setNewRemark(stringArray7[i]);
                }
                if (i >= stringArray8.length) continue;
                ((RubricChangeValues)object).setNewDate(stringArray8[i]);
            }
        }
        ArrayList arrayList = null;
        if (!bl && stringArray != null) {
            arrayList = new ArrayList();
            Collections.addAll(arrayList, stringArray);
            iterator = arrayList.iterator();
        } else {
            iterator = ((TreeMap)serializable).keySet().iterator();
        }
        ArrayList<RubricChangeValues> arrayList2 = new ArrayList<RubricChangeValues>();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            if (string5 == null || (object = (RubricChangeValues)((TreeMap)serializable).get(string5.toLowerCase())) == null) continue;
            if (bl4) {
                ((RubricChangeValues)object).setNewValue(((RubricChangeValues)object).getOrgValue());
            }
            arrayList2.add((RubricChangeValues)object);
        }
        int n4 = string2.lastIndexOf("[");
        if (n4 > 0) {
            string2 = string2.substring(0, n4).trim();
        }
        this.textEl = new JTextField(string2);
        this.textEl.setCaretPosition(string2.length());
        this.textEl.addKeyListener(keyListener);
        jPanel3.add((Component)this.textEl, "Center");
        this.scrollPane = new JScrollPane();
        this.scrollPane.addKeyListener(keyListener);
        jPanel2.add((Component)this.scrollPane, "Center");
        this.scrollPane.addKeyListener(keyListener);
        this.rubricChangeTableModel = new RubricChangeTableModel(bl2, caseShow, this.caseRubricToChange, arrayList2);
        this.rubricChangeTable = new RubricChangeTable(this.rubricChangeTableModel);
        this.rubricChangeTable.addKeyListener(keyListener);
        this.scrollPane.setViewportView(this.rubricChangeTable);
    }

    private String getSearchString(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = RubricUtil.getMedNameForRubric(string);
        if (stringArray == null || stringArray.length < 2) {
            return string.toLowerCase();
        }
        return SearchUtil.getSearchKey("." + string + "." + stringArray[0] + "." + stringArray[1] + ".");
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (this.textEl != null && this.textEl.isEditable()) {
            this.textEl.setCaretPosition(this.textEl.getText().length());
            this.textEl.requestFocus();
        } else if (this.searchField != null) {
            this.searchField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown() || (c = Character.toUpperCase(keyEvent.getKeyChar())) != '\u001b')) {
                keyEvent.consume();
                if (this.searchField.getText().length() > 0) {
                    this.searchField.setText("");
                }
                this.searchField.requestFocus();
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                RepMainMenu.mainMenuActionDone(keyEvent, c);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    private void searchFieldTextValueChanged(DocumentEvent documentEvent) {
        try {
            this.rubricChangeTableModel.filterMedis(this.searchField.getText());
            if (this.searchField.getText().length() > 0) {
                String string = (String)this.rubricChangeTableModel.getValueAt(0, 1);
                String[] stringArray = RubricUtil.getMedNameForRubric(string);
                if (stringArray != null && stringArray.length > 1) {
                    this.setTitleText(stringArray[0] + " - " + stringArray[1]);
                } else {
                    this.setTitleText(null);
                }
            } else {
                this.setTitleText(null);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    protected void setTitleText(String string) {
        if (string != null && string.length() > 0) {
            this.setTitle("jRep  " + string);
        } else {
            this.setTitle(this.orgTitle);
        }
    }

    protected void okAction(boolean bl) {
        try {
            String string;
            String string2 = this.textEl.getText().trim();
            if (string2.length() == 0) {
                string2 = StringResource.getString("menu_search");
            }
            if ((string = this.codeEl.getText().trim()).length() == 0) {
                string = "xxx 00000";
            }
            if (this.isNewRubric) {
                RepUtil.saveSingleCounterForRubric(this.repIndex);
            }
            this.rubricChangeTableModel.okAction(this.repIndex, string, string2, bl);
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "okAction", exception);
        }
        this.closeAction();
        if (bl && this.caseRubricToChange == null) {
            RepMainFrame.getRepInstance().searchAgain();
        }
    }
}

