/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.PanelKeyListener;
import ch.steph.repdata.Rubric;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.repui.SimpleShowPanel;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.reputil.SearchHighlighter;
import ch.steph.reputil.SearchParam;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class RubricShow
extends MdiNormalFrame
implements PanelKeyListener {
    private static final long serialVersionUID = 1L;
    private static int secondCounter = 0;
    private boolean closeOnFocusToParent;
    private Rubric actRubric = null;
    private ArrayList<Rubric> showedRubric = null;
    private String showedHtmlText = null;
    private String showedRubricStr;
    private JButton selectButton;
    private JButton backButton;
    private JButton searchButton;
    protected JTextField searchField;
    private JLabel statusField;
    private SearchParam searchParam;
    private List<SearchHighlighter.HighLight> highLights;
    private int nextHighLight;
    private JMenuItem editRubricMenu;
    private JMenuItem backMenu;
    private boolean extPathOk = false;
    private URL htmlUrl = null;
    private SimpleShowPanel contentPanel;

    public RubricShow(boolean bl) {
        super(bl, "", 5, "rubric");
        if (bl) {
            User.instance().setProperty("cRubShow", User.instance().getProperty("cRubShow", 0) + 1);
        }
        this.closeOnFocusToParent = bl;
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/2.gif"));
        this.setTitle(null);
        this.getContentPane().setLayout(new BorderLayout());
        Rectangle rectangle = this.getStartRect();
        if (bl) {
            if (++secondCounter > 5) {
                secondCounter = 1;
            }
            rectangle.x -= (secondCounter - 1) * 10;
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
            rectangle.y = rectangle.y + secondCounter * 10 + rectangle.height - rectangle.height / 5;
        }
        this.setBounds(rectangle);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                RubricShow.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        JPanel jPanel = new JPanel(new GridLayout(1, 4));
        jPanel.addKeyListener(keyListener);
        this.searchField = new JTextField(16);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                RubricShow.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                RubricShow.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                RubricShow.this.searchFieldTextValueChanged(documentEvent);
            }
        });
        this.searchField.addKeyListener(keyListener);
        this.searchField.setEnabled(false);
        jPanel.add((Component)this.searchField, "Center");
        this.searchButton = new JButton(StringResource.getString("search_button"));
        this.searchButton.addActionListener(actionEvent -> this.searchAction());
        this.searchButton.setEnabled(false);
        this.searchButton.addKeyListener(keyListener);
        this.searchButton.setMargin(new Insets(1, 2, 2, 2));
        jPanel.add(this.searchButton);
        this.statusField = new JLabel("", 0);
        this.statusField.setHorizontalAlignment(0);
        jPanel.add(this.statusField);
        this.selectButton = new JButton(StringResource.getString("button_select"));
        this.selectButton.addActionListener(actionEvent -> {
            this.selectButton.setEnabled(false);
            RepMainFrame.getRepInstance().selectRubricAction(this.showedRubric.get(this.showedRubric.size() - 1));
            RepMainFrame.getRepInstance().checkAndGetFocus();
        });
        this.selectButton.setEnabled(false);
        this.selectButton.addKeyListener(keyListener);
        this.selectButton.setMargin(new Insets(0, 2, 0, 2));
        jPanel.add(this.selectButton);
        this.backButton = new JButton(StringResource.getString("back"));
        this.backButton.addActionListener(actionEvent -> this.backAction());
        this.backButton.addKeyListener(keyListener);
        this.backButton.setMargin(new Insets(0, 2, 0, 2));
        jPanel.add(this.backButton);
        this.getContentPane().add((Component)jPanel, "North");
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.backMenu = new JMenuItem(StringResource.getString("back"));
        this.backMenu.addActionListener(actionEvent -> this.backAction());
        this.backMenu.setEnabled(false);
        MenuHint.set(MenuHint.SHORTCUT.Backspace, this.backMenu);
        jPopupMenu.add(this.backMenu);
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(StringResource.getString("menu_result_copy"));
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx(), false));
        jMenuItem.addActionListener(actionEvent -> this.copyFrameToClipboard());
        jPopupMenu.add(jMenuItem);
        jPopupMenu.addSeparator();
        this.editRubricMenu = new JMenuItem(StringResource.getString("rubric_edit"));
        this.editRubricMenu.addActionListener(actionEvent -> this.editActRubric());
        this.editRubricMenu.setEnabled(false);
        jPopupMenu.add(this.editRubricMenu);
        this.contentPanel = new SimpleShowPanel(jPopupMenu);
        this.contentPanel.initPanel(this, null);
        this.getContentPane().add(this.contentPanel);
        if (GetDataFile.getDataPath() != null && User.instance().getProperty("externalRubric", true)) {
            this.extPathOk = true;
        }
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (this.searchField != null) {
            this.searchField.requestFocus();
        } else if (this.contentPanel != null) {
            this.contentPanel.requestFocus();
        } else {
            super.requestFocus();
        }
        if (this.actRubric != null) {
            this.setRubric(this.actRubric, null);
        }
        this.actRubric = null;
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                c = Character.toUpperCase(keyEvent.getKeyChar());
                if (c == '\u001b') {
                    keyEvent.consume();
                    if (this.searchField.getText().length() > 0) {
                        this.resetSearch(true);
                        this.searchField.requestFocus();
                    } else {
                        this.focusToParent();
                    }
                } else if (c == '\n') {
                    keyEvent.consume();
                    if (this.searchButton.isEnabled()) {
                        this.searchAction();
                    } else if (this.selectButton.isEnabled()) {
                        this.selectButton.setEnabled(false);
                        RepMainFrame.getRepInstance().selectRubricAction(this.showedRubric.get(this.showedRubric.size() - 1));
                        RepMainFrame.getRepInstance().checkAndGetFocus();
                    } else {
                        this.focusToParent();
                    }
                } else if (c == '\b') {
                    if (!this.searchField.hasFocus() || this.searchField.getText().length() == 0) {
                        keyEvent.consume();
                        this.backAction();
                    }
                } else if (keyEvent.getKeyCode() == 112) {
                    keyEvent.consume();
                    RepMainFrame.getRepInstance().helpContextAction("RubrikAnzeige");
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'U') {
                    keyEvent.consume();
                    if (!this.closeOnFocusToParent) {
                        RepMainFrame.getRepInstance().checkAndGetFocus();
                    }
                } else if (c == 'C') {
                    this.copyFrameToClipboard();
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    public boolean setRubric(Rubric rubric, String string) {
        this.showedRubric = new ArrayList();
        if (this.isVisible()) {
            if (this.showedRubricStr == null || !this.showedRubricStr.equals(rubric.getRubricKeyWithChangedExtension()) || string != null) {
                this.showedRubric.add(rubric);
                if (rubric != null) {
                    this.htmlUrl = RubricUtil.getUrlHtmRub(rubric, string);
                    if (this.htmlUrl != null) {
                        this.contentPanel.initPanel(this, this.htmlUrl);
                        if (rubric.hasValues()) {
                            this.selectButton.setEnabled(true);
                        } else {
                            this.selectButton.setEnabled(false);
                        }
                        if (this.extPathOk) {
                            this.editRubricMenu.setEnabled(true);
                        }
                        this.searchField.setEnabled(true);
                        this.highLights = null;
                        this.showedRubricStr = rubric.getRubricKeyWithChangedExtension();
                        this.setRubricAsTitle(this.showedRubricStr);
                        this.showedHtmlText = null;
                        return true;
                    }
                }
                this.contentPanel.initPanel(this, null);
                this.htmlUrl = null;
                this.showedHtmlText = null;
                this.showedRubricStr = null;
                this.setTitle(null);
                this.selectButton.setEnabled(false);
                this.editRubricMenu.setEnabled(false);
                this.searchButton.setEnabled(false);
                this.resetSearch(false);
                return false;
            }
            this.actRubric = null;
        } else {
            this.actRubric = rubric;
        }
        return false;
    }

    public boolean setStartRubric(String string) {
        this.showedRubric = new ArrayList();
        this.setTitle(null);
        if (this.isVisible() && string != null && (this.showedRubricStr == null || !this.showedRubricStr.equals(string))) {
            String string2 = "rub_info";
            this.htmlUrl = RubricUtil.getUrlHtmRub(string, string2);
            this.contentPanel.initPanel(this, this.htmlUrl);
            if (this.htmlUrl != null) {
                this.selectButton.setEnabled(false);
                this.editRubricMenu.setEnabled(false);
                this.resetSearch(true);
                this.showedRubricStr = string;
                this.showedHtmlText = null;
                return true;
            }
        }
        this.showedHtmlText = null;
        this.showedRubricStr = null;
        return false;
    }

    @Override
    public void setTitle(String string) {
        if (string == null || string.length() == 0) {
            super.setTitle("jRep  " + StringResource.getString("rubric_title"));
        } else {
            super.setTitle("jRep  " + string);
        }
    }

    public void setRubricAsTitle(String string) {
        if (string == null || string.length() == 0) {
            this.setTitle(null);
        } else {
            super.setTitle(StringResource.getString("countField_rubric") + "  " + string);
        }
    }

    public void setImage(String string, URL uRL) {
        this.showedRubric = new ArrayList();
        if (this.isVisible() && (this.showedRubricStr == null || !this.showedRubricStr.equals(string))) {
            this.showedRubric = null;
            this.showedRubricStr = string;
            this.contentPanel.initWithImage(string, uRL);
            this.selectButton.setEnabled(false);
            this.editRubricMenu.setEnabled(false);
            this.searchButton.setEnabled(false);
            this.resetSearch(false);
            this.htmlUrl = null;
            this.showedHtmlText = null;
            this.actRubric = null;
        }
    }

    public void setText(Rubric rubric, String[] stringArray) {
        this.showedRubric = new ArrayList();
        if (this.isVisible() && rubric != null && (this.showedRubricStr == null || !this.showedRubricStr.equals(rubric.getRubricKeyWithChangedExtension()))) {
            this.showedRubric.add(rubric);
            this.showedRubricStr = rubric.getRubricKeyWithChangedExtension();
            this.setRubricAsTitle(this.showedRubricStr);
            this.showedHtmlText = this.contentPanel.initWithText(stringArray);
            this.setRubricAsTitle(rubric.getRubricKeyWithChangedExtension());
            if (rubric.hasValues()) {
                this.selectButton.setEnabled(true);
            } else {
                this.selectButton.setEnabled(false);
            }
            if (this.extPathOk) {
                this.editRubricMenu.setEnabled(true);
            }
            this.searchField.setEnabled(true);
            this.highLights = null;
            this.htmlUrl = null;
            this.actRubric = null;
        }
    }

    protected void editActRubric() {
        if (this.showedRubric != null) {
            RubricUtil.editRubric(this.htmlUrl, this.showedRubric.get(this.showedRubric.size() - 1), this.showedHtmlText);
        }
    }

    void searchFieldTextValueChanged(DocumentEvent documentEvent) {
        try {
            if (this.searchField.getText().length() == 0) {
                this.searchButton.setEnabled(false);
            } else {
                this.searchButton.setEnabled(true);
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "searchFieldTextValueChanged", exception);
        }
    }

    void searchAction() {
        block8: {
            try {
                Document document = this.contentPanel.htmlPanel.getDocument();
                if (document != null) {
                    try {
                        Object object;
                        SearchParam searchParam = SearchUtil.getSearchStrings(this.searchField.getText(), true);
                        if (searchParam.isDifferentSearch(this.searchParam)) {
                            Log.write(4, this.getClass().getName(), "searching with: " + this.searchField.getText());
                            this.searchParam = searchParam;
                            object = document.getText(0, document.getLength()).toLowerCase();
                            this.highLights = this.searchParam.getAllHighLights((String)object);
                            this.nextHighLight = 0;
                        }
                        if (this.highLights != null && !this.highLights.isEmpty()) {
                            Log.write(4, this.getClass().getName(), "found values: " + this.highLights.size());
                            this.contentPanel.highlight(this.highLights);
                            object = this.highLights.get(this.nextHighLight);
                            ++this.nextHighLight;
                            this.statusField.setText(this.nextHighLight + "/" + this.highLights.size() + " " + StringResource.getString("search_found"));
                            if (this.nextHighLight >= this.highLights.size()) {
                                this.nextHighLight = 0;
                            }
                            this.contentPanel.setAndActivateMark(((SearchHighlighter.HighLight)object).getStart(), ((SearchHighlighter.HighLight)object).getEnd() - ((SearchHighlighter.HighLight)object).getStart());
                        }
                        break block8;
                    }
                    catch (Exception exception) {
                        Log.write(5, this.getClass().getName(), "searchInActDocument ", exception);
                    }
                    break block8;
                }
                Log.write(3, this.getClass().getName(), "no document retrieved ");
            }
            catch (Exception exception) {
                Log.write(3, this.getClass().getName(), "searchAction", exception);
            }
        }
    }

    @Override
    public void doneResizeLayout() {
        if (!this.closeOnFocusToParent) {
            super.doneResizeLayout();
        }
        this.contentPanel.doneResizeLayout();
    }

    @Override
    public void maximizedAction() {
        super.maximizedAction();
        this.contentPanel.doneResizeLayout();
    }

    @Override
    public void normalizedAction() {
        super.normalizedAction();
        this.contentPanel.doneResizeLayout();
    }

    protected void focusToParent() {
        if (this.closeOnFocusToParent) {
            this.closeAction();
        } else {
            RepMainFrame.getRepInstance().checkAndGetFocus();
        }
    }

    protected void backAction() {
        if (this.searchField.getText().length() == 0) {
            this.contentPanel.historyBackAction();
        } else if (this.highLights != null && this.highLights.size() > 0) {
            --this.nextHighLight;
            if (this.nextHighLight > 0) {
                SearchHighlighter.HighLight highLight = this.highLights.get(this.nextHighLight - 1);
                this.contentPanel.setAndActivateMark(highLight.getStart(), highLight.getEnd() - highLight.getStart());
            } else {
                this.resetSearch(true);
                this.contentPanel.setAndActivateMark(0, 0);
                SwingUtilities.invokeLater(() -> this.searchField.requestFocus());
            }
        }
    }

    private void resetSearch(boolean bl) {
        this.searchField.setEnabled(bl);
        this.searchField.setText("");
        this.statusField.setText("");
        this.searchParam = null;
        this.highLights = null;
        this.contentPanel.removeHighlights();
    }

    @Override
    public void historyChanged(Object object, int n) {
        this.resetSearch(true);
        if (this.contentPanel.hasHistory()) {
            this.backButton.setEnabled(true);
            this.backMenu.setEnabled(true);
        } else {
            this.backButton.setEnabled(false);
            this.backMenu.setEnabled(false);
        }
        if (this.showedRubric != null && this.showedRubric.size() != 0 && (n > 1 || this.showedRubric.size() > 1)) {
            if (n > this.showedRubric.size()) {
                boolean bl = false;
                if (object != null) {
                    Serializable serializable;
                    this.contentPanel.setAndActivateMark(0, 0);
                    if (object instanceof URL && (((URL)(serializable = (URL)object)).getFile().contains("/rubr/") || ((URL)serializable).getFile().contains("/jruba/") || ((URL)serializable).getFile().contains("/jrubb/"))) {
                        Object object2 = ((URL)serializable).getFile();
                        int n2 = ((String)object2).lastIndexOf(47);
                        object2 = ((String)object2).substring(n2 + 1, ((String)object2).length() - 4);
                        Rubric rubric = this.showedRubric.get(this.showedRubric.size() - 1);
                        String string = rubric.getRubricKeyWithChangedExtension();
                        object2 = string.substring(0, (n2 = string.lastIndexOf(" ")) + 1) + (String)object2;
                        Rubric rubric2 = RepUtil.getRubricFromRepNoChanged((String)object2, rubric.getRepIndex());
                        if (rubric2 != null) {
                            this.showedRubric.add(rubric2);
                            this.setRubricAsTitle(rubric2.getRubricKeyWithChangedExtension());
                            bl = true;
                            if (rubric2.hasValues()) {
                                this.selectButton.setEnabled(true);
                            } else {
                                this.selectButton.setEnabled(false);
                            }
                            Log.write(5, this.getClass().getName(), "history added " + rubric2.getRubricKeyWithChangedExtension());
                        }
                    }
                    if (object instanceof Rubric) {
                        serializable = (Rubric)object;
                        this.showedRubric.add((Rubric)serializable);
                        this.setRubricAsTitle(((Rubric)serializable).getRubricKeyWithChangedExtension());
                        bl = true;
                        if (((Rubric)serializable).hasValues()) {
                            this.selectButton.setEnabled(true);
                        } else {
                            this.selectButton.setEnabled(false);
                        }
                        Log.write(5, this.getClass().getName(), "history added " + ((Rubric)serializable).getRubricKeyWithChangedExtension());
                    }
                }
                if (!bl) {
                    this.showedRubric.add(this.showedRubric.get(this.showedRubric.size() - 1));
                    Log.write(5, this.getClass().getName(), "history same " + this.showedRubric.get(this.showedRubric.size() - 1).getRubricKeyWithChangedExtension());
                }
            } else {
                this.showedRubric.remove(this.showedRubric.size() - 1);
                Rubric rubric = this.showedRubric.get(this.showedRubric.size() - 1);
                Log.write(5, this.getClass().getName(), "history removed " + rubric.getRubricKeyWithChangedExtension());
                this.setRubricAsTitle(rubric.getRubricKeyWithChangedExtension());
                if (rubric.hasValues()) {
                    this.selectButton.setEnabled(true);
                } else {
                    this.selectButton.setEnabled(false);
                }
            }
        }
    }

    @Override
    public void copyToClipboard() {
        this.copyFrameToClipboard();
    }
}

