/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.PanelKeyListener;
import ch.steph.repdata.SearchMmOneResult;
import ch.steph.repmodel.MmMediListModel;
import ch.steph.repmodel.SearchMmThread;
import ch.steph.repmodel.SearchMmThreadListener;
import ch.steph.repui.RepMainFrame;
import ch.steph.repui.RepMainMenu;
import ch.steph.repui.SimpleShowPanel;
import ch.steph.reputil.MmUtil;
import ch.steph.util.Constants;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import ch.steph.util.MenuHint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SearchMedica
extends MdiNormalFrame
implements PanelKeyListener,
SearchMmThreadListener {
    private static final long serialVersionUID = 1L;
    private SimpleShowPanel contentPanel = null;
    private String medicine;
    private String[] mmTitle;
    private ArrayList<SearchMmOneResult> actResults;
    private int actResultsPointer;
    private JComboBox<String> mmChoice = null;
    private JScrollPane mediListPane;
    private JList<String> mediList = null;
    private MmMediListModel mediListModel;
    private String actMedi = null;
    private JMenu editMmMenu;
    private String[] extMmTitle;
    private SearchMmThread searchThread = null;
    private JTextField searchField;
    private JLabel statusField;
    private JButton searchButton;
    private JButton forwardButton;
    private JButton backButton;
    private static final int NO_MM = 62;
    private int actMm = 62;
    private int firstMM = 62;
    private JMenuItem backMenu;
    private JMenuItem upMenuItem;
    private JMenuItem downMenuItem;
    private JMenuItem searchMenuItem;
    private JMenuItem nextMenuItem;
    private JMenuItem prevMenuItem;
    private JMenuItem buildRubricItem;
    private SearchMedica thisInstance;
    private int statusCount;

    public SearchMedica(String string, boolean bl, String[] stringArray) {
        super(true, "", 9, "med");
        JComponent jComponent;
        User.instance().setProperty("cSearchMed", User.instance().getProperty("cSearchMed", 0) + 1);
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        this.medicine = string;
        this.thisInstance = this;
        if (bl && string == null) {
            this.medicine = StringResource.getString("search_button");
        }
        this.setTitle(null);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                SearchMedica.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        if (bl) {
            jComponent = new JPanel();
            jComponent.setLayout(new GridLayout(1, 5));
            jPanel2.add((Component)jComponent, "Center");
            this.searchField = new JTextField(12);
            this.searchField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    SearchMedica.this.searchFieldTextValueChanged(documentEvent);
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SearchMedica.this.searchFieldTextValueChanged(documentEvent);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SearchMedica.this.searchFieldTextValueChanged(documentEvent);
                }
            });
            jComponent.add(this.searchField);
            this.searchField.addKeyListener(keyListener);
            this.searchField.setToolTipText(StringResource.getString("input_mm_tooltip"));
            this.searchButton = new JButton(StringResource.getString("search_button"));
            this.searchButton.addActionListener(actionEvent -> this.doSearch());
            this.searchButton.setEnabled(false);
            jComponent.add(this.searchButton);
            this.searchButton.addKeyListener(keyListener);
            this.statusField = new JLabel("", 0);
            this.statusField.setHorizontalAlignment(0);
            this.statusField.setText(StringResource.getString("search_in") + " ");
            jComponent.add(this.statusField);
            this.forwardButton = new JButton(StringResource.getString("search_forward"));
            this.forwardButton.addActionListener(actionEvent -> this.searchForward());
            this.forwardButton.setEnabled(false);
            jComponent.add(this.forwardButton);
            this.forwardButton.addKeyListener(keyListener);
            this.backButton = new JButton(StringResource.getString("search_back"));
            this.backButton.addActionListener(actionEvent -> this.searchBackward());
            this.backButton.setEnabled(false);
            jComponent.add(this.backButton);
            this.backButton.addKeyListener(keyListener);
        }
        jComponent = new JPopupMenu();
        this.backMenu = new JMenuItem(StringResource.getString("back"));
        this.backMenu.addActionListener(actionEvent -> this.backAction());
        this.backMenu.setEnabled(false);
        ((JPopupMenu)jComponent).add(this.backMenu);
        ((JPopupMenu)jComponent).addSeparator();
        this.editMmMenu = new JMenu(StringResource.getString("menu_mm_edit") + "                      ");
        for (String string2 : this.extMmTitle = MmUtil.getExtMMTitles()) {
            JMenuItem object = new JMenuItem(string2);
            object.addActionListener(this::editExtMM);
            this.editMmMenu.add(object);
            this.editMmMenu.setEnabled(false);
        }
        ((JPopupMenu)jComponent).add(this.editMmMenu);
        this.buildRubricItem = new JMenuItem(StringResource.getString("case_rubric_new"));
        this.buildRubricItem.addActionListener(actionEvent -> this.buildNewRubric());
        ((JPopupMenu)jComponent).add(this.buildRubricItem);
        this.buildRubricItem.setEnabled(false);
        ((JPopupMenu)jComponent).addSeparator();
        this.upMenuItem = new JMenuItem(StringResource.getString("search_pop_pgup"));
        this.upMenuItem.addActionListener(actionEvent -> this.contentPanel.doPgUp());
        MenuHint.set(MenuHint.SHORTCUT.PgUp, this.upMenuItem);
        ((JPopupMenu)jComponent).add(this.upMenuItem);
        this.downMenuItem = new JMenuItem(StringResource.getString("search_pop_pgdn"));
        this.downMenuItem.addActionListener(actionEvent -> this.contentPanel.doPgDown());
        MenuHint.set(MenuHint.SHORTCUT.PgDn, this.downMenuItem);
        ((JPopupMenu)jComponent).add(this.downMenuItem);
        if (bl) {
            ((JPopupMenu)jComponent).addSeparator();
            this.searchMenuItem = new JMenuItem(StringResource.getString("search_pop_search"));
            this.searchMenuItem.addActionListener(actionEvent -> this.doSearch());
            ((JPopupMenu)jComponent).add(this.searchMenuItem);
            MenuHint.set(MenuHint.SHORTCUT.Enter, this.searchMenuItem);
            this.searchMenuItem.setEnabled(false);
            this.nextMenuItem = new JMenuItem(StringResource.getString("search_pop_next"));
            this.nextMenuItem.addActionListener(actionEvent -> this.searchForward());
            MenuHint.set(MenuHint.SHORTCUT.Enter, this.nextMenuItem);
            ((JPopupMenu)jComponent).add(this.nextMenuItem);
            this.nextMenuItem.setEnabled(false);
            this.prevMenuItem = new JMenuItem(StringResource.getString("search_pop_previos"));
            this.prevMenuItem.addActionListener(actionEvent -> this.searchBackward());
            MenuHint.set(MenuHint.SHORTCUT.Backspace, this.prevMenuItem);
            ((JPopupMenu)jComponent).add(this.prevMenuItem);
            this.prevMenuItem.setEnabled(false);
        }
        this.mmTitle = User.instance().getMmTitles();
        this.mmTitle[0] = StringResource.getString("mm_all_medi");
        if (this.mmTitle != null) {
            for (int i = 0; i < this.mmTitle.length && this.firstMM >= 62; ++i) {
                if (this.mmTitle[i].length() <= 0) continue;
                this.firstMM = i;
            }
        }
        if (this.mmTitle != null) {
            this.mmChoice = new JComboBox();
            int n = 0;
            for (String string2 : this.mmTitle) {
                if (string2.length() <= 0) continue;
                ++n;
                this.mmChoice.addItem(string2);
            }
            if (n > 0) {
                this.mmChoice.addItemListener(this::chooseMmAction);
            } else {
                this.mmChoice = null;
            }
            this.mmChoice.setMaximumRowCount(User.instance().getProperty("DropdownRows", 20));
        }
        if (this.mmChoice != null) {
            jPanel.add(this.mmChoice, "East");
            this.mmChoice.addKeyListener(keyListener);
        }
        if (stringArray != null) {
            this.mediListPane = new JScrollPane();
            this.mediListModel = new MmMediListModel(stringArray);
            this.mediList = new JList<String>(this.mediListModel);
            ((JLabel)((Object)this.mediList.getCellRenderer())).setBorder(BorderFactory.createEmptyBorder());
            this.mediListPane.getViewport().add(this.mediList);
            this.mediList.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    SearchMedica.this.chooseMediAction();
                }
            });
            this.mediList.addListSelectionListener(listSelectionEvent -> {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    this.chooseMediAction();
                }
            });
            this.getContentPane().add((Component)this.mediListPane, "West");
            this.mediList.addKeyListener(keyListener);
        }
        this.contentPanel = new SimpleShowPanel((JPopupMenu)jComponent);
        this.contentPanel.initPanel(this, null);
        this.getContentPane().add((Component)this.contentPanel, "Center");
        if (this.firstMM >= 62) {
            this.firstMM = 0;
        }
        int n = this.firstMM;
        this.firstMM = User.instance().getProperty("actMMsearch", this.firstMM);
        if (this.mmTitle == null || this.mmTitle.length <= this.firstMM || this.mmTitle[this.firstMM].length() == 0) {
            this.firstMM = n;
        }
        if (this.medicine != null && !Constants.APP_HELP.equals(this.medicine) && !this.medicine.startsWith(Constants.DATA_HELP)) {
            this.chooseMm(this.firstMM);
        }
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        if (!(this.medicine == null || Constants.APP_HELP.equals(this.medicine) || this.medicine.startsWith(Constants.DATA_HELP) || this.medicine.startsWith("MM-Info") || this.actMm == 0 || this.searchField == null)) {
            this.searchField.requestFocus();
        } else if (this.mediList != null) {
            this.mediList.requestFocus();
        } else if (this.contentPanel != null) {
            this.contentPanel.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public void setTitle(String string) {
        if (string == null || string.length() == 0) {
            super.setTitle("jRep " + StringResource.getString("mm_added_title"));
        } else {
            super.setTitle("jRep  " + string);
        }
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                c = Character.toUpperCase(keyEvent.getKeyChar());
                switch (c) {
                    case '\u001b': {
                        keyEvent.consume();
                        this.closeAction();
                        break;
                    }
                    case '\t': {
                        keyEvent.consume();
                        this.mediList.requestFocus();
                        break;
                    }
                    case '\"': {
                        keyEvent.consume();
                        this.contentPanel.doPgDown();
                        break;
                    }
                    case '!': {
                        keyEvent.consume();
                        this.contentPanel.doPgUp();
                        break;
                    }
                    case '\n': {
                        keyEvent.consume();
                        if (this.actResults != null && this.actResults.size() > 1) {
                            this.searchForward();
                            break;
                        }
                        if (!this.searchButton.isEnabled()) break;
                        this.doSearch();
                        break;
                    }
                    case '\b': {
                        if (!this.searchBackward()) break;
                        keyEvent.consume();
                        break;
                    }
                    default: {
                        int n;
                        if (keyEvent.getKeyCode() == 112) {
                            keyEvent.consume();
                            RepMainFrame.getRepInstance().helpContextAction("MM-Zusaetzlich");
                            break;
                        }
                        if (keyEvent.getSource() == this.searchField || keyEvent.getSource() == this.mediList || (n = MmUtil.getMmIndex(c)) < 1) break;
                        keyEvent.consume();
                        this.chooseMm(n);
                    }
                }
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'C') {
                    this.copyToClipboard();
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    protected void chooseMm(int n) {
        if (n < 62) {
            if (this.mmTitle == null) {
                n = this.actMm < 62 ? this.actMm : this.firstMM;
            } else if (this.mmTitle[n].length() == 0) {
                n = this.actMm < 62 ? (this.mmTitle[this.actMm].length() == 0 ? this.firstMM : this.actMm) : this.firstMM;
            }
            if (n != this.actMm) {
                this.actMm = n;
                if (this.mmChoice != null && this.mmTitle[this.actMm] != null && this.mmTitle[this.actMm].length() > 0) {
                    if (!this.mmChoice.getSelectedItem().equals(this.mmTitle[this.actMm])) {
                        this.mmChoice.setSelectedItem(this.mmTitle[this.actMm]);
                    } else {
                        this.chooseMmAction(new ItemEvent(this.mmChoice, 0, this.mmTitle[this.actMm], 1));
                    }
                }
            }
        }
    }

    protected void chooseMmAction(ItemEvent itemEvent) {
        if (this.mmTitle != null && itemEvent.getStateChange() == 1) {
            for (int i = 0; i < 62; ++i) {
                if (!itemEvent.getItem().equals(this.mmTitle[i])) continue;
                this.actMm = i;
                User.instance().setProperty("actMMsearch", this.actMm);
                if (this.actMm == 0) {
                    this.searchButton.setEnabled(false);
                    this.searchField.setText("");
                    this.searchField.setEnabled(false);
                } else {
                    this.searchField.setEnabled(true);
                }
                if (this.contentPanel == null) continue;
                if (this.actMedi != null) {
                    this.setMmMediChoice(this.actMm, this.actMedi);
                    continue;
                }
                this.setMmMediChoice(this.actMm, this.medicine);
            }
            this.mediList.requestFocus();
        }
    }

    private void setMmMediChoice(int n, String string) {
        if (this.mediList != null) {
            this.mediListModel.filterMedisByMm(n);
            if (this.statusField != null) {
                SwingUtilities.invokeLater(() -> {
                    this.statusField.setText(StringResource.getString("search_in") + " " + (this.mediListModel.getSize() - 1));
                    this.enableResults(false);
                });
            }
            if (this.actMm == 0 && ("MM-Info".equals(this.medicine) && this.actMedi == null || this.actMedi != null && "MM-Info".equals(this.actMedi))) {
                String string2 = this.mediListModel.getMediByIndex(0);
                this.mediList.setSelectedIndex(0);
                this.mediList.ensureIndexIsVisible(0);
                this.contentPanel.initPanel(this, MmUtil.getUrlHtmMed(n, string, false), this.actMm, string2);
            } else {
                int n2 = this.mediListModel.getIndexByMedi(string);
                this.actMedi = this.mediListModel.getMediByIndex(n2);
                this.mediList.setSelectedIndex(n2);
                this.mediList.ensureIndexIsVisible(n2);
                this.contentPanel.initPanel(this, MmUtil.getUrlHtmMed(n, string, false), this.actMm, string);
            }
            this.enableEditMmMenu();
        }
    }

    private String getSelectedMedi() {
        String string = this.mediList.getSelectedValue();
        if (string != null) {
            int n = string.indexOf(" {");
            if (n >= 0) {
                string = string.substring(0, n);
            }
            return string;
        }
        return "";
    }

    protected void chooseMediAction() {
        String string = this.getSelectedMedi();
        if (string != null) {
            this.actMedi = string;
            if (this.actResults != null) {
                for (int i = 0; i < this.actResults.size(); ++i) {
                    SearchMmOneResult searchMmOneResult = this.actResults.get(i);
                    if (!searchMmOneResult.getMedi().equals(this.actMedi)) continue;
                    this.actResultsPointer = i;
                    this.contentPanel.initPanel(this, MmUtil.getUrlHtmMed(this.actMm, string, false), string, searchMmOneResult.getWhere(), searchMmOneResult.getLength(), searchMmOneResult.getHighLights());
                    this.enableEditMmMenu();
                    return;
                }
            }
            this.actResultsPointer = 0;
            this.contentPanel.initPanel(this, MmUtil.getUrlHtmMed(this.actMm, string, false), this.actMm, string);
            this.enableEditMmMenu();
        }
    }

    private void enableSearch(boolean bl) {
        this.searchButton.setEnabled(bl);
        if (bl) {
            if (this.actResults == null || this.actResults.size() <= 1) {
                this.searchMenuItem.setEnabled(false);
            }
        } else {
            this.searchMenuItem.setEnabled(false);
        }
    }

    private void enableResults(boolean bl) {
        this.forwardButton.setEnabled(bl);
        this.backButton.setEnabled(bl);
        this.nextMenuItem.setEnabled(bl);
        this.prevMenuItem.setEnabled(bl);
        this.buildRubricItem.setEnabled(bl);
        if (bl) {
            this.searchMenuItem.setEnabled(false);
        }
    }

    protected void searchFieldTextValueChanged(DocumentEvent documentEvent) {
        if (this.searchField.getText().length() > 0) {
            this.enableSearch(true);
        } else {
            this.enableSearch(false);
        }
    }

    protected void doSearch() {
        if (this.searchButton.isEnabled()) {
            this.enableSearch(false);
            this.enableResults(false);
            this.actResults = new ArrayList();
            this.actResultsPointer = 0;
            this.mediListModel.resetResultCounter();
            this.statusCount = 0;
            SwingUtilities.invokeLater(() -> this.statusField.setText(StringResource.getString("search_button") + " " + this.statusCount));
            int n = this.mediList.getSelectedIndex();
            if (n < 0) {
                n = 0;
            }
            new SearchMmThread(this.actMm, n, this.mediListModel, this.searchField.getText(), this);
        }
    }

    private void showActResult() {
        if (this.actResultsPointer >= 0 && this.actResultsPointer < this.actResults.size()) {
            SwingUtilities.invokeLater(() -> {
                if (this.actResultsPointer >= 0 && this.actResultsPointer < this.actResults.size()) {
                    SearchMmOneResult searchMmOneResult = this.actResults.get(this.actResultsPointer);
                    this.actMedi = searchMmOneResult.getMedi();
                    String string = this.mediListModel.getElementAt(searchMmOneResult.getListPlace());
                    this.mediList.setSelectedValue(string, true);
                    this.contentPanel.initPanel(this.thisInstance, MmUtil.getUrlHtmMed(this.actMm, this.actMedi, false), this.actMedi, searchMmOneResult.getWhere(), searchMmOneResult.getLength(), searchMmOneResult.getHighLights());
                    this.enableEditMmMenu();
                }
            });
        }
    }

    protected void searchForward() {
        if (this.actResults != null && this.actResults.size() > 1 && this.actResultsPointer < this.actResults.size() - 1) {
            ++this.actResultsPointer;
            this.showActResult();
        }
    }

    protected boolean searchBackward() {
        if (this.backMenu.isEnabled()) {
            this.backAction();
            return true;
        }
        if (this.actResults != null && this.actResults.size() > 1) {
            if (this.actResultsPointer >= 0) {
                --this.actResultsPointer;
                this.showActResult();
            } else {
                this.newSearch();
            }
            return true;
        }
        return false;
    }

    @Override
    public void searchDone() {
        this.enableSearch(true);
        if (this.actResults.size() > 0) {
            this.enableResults(true);
        } else {
            this.enableResults(false);
        }
        if (this.searchThread != null) {
            this.searchThread.stopSearch();
        }
        this.searchThread = null;
        SwingUtilities.invokeLater(() -> this.statusField.setText(this.actResults.size() + " " + StringResource.getString("search_found")));
        this.validate();
    }

    @Override
    public void searchResult(SearchMmOneResult searchMmOneResult) {
        int n = this.mediListModel.getIndexByMedi(searchMmOneResult.getMedi());
        this.mediListModel.incrementResultCount(n);
        searchMmOneResult.setListPlace(n);
        this.actResults.add(searchMmOneResult);
        if (this.actResults.size() == 1) {
            this.actResultsPointer = 0;
            this.showActResult();
        } else {
            this.enableResults(true);
        }
    }

    @Override
    public void searchInMedi(int n) {
        this.statusCount = n;
        SwingUtilities.invokeLater(() -> this.statusField.setText(StringResource.getString("search_button") + " " + this.statusCount));
    }

    protected void newSearch() {
        this.actResults = new ArrayList();
        this.searchField.setText("");
        this.statusField.setText("");
        this.searchField.requestFocus();
        this.mediListModel.resetResultCounter();
    }

    protected void enableEditMmMenu() {
        boolean bl = true;
        if (GetDataFile.getDataPath() == null) {
            bl = false;
        }
        if (!User.instance().getProperty("externalRubric", true)) {
            bl = false;
        }
        if (this.contentPanel.getActMedicine() == null || this.contentPanel.getActMedicine().length() == 0) {
            bl = false;
        }
        this.editMmMenu.setEnabled(bl);
    }

    protected void editExtMM(ActionEvent actionEvent) {
        for (int i = 0; i < this.extMmTitle.length; ++i) {
            if (!actionEvent.getActionCommand().equals(this.extMmTitle[i])) continue;
            MmUtil.editExtMM(i + 1, this.contentPanel.getActMedicine());
            i = this.extMmTitle.length;
        }
    }

    private void buildNewRubric() {
        String string = this.searchField.getText();
        String[] stringArray = this.mediListModel.getMediArray();
        int[] nArray = this.mediListModel.getSearchResultForMediArray();
        RepMainFrame.getRepInstance().newRubric(string, stringArray, nArray);
    }

    @Override
    public void closeAction() {
        if (this.searchThread != null) {
            this.searchThread.stopSearch();
        }
        this.searchThread = null;
        super.closeAction();
    }

    protected void backAction() {
        this.contentPanel.historyBackAction();
    }

    @Override
    public void historyChanged(Object object, int n) {
        if (this.contentPanel.hasHistory()) {
            this.backMenu.setEnabled(true);
            this.backButton.setEnabled(true);
        } else {
            this.backMenu.setEnabled(false);
            if (this.actResults == null || this.actResults.size() == 0) {
                this.backButton.setEnabled(false);
            }
        }
    }

    @Override
    public void copyToClipboard() {
        this.copyFrameToClipboard();
    }
}

