/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.StringResource;
import ch.steph.rep.Rep;
import ch.steph.repmodel.SearchMmThread;
import ch.steph.repui.SimpleShowPanel;
import ch.steph.reputil.SearchHighlighter;
import ch.steph.reputil.SearchParam;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.Log;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Caret;

public class SimpleSearchPanel
extends SimpleShowPanel
implements Runnable {
    private static final long serialVersionUID = 1L;
    private List<SearchHighlighter.HighLight> highLights;
    private int nextHighLight;
    private SearchMmThread searchThread = null;
    private JTextField searchField;
    private JLabel statusField;
    private JButton searchButton;
    private JButton forwardButton;
    private JButton backButton;
    protected JButton historyBackButton;
    JMenuItem upMenuItem;
    JMenuItem downMenuItem;
    JMenuItem searchMenuItem;
    JMenuItem nextMenuItem;
    JMenuItem prevMenuItem;

    public SimpleSearchPanel(JPopupMenu jPopupMenu) {
        super(jPopupMenu);
        if (jPopupMenu == null) {
            jPopupMenu = new JPopupMenu();
        } else {
            jPopupMenu.addSeparator();
        }
        this.upMenuItem = new JMenuItem(StringResource.getString("search_pop_pgup"));
        this.upMenuItem.addActionListener(actionEvent -> this.doPgUp());
        jPopupMenu.add(this.upMenuItem);
        this.downMenuItem = new JMenuItem(StringResource.getString("search_pop_pgdn"));
        this.downMenuItem.addActionListener(actionEvent -> this.doPgDown());
        jPopupMenu.add(this.downMenuItem);
        jPopupMenu.addSeparator();
        this.searchMenuItem = new JMenuItem(StringResource.getString("search_pop_search"));
        this.searchMenuItem.addActionListener(actionEvent -> this.doSearch());
        jPopupMenu.add(this.searchMenuItem);
        this.searchMenuItem.setEnabled(false);
        this.nextMenuItem = new JMenuItem(StringResource.getString("search_pop_next"));
        this.nextMenuItem.addActionListener(actionEvent -> this.searchForward());
        jPopupMenu.add(this.nextMenuItem);
        this.nextMenuItem.setEnabled(false);
        this.prevMenuItem = new JMenuItem(StringResource.getString("search_pop_previos"));
        this.prevMenuItem.addActionListener(actionEvent -> this.searchBackward());
        jPopupMenu.add(this.prevMenuItem);
        this.prevMenuItem.setEnabled(false);
        super.setPopupMenu(jPopupMenu);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                SimpleSearchPanel.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 5));
        this.add((Component)jPanel, "North");
        this.searchField = new JTextField(12);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SimpleSearchPanel.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SimpleSearchPanel.this.searchFieldTextValueChanged(documentEvent);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SimpleSearchPanel.this.searchFieldTextValueChanged(documentEvent);
            }
        });
        jPanel.add(this.searchField);
        this.searchField.addKeyListener(keyListener);
        this.searchButton = new JButton(StringResource.getString("search_button"));
        this.searchButton.addActionListener(actionEvent -> this.doSearch());
        this.searchButton.setEnabled(false);
        jPanel.add(this.searchButton);
        this.searchButton.addKeyListener(keyListener);
        this.statusField = new JLabel("", 0);
        this.statusField.setHorizontalAlignment(0);
        this.statusField.setText(" ");
        jPanel.add(this.statusField);
        this.forwardButton = new JButton(StringResource.getString("search_forward"));
        this.forwardButton.addActionListener(actionEvent -> this.searchForward());
        this.forwardButton.setEnabled(false);
        jPanel.add(this.forwardButton);
        this.forwardButton.addKeyListener(keyListener);
        this.backButton = new JButton(StringResource.getString("search_back"));
        this.backButton.addActionListener(actionEvent -> this.searchBackward());
        this.backButton.setEnabled(false);
        jPanel.add(this.backButton);
        this.backButton.addKeyListener(keyListener);
        this.historyBackButton = new JButton(StringResource.getString("back"));
        this.historyBackButton.addActionListener(actionEvent -> this.historyBackAction());
        this.historyBackButton.setEnabled(false);
        jPanel.add(this.historyBackButton);
        this.historyBackButton.addKeyListener(keyListener);
    }

    @Override
    public void requestFocus() {
        if (this.searchField != null) {
            this.searchField.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    private void enableSearch(boolean bl) {
        this.searchButton.setEnabled(bl);
        if (bl) {
            if (this.highLights == null || this.highLights.size() <= 1) {
                this.searchMenuItem.setEnabled(false);
            }
        } else {
            this.searchMenuItem.setEnabled(false);
        }
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                char c = Character.toUpperCase(keyEvent.getKeyChar());
                switch (c) {
                    case '\"': {
                        keyEvent.consume();
                        this.doPgDown();
                        break;
                    }
                    case '!': {
                        keyEvent.consume();
                        this.doPgUp();
                        break;
                    }
                    case '\n': {
                        if (this.highLights != null && this.highLights.size() > 1) {
                            keyEvent.consume();
                            this.searchForward();
                            break;
                        }
                        if (!this.searchButton.isEnabled()) break;
                        keyEvent.consume();
                        this.doSearch();
                        break;
                    }
                    case '\b': {
                        if (this.highLights != null && this.highLights.size() > 1) {
                            keyEvent.consume();
                            this.searchBackward();
                            break;
                        }
                        this.searchField.requestFocus();
                        break;
                    }
                }
            }
            super.mainKeyPressed(keyEvent);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    private void enableResults(boolean bl) {
        this.forwardButton.setEnabled(bl);
        this.backButton.setEnabled(bl);
        this.nextMenuItem.setEnabled(bl);
        this.prevMenuItem.setEnabled(bl);
        if (bl) {
            this.searchMenuItem.setEnabled(false);
        }
    }

    protected void searchFieldTextValueChanged(DocumentEvent documentEvent) {
        if (this.searchField.getText().length() > 0) {
            this.enableSearch(true);
        } else {
            this.enableSearch(false);
        }
    }

    protected void doSearch() {
        if (this.searchButton.isEnabled()) {
            this.enableSearch(false);
            this.enableResults(false);
            SwingUtilities.invokeLater(() -> this.statusField.setText(StringResource.getString("search_button") + " 0"));
            Rep.getExecutor().execute(this);
        }
    }

    private void showActResult() {
        SearchHighlighter.highlight(this.htmlPanel, this.highLights);
        if (this.nextHighLight >= 0 && this.nextHighLight < this.highLights.size()) {
            SwingUtilities.invokeLater(() -> {
                if (this.nextHighLight >= 0 && this.nextHighLight < this.highLights.size()) {
                    SearchHighlighter.HighLight highLight = this.highLights.get(this.nextHighLight);
                    this.htmlPanel.requestFocus();
                    Caret caret = this.htmlPanel.getCaret();
                    caret.setDot(highLight.getStart());
                    caret.moveDot(highLight.getEnd());
                }
            });
        }
    }

    protected void searchForward() {
        if (this.highLights != null && this.highLights.size() > 1 && this.nextHighLight < this.highLights.size() - 1) {
            ++this.nextHighLight;
            this.showActResult();
        }
    }

    protected void searchBackward() {
        if (this.highLights != null && this.highLights.size() > 1) {
            if (this.nextHighLight >= 0) {
                --this.nextHighLight;
                this.showActResult();
            } else {
                this.highLights = new ArrayList<SearchHighlighter.HighLight>();
                this.searchField.setText("");
                this.statusField.setText("");
                this.searchField.requestFocus();
            }
        }
    }

    public void searchDone() {
        this.enableSearch(true);
        if (this.highLights.size() > 0) {
            this.enableResults(true);
        } else {
            this.enableResults(false);
        }
        if (this.searchThread != null) {
            this.searchThread.stopSearch();
        }
        this.searchThread = null;
        SwingUtilities.invokeLater(() -> this.statusField.setText(this.highLights.size() + " " + StringResource.getString("search_found")));
    }

    @Override
    public void run() {
        try {
            SearchParam searchParam = SearchUtil.getSearchStrings(this.searchField.getText(), true);
            if (this.actDocument != null && searchParam != null) {
                String string = this.actDocument.getText(0, this.actDocument.getLength()).toLowerCase();
                this.highLights = searchParam.getAllHighLights(string);
                this.nextHighLight = 0;
                if (this.highLights.size() == 1) {
                    this.showActResult();
                } else {
                    this.enableResults(true);
                }
            }
        }
        catch (Exception exception) {
            Log.write(5, this.getClass().getName(), "searchInActDocument ", exception);
        }
        this.searchDone();
    }
}

