/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.rep.PanelKeyListener;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.MmUtil;
import ch.steph.reputil.RubricShowUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.reputil.SearchHighlighter;
import ch.steph.util.FsetJEditorPane;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Caret;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.JRepSwingViewBuilder;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.views.AnnotationCallback;

public class SimpleShowPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private PanelKeyListener parent;
    protected JScrollPane scrollPane;
    private JViewport port;
    protected FsetJEditorPane htmlPanel;
    private KeyListener mainKeyListener;
    protected String documentTitle;
    protected HTMLDocument actDocument;
    protected SwingController pdfController;
    private JPanel pdfComponentPanel;
    private JPopupMenu popupMenu;
    private String medicine;
    private JLabel nameLabel;
    private JLabel imageLabel;
    private URL showedUrl;
    private BufferedImage orgImage = null;
    private ArrayList<Object> urlHistory = new ArrayList();
    private List<SearchHighlighter.HighLight> highLights;
    private int cursorToSet;
    private int lengthToSet;

    public SimpleShowPanel(JPopupMenu jPopupMenu) {
        super(new BorderLayout());
        this.popupMenu = jPopupMenu;
        Log.write(5, this.getClass().getName(), "start");
        this.mainKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                SimpleShowPanel.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.addKeyListener(this.mainKeyListener);
        this.cursorToSet = 1;
        this.lengthToSet = 0;
        this.makeNewPanel(true);
        this.makeNewPanelAfterLoading();
    }

    public void setPopupMenu(JPopupMenu jPopupMenu) {
        this.popupMenu = jPopupMenu;
    }

    private void removeHtmlPanel() {
        this.actDocument = null;
        Component component = this.port.getView();
        if (component != null) {
            this.port.remove(component);
            component.removeNotify();
        }
        this.nameLabel = null;
        this.imageLabel = null;
        this.orgImage = null;
    }

    private void makeNewPanel(boolean bl) {
        this.nameLabel = null;
        this.imageLabel = null;
        this.orgImage = null;
        if (this.parent != null) {
            this.parent.setTitle(null);
        }
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        if (this.pdfComponentPanel != null) {
            this.remove(this.pdfComponentPanel);
        }
        if (this.pdfController != null) {
            this.pdfController.closeDocument();
            this.pdfController.dispose();
        }
        this.scrollPane = null;
        this.port = null;
        this.htmlPanel = null;
        this.actDocument = null;
        this.pdfController = null;
        this.pdfComponentPanel = null;
        this.highLights = null;
        if (bl) {
            this.scrollPane = new JScrollPane();
            this.port = this.scrollPane.getViewport();
            this.port.addKeyListener(this.mainKeyListener);
            this.scrollPane.addKeyListener(this.mainKeyListener);
            this.htmlPanel = new FsetJEditorPane();
            this.port.add(this.htmlPanel);
            this.htmlPanel.setEditable(false);
            this.htmlPanel.setContentType("text/html");
            this.htmlPanel.addKeyListener(this.mainKeyListener);
            this.actDocument = (HTMLDocument)this.htmlPanel.getDocument();
            this.htmlPanel.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                        if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                            HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                            SimpleShowPanel.this.actDocument = (HTMLDocument)jEditorPane.getDocument();
                            SimpleShowPanel.this.actDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                        } else {
                            try {
                                URL uRL = hyperlinkEvent.getURL();
                                if (uRL == null) {
                                    String string = hyperlinkEvent.getDescription();
                                    if (string != null && string.startsWith("j:")) {
                                        uRL = ClassLoader.getSystemResource(string.substring(2));
                                    }
                                    if (string != null && string.startsWith("r:")) {
                                        Rubric rubric = RubricShowUtil.getRubricFromRLink(string);
                                        SimpleShowPanel.this.addResetUrlHistory(rubric, false);
                                        String string2 = RubricUtil.getHtmlText(RubricShowUtil.makeRubricHtml(rubric, null));
                                        SimpleShowPanel.this.htmlPanel.setText(string2);
                                        SimpleShowPanel.this.setCursorToSet(true);
                                    }
                                }
                                if (uRL != null) {
                                    SimpleShowPanel.this.addResetUrlHistory(uRL, false);
                                    SimpleShowPanel.this.showedUrl = uRL;
                                    if (uRL.getFile().endsWith(".pdf")) {
                                        SimpleShowPanel.this.makeNewPanel(false);
                                        Log.write(5, this.getClass().getName(), "Load PDF: " + String.valueOf(uRL));
                                        SimpleShowPanel.this.pdfController.openDocument(uRL);
                                    } else {
                                        SimpleShowPanel.this.htmlPanel.setFsetPage(uRL);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                Log.write(3, this.getClass().getName(), "page not loaded: " + String.valueOf(hyperlinkEvent.getURL()), exception);
                            }
                        }
                    }
                }
            });
            this.htmlPanel.addPropertyChangeListener("document", propertyChangeEvent -> {
                if (propertyChangeEvent.getNewValue() instanceof HTMLDocument) {
                    this.actDocument = (HTMLDocument)propertyChangeEvent.getNewValue();
                    this.documentTitle = (String)this.actDocument.getProperty("title");
                    if (this.documentTitle != null && this.documentTitle.length() > 0) {
                        SwingUtilities.invokeLater(() -> {
                            if (this.documentTitle != null && this.parent != null) {
                                this.parent.setTitle(this.documentTitle);
                            }
                        });
                    }
                    this.actDocument.addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent documentEvent) {
                        }

                        @Override
                        public void insertUpdate(DocumentEvent documentEvent) {
                            SimpleShowPanel.this.actDocument = (HTMLDocument)documentEvent.getDocument();
                            SimpleShowPanel.this.documentTitle = (String)SimpleShowPanel.this.actDocument.getProperty("title");
                            if (SimpleShowPanel.this.documentTitle != null && SimpleShowPanel.this.documentTitle.length() > 0) {
                                SwingUtilities.invokeLater(() -> {
                                    if (SimpleShowPanel.this.documentTitle != null && SimpleShowPanel.this.parent != null) {
                                        SimpleShowPanel.this.parent.setTitle(SimpleShowPanel.this.documentTitle);
                                    }
                                });
                            }
                        }

                        @Override
                        public void removeUpdate(DocumentEvent documentEvent) {
                        }
                    });
                }
            });
            this.htmlPanel.addPropertyChangeListener("page", propertyChangeEvent -> {
                this.setCursorToSet(false);
                if (this.lengthToSet > 0) {
                    this.htmlPanel.requestFocus();
                }
            });
            if (this.popupMenu != null) {
                this.htmlPanel.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                        if (mouseEvent.isPopupTrigger()) {
                            SimpleShowPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
                        if (mouseEvent.isPopupTrigger()) {
                            SimpleShowPanel.this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                        }
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
            }
            this.add((Component)this.scrollPane, "Center");
        } else {
            this.pdfController = new SwingController();
            JRepSwingViewBuilder jRepSwingViewBuilder = new JRepSwingViewBuilder(this.pdfController);
            this.pdfComponentPanel = jRepSwingViewBuilder.buildViewerPanel();
            ComponentKeyBinding.install((SwingController)this.pdfController, (JComponent)this.pdfComponentPanel);
            this.pdfController.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(this.pdfController.getDocumentViewController()));
            this.add(this.pdfComponentPanel);
        }
    }

    private void makeNewPanelAfterLoading() {
        if (this.pdfController != null) {
            this.pdfController.getDocumentViewController().setFitMode(4);
            this.pdfController.setUtilityPaneVisible(true);
        }
        this.validate();
    }

    public void initPanel(PanelKeyListener panelKeyListener, URL uRL) {
        this.initPanel(panelKeyListener, uRL, -1, null, false);
    }

    public void initPanel(PanelKeyListener panelKeyListener, URL uRL, boolean bl) {
        this.initPanel(panelKeyListener, uRL, -1, null, bl);
    }

    public void initPanel(PanelKeyListener panelKeyListener, URL uRL, int n, String string) {
        this.initPanel(panelKeyListener, uRL, n, string, false);
    }

    public void initPanel(PanelKeyListener panelKeyListener, URL uRL, int n, String string, boolean bl) {
        this.parent = panelKeyListener;
        this.medicine = string;
        this.orgImage = null;
        this.cursorToSet = 1;
        this.lengthToSet = 0;
        if (uRL == null || this.showedUrl == null || !uRL.sameFile(this.showedUrl) || bl) {
            this.showedUrl = uRL;
            if (this.showedUrl == null) {
                this.makeNewPanel(true);
                if (string != null && string.length() > 0) {
                    this.htmlPanel.setText(MmUtil.getNoMedHTML(string, n != 0));
                    this.setCursorToSet(true);
                    this.showedUrl = null;
                }
                this.makeNewPanelAfterLoading();
                Log.write(5, this.getClass().getName(), "url is null");
            } else {
                this.addResetUrlHistory(uRL, true);
                try {
                    String string2 = uRL.getFile();
                    if (string2.endsWith(".pdf")) {
                        this.makeNewPanel(false);
                        Log.write(5, this.getClass().getName(), "Load PDF: " + String.valueOf(this.showedUrl));
                        this.pdfController.openDocument(string2);
                    } else {
                        if (this.port == null || !(this.port.getView() instanceof FsetJEditorPane)) {
                            this.makeNewPanel(true);
                        }
                        Log.write(5, this.getClass().getName(), "Load HTML: " + String.valueOf(this.showedUrl));
                        this.htmlPanel.setFsetPage(this.showedUrl);
                    }
                    this.makeNewPanelAfterLoading();
                }
                catch (Exception exception) {
                    Log.write(5, this.getClass().getName(), "Not Loaded: " + String.valueOf(this.showedUrl), exception);
                }
            }
        }
    }

    public void initPanel(PanelKeyListener panelKeyListener, URL uRL, String string, int n, int n2, List<SearchHighlighter.HighLight> list) {
        this.parent = panelKeyListener;
        this.medicine = string;
        this.orgImage = null;
        this.cursorToSet = n;
        this.lengthToSet = n2;
        this.highLights = list;
        if (uRL == null || this.showedUrl == null || !uRL.sameFile(this.showedUrl)) {
            this.showedUrl = uRL;
            if (this.showedUrl == null) {
                Log.write(5, this.getClass().getName(), "url is null");
            } else {
                this.addResetUrlHistory(uRL, true);
                try {
                    String string2 = uRL.getFile();
                    if (string2.endsWith(".pdf")) {
                        this.makeNewPanel(false);
                        Log.write(5, this.getClass().getName(), "Load PDF: " + String.valueOf(this.showedUrl));
                        this.pdfController.openDocument(string2);
                    } else {
                        if (this.port == null || !(this.port.getView() instanceof FsetJEditorPane)) {
                            this.makeNewPanel(true);
                        }
                        Log.write(5, this.getClass().getName(), "Load HTML: " + String.valueOf(this.showedUrl));
                        this.htmlPanel.setFsetPage(this.showedUrl);
                    }
                    this.makeNewPanelAfterLoading();
                }
                catch (Exception exception) {
                    Log.write(5, this.getClass().getName(), "Not Loaded: " + String.valueOf(this.showedUrl), exception);
                }
            }
        } else {
            this.setCursorToSet(false);
            this.htmlPanel.requestFocus();
        }
    }

    public void refresh() {
        if (this.htmlPanel != null && this.showedUrl != null) {
            this.htmlPanel.setFsetPage(this.showedUrl);
        }
    }

    public void setAndActivateMark(int n, int n2) {
        this.cursorToSet = n;
        this.lengthToSet = n2;
        SwingUtilities.invokeLater(() -> {
            this.setCursorToSet(false);
            this.htmlPanel.requestFocus();
        });
    }

    public void highlight(List<SearchHighlighter.HighLight> list) {
        SearchHighlighter.highlight(this.htmlPanel, list);
    }

    public void removeHighlights() {
        SearchHighlighter.removeHighlights(this.htmlPanel);
    }

    protected void setCursorToSet(boolean bl) {
        if (this.highLights != null) {
            this.highlight(this.highLights);
            this.highLights = null;
        }
        Caret caret = this.htmlPanel.getCaret();
        if (bl) {
            caret.setDot(0);
        } else {
            caret.setDot(this.cursorToSet);
            caret.moveDot(this.cursorToSet + this.lengthToSet);
        }
    }

    public void initWithImage(String string, URL uRL) {
        this.medicine = null;
        this.cursorToSet = 1;
        this.lengthToSet = 0;
        if (uRL != null) {
            this.addResetUrlHistory(uRL, true);
            this.removeHtmlPanel();
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            if (string == null) {
                string = "";
            }
            this.nameLabel = new JLabel(string, 0);
            jPanel.add((Component)this.nameLabel, "North");
            this.orgImage = IconUtil.getBufferedImageExtern(uRL);
            Dimension dimension = this.scrollPane.getSize();
            int n = dimension.height - this.nameLabel.getPreferredSize().height - 3;
            int n2 = dimension.width - 3;
            ImageIcon imageIcon = IconUtil.downsizeImage(this.orgImage, n2, n);
            this.imageLabel = new JLabel(imageIcon);
            jPanel.add((Component)this.imageLabel, "Center");
            this.port.add(jPanel);
            jPanel.addKeyListener(this.mainKeyListener);
        } else {
            this.makeNewPanel(true);
        }
        this.makeNewPanelAfterLoading();
    }

    public void doneResizeLayout() {
        if (this.orgImage != null && this.imageLabel != null) {
            Dimension dimension = this.scrollPane.getSize();
            int n = dimension.height - this.nameLabel.getPreferredSize().height - 3;
            int n2 = dimension.width - 3;
            ImageIcon imageIcon = IconUtil.downsizeImage(this.orgImage, n2, n);
            this.imageLabel.setIcon(imageIcon);
        }
    }

    protected String initWithText(String[] stringArray) {
        String string = "";
        this.medicine = null;
        this.orgImage = null;
        this.cursorToSet = 1;
        this.lengthToSet = 0;
        if (stringArray != null) {
            this.addResetUrlHistory(stringArray, true);
            this.makeNewPanel(true);
            string = RubricUtil.getHtmlText(stringArray);
            this.htmlPanel.setText(string);
            this.setCursorToSet(true);
        } else {
            this.makeNewPanel(true);
        }
        this.makeNewPanelAfterLoading();
        return string;
    }

    public void initPanelHtm(PanelKeyListener panelKeyListener, String string) {
        this.parent = panelKeyListener;
        this.medicine = null;
        this.orgImage = null;
        this.cursorToSet = 1;
        this.lengthToSet = 0;
        try {
            this.addResetUrlHistory(null, true);
            this.makeNewPanel(true);
            this.htmlPanel.setText(string);
            this.setCursorToSet(true);
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "initPanel", exception);
        }
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            this.parent.mainKeyPressed(keyEvent);
        }
    }

    @Override
    public void requestFocus() {
        if (this.htmlPanel != null) {
            this.htmlPanel.requestFocus();
        } else if (this.scrollPane != null) {
            this.scrollPane.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void doPgUp() {
        SwingUtilities.invokeLater(() -> {
            KeyEvent keyEvent = new KeyEvent(this.port.getView(), 401, System.currentTimeMillis(), 0, 33, '\uffff');
            this.port.getView().dispatchEvent(keyEvent);
            this.port.getView().requestFocus();
        });
    }

    public void doPgDown() {
        SwingUtilities.invokeLater(() -> {
            KeyEvent keyEvent = new KeyEvent(this.port.getView(), 401, System.currentTimeMillis(), 0, 34, '\uffff');
            this.port.getView().dispatchEvent(keyEvent);
            this.port.getView().requestFocus();
        });
    }

    public String getActMedicine() {
        return this.medicine;
    }

    public void doPgEnd(boolean bl) {
        SwingUtilities.invokeLater(() -> {
            KeyEvent keyEvent = new KeyEvent(this.port.getView(), 401, System.currentTimeMillis(), 128, 35, '\uffff');
            this.port.getView().dispatchEvent(keyEvent);
            if (bl) {
                this.port.getView().requestFocus();
            }
        });
    }

    public void historyBackAction() {
        if (this.urlHistory != null && this.urlHistory.size() > 1) {
            Object object = this.urlHistory.get(this.urlHistory.size() - 2);
            this.urlHistory.remove(this.urlHistory.size() - 1);
            if (object instanceof URL) {
                URL uRL = (URL)object;
                Log.write(5, this.getClass().getName(), "historyBack to url: " + String.valueOf(uRL));
                this.showedUrl = uRL;
                String string = uRL.getFile();
                if (string.endsWith(".pdf")) {
                    this.makeNewPanel(false);
                    this.pdfController.openDocument(string);
                } else {
                    this.makeNewPanel(true);
                    this.htmlPanel.setFsetPage(this.showedUrl);
                }
                this.makeNewPanelAfterLoading();
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                this.showedUrl = null;
                Log.write(5, this.getClass().getName(), "historyBack to virtual page ");
                this.makeNewPanel(true);
                String string = RubricUtil.getHtmlText(stringArray);
                this.htmlPanel.setText(string);
                this.setCursorToSet(true);
                this.makeNewPanelAfterLoading();
            } else if (object instanceof Rubric) {
                String[] stringArray = RubricShowUtil.makeRubricHtml((Rubric)object, null);
                this.showedUrl = null;
                Log.write(5, this.getClass().getName(), "historyBack to virtual rubric ");
                this.makeNewPanel(true);
                String string = RubricUtil.getHtmlText(stringArray);
                this.htmlPanel.setText(string);
                this.setCursorToSet(true);
                this.makeNewPanelAfterLoading();
            }
            if (this.parent != null) {
                this.parent.historyChanged(object, this.urlHistory.size());
            }
        }
    }

    public boolean hasHistory() {
        return this.urlHistory != null && this.urlHistory.size() > 1;
    }

    protected void addResetUrlHistory(Object object, boolean bl) {
        if (bl) {
            this.urlHistory = new ArrayList();
            Log.write(5, this.getClass().getName(), "resetHistory ");
        }
        if (object != null) {
            this.urlHistory.add(object);
            if (object instanceof URL) {
                Log.write(5, this.getClass().getName(), "addHistory: " + ((URL)object).getFile());
            } else if (object instanceof String[]) {
                Log.write(5, this.getClass().getName(), "addHistory: " + ((String[])object)[0]);
            } else if (object instanceof Rubric) {
                Log.write(5, this.getClass().getName(), "addHistory: " + ((Rubric)object).getRubricKeyWithChangedExtension());
            } else {
                Log.write(5, this.getClass().getName(), "addHistory: " + String.valueOf(object));
            }
        }
        if (this.parent != null) {
            this.parent.historyChanged(object, this.urlHistory.size());
        }
    }
}

