/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.repui;

import ch.steph.apputil.MdiModalFrame;
import ch.steph.apputil.ScreenUtil;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.rep.PanelKeyListener;
import ch.steph.rep.Rep;
import ch.steph.repmodel.SortedListModel;
import ch.steph.repmodel.SortedShowEntryModel;
import ch.steph.repui.RepMainFrame;
import ch.steph.reputil.FontUtil;
import ch.steph.reputil.PatientUtil;
import ch.steph.reputil.WebJRepUtil;
import ch.steph.util.Log;
import ch.steph.util.ShowListEntry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class WebBox
extends MdiModalFrame
implements PanelKeyListener {
    private static final long serialVersionUID = 1L;
    JButton[] patRootButton;
    private SortedListModel patListModel;
    private JList<String> patList;
    private JSplitPane patSplitPane;
    private JSplitPane caseSplitPane;
    private JSplitPane webSplitPane;
    private SortedShowEntryModel caseListModel;
    private JList<ShowListEntry> caseList;
    private SortedListModel webPatListModel;
    private JList<String> webPatList;
    private SortedListModel webCaseListModel;
    private JList<String> webCaseList;
    private JButton patNewButton;
    private JButton patDelButton;
    private JButton caseWorkButton;
    private JButton caseDelButton;
    private JButton caseCopyButton;
    private JButton reconnectButton;
    private JButton webPatCopyButton;
    private JButton webPatDelButton;
    private JButton webCaseDelButton;
    private JButton webCaseCopyButton;
    private JTextField username;
    private JPasswordField password;
    private JTextField webStatus;
    private Component boxParent;
    private static final String addonText = "Synchronisation mit jRepWeb - ";

    public WebBox() {
        super(StringResource.getString("menu_file_web"));
        Object object;
        JComponent jComponent;
        Object object2;
        User.instance().setProperty("cWebBox", User.instance().getProperty("cWebBox", 0) + 1);
        this.boxParent = this;
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                WebBox.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        Rectangle rectangle = ScreenUtil.getPatientWindowSize();
        this.setBounds(rectangle);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        int n = PatientUtil.countPatDir();
        if (n > 1) {
            object2 = PatientUtil.getPatRoot();
            jComponent = new JPanel(new GridLayout(n, 1));
            object = PatientUtil.getPatButtons(true);
            this.patRootButton = new JButton[n];
            int n2 = 0;
            for (int i = 0; i < 4; ++i) {
                if (object[i] == null || object[i].length() <= 0) continue;
                this.patRootButton[n2] = new JButton(object[i]);
                this.patRootButton[n2].addKeyListener(keyListener);
                if (!((String)object2).equals(PatientUtil.getPatDir(object[i]))) {
                    this.patRootButton[n2].setFont(FontUtil.getChangedFont());
                } else {
                    this.patRootButton[n2].setFont(FontUtil.getBoldChangedFont());
                }
                this.patRootButton[n2].addActionListener(this::patButtonAction);
                jComponent.add(this.patRootButton[n2]);
                ++n2;
            }
            jPanel.add((Component)jComponent, "North");
        }
        object2 = new JPanel(new GridLayout(2, 1));
        this.patNewButton = new JButton(StringResource.getString("pat_button_new_pat"));
        this.patNewButton.addKeyListener(keyListener);
        this.patNewButton.addActionListener(actionEvent -> {
            String string = JOptionPane.showInternalInputDialog(this.getContentPane(), StringResource.getString("pat_button_new_pat"));
            this.addNewPatient(string);
        });
        this.patNewButton.setMargin(new Insets(3, 0, 3, 0));
        ((Container)object2).add(this.patNewButton);
        this.patDelButton = new JButton(StringResource.getString("pat_menu_pat_delete"));
        this.patDelButton.addKeyListener(keyListener);
        this.patDelButton.addActionListener(actionEvent -> {
            if (0 == JOptionPane.showConfirmDialog(null, StringResource.getString("pat_patdelconfirm1") + PatientUtil.getPatientName() + StringResource.getString("pat_patdelconfirm2"), StringResource.getString("pat_menu_pat_delete"), 0)) {
                this.deleteActPatient();
            }
        });
        this.patDelButton.setMargin(new Insets(3, 0, 3, 0));
        ((Container)object2).add(this.patDelButton);
        jPanel.add((Component)object2, "South");
        jComponent = new JScrollPane();
        this.patListModel = new SortedListModel(PatientUtil.getActualizedPatList(), false);
        this.patList = new JList<String>(this.patListModel);
        this.patList.setSelectedIndex(this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
        this.patList.addKeyListener(keyListener);
        ((JScrollPane)jComponent).getViewport().add(this.patList);
        jPanel.add((Component)jComponent, "Center");
        object = new JPanel(new BorderLayout());
        this.patSplitPane = new JSplitPane(1, jPanel, (Component)object);
        this.patSplitPane.setContinuousLayout(true);
        this.getContentPane().add(this.patSplitPane);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        object2 = new JPanel(new GridLayout(3, 1));
        this.caseCopyButton = new JButton(StringResource.getString("web_button_copy_case"));
        this.caseCopyButton.setEnabled(false);
        this.caseCopyButton.addKeyListener(keyListener);
        this.caseCopyButton.addActionListener(actionEvent -> this.copyCaseToWeb());
        this.caseCopyButton.setMargin(new Insets(3, 0, 3, 0));
        ((Container)object2).add(this.caseCopyButton);
        this.caseWorkButton = new JButton(StringResource.getString("pat_menu_case_edit"));
        this.caseWorkButton.setEnabled(false);
        this.caseWorkButton.addKeyListener(keyListener);
        this.caseWorkButton.addActionListener(actionEvent -> this.selectCase());
        this.caseWorkButton.setMargin(new Insets(3, 0, 3, 0));
        ((Container)object2).add(this.caseWorkButton);
        this.caseDelButton = new JButton(StringResource.getString("pat_menu_case_delete"));
        this.caseDelButton.setEnabled(false);
        this.caseDelButton.addKeyListener(keyListener);
        this.caseDelButton.addActionListener(actionEvent -> {
            ShowListEntry showListEntry = this.caseListModel.getElementAt(this.caseList.getSelectedIndex());
            if (0 == JOptionPane.showConfirmDialog(null, StringResource.getString("pat_patdelconfirm1") + showListEntry.getShowname() + StringResource.getString("pat_patdelconfirm2"), StringResource.getString("pat_menu_case_delete"), 0)) {
                this.deleteCase();
            }
        });
        this.caseDelButton.setMargin(new Insets(3, 0, 3, 0));
        ((Container)object2).add(this.caseDelButton);
        jPanel2.add((Component)object2, "South");
        JScrollPane jScrollPane = new JScrollPane();
        this.caseListModel = new SortedShowEntryModel(PatientUtil.getActualizedCaseList(false), true);
        this.caseList = new JList<ShowListEntry>(this.caseListModel);
        this.caseList.addKeyListener(keyListener);
        jScrollPane.getViewport().add(this.caseList);
        jPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.caseSplitPane = new JSplitPane(1, jPanel2, jPanel3);
        this.caseSplitPane.setContinuousLayout(true);
        ((Container)object).add(this.caseSplitPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        object2 = new JPanel(new GridLayout(2, 1));
        this.reconnectButton = new JButton(StringResource.getString("web_button_reconnect"));
        this.reconnectButton.addKeyListener(keyListener);
        this.reconnectButton.addActionListener(actionEvent -> this.webConnectButtonAction());
        this.reconnectButton.setMargin(new Insets(3, 0, 3, 0));
        ((Container)object2).add(this.reconnectButton);
        this.webPatDelButton = new JButton(StringResource.getString("pat_menu_pat_delete"));
        this.webPatDelButton.addKeyListener(keyListener);
        this.webPatDelButton.addActionListener(actionEvent -> {
            if (0 == JOptionPane.showConfirmDialog(null, StringResource.getString("pat_patdelconfirm1") + PatientUtil.getPatientName() + StringResource.getString("pat_patdelconfirm2"), StringResource.getString("pat_menu_pat_delete"), 0)) {
                this.deleteWebPatient();
            }
        });
        this.webPatDelButton.setMargin(new Insets(3, 0, 3, 0));
        ((Container)object2).add(this.webPatDelButton);
        jPanel4.add((Component)object2, "South");
        JScrollPane jScrollPane2 = new JScrollPane();
        this.webPatListModel = new SortedListModel(new Vector<String>(), false);
        this.webPatList = new JList<String>(this.webPatListModel);
        this.webPatList.addKeyListener(keyListener);
        jScrollPane2.getViewport().add(this.webPatList);
        jPanel4.add((Component)jScrollPane2, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.webSplitPane = new JSplitPane(1, jPanel4, jPanel5);
        this.webSplitPane.setContinuousLayout(true);
        jPanel3.add(this.webSplitPane);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        object2 = new JPanel(new GridLayout(3, 1));
        this.webCaseCopyButton = new JButton(StringResource.getString("web_button_copy_case"));
        this.webCaseCopyButton.addKeyListener(keyListener);
        this.webCaseCopyButton.addActionListener(actionEvent -> this.copyWebCase());
        this.webCaseCopyButton.setMargin(new Insets(3, 0, 3, 0));
        this.webCaseCopyButton.setEnabled(false);
        ((Container)object2).add(this.webCaseCopyButton);
        this.webPatCopyButton = new JButton(StringResource.getString("web_button_copy_pat"));
        this.webPatCopyButton.addKeyListener(keyListener);
        this.webPatCopyButton.addActionListener(actionEvent -> this.copyWebPatient());
        this.webPatCopyButton.setMargin(new Insets(3, 0, 3, 0));
        this.webPatCopyButton.setEnabled(false);
        ((Container)object2).add(this.webPatCopyButton);
        this.webCaseDelButton = new JButton(StringResource.getString("pat_menu_case_delete"));
        this.webCaseDelButton.addKeyListener(keyListener);
        this.webCaseDelButton.addActionListener(actionEvent -> {
            String string = this.webCaseListModel.getElementAt(this.webCaseList.getSelectedIndex());
            if (0 == JOptionPane.showConfirmDialog(null, StringResource.getString("pat_patdelconfirm1") + string + StringResource.getString("pat_patdelconfirm2"), StringResource.getString("pat_menu_case_delete"), 0)) {
                this.deleteWebCase();
            }
        });
        this.webCaseDelButton.setMargin(new Insets(3, 0, 3, 0));
        this.webCaseDelButton.setEnabled(false);
        ((Container)object2).add(this.webCaseDelButton);
        jPanel6.add((Component)object2, "South");
        JScrollPane jScrollPane3 = new JScrollPane();
        this.webCaseListModel = new SortedListModel(new Vector<String>(), true);
        this.webCaseList = new JList<String>(this.webCaseListModel);
        this.webCaseList.addKeyListener(keyListener);
        jScrollPane3.getViewport().add(this.webCaseList);
        jPanel6.add((Component)jScrollPane3, "Center");
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel(new GridLayout(6, 1));
        JLabel jLabel = new JLabel("Username");
        jPanel7.add(jLabel);
        this.username = new JTextField(24);
        if (User.instance().isSuperUser()) {
            this.username.setText(User.instance().getProperty("WebUser", User.instance().getUserName()));
        } else {
            this.username.setText(User.instance().getUserName());
            this.username.setEditable(false);
        }
        jPanel7.add(this.username);
        jLabel = new JLabel("Password");
        jPanel7.add(jLabel);
        this.password = new JPasswordField(24);
        this.password.setText(User.instance().getProperty("WebPassword", ""));
        jPanel7.add(this.password);
        jLabel = new JLabel("jRepWeb Status");
        jPanel7.add(jLabel);
        this.webStatus = new JTextField(24);
        this.webStatus.setEditable(false);
        jPanel7.add(this.webStatus);
        jPanel4.add((Component)jPanel7, "North");
        this.patList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.patSelectionChanged();
            }
        });
        this.patList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    WebBox.this.selectPatient();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = WebBox.this.patList.locationToIndex(mouseEvent.getPoint());
                WebBox.this.patList.setSelectedIndex(n);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.caseList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.caseSelectionChanged();
            }
        });
        this.caseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    WebBox.this.selectCase();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = WebBox.this.caseList.locationToIndex(mouseEvent.getPoint());
                WebBox.this.caseList.setSelectedIndex(n);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.webPatList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.webPatSelectionChanged();
            }
        });
        this.webPatList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    WebBox.this.selectWebPatient();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = WebBox.this.webPatList.locationToIndex(mouseEvent.getPoint());
                WebBox.this.webPatList.setSelectedIndex(n);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.webCaseList.addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.webCaseSelectionChanged();
            }
        });
        this.webCaseList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseClicked: " + mouseEvent.paramString());
                if (mouseEvent.getClickCount() >= 2) {
                    WebBox.this.selectWebCase();
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mousePressed: " + mouseEvent.paramString());
                int n = WebBox.this.webCaseList.locationToIndex(mouseEvent.getPoint());
                WebBox.this.webCaseList.setSelectedIndex(n);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                Log.write(5, this.getClass().getName(), "mouseReleased: " + mouseEvent.paramString());
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.setTitleText();
        try {
            int n3 = User.instance().getProperty("WebPatDivider", 0);
            if (n3 == 0) {
                this.patSplitPane.setDividerLocation(0.25);
            } else {
                this.patSplitPane.setDividerLocation(n3);
            }
            n3 = User.instance().getProperty("WebCaseDivider", 0);
            if (n3 == 0) {
                this.caseSplitPane.setDividerLocation(0.33);
            } else {
                this.caseSplitPane.setDividerLocation(n3);
            }
            n3 = User.instance().getProperty("WebWebDivider", 0);
            if (n3 == 0) {
                this.webSplitPane.setDividerLocation(0.5);
            } else {
                this.webSplitPane.setDividerLocation(n3);
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "setMenuEnables ", exception);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    WebBox.this.patList.setSelectedIndex(WebBox.this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
                    WebBox.this.patSelectionChanged();
                }
                catch (Exception exception) {
                    Log.write(3, this.getClass().getName(), "select starting ", exception);
                }
            }
        });
        this.webConnectButtonAction();
    }

    @Override
    public void requestFocus() {
        if (this.patList != null) {
            this.patList.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void setTitleText() {
        SwingUtilities.invokeLater(() -> {
            String string = PatientUtil.getPatientName();
            if (string != null) {
                this.setTitle(addonText + StringResource.getString("pat_title") + " : " + string);
            } else {
                this.setTitle(addonText + StringResource.getString("pat_title"));
            }
        });
    }

    @Override
    public void closeAction() {
        User.instance().setProperty("WebPatDivider", this.patSplitPane.getDividerLocation());
        User.instance().setProperty("WebCaseDivider", this.caseSplitPane.getDividerLocation());
        User.instance().setProperty("WebWebDivider", this.webSplitPane.getDividerLocation());
        super.closeAction();
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c = keyEvent.getKeyChar();
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown())) {
                if (c == '\n') {
                    keyEvent.consume();
                    if (this.patList.hasFocus()) {
                        this.selectPatient();
                    } else if (this.caseList.hasFocus()) {
                        this.selectCase();
                    }
                } else if (c == '\u001b') {
                    keyEvent.consume();
                    this.closeAction();
                } else if (keyEvent.getKeyCode() == 112) {
                    keyEvent.consume();
                    RepMainFrame.getRepInstance().helpContextAction("Patienten-Liste");
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    protected void patSelectionChanged() {
        int n = this.patList.getSelectedIndex();
        if (n >= 0) {
            PatientUtil.setSelectedPatient(this.patListModel.getElementAt(n));
            this.setTitleText();
            this.caseList.clearSelection();
            this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(false));
        } else {
            this.caseList.clearSelection();
            this.caseListModel.setNewList(new Vector<ShowListEntry>());
        }
    }

    protected void selectPatient() {
        this.patSelectionChanged();
        int n = this.patList.getSelectedIndex();
        if (n >= 0) {
            this.caseList.setSelectedIndex(0);
            this.caseList.requestFocus();
        }
    }

    protected void addNewPatient(String string) {
        if ((string = PatientUtil.addPatient(string)) != null && string.length() > 0) {
            Log.write(3, this.getClass().getName(), "addNewPatient " + string);
            this.patList.clearSelection();
            this.patListModel.setNewList(PatientUtil.getActualizedPatList());
            PatientUtil.setSelectedPatient(string);
            this.patList.setSelectedIndex(this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
            this.setTitleText();
            this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(false));
            this.caseList.setSelectedIndex(0);
            this.caseList.requestFocus();
        }
        this.updatePatButtonText();
    }

    protected void deleteActPatient() {
        int n = this.patList.getSelectedIndex();
        if (n >= 0) {
            Log.write(3, this.getClass().getName(), "deleteActPatient" + n);
            this.patList.clearSelection();
            PatientUtil.deleteActPatient();
            this.patListModel.setNewList(PatientUtil.getActualizedPatList());
            if (n < this.patListModel.getSize()) {
                PatientUtil.setSelectedPatient(this.patListModel.getElementAt(n));
            } else {
                PatientUtil.setSelectedPatient(this.patListModel.getElementAt(0));
            }
            this.updatePatButtonText();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebBox.this.patList.setSelectedIndex(WebBox.this.patListModel.getSelectedIndex(PatientUtil.getPatientName()));
                        WebBox.this.patSelectionChanged();
                        WebBox.this.patList.requestFocus();
                    }
                    catch (Exception exception) {
                        Log.write(3, this.getClass().getName(), "setMenuEnables ", exception);
                    }
                }
            });
        }
    }

    protected void selectCase() {
        int n = this.caseList.getSelectedIndex();
        if (n >= 0) {
            ShowListEntry showListEntry = this.caseListModel.getElementAt(n);
            Log.write(3, this.getClass().getName(), "selectCase " + showListEntry.getShowname());
            String string = showListEntry.getUrlString();
            RepMainFrame.getRepInstance().newCaseAction();
            RepMainFrame.getRepInstance().loadFileAction(string);
            this.closeAction();
        }
    }

    protected void deleteCase() {
        int n = this.caseList.getSelectedIndex();
        if (n >= 0) {
            ShowListEntry showListEntry = this.caseListModel.getElementAt(n);
            Log.write(3, this.getClass().getName(), "deleteCase " + showListEntry.getShowname());
            PatientUtil.deleteCase(showListEntry);
            this.caseListModel.setNewList(PatientUtil.getActualizedCaseList(false));
            if (n >= this.caseListModel.getSize() && this.caseListModel.getSize() > 0) {
                n = this.caseListModel.getSize() - 1;
            }
            this.caseList.setSelectedIndex(0);
            this.caseList.requestFocus();
        }
    }

    public void caseSelectionChanged() {
        this.checkCopyButtons();
    }

    protected void patButtonAction(ActionEvent actionEvent) {
        try {
            JButton jButton = (JButton)actionEvent.getSource();
            PatientUtil.activatePatDir(jButton.getText());
            for (JButton jButton2 : this.patRootButton) {
                if (jButton.equals(jButton2)) {
                    jButton2.setFont(FontUtil.getBoldChangedFont());
                    Log.write(4, this.getClass().getName(), "change to: " + jButton2.getText());
                    continue;
                }
                jButton2.setFont(FontUtil.getChangedFont());
            }
            this.patList.clearSelection();
            this.patListModel.setNewList(PatientUtil.getActualizedPatList());
            this.patList.requestFocus();
            this.patList.setSelectedIndex(0);
            this.patSelectionChanged();
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "patButtonAction", exception);
        }
    }

    private void webPatSelectionChanged() {
        int n = this.webPatList.getSelectedIndex();
        if (n >= 0) {
            this.webCaseList.clearSelection();
            this.webCaseListModel.setNewList(new Vector<String>());
            User.instance().setProperty("WebPatient", this.webPatListModel.getElementAt(n));
            String[] stringArray = WebJRepUtil.getInstance().webGetCaseList(this.webPatListModel.getElementAt(n));
            if (stringArray != null) {
                Vector<String> vector = new Vector<String>();
                Collections.addAll(vector, stringArray);
                this.webCaseListModel.setNewList(vector, true);
            }
        } else {
            this.webCaseList.clearSelection();
            this.webCaseListModel.setNewList(new Vector<String>());
        }
        this.checkCopyButtons();
    }

    private void selectWebPatient() {
        this.webPatSelectionChanged();
        int n = this.webPatList.getSelectedIndex();
        if (n >= 0) {
            this.webCaseList.setSelectedIndex(0);
            this.webCaseList.requestFocus();
        }
    }

    private void webCaseSelectionChanged() {
        this.checkCopyButtons();
    }

    private void selectWebCase() {
        this.webCaseSelectionChanged();
        this.checkCopyButtons();
    }

    protected void webConnectButtonAction() {
        try {
            try {
                if (User.instance().isSuperUser()) {
                    User.instance().setProperty("WebUser", this.username.getText());
                }
                String string = new String(this.password.getPassword());
                User.instance().setProperty("WebPassword", string);
                this.webPatList.clearSelection();
                this.webCaseList.clearSelection();
                this.webPatListModel.setNewList(new Vector<String>());
                this.webCaseListModel.setNewList(new Vector<String>());
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "patButtonAction", exception);
            }
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "webAction ", exception);
        }
        Rep.getExecutor().execute(() -> {
            WebJRepUtil webJRepUtil = WebJRepUtil.getNewInstance();
            if (webJRepUtil.webCheckPassword(this.username.getText(), User.instance().getProperty("WebPassword", ""), this.boxParent, this.webStatus)) {
                String[] stringArray = webJRepUtil.webGetPatList();
                String string = User.instance().getProperty("WebPatient", "");
                int n = 0;
                if (stringArray != null) {
                    Vector<String> vector = new Vector<String>();
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.add(stringArray[i]);
                        if (!stringArray[i].equals(string)) continue;
                        n = i;
                    }
                    this.webPatListModel.setNewList(vector);
                    this.webPatList.setSelectedIndex(n);
                    this.webPatSelectionChanged();
                }
            }
        });
    }

    protected void copyCaseToWeb() {
        Rep.getExecutor().execute(() -> {
            String string = this.webPatListModel.getElementAt(this.webPatList.getSelectedIndex());
            ShowListEntry showListEntry = this.caseListModel.getElementAt(this.caseList.getSelectedIndex());
            Log.write(4, this.getClass().getName(), "copyCase " + string + " " + showListEntry.getShowname());
            String string2 = PatientUtil.getSimpleCaseFileNameFromList(showListEntry);
            if (string2 != null) {
                WebJRepUtil.getInstance().putCsvFile(string, showListEntry.getShowname());
                WebJRepUtil.getInstance().reloadCaseList(string);
                this.webPatSelectionChanged();
            }
        });
    }

    protected void deleteWebPatient() {
        Rep.getExecutor().execute(() -> {
            String string = this.webPatListModel.getElementAt(this.webPatList.getSelectedIndex());
            WebJRepUtil.getInstance().deleteWebPat(string);
            this.webConnectButtonAction();
        });
    }

    protected void deleteWebCase() {
        Rep.getExecutor().execute(() -> {
            String string = this.webPatListModel.getElementAt(this.webPatList.getSelectedIndex());
            String string2 = this.webCaseListModel.getElementAt(this.webCaseList.getSelectedIndex());
            WebJRepUtil.getInstance().deleteWebCase(string, string2);
            WebJRepUtil.getInstance().reloadCaseList(string);
            this.webPatSelectionChanged();
        });
    }

    protected void copyWebCase() {
        Rep.getExecutor().execute(() -> {
            String string = this.webPatListModel.getElementAt(this.webPatList.getSelectedIndex());
            String string2 = this.webCaseListModel.getElementAt(this.webCaseList.getSelectedIndex());
            WebJRepUtil.getInstance().webGetRepFile(string, string2);
            SwingUtilities.invokeLater(this::patSelectionChanged);
        });
    }

    protected void copyWebPatient() {
        Rep.getExecutor().execute(() -> {
            String string = this.webPatListModel.getElementAt(this.webPatList.getSelectedIndex());
            for (int i = 0; i < this.webCaseListModel.getSize(); ++i) {
                String string2 = this.webCaseListModel.getElementAt(i);
                WebJRepUtil.getInstance().webGetRepFile(string, string2);
            }
            SwingUtilities.invokeLater(this::patSelectionChanged);
        });
    }

    private void checkCopyButtons() {
        if (this.patList.getSelectedIndex() >= 0 && this.webPatList.getSelectedIndex() >= 0) {
            this.webPatCopyButton.setEnabled(true);
            if (this.caseList.getSelectedIndex() >= 0) {
                this.caseCopyButton.setEnabled(true);
            } else {
                this.caseCopyButton.setEnabled(false);
            }
            if (this.webCaseList.getSelectedIndex() >= 0) {
                this.webCaseCopyButton.setEnabled(true);
            } else {
                this.webCaseCopyButton.setEnabled(false);
            }
        } else {
            this.webPatCopyButton.setEnabled(false);
            this.caseCopyButton.setEnabled(false);
            this.webCaseCopyButton.setEnabled(false);
        }
        if (this.caseList.getSelectedIndex() >= 0) {
            this.caseWorkButton.setEnabled(true);
            this.caseDelButton.setEnabled(true);
        } else {
            this.caseWorkButton.setEnabled(false);
            this.caseDelButton.setEnabled(false);
        }
        if (this.webCaseList.getSelectedIndex() >= 0) {
            this.webCaseDelButton.setEnabled(true);
        } else {
            this.webCaseDelButton.setEnabled(false);
        }
    }

    private void updatePatButtonText() {
        if (this.patRootButton != null) {
            String[] stringArray = PatientUtil.getPatButtons(true);
            for (int i = 0; i < this.patRootButton.length; ++i) {
                if (this.patRootButton[i] == null) continue;
                this.patRootButton[i].setText(stringArray[i]);
            }
        }
    }

    @Override
    public void historyChanged(Object object, int n) {
    }

    @Override
    public void copyToClipboard() {
    }
}

