/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.apputil.User;
import ch.steph.util.Log;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.UIManager;

public class FontUtil {
    private static Font progFont = null;
    private static Font monoFont = null;
    private static Font changedProgFont = null;
    private static Font changedBoldFont = null;
    private static Font changedMenuFont = null;
    private static int monoCharSizeDiff = 99;
    private static int progCharSizeDiff = 99;

    public static void setProgFont(Font font) {
        if (progFont == null) {
            if (font == null) {
                font = new Font("Dialog", 0, 12);
            }
            progFont = font;
            changedProgFont = font;
            int n = font.getSize();
            monoCharSizeDiff = 0;
            progCharSizeDiff = 0;
            monoFont = new Font("Monospaced", 0, n);
            Log.write(5, "jRep", "progFont : " + String.valueOf(FontUtil.getProgFont()));
            Log.write(5, "jRep", "changedFont: " + String.valueOf(FontUtil.getChangedFont()));
            Log.write(5, "jRep", "monoFont : " + String.valueOf(FontUtil.getMonoFont()));
        }
    }

    public static Font getBoldChangedFont() {
        return changedBoldFont;
    }

    public static void setMonoFontDiff(int n, int n2) {
        int n3;
        if (n > 8) {
            n = 8;
        }
        if (monoCharSizeDiff != n && progFont != null) {
            monoCharSizeDiff = n;
            n3 = progFont.getSize();
            monoFont = new Font("Monospaced", 0, n3 - monoCharSizeDiff);
            Log.write(5, "jRep", "set monoFont : " + String.valueOf(FontUtil.getMonoFont()));
        }
        if (User.instance().getProperty("ChangeFont", true)) {
            if (n2 > 8) {
                n2 = 8;
            }
            if (progCharSizeDiff != n2 && progFont != null) {
                progCharSizeDiff = n2;
                n3 = progFont.getSize();
                changedProgFont = new Font(progFont.getName(), 0, n3 - progCharSizeDiff);
                Log.write(5, "jRep", "set changedFont: " + String.valueOf(FontUtil.getChangedFont()));
            }
        }
        if (User.instance().getProperty("ChangeFont", true)) {
            n3 = changedProgFont.getSize();
            changedBoldFont = new Font(changedProgFont.getName(), 1, n3);
            Log.write(5, "jRep", "set menuFont: " + String.valueOf(FontUtil.getChangedFont()));
        } else {
            changedBoldFont = changedProgFont;
        }
        if (User.instance().getProperty("ChangeFont", true)) {
            n3 = changedProgFont.getSize();
            if (n3 < 12) {
                n3 = 12;
            }
            changedMenuFont = new Font(changedProgFont.getName(), 1, n3);
            Log.write(5, "jRep", "set menuFont: " + String.valueOf(FontUtil.getChangedFont()));
        } else {
            changedMenuFont = changedProgFont;
        }
        UIManager.put("CheckBox.font", changedProgFont);
        UIManager.put("ColorChooser.font", changedProgFont);
        UIManager.put("ComboBox.font", changedProgFont);
        UIManager.put("EditorPane.font", changedProgFont);
        UIManager.put("FormattedTextField.font", changedProgFont);
        UIManager.put("Label.font", changedProgFont);
        UIManager.put("OptionPane.font", changedProgFont);
        UIManager.put("OptionPane.messageFont", changedProgFont);
        UIManager.put("Panel.font", changedProgFont);
        UIManager.put("PasswordField.font", changedProgFont);
        UIManager.put("ProgressBar.font", changedProgFont);
        UIManager.put("RadioButton.font", changedProgFont);
        UIManager.put("ScrollPane.font", changedProgFont);
        UIManager.put("Slider.font", changedProgFont);
        UIManager.put("Spinner.font", changedProgFont);
        UIManager.put("TabbedPane.font", changedProgFont);
        UIManager.put("TabbedPane.smallFont", changedProgFont);
        UIManager.put("Table.font", changedProgFont);
        UIManager.put("TextArea.font", changedProgFont);
        UIManager.put("TextField.font", changedProgFont);
        UIManager.put("TextPane.font", changedProgFont);
        UIManager.put("TitledBorder.font", changedProgFont);
        UIManager.put("ToggleButton.font", changedProgFont);
        UIManager.put("ToolBar.font", changedProgFont);
        UIManager.put("ToolTip.font", changedProgFont);
        UIManager.put("Tree.font", changedProgFont);
        UIManager.put("Viewport.font", changedProgFont);
        UIManager.put("List.font", changedMenuFont);
        UIManager.put("Button.font", changedMenuFont);
        UIManager.put("IconButton.font", changedMenuFont);
        UIManager.put("OptionPane.buttonFont", changedMenuFont);
        UIManager.put("InternalFrame.titleFont", changedMenuFont);
        UIManager.put("InternalFrame.optionDialogTitleFont", changedMenuFont);
        UIManager.put("InternalFrame.paletteTitleFont", changedMenuFont);
        UIManager.put("Menu.font", changedMenuFont);
        UIManager.put("PopupMenu.font", changedMenuFont);
        UIManager.put("Menu.acceleratorFont", changedMenuFont);
        UIManager.put("MenuBar.font", changedMenuFont);
        UIManager.put("MenuItem.font", changedMenuFont);
        UIManager.put("MenuItem.acceleratorFont", changedMenuFont);
        UIManager.put("CheckBoxMenuItem.font", changedMenuFont);
        UIManager.put("CheckBoxMenuItem.acceleratorFont", changedMenuFont);
        UIManager.put("RadioButtonMenuItem.font", changedMenuFont);
        UIManager.put("RadioButtonMenuItem.acceleratorFont", changedMenuFont);
        UIManager.put("TableHeader.font", changedMenuFont);
    }

    public static Font getProgFont() {
        return progFont;
    }

    public static Font getChangedFont() {
        return changedProgFont;
    }

    public static Font getMonoFont() {
        return monoFont;
    }

    public static void setAllComponentFonts(Container container) {
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                FontUtil.setAllComponentFonts((Container)component);
            }
            if (component instanceof JMenu) {
                FontUtil.setAllMenuFonts((JMenu)component);
            }
            Font font = changedProgFont;
            if (component instanceof JMenuBar) {
                font = changedMenuFont;
            }
            if (component instanceof JMenuItem) {
                font = changedMenuFont;
            }
            if (component instanceof JButton) {
                font = changedMenuFont;
            }
            try {
                component.setFont(font);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void setAllMenuFonts(JMenu jMenu) {
        Component[] componentArray;
        for (Component component : componentArray = jMenu.getMenuComponents()) {
            if (component instanceof JMenu) {
                FontUtil.setAllMenuFonts((JMenu)component);
            }
            try {
                component.setFont(changedMenuFont);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

