/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.MmMedis;
import ch.steph.reputil.RubricUtil;
import ch.steph.util.Constants;
import ch.steph.util.FileCsv;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.StartEkit;
import ch.steph.util.StrProc;
import ch.steph.util.TimeProbe;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MmUtil {
    private static final String KEY_SEPARATOR = " - ";
    private static String[] mmTitles;
    private static String[] extMmTitles;
    private static String[] mmAddon;
    private static String[] showAllTitle;
    private static String[] showLicensedTitle;
    private static Map<String, MmHeader> showMedis;
    private static ArrayList<String[]> mmLinkFile;

    private MmUtil() {
    }

    public static String getFilenameHelpShow(int n) {
        Object object = n >= 1 && n <= 41 ? Constants.DATA_HELP + n : (n < 62 ? Constants.DATA_HELP + (n - 41) : Constants.APP_HELP);
        return object;
    }

    public static URL getUrlHtmDat(int n, String string) {
        String string2;
        URL uRL = null;
        if (n >= 1 && n <= 41 || n >= 62) {
            String string3;
            if (string.startsWith(Constants.DATA_HELP) && (string3 = GetDataFile.getDataPath()) != null && User.instance().getProperty("externalRubric", true) && (uRL = FileProcedures.nameDirToUrl(string3, "extern-" + string.toLowerCase() + ".htm")) == null) {
                uRL = FileProcedures.nameDirToUrl(string3, "extern-" + string.toLowerCase() + ".txt");
            }
            if (uRL == null) {
                uRL = ClassLoader.getSystemResource("jrepdata/" + string.toLowerCase() + ".jrh");
            }
        } else if (n < 62 && (string2 = GetDataFile.getDataPath()) != null) {
            uRL = FileProcedures.nameDirToUrl(string2, string.toLowerCase() + ".htm");
        }
        if (uRL == null) {
            uRL = MmUtil.getUrlTxtDat(n, string);
        }
        return uRL;
    }

    public static URL getUrlTxtDat(int n, String string) {
        String string2;
        URL uRL = null;
        if (n >= 1 && n <= 41 || n >= 62) {
            String string3;
            if (string.startsWith(Constants.DATA_HELP) && (string3 = GetDataFile.getDataPath()) != null && User.instance().getProperty("externalRubric", true)) {
                uRL = FileProcedures.nameDirToUrl(string3, "extern-" + string.toLowerCase() + ".txt");
            }
            if (uRL == null) {
                uRL = ClassLoader.getSystemResource("jrepdata/" + string.toLowerCase() + ".jrt");
            }
        } else if (n < 62 && (string2 = GetDataFile.getDataPath()) != null) {
            uRL = FileProcedures.nameDirToUrl(string2, string.toLowerCase() + ".txt");
        }
        return uRL;
    }

    public static URL getUrlHtmMed(int n, String string, boolean bl) {
        String string2 = string.toLowerCase().trim();
        if (!bl) {
            if (showAllTitle == null) {
                MmUtil.getAllTitles();
            }
            String string3 = showAllTitle[n];
            if (!MmUtil.hasNomedInfo(string2)) {
                return null;
            }
            List<MmData> list = MmUtil.getNomedData(string2);
            if (list != null) {
                for (MmData mmData : list) {
                    if (!string3.equals(mmData.mmTitle)) continue;
                    return mmData.url;
                }
            }
            return null;
        }
        return MmUtil.getUrlHtmMedIntern(n, string2, bl, false);
    }

    private static URL getUrlHtmMedIntern(int n, String string, boolean bl, boolean bl2) {
        URL uRL = null;
        if (string != null && string.length() > 0) {
            String string2;
            string = MmUtil.getFilenameFromMedi(string);
            if (n >= 1 && n <= 41) {
                if (bl && !bl2) {
                    uRL = ClassLoader.getSystemResource("jrmma" + n + "/dyn/" + string + ".jrh");
                }
                if (uRL == null) {
                    uRL = ClassLoader.getSystemResource("jrmma" + n + "/" + string + ".jrh");
                }
                if (uRL == null && !bl2) {
                    uRL = MmUtil.getUrlTxtMed(n, string);
                }
            } else if (n < 62 && (string2 = GetDataFile.getDataPath()) != null && User.instance().getProperty("externalRubric", true)) {
                if (bl && !bl2) {
                    uRL = FileProcedures.nameDirToUrl(string2, "mm" + (n - 41), "dyn", string + ".pdf");
                }
                if (uRL == null) {
                    uRL = FileProcedures.nameDirToUrl(string2, "mm" + (n - 41), string + ".pdf");
                }
                if (uRL == null && bl && !bl2) {
                    uRL = FileProcedures.nameDirToUrl(string2, "mm" + (n - 41), "dyn", string + ".htm");
                }
                if (uRL == null) {
                    uRL = FileProcedures.nameDirToUrl(string2, "mm" + (n - 41), string + ".htm");
                }
                if (uRL == null) {
                    uRL = FileProcedures.nameDirToUrl(string2, "mm" + (n - 41), string + ".rtf");
                }
                if (uRL == null && !bl2) {
                    uRL = MmUtil.getUrlTxtMed(n, string);
                }
            }
        }
        return uRL;
    }

    public static URL getUrlTxtMed(int n, String string) {
        URL uRL = null;
        if (string != null && string.length() > 0) {
            String string2;
            string = MmUtil.getFilenameFromMedi(string);
            if (n >= 1 && n <= 41) {
                uRL = ClassLoader.getSystemResource("jrmma" + n + "/" + string + ".jrt");
            } else if (n < 62 && (string2 = GetDataFile.getDataPath()) != null && User.instance().getProperty("externalRubric", true)) {
                uRL = FileProcedures.nameDirToUrl(string2, "mm" + (n - 41), string + ".txt");
            }
        }
        return uRL;
    }

    private static String[] getMmTitlesWithChar(String[] stringArray) {
        int n = 0;
        for (int i = 1; i < 62; ++i) {
            if (stringArray[i].length() <= 0) continue;
            ++n;
            if (stringArray[i].length() <= 0) continue;
            stringArray[i] = MmUtil.getMmKey(i) + KEY_SEPARATOR + stringArray[i];
        }
        if (n < 1) {
            return null;
        }
        return stringArray;
    }

    public static String[] getExtMMTitles() {
        if (extMmTitles == null) {
            try {
                int n;
                String[] stringArray = new String[19];
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = StringResource.getString("mm_own_title") + " " + (n + 1);
                }
                for (n = 0; n < stringArray.length; ++n) {
                    FileLn fileLn;
                    URL uRL = MmUtil.getUrlTxtMed(n + 41 + 1, "MM-Info".toLowerCase());
                    if (uRL == null || !(fileLn = GetDataFile.getDataFileRd(uRL)).isOpenRead()) continue;
                    stringArray[n] = fileLn.readLn().trim();
                    fileLn.close();
                }
                extMmTitles = stringArray;
            }
            catch (Exception exception) {
                Log.write(2, MmUtil.class.getName(), "getExtMMTitles", exception);
            }
        }
        return extMmTitles;
    }

    private static ArrayList<String[]> getMmLinkFile() {
        if (mmLinkFile.size() == 0) {
            FileCsv fileCsv = new FileCsv();
            String string = "mm-links.csv";
            String string2 = GetDataFile.getDataPath();
            if (string2 != null) {
                fileCsv = GetDataFile.getCsvFileRd(FileProcedures.nameDirToUrl(string2, string));
            }
            if (!fileCsv.isOpenRead()) {
                fileCsv = GetDataFile.getCsvFileRd(FileProcedures.systemResourceToUrl("jrepdata/" + string));
            }
            if (fileCsv.isOpenRead()) {
                String[] stringArray = fileCsv.readCSVLine();
                while (stringArray != null) {
                    if (stringArray.length > 0 && stringArray[0].length() > 0 && stringArray[0].charAt(0) != '#') {
                        mmLinkFile.add(stringArray);
                    }
                    stringArray = fileCsv.readCSVLine();
                }
                fileCsv.close();
            }
        }
        return mmLinkFile;
    }

    private static String getMmKey(int n) {
        for (String[] stringArray : MmUtil.getMmLinkFile()) {
            if (!("" + n).equals(stringArray[1])) continue;
            return stringArray[0];
        }
        return "";
    }

    public static int getMmIndex(char c) {
        String string = ("" + c).toUpperCase();
        for (String[] stringArray : MmUtil.getMmLinkFile()) {
            if (!stringArray[0].equals(string)) continue;
            return Integer.parseInt(stringArray[1]);
        }
        return -1;
    }

    public static void editExtMM(int n, String string) {
        String string2 = MmUtil.getFilenameFromMedi(string);
        String string3 = GetDataFile.getDataPath();
        Object object = "";
        if (string3 != null && User.instance().getProperty("externalRubric", true)) {
            Object object2;
            FileLn fileLn;
            Object object3;
            string3 = FileProcedures.addDirName(string3, "mm" + n);
            String string4 = FileProcedures.addDirName(string3, "MM-Info".toLowerCase() + ".txt");
            FileProcSync.makeDir(string3);
            if (!FileProcedures.exists(string4)) {
                object3 = GetDataFile.getDataDirFileRd("MM-Info".toLowerCase() + ".jrt");
                if (((FileLn)object3).isOpenRead()) {
                    fileLn = GetDataFile.getMmHtmlWr(string4);
                    if (fileLn.isOpenWrite()) {
                        object2 = object = ((FileLn)object3).readLn() + " " + n;
                        while (object2 != null) {
                            fileLn.writeLn((String)object2);
                            object2 = ((FileLn)object3).readLn();
                        }
                        fileLn.close();
                    }
                    ((FileLn)object3).close();
                }
                object3 = GetDataFile.getDataDirFileRd("MM-Info".toLowerCase() + ".jrh");
                fileLn = GetDataFile.getMmHtmlWr(FileProcedures.addDirName(string3, "MM-Info".toLowerCase() + ".htm"));
                MmUtil.copyFileReplaceStrings((FileLn)object3, fileLn, (String)object, string4, null);
                showMedis.remove(string.toLowerCase().trim());
                new StartEkit(string3, "MM-Info".toLowerCase() + ".htm", 20);
            }
            if (!FileProcedures.exists(string3, string2.toLowerCase() + ".htm") && (object3 = RubricUtil.getMedNameForRubric(string)) != null && ((String[])object3).length >= 2) {
                fileLn = GetDataFile.getDataDirFileRd("MM-Template".toLowerCase() + ".jrh");
                object2 = GetDataFile.getMmHtmlWr(FileProcedures.addDirName(string3, string2.toLowerCase() + ".htm"));
                MmUtil.copyFileReplaceStrings(fileLn, (FileLn)object2, (String)object, null, (String[])object3);
                showMedis.remove(string.toLowerCase().trim());
            }
            new StartEkit(string3, string2.toLowerCase() + ".htm", 0);
        }
    }

    private static void copyFileReplaceStrings(FileLn fileLn, FileLn fileLn2, String string, String string2, String[] stringArray) {
        if (fileLn.isOpenRead() && fileLn2.isOpenWrite()) {
            String string3 = fileLn.readLn();
            while (string3 != null) {
                string3 = StrProc.replaceAll(string3, "{MM}", string);
                string3 = StrProc.replaceAll(string3, "{DATE}", new SimpleDateFormat("dd.MM.yyyy HH:mm").format(new Date()));
                string3 = StrProc.replaceAll(string3, "{USER}", User.instance().getUserName());
                string3 = StrProc.replaceAll(string3, "{FILE}", string2);
                if (stringArray != null) {
                    if (stringArray.length >= 1 && stringArray[0] != null) {
                        string3 = StrProc.replaceAll(string3, "{MED0}", stringArray[0]);
                    }
                    if (stringArray.length >= 2 && stringArray[1] != null) {
                        string3 = StrProc.replaceAll(string3, "{MED1}", stringArray[1]);
                    }
                    if (stringArray.length >= 3 && stringArray[2] != null) {
                        string3 = StrProc.replaceAll(string3, "{MED2}", stringArray[2]);
                    }
                    if (stringArray.length >= 4 && stringArray[3] != null) {
                        string3 = StrProc.replaceAll(string3, "{MED3}", stringArray[3]);
                    }
                    if (stringArray.length >= 5 && stringArray[4] != null) {
                        string3 = StrProc.replaceAll(string3, "{MED4}", stringArray[4]);
                    }
                    if (stringArray.length >= 6 && stringArray[5] != null) {
                        string3 = StrProc.replaceAll(string3, "{MED5}", stringArray[5]);
                    }
                }
                string3 = StrProc.replaceAll(string3, "{MED0}", "");
                string3 = StrProc.replaceAll(string3, "{MED1}", "");
                string3 = StrProc.replaceAll(string3, "{MED2}", "");
                string3 = StrProc.replaceAll(string3, "{MED3}", "");
                string3 = StrProc.replaceAll(string3, "{MED4}", "");
                string3 = StrProc.replaceAll(string3, "{MED5}", "");
                fileLn2.writeLn(string3);
                string3 = fileLn.readLn();
            }
        }
        fileLn.close();
        fileLn2.close();
    }

    public static String getFilenameFromMedi(String string) {
        String string2 = string.toLowerCase();
        if ("nul".equals(string2)) {
            string2 = "nul-";
        }
        if ("con".equals(string2)) {
            string2 = "con-";
        }
        return string2;
    }

    public static synchronized String[] getMmTitles() {
        if (mmTitles == null) {
            try {
                String[] stringArray = new String[62];
                for (int i = 0; i < 62; ++i) {
                    FileLn fileLn;
                    stringArray[i] = "";
                    URL uRL = MmUtil.getUrlTxtMed(i, "MM-Info".toLowerCase());
                    if (uRL == null || !(fileLn = GetDataFile.getDataFileRd(uRL)).isOpenRead()) continue;
                    stringArray[i] = fileLn.readLn().trim();
                    fileLn.close();
                }
                mmTitles = MmUtil.getMmTitlesWithChar(stringArray);
            }
            catch (Exception exception) {
                Log.write(2, MmUtil.class.getName(), "getMmTitles", exception);
            }
        }
        return mmTitles;
    }

    public static String[] getMmAddon() {
        if (mmAddon == null) {
            try {
                FileLn fileLn;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = GetDataFile.getDataPath();
                URL uRL = null;
                if (string != null) {
                    uRL = FileProcedures.nameDirToUrl(string, "mmaddon.txt");
                }
                if (uRL == null) {
                    uRL = FileProcedures.systemResourceToUrl("eigene/mmaddon.txt");
                }
                if ((fileLn = GetDataFile.getDataFileRd(uRL)).isOpenRead()) {
                    String string2 = fileLn.readLn();
                    while (string2 != null) {
                        if (string2.length() > 0) {
                            arrayList.add(string2);
                        }
                        string2 = fileLn.readLn();
                    }
                    fileLn.close();
                }
                mmAddon = new String[arrayList.size()];
                arrayList.toArray(mmAddon);
            }
            catch (Exception exception) {
                Log.write(2, MmUtil.class.getName(), "getMmAddon", exception);
            }
        }
        return mmAddon;
    }

    private static void getAllTitles() {
        try {
            if (showAllTitle == null) {
                showAllTitle = MmUtil.prepareTitlesToSave(MmUtil.getMmTitles());
                showLicensedTitle = MmUtil.prepareTitlesToSave(User.instance().getMmTitles());
            }
        }
        catch (Exception exception) {
            Log.write(2, MmUtil.class.getName(), "getData", exception);
        }
    }

    public static synchronized void getAllData() {
        try {
            MmUtil.getAllTitles();
            String[] stringArray = MmMedis.getMediArray();
            TimeProbe timeProbe = new TimeProbe();
            Log.write(4, MmUtil.class.getName(), "Get mm-medi.csv: Searching for " + stringArray.length + " medis in all MM.");
            for (String string : stringArray) {
                String string2 = string.toLowerCase().trim();
                boolean bl = true;
                MmHeader mmHeader = new MmHeader();
                for (int i = 2; i < showAllTitle.length; ++i) {
                    if (showAllTitle[i] == null || showAllTitle[i].length() <= 0 || i == 42 && mmHeader.mmList == null) continue;
                    URL uRL = MmUtil.getUrlHtmMedIntern(i, string2, false, bl);
                    timeProbe.partEnds(10, "checked url");
                    if (uRL != null) {
                        if (bl) {
                            timeProbe.partEnds(15, "checked second url");
                            bl = false;
                            uRL = MmUtil.getUrlHtmMedIntern(i, string2, false, false);
                        }
                        if (mmHeader.mmList == null) {
                            mmHeader.mmList = new ArrayList<MmData>();
                        }
                        MmData mmData = new MmData();
                        mmData.mmTitle = showAllTitle[i];
                        if (showLicensedTitle[i] != null && showLicensedTitle[i].length() > 0) {
                            mmData.url = uRL;
                        }
                        mmHeader.mmList.add(mmData);
                    }
                    timeProbe.partEnds(20, "found");
                }
                showMedis.put(string2, mmHeader);
            }
            MmMedis.refreshMmMediFile(showMedis);
            timeProbe.partEnds(30, "refreshed mm-medi");
            RepMainMenu.enableMmMenus();
            Log.write(4, MmUtil.class.getName(), "Get mm-medi.csv: Found " + showMedis.size() + " medis. " + timeProbe.getLogString());
        }
        catch (Exception exception) {
            Log.write(2, MmUtil.class.getName(), "getData", exception);
        }
    }

    private static String[] prepareTitlesToSave(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
            if (stringArray2[i] == null || stringArray2[i].length() <= 0) continue;
            if (stringArray2[i].contains(KEY_SEPARATOR)) {
                stringArray2[i] = stringArray2[i].substring(stringArray2[i].indexOf(KEY_SEPARATOR) + KEY_SEPARATOR.length()).trim();
            }
            stringArray2[i] = stringArray2[i].replace("  ", " ");
            if (stringArray2[i].charAt(0) != '.') continue;
            stringArray2[i] = stringArray2[i].substring(1);
        }
        return stringArray2;
    }

    public static boolean hasNomedInfo(String string) {
        string = string.toLowerCase().trim();
        if (showAllTitle == null) {
            MmUtil.getAllTitles();
        }
        if (showAllTitle != null) {
            MmHeader mmHeader = showMedis.get(string);
            if (mmHeader != null) {
                return mmHeader.mmList != null;
            }
            mmHeader = new MmHeader();
            for (int i = 1; i < showAllTitle.length; ++i) {
                if (showAllTitle[i].length() <= 0 || MmUtil.getUrlHtmMedIntern(i, string, false, true) == null) continue;
                mmHeader.mmList = new ArrayList<MmData>();
                showMedis.put(string, mmHeader);
                return true;
            }
            showMedis.put(string, mmHeader);
        }
        return false;
    }

    private static List<MmData> getNomedData(String string) {
        MmHeader mmHeader = showMedis.get(string = string.toLowerCase().trim());
        if (mmHeader != null) {
            if (mmHeader.mmList == null) {
                return null;
            }
            if (mmHeader.mmList.size() > 0) {
                return mmHeader.mmList;
            }
        }
        if (showAllTitle != null && MmUtil.hasNomedInfo(string)) {
            mmHeader = showMedis.get(string);
            for (int i = 1; i < showAllTitle.length; ++i) {
                URL uRL;
                if (showAllTitle[i] == null || showAllTitle[i].length() <= 0 || (uRL = MmUtil.getUrlHtmMedIntern(i, string, false, false)) == null) continue;
                MmData mmData = new MmData();
                mmData.mmTitle = showAllTitle[i];
                if (showLicensedTitle[i] != null && showLicensedTitle[i].length() > 0) {
                    mmData.url = uRL;
                }
                mmHeader.mmList.add(mmData);
            }
            return mmHeader.mmList;
        }
        return null;
    }

    public static String getNoMedHTML(String string, boolean bl) {
        if (showAllTitle == null) {
            MmUtil.getAllTitles();
        }
        StringBuilder stringBuilder = new StringBuilder("<table border=0><tr><td>");
        int n = User.instance().getProperty("fontDeltaNormal2", 3);
        if (n >= 16) {
            stringBuilder.append("<font face=Arial size=7>\n");
        } else if (n >= 12) {
            stringBuilder.append("<font face=Arial size=6>\n");
        } else if (n >= 8) {
            stringBuilder.append("<font face=Arial size=5>\n");
        } else if (n >= 4) {
            stringBuilder.append("<font face=Arial size=4>\n");
        } else {
            stringBuilder.append("<font face=Arial size=3>\n");
        }
        String[] stringArray = RubricUtil.getMedNameForRubric(string);
        if (stringArray != null && stringArray.length > 1) {
            stringBuilder.append("<b>").append(stringArray[0]).append("</b>").append("<br>").append("<b>").append(stringArray[1]).append("</b>");
        }
        if (stringArray != null && stringArray.length > 2) {
            stringBuilder.append("<br>").append(stringArray[2]);
        }
        if (stringArray != null && stringArray.length > 3 && stringArray[3] != null) {
            stringBuilder.append("<br>").append(stringArray[3]);
        }
        if (stringArray != null && stringArray.length > 4 && stringArray[4] != null) {
            stringBuilder.append(" ").append(stringArray[4]);
        }
        if (stringArray != null && stringArray.length > 5 && stringArray[5] != null) {
            stringBuilder.append(" ").append(stringArray[5]);
        }
        if (bl) {
            stringBuilder.append("<br><br>").append(StringResource.getString("mm_nomed_1"));
        } else {
            stringBuilder.append("<br>");
        }
        List<MmData> list = MmUtil.getNomedData(string);
        if (list != null) {
            stringBuilder.append("<br>").append(StringResource.getString("mm_nomed_1a"));
            for (MmData mmData : list) {
                if (mmData.url != null) {
                    stringBuilder.append("<br>-&nbsp;<a href=\"").append(mmData.url.toExternalForm()).append("\">").append(mmData.mmTitle).append("</a>");
                    continue;
                }
                stringBuilder.append("<br>-&nbsp;").append(mmData.mmTitle);
            }
        }
        stringBuilder.append("<br><br>").append(StringResource.getString("mm_nomed_2"));
        stringBuilder.append("<br><br>").append(StringResource.getString("mm_nomed_3"));
        stringBuilder.append("<br><br>").append(StringResource.getString("mm_nomed_4a"));
        stringBuilder.append(GetDataFile.getDataPath());
        stringBuilder.append(StringResource.getString("mm_nomed_4b"));
        stringBuilder.append("\n");
        stringBuilder.append("</td></tr></table>");
        return stringBuilder.toString();
    }

    static {
        showMedis = new HashMap<String, MmHeader>((int)Math.ceil(7333.333333333333));
        mmLinkFile = new ArrayList();
    }

    protected static class MmData {
        String mmTitle;
        URL url;

        protected MmData() {
        }
    }

    protected static class MmHeader {
        List<MmData> mmList;

        protected MmHeader() {
        }
    }
}

