/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.apputil.User;
import ch.steph.repui.RepMainFrame;
import ch.steph.util.ConstStr;
import ch.steph.util.Constants;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.ShowListEntry;
import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.TimeUnit;

public class PatientUtil {
    private static String actPatDir = null;
    private static String patientName = null;
    private static String patRoot = "";
    private static String[] patButtons = null;
    private static String[] patDirs = null;
    private static final String CLASS_NAME = "PatientUtil";
    private static Vector<ShowListEntry> savedCaseList = null;
    private static final String DATE_TRENNER = "  - ";
    private static final String FORM_PAT_TEXT = "Formular: ";
    private static Date lastConsultDate;
    private static boolean showPatName;

    private PatientUtil() {
    }

    public static String getActPatDir() {
        String string;
        File file;
        if (actPatDir == null && (file = FileProcedures.getFile(string = User.instance().getProperty("FileHome", PatientUtil.getPatRoot()))).isDirectory()) {
            actPatDir = file.getAbsolutePath();
            patientName = file.getName();
        }
        return actPatDir;
    }

    public static void setActPatDir(String string) {
        File file;
        if (string != null && string.length() > 3 && (file = FileProcedures.getFile(string)).isDirectory()) {
            String string2 = file.getAbsolutePath();
            if (actPatDir == null || !string2.equals(actPatDir)) {
                actPatDir = string2;
                User.instance().setProperty("FileHome", actPatDir);
                if (patRoot.length() <= 3) {
                    PatientUtil.setPatRoot(file.getParent());
                }
                patientName = file.getName();
                Log.write(5, CLASS_NAME, "setFileDir: " + actPatDir);
            }
        }
    }

    public static String getPatRoot() {
        Object object;
        String string;
        if (patRoot.length() < 3) {
            patRoot = User.instance().getProperty("PatientRoot", "");
            patientName = null;
        }
        if (patRoot.length() < 3 && (string = GetDataFile.getDataPath()) != null) {
            object = FileProcedures.addDirName(string, "Auswertungen");
            if (FileProcedures.exists((String)object)) {
                patRoot = object;
                User.instance().setProperty("PatientRoot", (String)object);
            } else {
                FileProcSync.makeDir((String)object);
                if (FileProcedures.exists((String)object)) {
                    patRoot = object;
                    User.instance().setProperty("PatientRoot", (String)object);
                }
            }
            Log.write(5, CLASS_NAME, "getPatRoot: " + patRoot);
        }
        if (patRoot.length() < 3 && ((File)(object = FileProcedures.getFile(string = User.instance().getProperty("FileHome", "")))).isDirectory()) {
            patRoot = ((File)object).getParent();
            Log.write(5, CLASS_NAME, "getPatRoot: " + patRoot);
        }
        return patRoot;
    }

    private static boolean setPatRoot(String string) {
        File file = FileProcedures.getFile(string);
        if (file.isDirectory() && (patRoot == null || !patRoot.equals(file.getAbsolutePath()))) {
            patRoot = file.getAbsolutePath();
            User.instance().setProperty("PatientRoot", patRoot);
            Log.write(5, CLASS_NAME, "setPatRoot: " + patRoot);
            return true;
        }
        return false;
    }

    public static boolean isPatientActive() {
        String string = PatientUtil.getPatRoot();
        return string != null && string.length() > 3;
    }

    public static String getPatientName() {
        if (patientName == null) {
            PatientUtil.getActPatDir();
        }
        if (patientName == null) {
            if (PatientUtil.getPatRoot() != null && PatientUtil.getPatRoot().length() > 3 && PatientUtil.getActPatDir() != null && PatientUtil.getActPatDir().startsWith(patRoot)) {
                patientName = PatientUtil.getActPatDir();
                patientName = patientName.length() > 0 ? FileProcedures.getFileName(patientName) : null;
            }
            Log.write(5, CLASS_NAME, "getPatientName: " + patientName);
        }
        if (patientName == null) {
            return "";
        }
        return patientName;
    }

    public static String addPatient(String string) {
        if (string != null && string.length() > 0 && PatientUtil.getPatRoot() != null) {
            String string2 = FileProcedures.addDirName(PatientUtil.getPatRoot(), string);
            FileProcSync.makeDir(string2);
            URL uRL = FileProcedures.nameToUrl(string2);
            if (FileProcedures.exists(FileProcedures.urlToName(uRL))) {
                patientName = FileProcedures.getFileName(uRL);
                return patientName;
            }
        }
        return null;
    }

    public static void deleteActPatient() {
        if (PatientUtil.getPatRoot() != null && PatientUtil.getPatRoot().length() > 0 && PatientUtil.getPatientName() != null && PatientUtil.getPatientName().length() > 0) {
            FileProcSync.deleteAll(FileProcedures.addDirName(PatientUtil.getPatRoot(), PatientUtil.getPatientName()));
        }
    }

    public static String renameActPatient(String string) {
        String string2;
        String string3 = PatientUtil.getPatientName();
        String string4 = PatientUtil.getPatRoot();
        String string5 = FileProcedures.addDirName(string4, string3);
        if (FileProcSync.rename(string5, string2 = FileProcedures.addDirName(string4, string))) {
            patientName = string;
        }
        return patientName;
    }

    public static Vector<String> getActualizedPatList() {
        if (PatientUtil.getPatRoot() != null) {
            Vector<String> vector = new Vector<String>();
            File file = FileProcedures.getFile(PatientUtil.getPatRoot());
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    if (!file2.isDirectory() || file2.getName().startsWith(".")) continue;
                    vector.addElement(file2.getName());
                }
            }
            vector.sort(String.CASE_INSENSITIVE_ORDER);
            return vector;
        }
        return null;
    }

    public static Vector<ShowListEntry> getActualizedCaseList(boolean bl) {
        savedCaseList = new Vector();
        try {
            if (actPatDir == null) {
                PatientUtil.getActPatDir();
            }
            if (actPatDir != null) {
                File[] fileArray;
                lastConsultDate = null;
                File file = FileProcedures.getFile(actPatDir);
                for (File file2 : fileArray = file.listFiles()) {
                    if (file2.isFile() && file2.getName().endsWith(".rep")) {
                        PatientUtil.addToList(file2);
                    }
                    if (!bl) continue;
                    if (file2.isFile() && file2.getName().endsWith(".repp")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd ");
                        ShowListEntry showListEntry = new ShowListEntry(actPatDir, file2.getName());
                        savedCaseList.add(showListEntry);
                        long l = file2.lastModified();
                        String string = simpleDateFormat.format(new Date(l));
                        if (User.instance().getProperty("PatListWithDate", false)) {
                            SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("dd.MM.yyyy HH:mm");
                            String string2 = simpleDateFormat2.format(new Date(l));
                            showListEntry.setShowname(string + FORM_PAT_TEXT + showListEntry.getFilenameNoExtension() + DATE_TRENNER + string2);
                        } else {
                            showListEntry.setShowname(string + FORM_PAT_TEXT + showListEntry.getFilenameNoExtension());
                        }
                    }
                    if (!file2.isFile() || file2.getName().startsWith("Notiz")) continue;
                    if (file2.getName().endsWith(".htm")) {
                        PatientUtil.addToList(file2);
                    }
                    if (file2.getName().endsWith(".rtf")) {
                        PatientUtil.addToList(file2);
                    }
                    if (file2.getName().endsWith(".csv")) {
                        PatientUtil.addToList(file2);
                    }
                    if (file2.getName().endsWith(".pdf")) {
                        PatientUtil.addToList(file2);
                    }
                    PatientUtil.checkForConsultDate(file2.getName());
                }
            }
        }
        catch (Exception exception) {
            Log.write(3, CLASS_NAME, "getActualizedCaseList: " + exception.getMessage());
        }
        return savedCaseList;
    }

    private static void addToList(File file) {
        ShowListEntry showListEntry = new ShowListEntry(actPatDir, file.getName());
        savedCaseList.add(showListEntry);
        if (User.instance().getProperty("PatListWithDate", false)) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            long l = file.lastModified();
            String string = simpleDateFormat.format(new Date(l));
            showListEntry.setShowname(showListEntry.getFilenameNoExtension() + DATE_TRENNER + string);
        } else {
            showListEntry.setShowname(showListEntry.getFilenameNoExtension());
        }
    }

    public static long getLastConsultDateDifference() {
        if (lastConsultDate == null) {
            return -1L;
        }
        long l = Math.abs(new Date().getTime() - lastConsultDate.getTime());
        return TimeUnit.DAYS.convert(l, TimeUnit.MILLISECONDS);
    }

    private static void checkForConsultDate(String string) {
        if (string.length() >= "yyyy-MM-dd".length()) {
            try {
                Date date = new SimpleDateFormat("yyyy-MM-dd").parse(string.substring(0, "yyyy-MM-dd".length()));
                if (lastConsultDate == null || lastConsultDate.before(date)) {
                    lastConsultDate = date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static void renameCase(String string, String string2) {
        if (actPatDir == null) {
            PatientUtil.getActPatDir();
        }
        if (actPatDir != null) {
            FileProcSync.rename(FileProcedures.addDirName(actPatDir, string), FileProcedures.addDirName(actPatDir, string2));
            if (string.endsWith(".repp")) {
                String string3 = string.substring(0, string.length() - ".repp".length()) + ".repa";
                String string4 = string2.substring(0, string2.length() - ".repp".length()) + ".repa";
                FileProcSync.rename(FileProcedures.addDirName(actPatDir, string3), FileProcedures.addDirName(actPatDir, string4));
            }
        }
    }

    public static void deleteCase(ShowListEntry showListEntry) {
        FileProcSync.delete(showListEntry.getUrlString());
        if (showListEntry.getUrlString().endsWith(".repp")) {
            String string = showListEntry.getUrlString().substring(0, showListEntry.getUrlString().length() - ".repp".length()) + ".repa";
            FileProcSync.delete(string);
        }
    }

    public static String getSimpleCaseFileNameFromList(ShowListEntry showListEntry) {
        if (showListEntry.getUrlString().endsWith(".rep")) {
            String string = showListEntry.getShowname();
            int n = string.lastIndexOf(DATE_TRENNER);
            if (n > 0) {
                return string.substring(0, n).trim();
            }
            return string;
        }
        return null;
    }

    public static void setSelectedPatient(String string) {
        String string2;
        File file;
        if (string != null && patRoot != null && (file = FileProcedures.getFile(string2 = FileProcedures.addDirName(patRoot, string))).isDirectory()) {
            PatientUtil.setActPatDir(string2);
            patientName = string;
            if (RepMainFrame.getRepInstance() != null) {
                RepMainFrame.getRepInstance().setNewPatientName();
            }
            Log.write(4, CLASS_NAME, "setSelectedPatient: " + patientName);
        }
    }

    public static void prepareOptions() {
        int n;
        PatientUtil.getPatButtons(false);
        PatientUtil.getPatRoot();
        if (patDirs[0] == null && patRoot != null && patRoot.length() > 0 && (n = patRoot.lastIndexOf(ConstStr.FILE_SEPARATOR.charAt(0))) > 0) {
            PatientUtil.patButtons[0] = patRoot.substring(n + 1);
            PatientUtil.patDirs[0] = patRoot;
        }
    }

    public static String[] getPatButtons(boolean bl) {
        patButtons = new String[4];
        patDirs = new String[4];
        for (int i = 0; i < 4; ++i) {
            int n;
            String string = User.instance().getProperty("PatientDir" + i, "");
            String string2 = User.instance().getProperty("PatientLabel" + i, "");
            if (string.length() <= 0 || string2.length() <= 0) continue;
            PatientUtil.patDirs[i] = string;
            PatientUtil.patButtons[i] = string2;
            if (!bl || (n = FileProcedures.countDir(string)) <= 0) continue;
            PatientUtil.patButtons[i] = string2 + " [" + n + "]";
        }
        return patButtons;
    }

    public static int countPatDir() {
        if (patButtons == null) {
            PatientUtil.getPatButtons(false);
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (patButtons[i] == null) continue;
            ++n;
        }
        return n;
    }

    public static String getPatDir(String string) {
        int n;
        PatientUtil.getPatButtons(true);
        for (n = 0; n < 4; ++n) {
            if (patButtons[n] == null || !patButtons[n].equals(string)) continue;
            return patDirs[n];
        }
        PatientUtil.getPatButtons(false);
        for (n = 0; n < 4; ++n) {
            if (patButtons[n] == null || !patButtons[n].equals(string)) continue;
            return patDirs[n];
        }
        return null;
    }

    public static String getPatDir(int n) {
        if (n >= 0 && n < 4) {
            PatientUtil.getPatButtons(false);
            return patDirs[n];
        }
        return "";
    }

    public static void setPatDir(int n, String string, String string2) {
        if (n < 4) {
            PatientUtil.getPatButtons(false);
            if (string == null || string.length() == 0) {
                User.instance().setProperty("PatientDir" + n, "");
                User.instance().setProperty("PatientLabel" + n, "");
                PatientUtil.patButtons[n] = null;
                PatientUtil.patDirs[n] = null;
            } else {
                File file = FileProcedures.getFile(string2);
                if (file.isDirectory()) {
                    String string3 = file.getAbsolutePath();
                    User.instance().setProperty("PatientDir" + n, string3);
                    User.instance().setProperty("PatientLabel" + n, string);
                    PatientUtil.patButtons[n] = string;
                    PatientUtil.patDirs[n] = string3;
                    Log.write(5, CLASS_NAME, "setPatDir: " + n + ", " + string + ", " + string3);
                }
            }
        }
    }

    public static boolean activatePatDir(String string) {
        String string2 = PatientUtil.getPatDir(string);
        if (string2 != null) {
            return PatientUtil.setPatRoot(string2);
        }
        return false;
    }

    public static Vector<String> getActImageFileList() {
        File file;
        Vector<String> vector = new Vector<String>();
        if (actPatDir == null) {
            PatientUtil.getActPatDir();
        }
        if (actPatDir != null && (file = FileProcedures.getFile(actPatDir)).exists() && file.isDirectory()) {
            File[] fileArray = file.listFiles();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            for (File file2 : fileArray) {
                if (!Constants.isKnownImageFile(file2.getName())) continue;
                if (User.instance().getProperty("PatListWithDate", false)) {
                    long l = file2.lastModified();
                    String string = simpleDateFormat.format(new Date(l));
                    vector.add(file2.getName() + DATE_TRENNER + string);
                    continue;
                }
                vector.add(file2.getName());
            }
        }
        return vector;
    }

    public static URL getActImageFromList(String string) {
        if (actPatDir != null) {
            int n = string.indexOf(DATE_TRENNER);
            if (n > 0) {
                String string2 = string.substring(0, n);
                return FileProcedures.nameDirToUrl(actPatDir, string2);
            }
            return FileProcedures.nameDirToUrl(actPatDir, string);
        }
        return null;
    }

    public static URL findNewestImageFile() {
        Vector<String> vector = PatientUtil.getActImageFileList();
        if (vector != null && vector.size() > 0) {
            String string = vector.get(vector.size() - 1);
            return PatientUtil.getActImageFromList(string);
        }
        return null;
    }

    public static String findNewestConsultFile() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ShowListEntry showListEntry : PatientUtil.getActualizedCaseList(true)) {
            String string3 = showListEntry.getFilename();
            if (!string3.endsWith(".htm") && !string3.endsWith(".rtf")) continue;
            arrayList.add(string3);
        }
        if (arrayList != null && arrayList.size() > 0) {
            arrayList.sort((string, string2) -> string2.compareToIgnoreCase((String)string));
            return (String)arrayList.get(0);
        }
        return null;
    }

    public static boolean isShowPatName() {
        return showPatName;
    }

    public static void setShowPatName(boolean bl) {
        showPatName = bl;
    }

    static {
        showPatName = false;
    }
}

