/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.ReadRubrics;
import ch.steph.reputil.RepUtil;
import ch.steph.util.FileCsvKey;
import ch.steph.util.Log;
import ch.steph.util.TimeProbe;
import java.util.ArrayList;
import java.util.List;

public class ReadFileRubrics
implements ReadRubrics {
    private int repIndex;
    private String[] repMedis;
    private boolean doLog;
    private TimeProbe timeProbe;
    private int loadCount;
    private List<Rubric> rubricList;

    public ReadFileRubrics(int n, String[] stringArray, boolean bl, TimeProbe timeProbe) {
        this.repIndex = n;
        this.repMedis = stringArray;
        this.doLog = bl;
        this.timeProbe = timeProbe;
        this.loadCount = 0;
        this.rubricList = new ArrayList<Rubric>();
        this.readMain();
    }

    private void readMain() {
        FileCsvKey fileCsvKey = RepUtil.openRepFile(this.repIndex);
        if (fileCsvKey.isOpenRead()) {
            boolean bl = false;
            boolean bl2 = false;
            fileCsvKey.readLn();
            String string = fileCsvKey.readLn();
            while (string != null) {
                int n = string.indexOf(";");
                if (string.length() < 2) {
                    if (string.length() != 0) {
                        bl = true;
                    }
                } else if (string.charAt(0) != '#') {
                    Rubric rubric;
                    int n2 = this.rubricList.size();
                    if (n < 0) {
                        n = string.length();
                    }
                    String string2 = string.substring(0, n).trim();
                    String string3 = "";
                    if (string.length() > n + 1) {
                        string3 = string.substring(n + 1);
                    }
                    if (this.doLog) {
                        this.timeProbe.partEnds(20, "load file: read line");
                    }
                    if ((rubric = new Rubric(this.repIndex, string2, string3, this.repMedis)).isValid()) {
                        this.rubricList.add(rubric);
                    } else {
                        bl2 = true;
                    }
                    if (this.doLog) {
                        this.timeProbe.partEnds(21, "load file: new rubric");
                    }
                    ++this.loadCount;
                    if (this.loadCount % 1000 == 1) {
                        RepDataPool.getInstance().checkMemory();
                        if (this.doLog) {
                            this.timeProbe.partEnds(23, "load file: mem checked");
                        }
                    }
                    if (n2 == this.rubricList.size()) {
                        bl2 = true;
                    } else if (bl2) {
                        Log.write(3, ReadFileRubrics.class.getName(), "Rep" + this.repIndex + " line not loaded above: " + string);
                        bl2 = false;
                    }
                    if (bl) {
                        Log.write(3, ReadFileRubrics.class.getName(), "Rep" + this.repIndex + " found short line above: " + string);
                        bl = false;
                    }
                }
                string = fileCsvKey.readLn();
            }
            fileCsvKey.close();
        }
    }

    @Override
    public List<Rubric> getRepEntries() {
        return this.rubricList;
    }
}

