/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.apputil.User;
import ch.steph.repdata.RepData;
import ch.steph.repdata.RepDataLoader;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.util.FileCsv;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.MemCache;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;

public class RepUtil {
    private static final MemCache repUtilCache = MemCache.getInstance(MemCache.CacheType.REP_UTIL);
    public static String publicMediFileDate = "";
    public static String publicMediFileLength = "";
    private static ArrayList<String[]> repLinkFile = new ArrayList();

    public static FileCsvKey openRepFile(int n) {
        if (n <= 41) {
            String string = "Rep" + n + ".jrr";
            return GetDataFile.getKeyFileRd(FileProcedures.systemResourceToUrl("jrepdata/" + string));
        }
        return GetDataFile.getOwnRepRd(n);
    }

    public static FileCsv openTabbedFile(String string, String string2) {
        return GetDataFile.getTabbedFileRd(FileProcedures.systemResourceToUrl(string + "/" + string2 + ".jrr"));
    }

    public static synchronized String[] getRepTitles() {
        try {
            String[] stringArray = (String[])repUtilCache.get("RepTitles");
            if (stringArray == null) {
                String string;
                int n;
                stringArray = new String[62];
                for (n = 1; n < 62; ++n) {
                    FileCsvKey fileCsvKey = RepUtil.openRepFile(n);
                    stringArray[n] = "";
                    if (!fileCsvKey.isOpenRead()) continue;
                    string = fileCsvKey.readFirstLn(64);
                    int n2 = string.indexOf(";");
                    if (n2 > 0) {
                        string = string.substring(0, n2).trim();
                    }
                    stringArray[n] = string;
                    fileCsvKey.close();
                }
                n = 0;
                for (int i = 1; i < 62; ++i) {
                    if (stringArray[i].length() <= 0) continue;
                    ++n;
                    string = RepUtil.getRepKey(i);
                    if (string.length() <= 0) continue;
                    stringArray[i] = stringArray[i] + " - " + string;
                }
                if (n < 1) {
                    stringArray = null;
                } else {
                    repUtilCache.put("RepTitles", stringArray);
                }
            }
            if (stringArray != null) {
                String[] stringArray2 = new String[stringArray.length];
                System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                return stringArray2;
            }
        }
        catch (Exception exception) {
            Log.write(2, RepUtil.class.getName(), "getRepTitles", exception);
        }
        return null;
    }

    public static String stripFxFromTitle(String string) {
        int n = string.indexOf(" - ");
        if (n > 0) {
            return string.substring(0, n);
        }
        return string;
    }

    private static FileCsv getPolarFile(int n) {
        if (n <= 41) {
            FileCsv fileCsv;
            Object object;
            String string = GetDataFile.getDataPath();
            if (string != null && User.instance().getProperty("externalRubric", true) && (object = FileProcedures.nameDirToUrl(string, "extern-" + "Polar".toLowerCase() + n + ".csv")) != null && (fileCsv = GetDataFile.getCsvFileRd((URL)object)).isOpenRead()) {
                return fileCsv;
            }
            String string2 = "Polar" + n + ".jrr";
            object = GetDataFile.getCsvFileRd(FileProcedures.systemResourceToUrl("jrepdata/" + string2));
            if (((FileLn)object).isOpenRead()) {
                return object;
            }
        } else {
            String string = GetDataFile.getDataPath();
            if (string != null) {
                String string3 = "Polar" + (n - 41) + ".csv";
                return GetDataFile.getCsvFileRd(FileProcedures.nameDirToUrl(string, string3));
            }
        }
        return null;
    }

    private static String getPolarRubricFromFile(int n, String object) {
        try {
            if (object != null && ((String)object).length() > 0) {
                object = ((String)object).toLowerCase() + " ";
                String string = "p-" + n;
                ArrayList<String[]> arrayList = (ArrayList<String[]>)MemCache.getInstance(MemCache.CacheType.POLAR).get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList<String[]>();
                    FileCsv fileCsv = RepUtil.getPolarFile(n);
                    if (fileCsv != null && fileCsv.isOpenRead()) {
                        String[] stringArray = fileCsv.readCSVLine();
                        while (stringArray != null) {
                            for (int i = 0; i < stringArray.length && i < 2; ++i) {
                                stringArray[i] = i == 0 ? stringArray[i].toLowerCase() + " " : stringArray[i].toLowerCase().trim();
                            }
                            arrayList.add(stringArray);
                            stringArray = fileCsv.readCSVLine();
                        }
                        fileCsv.close();
                    }
                    MemCache.getInstance(MemCache.CacheType.POLAR).put(string, arrayList);
                }
                if (arrayList.size() > 0) {
                    for (String[] stringArray : arrayList) {
                        if (!((String)object).contains(stringArray[0])) continue;
                        return stringArray[1];
                    }
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, RepUtil.class.getName(), "exception in getPolarRubricFromFile: " + (String)object, exception);
        }
        return null;
    }

    public static Rubric getRubricFromAllRepFile(String string, int n) {
        Object object;
        int n2 = -1;
        int n3 = (string = string.trim()).indexOf(" ");
        if (n3 >= 2) {
            object = string.substring(0, n3);
            n2 = RepUtil.getRepIndex((String)object, n);
        }
        if (n2 < 0) {
            return null;
        }
        object = RepDataPool.getInstance().getRepFile(n2);
        return RepUtil.getRubricFromRepWithChanged((RepData)object, string);
    }

    public static Rubric getRubricFromRepNoChanged(String string, int n) {
        if (n < 0) {
            return null;
        }
        RepData repData = RepDataPool.getInstance().getRepFile(n);
        return RepUtil.getRubricFromRepNoChanged(repData, string);
    }

    public static Rubric getPolarRubric(Rubric rubric) {
        String string;
        int n;
        String string2;
        if (rubric != null && (string2 = RepUtil.getPolarRubricFromFile(n = rubric.getRepIndex(), string = rubric.getRubricKey())) != null) {
            RepData repData = RepDataPool.getInstance().getRepFile(n);
            return RepUtil.getRubricFromRepWithChanged(repData, string2);
        }
        return null;
    }

    private static Rubric getRubricFromRepWithChanged(RepData repData, String string) {
        Log.write(4, RepUtil.class.getName(), "getRubricFromRepWithChanged: " + string);
        if (repData != null && string != null) {
            Rubric rubric;
            if (!string.startsWith("++") && (rubric = repData.getRubricWithKey("++" + string)) != null) {
                Log.write(4, RepUtil.class.getName(), "Found a: " + rubric.getRubricKeyWithChangedExtension());
                return rubric;
            }
            rubric = repData.getRubricWithKey(string);
            if (rubric != null) {
                Log.write(4, RepUtil.class.getName(), "Found b: " + rubric.getRubricKeyWithChangedExtension());
                return rubric;
            }
        }
        return null;
    }

    private static Rubric getRubricFromRepNoChanged(RepData repData, String string) {
        Rubric rubric;
        Log.write(4, RepUtil.class.getName(), "getRubricFromRepNoChanged: " + string);
        if (repData != null && string != null && (rubric = repData.getRubricWithKey(string)) != null) {
            Log.write(4, RepUtil.class.getName(), "Found c: " + rubric.getRubricKeyWithChangedExtension());
            return rubric;
        }
        return null;
    }

    public static Rubric getOriginalRubric(Rubric rubric) {
        if (rubric != null) {
            String string = rubric.getRubricKey();
            RepData repData = RepDataPool.getInstance().getRepFile(rubric.getRepIndex());
            return repData.getRubricWithKey(string);
        }
        return null;
    }

    public static FileCsv openFirstIniFile() {
        String string = "first-ini.jrr";
        FileCsv fileCsv = GetDataFile.getCsvFileRd(FileProcedures.systemResourceToUrl("jrepdata/" + string));
        if (fileCsv.isOpenRead()) {
            return fileCsv;
        }
        return new FileCsv();
    }

    public static synchronized String[] getFullMediArray() {
        try {
            String[] stringArray = (String[])repUtilCache.get("fullMediArray");
            if (stringArray == null) {
                String[] stringArray2;
                FileCsv fileCsv = new FileCsv();
                ArrayList<String> arrayList = new ArrayList<String>();
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                String string = GetDataFile.getDataPath();
                if (string != null && (stringArray2 = FileProcedures.nameDirToUrl(string, "arzneien.csv")) != null) {
                    fileCsv = GetDataFile.getCsvFileRd((URL)stringArray2);
                    publicMediFileDate = "" + FileProcedures.getFileDate((URL)stringArray2);
                    publicMediFileLength = "" + FileProcedures.getFileSize((URL)stringArray2);
                }
                if (!fileCsv.isOpenRead() && (stringArray2 = FileProcedures.systemResourceToUrl("eigene/arzneien.csv")) != null) {
                    fileCsv = GetDataFile.getCsvFileRd((URL)stringArray2);
                    publicMediFileDate = "" + FileProcedures.getFileDate((URL)stringArray2);
                    publicMediFileLength = "" + FileProcedures.getFileSize((URL)stringArray2);
                }
                if (fileCsv.isOpenRead()) {
                    stringArray2 = fileCsv.readCSVLine();
                    while (stringArray2 != null) {
                        if (stringArray2[0].length() > 0 && stringArray2[0].charAt(0) != '#') {
                            arrayList.add(stringArray2[0]);
                            if (stringArray2.length > 1 && stringArray2[1] != null && stringArray2[1].length() > 0) {
                                hashtable.put(stringArray2[0].toLowerCase().trim(), stringArray2[1].trim());
                            }
                        }
                        stringArray2 = fileCsv.readCSVLine();
                    }
                    if (arrayList.size() > 0) {
                        stringArray = new String[arrayList.size()];
                        Collections.sort(arrayList);
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = (String)arrayList.get(i);
                        }
                    }
                }
                if ("0".equals(publicMediFileLength)) {
                    publicMediFileLength = "" + stringArray.length;
                }
                repUtilCache.put("fullMediArray", stringArray);
                repUtilCache.put("fullFilterTable", hashtable);
            }
            return stringArray;
        }
        catch (Exception exception) {
            Log.write(2, RepUtil.class.getName(), "getFullMediArray", exception);
            return null;
        }
    }

    public static Hashtable<String, String> getFullFilterTable() {
        try {
            Hashtable hashtable = (Hashtable)repUtilCache.get("fullFilterTable");
            if (hashtable == null) {
                RepUtil.getFullMediArray();
                hashtable = (Hashtable)repUtilCache.get("fullFilterTable");
            }
            return hashtable;
        }
        catch (Exception exception) {
            Log.write(2, RepUtil.class.getName(), "getFullFilterTable", exception);
            return null;
        }
    }

    public static void setRepId(int n, String string) {
        try {
            String[] stringArray = RepUtil.getRepIdents();
            if (!string.equals(stringArray[n])) {
                stringArray[n] = string;
                repUtilCache.put("repIdents", stringArray);
            }
        }
        catch (Exception exception) {
            Log.write(2, RepUtil.class.getName(), "setRepId", exception);
        }
    }

    private static String[] getRepIdents() {
        try {
            String[] stringArray = (String[])repUtilCache.get("repIdents");
            if (stringArray == null) {
                stringArray = new String[63];
                repUtilCache.put("repIdents", stringArray);
            }
            return stringArray;
        }
        catch (Exception exception) {
            Log.write(2, RepUtil.class.getName(), "getRepIdents", exception);
            return null;
        }
    }

    public static int getRepIndex(String string, int n) {
        if (string != null) {
            int n2;
            if (string.startsWith("++")) {
                string = string.substring("++".length());
            }
            String[] stringArray = RepUtil.getRepTitles();
            String[] stringArray2 = RepUtil.getRepIdents();
            if (n < stringArray2.length && n >= 0 && stringArray[n] != null && stringArray[n].length() > 0) {
                if (stringArray2[n] == null) {
                    RepData repData = new RepData(n);
                    new RepDataLoader(repData);
                    stringArray2 = RepUtil.getRepIdents();
                }
                if (stringArray2[n] != null && stringArray2[n].equals(string)) {
                    return n;
                }
            }
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                if (stringArray2[n2] == null || !stringArray2[n2].equals(string)) continue;
                return n2;
            }
            for (n2 = 1; n2 < 62; ++n2) {
                if (stringArray[n2] == null || stringArray[n2].length() <= 0) continue;
                RepData repData = RepDataPool.getInstance().getRepHeader(n2);
                new RepDataLoader(repData);
                stringArray2 = RepUtil.getRepIdents();
                if (stringArray2[n2] == null || !stringArray2[n2].equals(string)) continue;
                return n2;
            }
        }
        return n;
    }

    private static ArrayList<String[]> getRepLinkFile() {
        if (repLinkFile.size() == 0) {
            FileCsv fileCsv = new FileCsv();
            String string = "rep-links.csv";
            String string2 = GetDataFile.getDataPath();
            if (string2 != null) {
                fileCsv = GetDataFile.getCsvFileRd(FileProcedures.nameDirToUrl(string2, string));
            }
            if (!fileCsv.isOpenRead()) {
                fileCsv = GetDataFile.getCsvFileRd(FileProcedures.systemResourceToUrl("jrepdata/" + string));
            }
            if (fileCsv.isOpenRead()) {
                String[] stringArray = fileCsv.readCSVLine();
                while (stringArray != null) {
                    if (stringArray.length > 0 && stringArray[0].length() > 0 && stringArray[0].charAt(0) != '#') {
                        repLinkFile.add(stringArray);
                    }
                    stringArray = fileCsv.readCSVLine();
                }
                fileCsv.close();
            }
        }
        return repLinkFile;
    }

    public static List<List<String>> getExternalTabbedFile(String string) {
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        FileCsv fileCsv = new FileCsv('\t');
        String string2 = GetDataFile.getDataPath();
        if (string2 != null) {
            fileCsv = GetDataFile.getTabbedFileRd(FileProcedures.nameDirToUrl(string2, string));
        }
        if (fileCsv.isOpenRead()) {
            List<String> list = fileCsv.readCSVList();
            while (list != null) {
                if (!list.isEmpty() && list.get(0).length() > 0 && list.get(0).charAt(0) != '#') {
                    arrayList.add(list);
                }
                list = fileCsv.readCSVList();
            }
            fileCsv.close();
        }
        return arrayList;
    }

    public static FileLn getExternalFileWr(String string) {
        FileLn fileLn = new FileLn();
        String string2 = GetDataFile.getDataPath();
        if (string2 != null) {
            fileLn = GetDataFile.getCsvFileWr(FileProcedures.addDirName(string2, string), false);
        }
        return fileLn;
    }

    private static String getRepKey(int n) {
        for (String[] stringArray : RepUtil.getRepLinkFile()) {
            if (!("" + n).equals(stringArray[1])) continue;
            return stringArray[0];
        }
        return "";
    }

    public static int getRepIndex(String string) {
        for (String[] stringArray : RepUtil.getRepLinkFile()) {
            if (!stringArray[0].equals(string)) continue;
            return Integer.parseInt(stringArray[1]);
        }
        return 0;
    }

    public static String getSingleCounterForRubric(int n) {
        long l = User.instance().getProperty("repChangeCounter" + n, 1);
        StringBuilder stringBuilder = new StringBuilder("" + l);
        while (stringBuilder.length() < 5) {
            stringBuilder.insert(0, '0');
        }
        return stringBuilder.toString();
    }

    public static void saveSingleCounterForRubric(int n) {
        long l = User.instance().getProperty("repChangeCounter" + n, 1);
        User.instance().setProperty("repChangeCounter" + n, l + 1L);
    }
}

