/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.repdata.RepData;
import ch.steph.repdata.RepDataLoader;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.complete.ReadCompleteRubrics;
import ch.steph.util.Constants;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;

public class RubricChangeFile {
    private static ArrayList<String> remarksLoaded = new ArrayList();
    private static Hashtable<String, String> rubricRemarks = new Hashtable();

    public static FileCsvKey openPrivateRepFile(int n) {
        return GetDataFile.getRubricPrivateRd(n, "SearchChanged");
    }

    public static void checkFileChangedForDelete(int n) {
        if (n > 0) {
            RepData repData = new RepData(n);
            new RepDataLoader(repData);
            String[] stringArray = null;
            if (repData.isCrFormat()) {
                ReadCompleteRubrics readCompleteRubrics = new ReadCompleteRubrics(repData.getRepId(), repData.getCrDirectory(), repData.getRepNumber(), repData.isCrCountNormal(), false, null);
                stringArray = readCompleteRubrics.getMediArray();
            } else {
                stringArray = repData.getRepMedis();
            }
            RubricChangeFile.checkFileChanged(n, stringArray);
        } else {
            Log.write(3, "RubricChangeFile", "No medis provided in rep: " + n);
        }
    }

    public static void checkFileChanged(int n, String[] stringArray) {
        block15: {
            if (stringArray == null) {
                Log.write(3, "RubricChangeFile checkFileChanged", "Missing the medi array, don't proceed in rep: " + n);
                return;
            }
            boolean bl = false;
            Log.write(5, "RubricChangeFile checkFileChanged", "Check files: " + n);
            String string = GetDataFile.getDataPath();
            if (string != null) {
                String string2 = "RubricChange" + n + ".csv";
                if (FileProcedures.exists(string, string2)) {
                    try {
                        Object object;
                        String string3 = "" + FileProcedures.getFileDate(string, string2);
                        String string4 = "" + FileProcedures.getFileSize(string, string2);
                        FileCsvKey fileCsvKey = RubricChangeFile.openPrivateRepFile(n);
                        if (fileCsvKey.isOpenRead()) {
                            object = fileCsvKey.readCSVLine();
                            fileCsvKey.close();
                            if (((String[])object).length < 3) {
                                bl = true;
                            }
                            if (!bl && !object[0].equals(Constants.getFullVersion())) {
                                bl = true;
                            }
                            if (!bl && !object[1].equals(string3)) {
                                bl = true;
                            }
                            if (!bl && !object[2].equals(string4)) {
                                bl = true;
                            }
                        } else {
                            bl = true;
                        }
                        if (!bl) break block15;
                        Log.write(4, "checkFileChanged", "Generate private rep file: " + n);
                        RubricChangeFile.deleteAllPrivateFiles(n);
                        fileCsvKey = GetDataFile.getRubricPrivateWr(n, "SearchChanged");
                        object = GetDataFile.getRubricPrivateWr(n, "ExtensionChanged");
                        try {
                            if (fileCsvKey.isOpenWrite()) {
                                String[] stringArray2 = new String[]{Constants.getFullVersion(), string3, string4};
                                fileCsvKey.writeCSVLine(stringArray2);
                                RubricChangeFile.copyPublicToPrivate(n, stringArray, fileCsvKey, (FileCsvKey)object);
                                fileCsvKey.close();
                                ((FileLn)object).close();
                                RepDataPool.getInstance().reloadRepFile(n);
                            }
                        }
                        catch (Exception exception) {
                            Log.write(3, "RubricChangeFile", "problem writing private File");
                        }
                    }
                    catch (Exception exception) {
                        Log.write(3, "RubricChangeFile", "checkFileChanged", exception);
                    }
                } else {
                    RubricChangeFile.deleteAllPrivateFiles(n);
                }
            }
        }
    }

    private static void deleteAllPrivateFiles(int n) {
        remarksLoaded = new ArrayList();
        rubricRemarks = new Hashtable();
        String string = GetDataFile.getUserPath();
        FileProcSync.delete(string, "SearchChanged" + n + ".jrr");
        FileProcSync.delete(string, "ExtensionChanged" + n + ".jrr");
        FileProcSync.delete(string, "ExtensionMedi" + n + ".jrr");
        FileProcSync.delete(string, "ExtensionMedi" + n + ".csv");
    }

    public static String getRubricRemarks(Rubric rubric) {
        if (rubric != null) {
            Object object;
            Object object2;
            try {
                object2 = "" + rubric.getRepIndex();
                if (!remarksLoaded.contains(object2)) {
                    remarksLoaded.add((String)object2);
                    object = GetDataFile.getRubricPrivateRd(rubric.getRepIndex(), "ExtensionChanged");
                    if (((FileLn)object).isOpenRead()) {
                        String string = ((FileCsvKey)object).readNextGetKey();
                        while (string != null) {
                            String string2 = string;
                            String string3 = ((FileCsvKey)object).getRemaining();
                            rubricRemarks.put(string2, string3);
                            string = ((FileCsvKey)object).readNextGetKey();
                        }
                        ((FileLn)object).close();
                    }
                }
            }
            catch (Exception exception) {
                Log.write(3, "RubricChangeFile", "getRubricRemarks", exception);
            }
            object2 = rubric.getRubricKeyWithChangedExtension();
            object = rubricRemarks.get(object2);
            if (object != null) {
                return object;
            }
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private static void copyPublicToPrivate(int n, String[] stringArray, FileCsvKey fileCsvKey, FileCsvKey fileCsvKey2) {
        try {
            FileCsvKey fileCsvKey3 = GetDataFile.getRubricPublicRd(n);
            if (fileCsvKey3.isOpenRead()) {
                String string = fileCsvKey3.readNextGetKey();
                String string2 = null;
                while (string != null) {
                    String string3 = string;
                    String string4 = fileCsvKey3.getRemaining();
                    String string5 = fileCsvKey3.readNextGetKey();
                    if (string5 != null && string5.startsWith(string3)) {
                        String string6 = fileCsvKey3.getRemaining();
                        String string7 = fileCsvKey3.readNextGetKey();
                        if (string7 != null && string7.startsWith(string3)) {
                            string2 = fileCsvKey3.getRemaining();
                        }
                        Object[] objectArray = fileCsvKey3.changeCSVtoArray(string4);
                        String[] stringArray2 = fileCsvKey3.changeCSVtoArray(string6);
                        for (String string8 : objectArray) {
                            boolean bl = false;
                            for (int stringArray3 = 1; stringArray3 < stringArray.length && !bl; ++stringArray3) {
                                if (!stringArray[stringArray3].equalsIgnoreCase(string8)) continue;
                                bl = true;
                            }
                            if (bl) continue;
                            String[] object = new String[stringArray.length + 1];
                            System.arraycopy(stringArray, 0, object, 0, stringArray.length);
                            object[stringArray.length] = string8;
                            stringArray = object;
                            FileCsvKey fileCsvKey4 = GetDataFile.getRubricPrivateWr(n, "ExtensionMedi");
                            if (!fileCsvKey4.isOpenWrite()) continue;
                            fileCsvKey4.writeCSVLine(stringArray);
                            fileCsvKey4.close();
                        }
                        if (RepDataPool.getInstance().getRepFile(n).isEditExtern()) {
                            Object[] objectArray2 = new String[stringArray.length];
                            Arrays.fill(objectArray2, "");
                            objectArray2[0] = RepDataPool.getInstance().getRepFile(n).isEditExtern() ? "++" + string5 : string5;
                            for (int i = 0; i < objectArray.length; ++i) {
                                for (int j = 1; j < stringArray.length; ++j) {
                                    if (!stringArray[j].equalsIgnoreCase((String)objectArray[i])) continue;
                                    objectArray2[j] = stringArray2[i];
                                }
                            }
                            fileCsvKey.writeCSVLine((String[])objectArray2);
                        }
                        if (string2 != null && fileCsvKey2.isOpenWrite()) {
                            void var18_24;
                            boolean bl = false;
                            StringBuilder stringBuilder = new StringBuilder("");
                            String[] stringArray4 = fileCsvKey2.changeCSVtoArray(string2);
                            boolean i = false;
                            while (var18_24 < stringArray4.length) {
                                if (stringArray4[var18_24].length() > 0) {
                                    Object object = objectArray[var18_24];
                                    if (!bl) {
                                        stringBuilder = RepDataPool.getInstance().getRepFile(n).isEditExtern() ? new StringBuilder("++" + string7 + ";") : new StringBuilder(string7 + ";");
                                        bl = true;
                                        stringBuilder.append((String)object).append(": ").append(stringArray4[var18_24]);
                                    } else {
                                        stringBuilder.append("\\n").append((String)object).append(": ").append(stringArray4[var18_24]);
                                    }
                                }
                                ++var18_24;
                            }
                            if (stringBuilder.length() > 0) {
                                fileCsvKey2.writeLn(stringBuilder.toString());
                            }
                        }
                    }
                    string = fileCsvKey3.readNextGetKey();
                    while (string != null && (string.equals(string3) || string.length() == 0)) {
                        string = fileCsvKey3.readNextGetKey();
                    }
                }
                fileCsvKey3.close();
            }
        }
        catch (Exception exception) {
            Log.write(3, "RubricChangeFile", "copyPublicToPrivate", exception);
        }
    }
}

