/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.MmUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricShowUtil;
import ch.steph.util.ConstStr;
import ch.steph.util.FileCsv;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.MemCache;
import ch.steph.util.StartEkit;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.net.URL;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class RubricUtil {
    private static MemCache rubricUtilCache = MemCache.getInstance(MemCache.CacheType.RUBRIC_UTIL);
    private static String[] messageText = new String[]{StringResource.getString("message_rubric_exportet_1") + "Rep-Export.csv" + StringResource.getString("message_rubric_exportet_2"), StringResource.getString("message_rubric_exportet_3")};

    public static URL getUrlHtmRub(String string, String string2) {
        URL uRL = null;
        string = string.trim().toLowerCase();
        string2 = string2.trim().toLowerCase();
        String string3 = GetDataFile.getDataPath();
        if (string3 != null && User.instance().getProperty("externalRubric", true) && (uRL = FileProcedures.nameDirToUrl(string3, "rubr", string, string2 + ".htm")) == null) {
            uRL = FileProcedures.nameDirToUrl(string3, "rubr", string, string2 + ".txt");
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource("jruba/" + string.replace('\\', '/') + "/" + string2 + ".jrh");
        }
        if (uRL == null) {
            uRL = RubricUtil.getUrlTxtRub(string, string2);
        }
        return uRL;
    }

    public static URL getUrlTxtRub(String string, String string2) {
        URL uRL = null;
        string = string.trim().toLowerCase();
        string2 = string2.trim().toLowerCase();
        String string3 = GetDataFile.getDataPath();
        if (string3 != null && User.instance().getProperty("externalRubric", true)) {
            uRL = FileProcedures.nameDirToUrl(string3, "rubr", string, string2 + ".txt");
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource("jruba/" + string.replace('\\', '/') + "/" + string2 + ".jrt");
        }
        return uRL;
    }

    public static URL getUrlHtmRub(Rubric rubric, String string) {
        String string2 = rubric.getRepIdent();
        String string3 = rubric.getRubrIdent() + rubric.getRubrPostfix();
        if (string != null && string.length() > 0) {
            URL uRL;
            int n = string3.indexOf(45);
            if (n > 0) {
                string3 = string3.substring(0, n) + ConstStr.FILE_SEPARATOR + string3.substring(n + 1);
            }
            if ((uRL = RubricUtil.getUrlHtmRub(string2 + ConstStr.FILE_SEPARATOR + string3, MmUtil.getFilenameFromMedi(string))) != null) {
                return uRL;
            }
            uRL = RubricUtil.checkForO1Url(rubric.getFullRubricLong(), string2, string3, string);
            if (uRL != null) {
                return uRL;
            }
        }
        return RubricUtil.getUrlHtmRub(string2, string3);
    }

    private static URL checkForO1Url(String string, String string2, String object, String string3) {
        if (string.contains(" o1 ")) {
            try {
                int n = ((String)object).length() - 1;
                while (Character.isDigit(((String)object).charAt(n))) {
                    --n;
                }
                String string4 = ((String)object).substring(++n);
                int n2 = Integer.parseInt(string4);
                Object object2 = Integer.toString(--n2);
                while (((String)object2).length() < string4.length()) {
                    object2 = "0" + (String)object2;
                }
                object = ((String)object).substring(0, n) + (String)object2;
                return RubricUtil.getUrlHtmRub(string2 + ConstStr.FILE_SEPARATOR + (String)object, MmUtil.getFilenameFromMedi(string3));
            }
            catch (Exception exception) {
                Log.write(3, RubricUtil.class.getName(), "Rubric with o1 doesn't align: " + (String)object, exception);
            }
        }
        return null;
    }

    public static URL getUrlTxtRub(Rubric rubric) {
        String string = rubric.getRepIdent();
        String string2 = rubric.getRubrIdent() + rubric.getRubrPostfix();
        return RubricUtil.getUrlTxtRub(string, string2);
    }

    public static String[] getMedNameForRubric(String string) {
        String[] stringArray;
        string = string.trim().toLowerCase();
        Hashtable<String, String[]> hashtable = null;
        try {
            hashtable = (Hashtable<String, String[]>)rubricUtilCache.get("AllValues");
        }
        catch (Exception exception) {
            Log.write(2, RubricUtil.class.getName(), "getMedNameForRubric", exception);
        }
        if (hashtable == null) {
            String[] stringArray2;
            hashtable = new Hashtable<String, String[]>();
            FileCsv fileCsv = new FileCsv();
            String string2 = GetDataFile.getDataPath();
            if (string2 != null && (stringArray2 = FileProcedures.nameDirToUrl(string2, "abk-namen.csv")) != null) {
                fileCsv = GetDataFile.getCsvFileRd((URL)stringArray2);
            }
            if (!fileCsv.isOpenRead()) {
                fileCsv = GetDataFile.getCsvFileRd(FileProcedures.systemResourceToUrl("jrepdata/abk-namen.jrr"));
            }
            if (fileCsv.isOpenRead()) {
                stringArray2 = fileCsv.readCSVLine();
                while (stringArray2 != null) {
                    if (stringArray2.length > 1) {
                        try {
                            String string3 = stringArray2[0].trim().toLowerCase();
                            stringArray = new String[stringArray2.length - 1];
                            System.arraycopy(stringArray2, 1, stringArray, 0, stringArray2.length - 1);
                            hashtable.put(string3, stringArray);
                        }
                        catch (Exception exception) {
                            Log.write(2, RubricUtil.class.getName(), "getMedNameForRubric", exception);
                        }
                    }
                    stringArray2 = fileCsv.readCSVLine();
                }
                try {
                    rubricUtilCache.put("AllValues", hashtable);
                }
                catch (Exception exception) {
                    Log.write(2, RubricUtil.class.getName(), "getMedNameForRubric", exception);
                }
                fileCsv.close();
            }
        }
        stringArray = (String[])hashtable.get(string);
        return stringArray;
    }

    public static Rubric combineRubrics(Vector<Rubric> vector, String string, CombineType combineType) {
        int n = 0;
        int n2 = 0;
        Object object = "";
        String[] stringArray = new String[]{};
        for (Rubric rubric : vector) {
            if (rubric.getRepIndex() < 1 || rubric.getRepIndex() >= 62) continue;
            if (n == 0) {
                n2 = rubric.getRepIndex();
            }
            if (stringArray.length < rubric.getMedis().length) {
                stringArray = rubric.getMedis();
            }
            if (n >= rubric.getValues().length) continue;
            n = rubric.getValues().length;
        }
        if (combineType == CombineType.ADD) {
            object = string.replace('\u00b1', '+');
        } else if (combineType == CombineType.SUB) {
            object = string.replace('\u00b1', '-');
        } else if (combineType == CombineType.COUNT) {
            object = string.replace(StringResource.getString("join_text_plus"), StringResource.getString("join_replace_5"));
        } else if (combineType == CombineType.COUNT4) {
            object = string.replace(StringResource.getString("join_text_plus"), StringResource.getString("join_replace_6"));
        } else if (combineType == CombineType.SUM4) {
            object = string.replace(StringResource.getString("join_text_plus"), StringResource.getString("join_replace_3"));
        } else if (combineType == CombineType.SUM4O1) {
            object = string.replace(StringResource.getString("join_text_plus"), StringResource.getString("join_replace_4"));
        }
        if (n > 0) {
            Object object2 = new int[n];
            int n3 = 0;
            for (int i = 0; i < ((Object)object2).length; ++i) {
                object2[i] = false;
                boolean bl = false;
                int n4 = 0;
                Iterator<Rubric> iterator = vector.iterator();
                while (iterator.hasNext() && !bl) {
                    Rubric rubric = iterator.next();
                    int n5 = rubric.getValue(i);
                    if (combineType == CombineType.ADD) {
                        if (n5 <= n4) continue;
                        n4 = n5;
                        continue;
                    }
                    if (combineType == CombineType.SUB) {
                        if (n5 > 0) {
                            if (n5 <= n4) continue;
                            n4 = n5;
                            continue;
                        }
                        n4 = 0;
                        bl = true;
                        continue;
                    }
                    if (combineType == CombineType.COUNT) {
                        if (n5 <= 0 || n4 >= 99) continue;
                        ++n4;
                        continue;
                    }
                    if (combineType == CombineType.COUNT4) {
                        if (n5 <= 0 || n4 >= 4) continue;
                        ++n4;
                        continue;
                    }
                    if ((combineType != CombineType.SUM4 || n5 <= 0) && (combineType != CombineType.SUM4O1 || n5 <= 0) || (n4 += n5) <= 4) continue;
                    n4 = 4;
                }
                if (n4 <= 1 && (n4 <= 0 || combineType == CombineType.SUM4O1)) continue;
                ++n3;
                object2[i] = n4;
            }
            if (combineType != CombineType.SUM4 && combineType != CombineType.SUM4O1) {
                object = (String)object + RubricUtil.getMediCountString(n3);
            }
            return new Rubric(n2, (String)object, (int[])object2, stringArray);
        }
        return null;
    }

    public static boolean isKombiText(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = StringResource.getString("join_text_plus");
        if (string.startsWith(string2 = string2.substring(0, string2.indexOf(177)))) {
            return true;
        }
        if (string.startsWith(StringResource.getString("join_replace_5").strip())) {
            return true;
        }
        if (string.startsWith(StringResource.getString("join_replace_6").strip())) {
            return true;
        }
        if (string.startsWith(StringResource.getString("join_replace_3").strip())) {
            return true;
        }
        return string.startsWith(StringResource.getString("join_replace_4").strip());
    }

    public static String getMediCountString(int n) {
        if (n <= 0) {
            return "  [ 0 ]";
        }
        if (n < 10) {
            return "  [ " + n + ".]";
        }
        if (n < 100) {
            return "  [." + n + " ]";
        }
        return "  [ " + n + " ]";
    }

    public static String getHtmlText(String[] stringArray) {
        if (stringArray != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                if (i == 3) {
                    int n;
                    if (stringArray[i].contains("\\n") && stringArray[i].contains(":")) {
                        n = stringArray[i].indexOf("\\n");
                        while (n >= 0) {
                            int n2 = stringArray[i].indexOf(":", n);
                            stringArray[i] = n2 > n && n2 < n + 13 ? stringArray[i].substring(0, n) + "<BR><font face=Arial size=3 color=#C00000>" + stringArray[i].substring(n + 2, n2 + 1) + "</font>" + stringArray[i].substring(n2 + 1) : stringArray[i].substring(0, n) + "<BR>" + stringArray[i].substring(n + 2);
                            n = stringArray[i].indexOf("\\n");
                        }
                        stringArray[i] = stringArray[i].replace("<font face=Arial size=3 color=#000000><BR>", "<BR><table cellspacing=\"0\" border=\"0\">");
                        stringArray[i] = stringArray[i].replace("<font face=Arial size=3 color=#C00000>", "<tr><td valign=top><font face=Arial size=3 color=#C00000>");
                        stringArray[i] = stringArray[i].replace(":</font>", " </font></td><td><font face=Arial size=3 color=#000000>");
                        stringArray[i] = stringArray[i].replace("<BR><font", "</td></tr><font");
                        stringArray[i] = stringArray[i].replace("</td></tr></table>", "</table></td></tr></table>");
                    } else {
                        n = stringArray[i].indexOf("\\n");
                        while (n >= 0) {
                            stringArray[i] = stringArray[i].substring(0, n) + "<BR>" + stringArray[i].substring(n + 2);
                            n = stringArray[i].indexOf("\\n");
                        }
                    }
                }
                stringBuilder.append(stringArray[i]);
            }
            stringBuilder = new StringBuilder(RubricShowUtil.replaceSizeInHtmlString(stringBuilder.toString()));
            return stringBuilder.toString();
        }
        return "";
    }

    public static void editRubric(URL uRL, Rubric rubric, String string) {
        String string2 = GetDataFile.getDataPath();
        if (string2 != null && User.instance().getProperty("externalRubric", true)) {
            if (!FileProcedures.exists(string2 = FileProcedures.addDirName(string2, "rubr"))) {
                FileProcSync.makeDir(string2);
            }
            if (!FileProcedures.exists(string2 = FileProcedures.addDirName(string2, rubric.getRepIdent()))) {
                FileProcSync.makeDir(string2);
            }
            if (uRL != null) {
                Object object = uRL.getFile();
                int n = ((String)object).lastIndexOf(47);
                object = ((String)object).substring(n + 1);
                n = ((String)object).lastIndexOf(46);
                object = ((String)object).substring(0, n);
                if (!FileProcedures.exists(FileProcedures.addDirName(string2, (String)(object = (String)object + ".htm")))) {
                    FileLn fileLn = GetDataFile.getDataFileRd(uRL);
                    FileLn fileLn2 = GetDataFile.getRubricHtmlWr(FileProcedures.addDirName(string2, (String)object));
                    if (fileLn.isOpenRead() && fileLn2.isOpenWrite()) {
                        String string3 = fileLn.readLn();
                        while (string3 != null) {
                            string3 = RubricShowUtil.replaceMmLinksInRubric((String)object, string3);
                            string3 = RubricShowUtil.replaceSizeInHtmlString(string3);
                            fileLn2.writeLn(string3);
                            string3 = fileLn.readLn();
                        }
                    }
                    fileLn.close();
                    fileLn2.close();
                }
                new StartEkit(string2, (String)object, 0);
            } else if (string != null) {
                FileLn fileLn;
                String string4 = rubric.getRubrIdent() + rubric.getRubrPostfix();
                if (!FileProcedures.exists(FileProcedures.addDirName(string2, string4 = string4 + ".htm")) && (fileLn = GetDataFile.getRubricHtmlWr(FileProcedures.addDirName(string2, string4))).isOpenWrite()) {
                    fileLn.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"/>\n</head>\n<body>\n");
                    fileLn.writeLn(string);
                    fileLn.write("\n</body>\n</html>");
                    fileLn.close();
                }
                new StartEkit(string2, string4, 0);
            }
        }
    }

    public static String[] exportRubric(Toolkit toolkit, Rubric rubric) {
        Object object;
        String[] stringArray = RepUtil.getFullMediArray();
        StringBuilder stringBuilder = new StringBuilder(rubric.getRubricKeyWithChangedExtension() + "  " + rubric.getFullRubric() + ";");
        StringBuilder stringBuilder2 = new StringBuilder(rubric.getRubricKeyWithChangedExtension() + "  " + rubric.getFullRubric() + ";");
        int[] nArray = rubric.getValues();
        for (String string : stringArray) {
            boolean bl = false;
            for (int i = 1; i < nArray.length; ++i) {
                if (!rubric.getMedis()[i].equalsIgnoreCase(string) || nArray[i] <= 0) continue;
                stringBuilder.append(string);
                stringBuilder2.append(" ").append(nArray[i]);
                bl = true;
            }
            if (!bl) continue;
            while (stringBuilder2.length() < stringBuilder.length()) {
                stringBuilder2.append(" ");
            }
            stringBuilder.append(";");
            stringBuilder2.append(";");
        }
        try {
            object = new StringSelection(stringBuilder.toString() + "\n" + stringBuilder2.toString());
            toolkit.getSystemClipboard().setContents((Transferable)object, null);
        }
        catch (Exception exception) {
            Log.write(2, RubricUtil.class.getName(), "writeToClipboard", exception);
        }
        object = GetDataFile.getRepExportWr();
        if (((FileLn)object).isOpenWrite()) {
            ((FileLn)object).writeLn(stringBuilder.toString());
            ((FileLn)object).writeLn(stringBuilder2.toString());
            ((FileLn)object).close();
            return messageText;
        }
        return null;
    }

    public static enum CombineType {
        ADD,
        SUB,
        COUNT,
        COUNT4,
        SUM4,
        SUM4O1;

    }
}

