/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.apputil.User;
import ch.steph.reputil.FontUtil;
import ch.steph.reputil.SearchParam;
import java.awt.Color;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class SearchHighlighter {
    private static Highlighter.HighlightPainter myHighlightPainter;
    private static SearchHighlighter instance;

    private SearchHighlighter() {
        String string = User.instance().getProperty("LookFeel", "none");
        int n = 1;
        if (string.equals("HiFi") || string.equals("Noire")) {
            n = 8;
        }
        switch (User.instance().getProperty("HighlightColor", n)) {
            default: {
                myHighlightPainter = new MyHighlightPainter(Color.yellow);
                break;
            }
            case 2: {
                myHighlightPainter = new MyHighlightPainter(Color.green);
                break;
            }
            case 3: {
                myHighlightPainter = new MyHighlightPainter(Color.cyan);
                break;
            }
            case 4: {
                myHighlightPainter = new MyHighlightPainter(Color.pink);
                break;
            }
            case 5: {
                myHighlightPainter = new MyHighlightPainter(Color.gray.brighter());
                break;
            }
            case 6: {
                myHighlightPainter = new MyHighlightPainter(Color.orange.darker());
                break;
            }
            case 7: {
                myHighlightPainter = new MyHighlightPainter(Color.red.darker());
                break;
            }
            case 8: {
                myHighlightPainter = new MyHighlightPainter(Color.blue.darker());
                break;
            }
            case 9: {
                myHighlightPainter = new MyHighlightPainter(Color.green.darker());
                break;
            }
            case 10: {
                myHighlightPainter = new MyHighlightPainter(Color.gray.darker());
            }
        }
    }

    public static JTextComponent getHighlighted(String string, String string2, SearchParam searchParam) {
        JTextField jTextField = new JTextField(string);
        jTextField.setFont(FontUtil.getChangedFont());
        if (string2.trim().length() >= 2 && searchParam != null) {
            SearchHighlighter.highlight(jTextField, string2, searchParam);
        }
        return jTextField;
    }

    private static void highlight(JTextComponent jTextComponent, String string, SearchParam searchParam) {
        try {
            Document document = jTextComponent.getDocument();
            String string2 = document.getText(0, document.getLength());
            SearchHighlighter.highlight(jTextComponent, searchParam.getAllHighLights(string2));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void highlight(JTextComponent jTextComponent, List<HighLight> list) {
        SearchHighlighter.removeHighlights(jTextComponent);
        try {
            Highlighter highlighter = jTextComponent.getHighlighter();
            for (HighLight highLight : list) {
                highlighter.addHighlight(highLight.getStart(), highLight.getEnd(), myHighlightPainter);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public static void removeHighlights(JTextComponent jTextComponent) {
        Highlighter.Highlight[] highlightArray;
        Highlighter highlighter = jTextComponent.getHighlighter();
        for (Highlighter.Highlight highlight : highlightArray = highlighter.getHighlights()) {
            if (!(highlight.getPainter() instanceof MyHighlightPainter)) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    static {
        instance = new SearchHighlighter();
    }

    private static class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }

    public static class HighLight
    implements Comparable<HighLight> {
        int start;
        int end;

        public HighLight(int n, int n2) {
            this.start = n;
            this.end = n2;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        @Override
        public int compareTo(HighLight highLight) {
            return this.start - highLight.start;
        }
    }
}

