/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.repdata.Rubric;
import ch.steph.reputil.SearchHighlighter;
import ch.steph.reputil.SearchParamOr;
import ch.steph.reputil.SearchString;
import ch.steph.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String userSearchString;
    private List<SearchParamOr> searchParamOrList;

    public SearchParam(String string, List<SearchParamOr> list) {
        this.userSearchString = string;
        this.searchParamOrList = list;
    }

    public boolean matches(boolean bl, Rubric rubric) {
        for (SearchParamOr searchParamOr : this.searchParamOrList) {
            if (searchParamOr.matches(bl, rubric)) continue;
            return false;
        }
        return true;
    }

    public boolean hasData() {
        if (this.searchParamOrList == null) {
            return false;
        }
        if (this.searchParamOrList.size() == 0) {
            return false;
        }
        for (SearchParamOr searchParamOr : this.searchParamOrList) {
            if (!searchParamOr.hasData()) continue;
            return true;
        }
        return false;
    }

    public List<SearchHighlighter.HighLight> getAllHighLights(String string) {
        Log.write(4, this.getClass().getName(), "search string length: " + string.length());
        ArrayList<SearchHighlighter.HighLight> arrayList = new ArrayList<SearchHighlighter.HighLight>();
        for (SearchParamOr searchParamOr : this.searchParamOrList) {
            for (SearchString searchString : searchParamOr.searchStrings) {
                arrayList.addAll(searchString.getAllHighLights(string));
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public boolean isNewSearch(SearchParam searchParam) {
        if (searchParam == null) {
            return true;
        }
        if (searchParam.searchParamOrList.size() != this.searchParamOrList.size() && searchParam.searchParamOrList.size() > this.searchParamOrList.size()) {
            Log.write(4, this.getClass().getName(), "new search with: " + this.toString());
            return true;
        }
        for (int i = 0; i < this.searchParamOrList.size() && i < searchParam.searchParamOrList.size(); ++i) {
            if (!this.searchParamOrList.get(i).isNewSearch(searchParam.searchParamOrList.get(i))) continue;
            Log.write(4, this.getClass().getName(), "new search with: " + this.toString());
            return true;
        }
        return false;
    }

    public boolean isAdditionalSearch(SearchParam searchParam) {
        if (searchParam == null) {
            return true;
        }
        if (searchParam.searchParamOrList.size() != this.searchParamOrList.size()) {
            return true;
        }
        for (int i = 0; i < this.searchParamOrList.size(); ++i) {
            if (this.searchParamOrList.get(i).equals(searchParam.searchParamOrList.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isDifferentSearch(SearchParam searchParam) {
        return this.isNewSearch(searchParam) || this.isAdditionalSearch(searchParam);
    }

    public String toString() {
        return "SearchParam [userSearchString=" + this.userSearchString + ", searchStrings=" + String.valueOf(this.searchParamOrList) + "]";
    }
}

