/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.repdata.Rubric;
import ch.steph.reputil.SearchString;
import java.io.Serializable;
import java.util.List;

class SearchParamOr
implements Serializable {
    private static final long serialVersionUID = 1L;
    List<SearchString> searchStrings;

    public SearchParamOr(List<SearchString> list) {
        this.searchStrings = list;
    }

    public boolean matches(boolean bl, Rubric rubric) {
        for (SearchString searchString : this.searchStrings) {
            if (!searchString.matches(bl, rubric)) continue;
            return true;
        }
        return false;
    }

    public boolean hasData() {
        for (SearchString searchString : this.searchStrings) {
            if (!searchString.hasData()) continue;
            return true;
        }
        return false;
    }

    public boolean isNewSearch(SearchParamOr searchParamOr) {
        if (searchParamOr == null) {
            return true;
        }
        if (searchParamOr.searchStrings.size() != this.searchStrings.size() && searchParamOr.searchStrings.size() < this.searchStrings.size()) {
            return true;
        }
        for (int i = 0; i < this.searchStrings.size() && i < searchParamOr.searchStrings.size(); ++i) {
            if (!this.searchStrings.get(i).isNotOnlyAdded(searchParamOr.searchStrings.get(i))) continue;
            return true;
        }
        return false;
    }

    public boolean isAdditionalSearch(SearchParamOr searchParamOr) {
        if (searchParamOr == null) {
            return true;
        }
        if (searchParamOr.searchStrings.size() != this.searchStrings.size()) {
            return true;
        }
        for (int i = 0; i < this.searchStrings.size(); ++i) {
            if (this.searchStrings.get(i).equals(searchParamOr.searchStrings.get(i))) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SearchParamOr [searchStrings=" + String.valueOf(this.searchStrings) + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SearchParamOr searchParamOr = (SearchParamOr)object;
        if (this.searchStrings == null) {
            return searchParamOr.searchStrings == null;
        }
        if (this.searchStrings.size() != searchParamOr.searchStrings.size()) {
            return false;
        }
        for (int i = 0; i < this.searchStrings.size(); ++i) {
            if (this.searchStrings.get(i).equals(searchParamOr.searchStrings.get(i))) continue;
            return false;
        }
        return true;
    }
}

