/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.repdata.Rubric;
import ch.steph.reputil.SearchHighlighter;
import ch.steph.reputil.SearchUtil;
import ch.steph.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SearchString
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean exactSearch;
    protected String searchString;
    private Pattern searchPattern;
    private boolean getAll;
    private boolean inverted;
    private boolean fastSearch;

    public SearchString(boolean bl, boolean bl2, String string, Pattern pattern) {
        this.exactSearch = bl;
        this.fastSearch = bl2;
        if (string.length() > 0 && string.charAt(0) == '!') {
            this.inverted = true;
            this.searchString = string.substring(1);
        } else {
            this.inverted = false;
            this.searchString = string;
        }
        this.searchPattern = pattern;
        this.getAll = "  ".equals(string);
    }

    public boolean hasData() {
        return this.searchString != null && this.searchString.length() >= 1;
    }

    public boolean isNotOnlyAdded(SearchString searchString) {
        if (this.inverted) {
            return true;
        }
        if (!this.searchString.equals(searchString.searchString)) {
            return !this.searchString.startsWith(searchString.searchString);
        }
        return false;
    }

    public boolean equals(SearchString searchString) {
        return this.searchString.equals(searchString.searchString);
    }

    public boolean matches(boolean bl, Rubric rubric) {
        String string = rubric.getSearchRubric(bl, this.exactSearch);
        if (this.getAll) {
            return true;
        }
        if (this.inverted) {
            if (this.searchString.length() < 2) {
                return true;
            }
            if (this.searchPattern == null) {
                return !string.contains(this.searchString);
            }
            Matcher matcher = this.searchPattern.matcher(string);
            return !matcher.find();
        }
        if (this.searchPattern == null) {
            return string.contains(this.searchString);
        }
        Matcher matcher = this.searchPattern.matcher(string);
        return matcher.find();
    }

    public List<SearchHighlighter.HighLight> getAllHighLights(String string) {
        ArrayList<SearchHighlighter.HighLight> arrayList = new ArrayList<SearchHighlighter.HighLight>();
        if (this.inverted) {
            return arrayList;
        }
        try {
            if (this.fastSearch) {
                string = string.toLowerCase();
                int n = 0;
                while ((n = string.indexOf(this.searchString, n)) >= 0) {
                    arrayList.add(new SearchHighlighter.HighLight(n, n + this.searchString.length()));
                    n += this.searchString.length();
                }
            } else if (this.searchPattern == null) {
                if (this.exactSearch) {
                    int n = 0;
                    while ((n = string.indexOf(this.searchString, n)) >= 0) {
                        arrayList.add(new SearchHighlighter.HighLight(n, n + this.searchString.length()));
                        n += this.searchString.length();
                    }
                } else {
                    String string2 = SearchUtil.getSearchKey(string);
                    int n = 0;
                    while ((n = string2.indexOf(this.searchString, n)) >= 0) {
                        int n2 = 0;
                        if (n > 0) {
                            n2 = -1;
                        }
                        String string3 = string2.substring(0, n + 1);
                        String string4 = SearchUtil.getSearchKey(string.substring(0, n + n2));
                        while (string4.length() < string3.length()) {
                            string4 = SearchUtil.getSearchKey(string.substring(0, n + ++n2));
                        }
                        int n3 = n + n2 - 1;
                        string3 = string2.substring(0, n + this.searchString.length());
                        String string5 = SearchUtil.getSearchKey(string.substring(0, n + this.searchString.length() + --n2));
                        while (string5.length() < string3.length()) {
                            string5 = SearchUtil.getSearchKey(string.substring(0, n + this.searchString.length() + ++n2));
                        }
                        int n4 = n + this.searchString.length() + n2;
                        arrayList.add(new SearchHighlighter.HighLight(n3, n4));
                        n += this.searchString.length();
                    }
                }
            } else if (this.exactSearch) {
                Log.write(3, this.getClass().getName(), "Not foreseen: Exact search with wildcard");
            } else {
                String string6 = SearchUtil.getSearchKey(string);
                Matcher matcher = this.searchPattern.matcher(string6);
                while (matcher.find()) {
                    int n = matcher.start();
                    int n5 = matcher.end();
                    int n6 = 0;
                    if (n > 0) {
                        n6 = -1;
                    }
                    String string7 = string6.substring(0, n + 1);
                    String string8 = SearchUtil.getSearchKey(string.substring(0, n + n6));
                    while (string8.length() < string7.length()) {
                        string8 = SearchUtil.getSearchKey(string.substring(0, n + ++n6));
                    }
                    int n7 = n + n6 - 1;
                    string7 = string6.substring(0, n5);
                    String string9 = SearchUtil.getSearchKey(string.substring(0, n5 + --n6));
                    while (string9.length() < string7.length()) {
                        string9 = SearchUtil.getSearchKey(string.substring(0, n5 + ++n6));
                    }
                    int n8 = n5 + n6;
                    arrayList.add(new SearchHighlighter.HighLight(n7, n8));
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "Exception while Highlighting ", exception);
        }
        return arrayList;
    }

    public String toString() {
        return "SearchString [exactSearch=" + this.exactSearch + ", searchString=" + this.searchString + ", searchPattern=" + String.valueOf(this.searchPattern) + "]";
    }
}

