/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.repdata.RepData;
import ch.steph.repdata.RepDataLoader;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.repmodel.MmMediListModel;
import ch.steph.reputil.MmMedis;
import ch.steph.reputil.MmUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.complete.ReadCompleteRubrics;
import ch.steph.util.FileCsv;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.TimeProbe;
import java.util.ArrayList;
import java.util.Collections;

public class StephActions {
    private static final String CLASS_NAME = "ch.steph.reputil.StephActions";

    public static void generateTitles() {
        try {
            TimeProbe timeProbe = new TimeProbe();
            String[] stringArray = RepUtil.getRepTitles();
            FileCsv fileCsv = GetDataFile.getCsvFileWr(GetDataFile.getTempRoot() + "dl-de-jrep.csv", false);
            fileCsv.writeLn("Nr;Title;Rep;used memory(kb);entries");
            timeProbe.partEnds(10, "start");
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].length() <= 0) continue;
                long l = StephActions.getAvailableMemory();
                timeProbe.partEnds(11, "prepare & gc");
                RepData repData = RepDataPool.getInstance().getRepHeader(i);
                RepDataPool.getInstance().getRepFile(i);
                String string = repData.getRepTitle().trim();
                if (string.endsWith(".")) {
                    string = string.substring(0, string.length() - 1);
                }
                timeProbe.partEnds(20 + i, string);
                long l2 = StephActions.getAvailableMemory();
                String string2 = StephActions.getRepIdents(repData);
                fileCsv.writeLn("rep" + i + ";" + string + ";" + string2 + ";" + (l - l2) + ";" + (RepDataLoader.RubricOverAllCount - n));
                n = RepDataLoader.RubricOverAllCount;
            }
            String[] stringArray2 = MmUtil.getMmTitles();
            for (int i = 0; i < stringArray2.length; ++i) {
                if (stringArray2[i] == null || stringArray2[i].length() <= 0) continue;
                MmMediListModel mmMediListModel = new MmMediListModel(MmMedis.getMediArray());
                mmMediListModel.filterMedisByMm(i);
                fileCsv.writeLn("mm" + i + ";" + stringArray2[i].substring(3).trim() + ";;;" + mmMediListModel.getSize());
            }
            fileCsv.writeLn(timeProbe.getLogString().replace("ms", "").replace("all: ", ";"));
            fileCsv.close();
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "generateTitles", exception);
        }
    }

    private static String getRepIdents(RepData repData) {
        repData.resetGetNextRubric();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object object = repData.getNextRubric();
        while (object != null) {
            String string = ((Rubric)object).getRepIdent();
            if (!string.startsWith("++") && string.length() > 0 && !arrayList.contains(string)) {
                arrayList.add(string);
            }
            object = repData.getNextRubric();
        }
        Collections.sort(arrayList);
        object = "";
        for (String string : arrayList) {
            object = (String)object + string + ",";
        }
        if (((String)object).length() > 0) {
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        return object;
    }

    public static void persistRep(boolean bl) {
        TimeProbe timeProbe = new TimeProbe();
        for (int i = 1; i <= 62; ++i) {
            RepData repData = RepDataPool.getInstance().getRepHeader(i);
            if (repData == null || repData.getRepTitle() == null || repData.getRepTitle().length() <= 0 || !repData.isCrFormat() && !bl) continue;
            RepDataPool.getInstance().getRepFile(i);
            StephActions.generateFile(repData, timeProbe);
        }
        Log.write(4, ReadCompleteRubrics.class.getName(), "Timing: " + timeProbe.getLogString());
    }

    private static void generateFile(RepData repData, TimeProbe timeProbe) {
        FileCsv fileCsv;
        if (repData != null && repData.getRepTitle() != null && repData.getRepTitle().length() > 0 && (fileCsv = GetDataFile.getCsvFileWr(GetDataFile.getTempRoot() + "Rep" + repData.getRepNumber() + ".jrr", false)).isOpenWrite()) {
            boolean bl = true;
            StringBuilder stringBuilder = new StringBuilder(repData.getRepTitle());
            for (String string : repData.getRepMedis()) {
                if (bl) {
                    bl = false;
                    continue;
                }
                stringBuilder.append(';');
                stringBuilder.append(string);
            }
            fileCsv.writeLn(stringBuilder.toString());
            for (String string : repData.repHeaderLines) {
                if (string.startsWith("#load")) continue;
                fileCsv.writeLn(string);
            }
            repData.resetGetNextRubric();
            Object object = repData.getNextRubric();
            while (object != null) {
                if (!((Rubric)object).getRepIdent().startsWith("++")) {
                    stringBuilder = new StringBuilder(((Rubric)object).getRepIdent());
                    stringBuilder.append(" ");
                    stringBuilder.append(((Rubric)object).getRubrIdent());
                    stringBuilder.append(((Rubric)object).getRubrPostfix());
                    stringBuilder.append("  ");
                    stringBuilder.append(((Rubric)object).getSimpleRubric());
                    int[] nArray = ((Rubric)object).getValues();
                    if (nArray != null) {
                        for (int i = 1; i < nArray.length; ++i) {
                            stringBuilder.append(";");
                            if (nArray[i] <= 0) continue;
                            stringBuilder.append(nArray[i]);
                        }
                    }
                    while (stringBuilder.charAt(stringBuilder.length() - 1) == ';') {
                        stringBuilder.setLength(stringBuilder.length() - 1);
                    }
                    fileCsv.writeLn(stringBuilder.toString());
                    if (timeProbe != null) {
                        timeProbe.partEnds(repData.getRepNumber(), repData.getRepTitle());
                    }
                }
                object = repData.getNextRubric();
            }
            fileCsv.close();
        }
    }

    private static long getAvailableMemory() {
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = (runtime.totalMemory() - runtime.freeMemory()) / 1024L;
        long l2 = runtime.maxMemory() / 1024L;
        return l2 - l;
    }
}

