/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.rep.SearchResult;
import ch.steph.repdata.Rubric;
import ch.steph.repform.FormUtil;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.RubricChangeFile;
import ch.steph.reputil.RubricShowUtil;
import ch.steph.reputil.RubricUtil;
import ch.steph.util.FileCsv;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import java.net.URL;
import java.util.Vector;

public class SuperUserActions {
    private static final String CLASS_NAME = "ch.steph.reputil.SuperUserActions";

    public static void generateHtmlPages(int n, SearchResult searchResult) {
        try {
            if (searchResult != null && searchResult.size() > 0) {
                for (int i = 0; i < searchResult.size(); ++i) {
                    Rubric rubric = searchResult.getByRubricIndex(i);
                    if (rubric == null) continue;
                    String string = RubricChangeFile.getRubricRemarks(rubric);
                    String[] stringArray = RubricShowUtil.makeRubricHtml(rubric, string);
                    String string2 = FileProcedures.addDirName(GetDataFile.getTempRoot(), rubric.getRubricKeyWithChangedExtension() + ".htm");
                    FileCsv fileCsv = GetDataFile.getCaseDataWr(string2, false);
                    if (!fileCsv.isOpenWrite()) continue;
                    fileCsv.writeLn("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\"/>\n</head>\n<body>\n" + RubricUtil.getHtmlText(stringArray) + "\n</body>\n</html>");
                    fileCsv.close();
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "generateHtmlPages", exception);
        }
    }

    public static void checkAllForms() {
        try {
            Vector<String> vector = FormUtil.getActualizedFormList();
            if (vector != null) {
                String string = FileProcedures.addDirName(GetDataFile.getTempRoot(), "FormularCheck.txt");
                FileCsv fileCsv = GetDataFile.getCaseDataWr(string, false);
                int n = -1;
                if (fileCsv.isOpenWrite()) {
                    for (String string2 : vector) {
                        URL uRL = FormUtil.getHtmlFormName(string2);
                        FileCsv fileCsv2 = GetDataFile.getCsvFileRd(uRL);
                        if (!fileCsv2.isOpenRead()) continue;
                        int n2 = 1;
                        String string3 = fileCsv2.readLn();
                        while (string3 != null) {
                            Rubric rubric;
                            String string4;
                            if (string3.indexOf(" name='in-") > 0) {
                                string4 = string3.substring(string3.indexOf(" name='in-") + " name='in-".length());
                                rubric = RepUtil.getRubricFromAllRepFile(string4 = string4.substring(0, string4.indexOf("'")), n);
                                if (rubric == null) {
                                    fileCsv.writeLn(string2 + " line " + n2 + ": pat key not found: '" + string4 + "'");
                                } else {
                                    n = rubric.getRepIndex();
                                }
                            } else if (string3.indexOf(" name='do-") > 0) {
                                string4 = string3.substring(string3.indexOf(" name='do-") + " name='do-".length());
                                rubric = RepUtil.getRubricFromAllRepFile(string4 = string4.substring(0, string4.indexOf("'")), n);
                                if (rubric == null) {
                                    fileCsv.writeLn(string2 + " line " + n2 + ": doc key not found: '" + string4 + "'");
                                } else {
                                    n = rubric.getRepIndex();
                                }
                            }
                            ++n2;
                            string3 = fileCsv2.readLn();
                        }
                        fileCsv2.close();
                        fileCsv.writeLn(string2 + ": done");
                    }
                    fileCsv.close();
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, CLASS_NAME, "generateHtmlPages", exception);
        }
    }
}

