/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil;

import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.reputil.PatientUtil;
import ch.steph.util.Constants;
import ch.steph.util.CryptBase64Service;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.Log;
import ch.steph.util.transfer.TransferDataFile;
import ch.steph.util.transfer.TransferListFile;
import ch.steph.util.transfer.TransferObject;
import ch.steph.util.transfer.TransferService;
import ch.steph.util.transfer.TransferServiceClient;
import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class WebJRepUtil {
    private static final String EXT_URL = "http://jrepapp.appspot.com";
    private static final String EXT_URI_WITH_DATA = "/jrepweb/ioService?action=req&v=" + Constants.getFullVersion() + "&data=";
    private static final String EXT_URI_NO_DATA = "/jrepweb/ioService?action=req&v=" + Constants.getFullVersion();
    private static final String POST_USERDATA = "data=";
    private static final String FORM_URL = "http://jrepform.appspot.com";
    public static final String FORM_URL_HTTPS = "https://jrepform.appspot.com";
    private static WebJRepUtil instance;
    private String username;
    private String password;
    private JTextField webStatus;
    private String[] patList;
    private HashMap<String, String[]> caseLists = new HashMap();

    public static WebJRepUtil getInstance() {
        if (instance == null) {
            instance = new WebJRepUtil();
        }
        return instance;
    }

    public static WebJRepUtil getNewInstance() {
        instance = new WebJRepUtil();
        return instance;
    }

    public boolean webCheckPassword(String string, String string2, Component component, JTextField jTextField) {
        WebJRepUtil.instance.username = string;
        WebJRepUtil.instance.password = string2;
        WebJRepUtil.instance.webStatus = jTextField;
        if (string2.length() == 0) {
            this.showWarningText(component, StringResource.getString("web_no_pw"));
            jTextField.setText("Passwort nicht eingegeben");
            return false;
        }
        try {
            Log.write(4, this.getClass().getName(), "webCheckPassword ");
            TransferServiceClient transferServiceClient = TransferServiceClient.instance();
            String string3 = transferServiceClient.validateCredentialsAction(string, string2);
            URL uRL = this.prepareUrl(string3);
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[50];
            int n = inputStream.read(byArray);
            inputStream.close();
            String string4 = new String(byArray, 0, n);
            Log.write(4, this.getClass().getName(), "Received result " + string4);
            if (n > 0 && string4.startsWith("success")) {
                this.setStatusText("Username / Passwort ok");
                return true;
            }
            this.setStatusText("Username / Passwort ung\u00fcltig");
            this.showWarningText(component, StringResource.getString("web_wrong_pw"));
        }
        catch (MalformedURLException malformedURLException) {
            Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
            this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
            this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
        }
        return false;
    }

    public String[] webGetPatList() {
        if (this.patList == null) {
            TransferListFile transferListFile = null;
            try {
                Log.write(4, this.getClass().getName(), "webGetPatList ");
                this.setStatusText("Patientenliste abfragen ");
                TransferServiceClient transferServiceClient = TransferServiceClient.instance();
                String string = transferServiceClient.prepareGetAllCustomers(this.username, this.password, this.username);
                URL uRL = this.prepareUrl(string);
                ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
                TransferObject transferObject = (TransferObject)objectInputStream.readObject();
                objectInputStream.close();
                transferListFile = (TransferListFile)transferServiceClient.decriptTransferObject(CryptBase64Service.getInstance("S!.Rae$$?"), transferObject);
                Log.write(4, this.getClass().getName(), "Received PatList ");
            }
            catch (MalformedURLException malformedURLException) {
                Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
                this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
            }
            catch (IOException iOException) {
                Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
                this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Log.write(3, this.getClass().getName(), "No PatList, ClassNotFoundException: ", classNotFoundException);
                this.setStatusText("Verbindungs-Fehler: " + classNotFoundException.getMessage());
            }
            if (transferListFile != null) {
                this.patList = transferListFile.getData();
            }
            if (this.patList == null) {
                this.webStatus.setText("Patientliste: leer ");
            } else {
                this.setStatusText("Patientliste: " + this.patList.length + " Eintr\u00e4ge");
            }
        }
        return this.patList;
    }

    public String[] deleteWebPat(String string) {
        try {
            Log.write(4, this.getClass().getName(), "deleteWebPat ");
            this.setStatusText("Patient l\u00f6schen ");
            TransferServiceClient transferServiceClient = TransferServiceClient.instance();
            String string2 = transferServiceClient.prepareDeletePatAction(this.username, this.password, this.username, string);
            URL uRL = this.prepareUrl(string2);
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[50];
            int n = inputStream.read(byArray);
            inputStream.close();
            String string3 = new String(byArray, 0, n);
            Log.write(4, this.getClass().getName(), "Received result " + string3);
            if (n > 0 && string3.startsWith("success")) {
                this.setStatusText("Patient gel\u00f6scht");
            } else {
                this.setStatusText("Patient nicht gel\u00f6scht");
            }
        }
        catch (MalformedURLException malformedURLException) {
            Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
            this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
            this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
        }
        return this.webGetPatList();
    }

    public String[] deleteWebCase(String string, String string2) {
        try {
            Log.write(4, this.getClass().getName(), "deleteWebCase ");
            this.setStatusText("Auswertung l\u00f6schen ");
            TransferServiceClient transferServiceClient = TransferServiceClient.instance();
            String string3 = transferServiceClient.prepareDeleteCsvFileAction(this.username, this.password, this.username, string, string2);
            URL uRL = this.prepareUrl(string3);
            InputStream inputStream = uRL.openStream();
            byte[] byArray = new byte[50];
            int n = inputStream.read(byArray);
            inputStream.close();
            String string4 = new String(byArray, 0, n);
            Log.write(4, this.getClass().getName(), "Received result " + string4);
            if (n > 0 && string4.startsWith("success")) {
                this.setStatusText("Auswertung gel\u00f6scht");
            } else {
                this.setStatusText("Auswertung nicht gel\u00f6scht");
            }
        }
        catch (MalformedURLException malformedURLException) {
            Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
            this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
            this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
        }
        return this.webGetPatList();
    }

    public void reloadCaseList(String string) {
        this.caseLists.remove(string);
    }

    public String[] webGetCaseList(String string) {
        String[] stringArray = this.caseLists.get(string);
        if (stringArray != null) {
            return stringArray;
        }
        String[] stringArray2 = null;
        TransferListFile transferListFile = null;
        try {
            Log.write(4, this.getClass().getName(), "webGetPatList ");
            this.setStatusText("Auswertungen abfragen ");
            TransferServiceClient transferServiceClient = TransferServiceClient.instance();
            String string2 = transferServiceClient.prepareGetAllCustomerCsvFiles(this.username, this.password, this.username, string);
            URL uRL = this.prepareUrl(string2);
            ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
            TransferObject transferObject = (TransferObject)objectInputStream.readObject();
            objectInputStream.close();
            transferListFile = (TransferListFile)transferServiceClient.decriptTransferObject(CryptBase64Service.getInstance("S!.Rae$$?"), transferObject);
            Log.write(4, this.getClass().getName(), "Received PatList ");
        }
        catch (MalformedURLException malformedURLException) {
            Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
            this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
            this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.write(3, this.getClass().getName(), "No PatList, ClassNotFoundException: ", classNotFoundException);
            this.setStatusText("Verbindungs-Fehler: " + classNotFoundException.getMessage());
        }
        if (transferListFile != null) {
            stringArray2 = transferListFile.getData();
            this.caseLists.put(string, stringArray2);
        }
        if (stringArray2 == null) {
            this.webStatus.setText(StringResource.getString("web_caselist") + ": " + StringResource.getString("web_empty"));
        } else {
            this.setStatusText(StringResource.getString("web_caselist") + ": " + stringArray2.length + " " + StringResource.getString("web_entries"));
        }
        return stringArray2;
    }

    public void putCsvFile(String string, String string2) {
        try {
            Log.write(4, this.getClass().getName(), "putCsvFile ");
            this.setStatusText("Auswertung hochladen ");
            URL uRL = FileProcedures.nameDirToUrl(PatientUtil.getActPatDir(), string2 + ".rep");
            TransferServiceClient transferServiceClient = TransferServiceClient.instance();
            String string3 = transferServiceClient.preparePutFileAction(this.username, this.password, this.username, string, string2, "csv", uRL);
            URL uRL2 = this.prepareUrl();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write(("userdata=" + string3).getBytes());
            outputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[2048];
            int n = 0;
            int n2 = 0;
            while (n2 >= 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((n2 = inputStream.read(byArray, n, 100)) <= 0) continue;
                n += n2;
            }
            inputStream.close();
            String string4 = new String(byArray, 0, n);
            Log.write(4, this.getClass().getName(), "Received result " + string4);
            if (n > 0 && string4.startsWith("success")) {
                this.setStatusText("Auswertung hochgeladen");
            } else {
                this.setStatusText("Fehler beim Hochladen");
            }
            Log.write(4, this.getClass().getName(), "CsvFile upload ok ");
        }
        catch (MalformedURLException malformedURLException) {
            Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
            this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
            this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
        }
    }

    public void webGetRepFile(String string, String string2) {
        Object object;
        Object object2;
        TransferDataFile transferDataFile = null;
        try {
            Log.write(4, this.getClass().getName(), "webGetCsvFile ");
            this.setStatusText("Auswertung kopieren: " + string2);
            object2 = TransferServiceClient.instance();
            object = ((TransferServiceClient)object2).prepareGetCsvFileAction(this.username, this.password, this.username, string, string2);
            URL uRL = this.prepareUrl((String)object);
            ObjectInputStream objectInputStream = new ObjectInputStream(uRL.openStream());
            TransferObject transferObject = (TransferObject)objectInputStream.readObject();
            objectInputStream.close();
            transferDataFile = (TransferDataFile)((TransferService)object2).decriptTransferObject(CryptBase64Service.getInstance("S!.Rae$$?"), transferObject);
            Log.write(4, this.getClass().getName(), "Received CsvFile ");
        }
        catch (MalformedURLException malformedURLException) {
            Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
            this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
            this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.write(3, this.getClass().getName(), "No PatList, ClassNotFoundException: ", classNotFoundException);
            this.setStatusText("Verbindungs-Fehler: " + classNotFoundException.getMessage());
        }
        if (transferDataFile != null) {
            this.webStatus.setText("Auswertung kopiert: " + string2);
            object2 = FileProcedures.addDirName(PatientUtil.getActPatDir(), transferDataFile.getFileName() + ".rep");
            object = GetDataFile.getCsvFileWr((String)object2, false);
            if (((FileLn)object).isOpenWrite()) {
                ((FileLn)object).write(transferDataFile.getData());
                ((FileLn)object).close();
                this.webStatus.setText("Auswertung gespeichert: " + string2);
            }
        } else {
            this.setStatusText("Auswertung nicht kopiert: " + string2);
        }
    }

    private URL prepareUrl(String string) throws MalformedURLException {
        URL uRL;
        boolean bl = User.instance().getProperty("UseProxy", false);
        String string2 = User.instance().getProperty("ProxyHost", "");
        int n = User.instance().getProperty("ProxyPort", -1);
        String string3 = EXT_URL + EXT_URI_WITH_DATA + string;
        if (bl && string2.length() > 0) {
            uRL = new URL("http", string2, n, string3);
            Log.write(4, this.getClass().getName(), "URL with proxy " + string2 + ":" + n);
        } else {
            uRL = new URL(string3);
        }
        return uRL;
    }

    private URL prepareUrl() throws MalformedURLException {
        URL uRL;
        boolean bl = User.instance().getProperty("UseProxy", false);
        String string = User.instance().getProperty("ProxyHost", "");
        int n = User.instance().getProperty("ProxyPort", 8080);
        String string2 = EXT_URL + EXT_URI_NO_DATA;
        if (bl && string.length() > 0) {
            uRL = new URL("http", string, n, string2);
            Log.write(4, this.getClass().getName(), "URL with proxy " + string + ":" + n);
        } else {
            uRL = new URL(string2);
        }
        return uRL;
    }

    private URL prepareFormUrl() throws MalformedURLException {
        URL uRL;
        boolean bl = User.instance().getProperty("UseProxy", false);
        String string = User.instance().getProperty("ProxyHost", "");
        int n = User.instance().getProperty("ProxyPort", 8080);
        String string2 = FORM_URL + EXT_URI_NO_DATA;
        if (bl && string.length() > 0) {
            uRL = new URL("http", string, n, string2);
            Log.write(4, this.getClass().getName(), "URL with proxy " + string + ":" + n);
        } else {
            uRL = new URL(string2);
        }
        return uRL;
    }

    public String putFormGetLink(JTextField jTextField, String string, String string2, String string3) {
        WebJRepUtil.instance.webStatus = jTextField;
        try {
            Log.write(4, this.getClass().getName(), "putFormGetLink ");
            this.setStatusText("Link im Server aktivieren und Formular hochladen");
            TransferServiceClient transferServiceClient = TransferServiceClient.instance();
            String string4 = transferServiceClient.prepareGetLinkSendForm(string, string2, string3);
            URL uRL = this.prepareFormUrl();
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setRequestMethod("POST");
            OutputStream outputStream = httpURLConnection.getOutputStream();
            outputStream.write((POST_USERDATA + string4).getBytes());
            outputStream.close();
            InputStream inputStream = httpURLConnection.getInputStream();
            byte[] byArray = new byte[2048];
            int n = 0;
            int n2 = 0;
            while (n2 >= 0) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if ((n2 = inputStream.read(byArray, n, 256)) <= 0) continue;
                n += n2;
            }
            inputStream.close();
            String string5 = new String(byArray, 0, n);
            Log.write(4, this.getClass().getName(), "Received link " + string5);
            if (n > 0 && string5.startsWith("/jrepweb")) {
                this.setStatusText("Link erhalten ");
                return string5;
            }
            this.setStatusText("Link generieren misslungen ");
            Log.write(4, this.getClass().getName(), "FormFile upload ok ");
        }
        catch (MalformedURLException malformedURLException) {
            Log.write(3, this.getClass().getName(), "No data, MalformedURLException: ", malformedURLException);
            this.setStatusText("Verbindungs-Fehler: " + malformedURLException.getMessage());
        }
        catch (IOException iOException) {
            Log.write(3, this.getClass().getName(), "No data, IOException: ", iOException);
            this.setStatusText("Verbindungs-Fehler: " + iOException.getMessage());
        }
        return null;
    }

    private void setStatusText(String string) {
        SwingUtilities.invokeLater(() -> this.webStatus.setText(string));
    }

    private void showWarningText(Component component, String string) {
        SwingUtilities.invokeLater(() -> JOptionPane.showInternalMessageDialog(component, string, "jRepWeb", 2));
    }
}

