/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil.complete;

import ch.steph.reputil.complete.ValueEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MainEntry
implements Serializable {
    private long id;
    private int hierarchy;
    private MainEntry parent;
    private List<MainEntry> children;
    private List<long[]> mediPosAndAuthors;
    private List<Long> xrefs;
    private String text;
    private String stat;
    private String repId;
    private int valueCount = 0;
    List<ValueEntry> mediValues;

    public MainEntry(long l, int n, MainEntry mainEntry, String string, String string2) {
        this.id = l;
        this.hierarchy = n;
        this.parent = mainEntry;
        this.text = string;
        int n2 = string2.indexOf(44) + 1;
        int n3 = string2.indexOf(44, n2);
        if (n2 > 0 && n3 > 0 && n3 > n2) {
            this.stat = string2.substring(n2, n3).trim();
        }
    }

    public long getId() {
        return this.id;
    }

    public int getHierarchy() {
        return this.hierarchy;
    }

    public MainEntry getParent() {
        return this.parent;
    }

    public List<MainEntry> getChildren() {
        return this.children;
    }

    public String getText() {
        return this.text;
    }

    public String getStat() {
        return this.stat;
    }

    public List<ValueEntry> getMediValues() {
        return this.mediValues;
    }

    public void clearMediValues() {
        this.mediValues = null;
    }

    public void addChild(MainEntry mainEntry) {
        if (this.children == null) {
            this.children = new ArrayList<MainEntry>();
        }
        this.children.add(mainEntry);
    }

    public String getRepId() {
        return this.repId;
    }

    public void setRepId(String string) {
        this.repId = string;
    }

    public void setValue(int n, int n2, int n3, List<Long> list) {
        if (this.mediValues == null) {
            this.mediValues = new ArrayList<ValueEntry>();
        }
        ++this.valueCount;
        ValueEntry valueEntry = new ValueEntry(n, n2);
        this.mediValues.add(valueEntry);
        if (this.mediPosAndAuthors == null) {
            this.mediPosAndAuthors = new ArrayList<long[]>();
        }
        long[] lArray = new long[list.size() + 1];
        lArray[0] = n2;
        for (int i = 0; i < list.size(); ++i) {
            long l;
            lArray[i + 1] = l = list.get(i).longValue();
        }
        this.mediPosAndAuthors.add(lArray);
    }

    public List<long[]> getMediPosAndAuthors() {
        return this.mediPosAndAuthors;
    }

    public void addXref(long l) {
        if (this.xrefs == null) {
            this.xrefs = new ArrayList<Long>();
        }
        this.xrefs.add(l);
    }

    public List<Long> getXrefs() {
        return this.xrefs;
    }

    public String getRubricId() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.repId);
        stringBuilder.append("  ");
        stringBuilder.append(this.text);
        if (this.valueCount > 0) {
            stringBuilder.append("  [");
            if (this.valueCount < 10) {
                stringBuilder.append(' ');
                stringBuilder.append(this.valueCount);
                stringBuilder.append('.');
            } else {
                if (this.valueCount < 100) {
                    stringBuilder.append('.');
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.valueCount);
                stringBuilder.append(' ');
            }
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    public int getValueCount() {
        return this.valueCount;
    }
}

