/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.reputil.complete;

import ch.steph.apputil.User;
import ch.steph.repdata.MediValues;
import ch.steph.repdata.RepDataPool;
import ch.steph.repdata.Rubric;
import ch.steph.reputil.ReadRubrics;
import ch.steph.reputil.RepUtil;
import ch.steph.reputil.complete.AuthorEntry;
import ch.steph.reputil.complete.MainEntry;
import ch.steph.reputil.complete.MediEntry;
import ch.steph.util.FileCsv;
import ch.steph.util.FileLn;
import ch.steph.util.Log;
import ch.steph.util.TimeProbe;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReadCompleteRubrics
implements ReadRubrics,
Serializable {
    private final String repIdent;
    private final String location;
    private final int repIndex;
    private final boolean doLog;
    private final TimeProbe timeProbe;
    private int loadCount;
    private final Map<Long, MainEntry> mainById;
    private final List<MainEntry> mainList;
    private final Map<Long, MediEntry> mediById;
    private final List<MediEntry> mediList;
    private int[] localMediCount;
    private String[] localMediArray;
    private Map<Long, AuthorEntry> authorsById;
    private List<AuthorEntry> authorsList;
    private Map<String, String> notFound;
    private AuthorEntry nullAuth;

    public ReadCompleteRubrics(String string, String string2, int n, boolean bl, boolean bl2, TimeProbe timeProbe) {
        this.repIdent = string;
        this.location = string2;
        this.repIndex = n;
        this.doLog = bl2;
        this.timeProbe = timeProbe;
        this.loadCount = 0;
        this.mainById = new HashMap<Long, MainEntry>(200000);
        this.mainList = new ArrayList<MainEntry>(50);
        this.mediById = new HashMap<Long, MediEntry>(2000);
        this.mediList = new ArrayList<MediEntry>(2000);
        this.notFound = new HashMap<String, String>();
        this.readMain(bl);
        this.setRepIdRoot();
        this.readMedis();
        this.readExternalAuthors();
        this.readInternalAuthors();
        this.setMediWeight(bl);
        this.adaptMediNames();
        this.readXref();
        this.logNotFound();
    }

    private void readMain(boolean bl) {
        FileCsv fileCsv;
        if (this.mainById.size() == 0 && (fileCsv = RepUtil.openTabbedFile(this.location, "main")).isOpenRead()) {
            List<String> list = fileCsv.readCSVList();
            while (list != null) {
                long l = this.parsePositiveLong(list.get(0));
                int n = this.parsePositiveInteger(list.get(1));
                MainEntry mainEntry = null;
                String string = list.get(5).replace("schl.", "agg.").replace("bess.", "amel.");
                if (n > 0) {
                    long l2 = this.parsePositiveLong(list.get(2));
                    mainEntry = this.mainById.get(l2);
                } else if (!bl) {
                    string = string.toUpperCase();
                }
                String string2 = "";
                if (list.size() > 8) {
                    string2 = list.get(8);
                }
                MainEntry mainEntry2 = new MainEntry(l, n, mainEntry, string, string2);
                if (this.doLog) {
                    this.timeProbe.partEnds(25, "new cr entry");
                }
                if (mainEntry != null) {
                    mainEntry.addChild(mainEntry2);
                    if (this.doLog) {
                        this.timeProbe.partEnds(26, "add cr child");
                    }
                } else {
                    if (n == 0) {
                        this.mainList.add(mainEntry2);
                    } else {
                        Log.write(2, this.getClass().getName(), "no parent and hierarchy > 0. Id: " + mainEntry2.getId() + ", text: " + mainEntry2.getText());
                    }
                    if (this.doLog) {
                        this.timeProbe.partEnds(27, "add cr parent");
                    }
                }
                this.mainById.put(l, mainEntry2);
                ++this.loadCount;
                if (this.loadCount % 1000 == 1) {
                    RepDataPool.getInstance().checkMemory();
                    if (this.doLog) {
                        this.timeProbe.partEnds(23, "load file: mem checked");
                    }
                }
                list = fileCsv.readCSVList();
            }
        }
    }

    private void setRepIdRoot() {
        int n = 1;
        for (MainEntry mainEntry : this.mainList) {
            this.setRepIds(mainEntry, this.repIdent, n, this.mainList.size(), true);
            ++n;
        }
    }

    private void readMedis() {
        if (this.mediById.size() == 0) {
            FileCsv fileCsv = RepUtil.openTabbedFile(this.location, "remid");
            this.mediList.add(new MediEntry(0L, 0, "null"));
            int n = 1;
            if (fileCsv.isOpenRead()) {
                List<String> list = fileCsv.readCSVList();
                while (list != null) {
                    long l = this.parsePositiveLong(list.get(0));
                    MediEntry mediEntry = new MediEntry(l, n, list.get(1));
                    ++n;
                    this.mediById.put(l, mediEntry);
                    this.mediList.add(mediEntry);
                    if (this.doLog) {
                        this.timeProbe.partEnds(28, "new cr medi");
                    }
                    list = fileCsv.readCSVList();
                }
            }
        }
        this.localMediCount = new int[this.mediList.size()];
    }

    private void readInternalAuthors() {
        boolean bl;
        FileCsv fileCsv = RepUtil.openTabbedFile(this.location, "authors");
        int n = 1;
        boolean bl2 = bl = this.authorsById.size() < 2;
        if (fileCsv.isOpenRead()) {
            List<String> list = fileCsv.readCSVList();
            while (list != null) {
                if (list.size() >= 2) {
                    long l = this.parsePositiveLong(list.get(0));
                    AuthorEntry authorEntry = this.authorsById.get(l);
                    if (authorEntry == null) {
                        authorEntry = list.size() < 3 ? new AuthorEntry(l, list.get(1), "", bl) : new AuthorEntry(l, list.get(1), list.get(2), bl);
                        this.authorsById.put(l, authorEntry);
                    }
                    authorEntry.setSortPlace(n++);
                    this.authorsList.add(authorEntry);
                }
                list = fileCsv.readCSVList();
            }
        }
    }

    private void readExternalAuthors() {
        this.authorsById = new HashMap<Long, AuthorEntry>();
        this.authorsList = new ArrayList<AuthorEntry>();
        boolean bl = User.instance().getProperty("noAuthor", true);
        this.nullAuth = new AuthorEntry(0L, "null author", "", bl);
        this.authorsById.put(0L, this.nullAuth);
        List<List<String>> list = RepUtil.getExternalTabbedFile(this.repIdent + "_authors.txt");
        if (list.size() > 0) {
            for (List<String> list2 : list) {
                if (list2.size() < 2) continue;
                long l = this.parsePositiveLong(list2.get(0));
                if (list2.size() < 3) {
                    this.authorsById.put(l, new AuthorEntry(l, list2.get(1), "", true));
                    continue;
                }
                this.authorsById.put(l, new AuthorEntry(l, list2.get(1), list2.get(2), true));
            }
        }
    }

    public boolean hasAuthors() {
        return this.authorsList.size() > 1;
    }

    public List<AuthorEntry> getAuthorsList() {
        return this.authorsList;
    }

    public FileLn getExternalAuthorFile() {
        return RepUtil.getExternalFileWr(this.repIdent + "_authors.txt");
    }

    private List<Long> hasAcceptedAuthors(String string) {
        AuthorEntry authorEntry;
        long l;
        int n;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n2 = 0;
        while ((n = string.indexOf(44, n2)) >= 0) {
            l = this.parsePositiveLong(string.substring(n2, n));
            authorEntry = this.authorsById.get(l);
            if (authorEntry == null) {
                this.notFound.put("a" + l, "setMedi - author not found with id: " + l);
                if (this.nullAuth.isAccepted()) {
                    arrayList.add(l);
                }
            } else if (authorEntry.isAccepted()) {
                arrayList.add(l);
            }
            n2 = n + 1;
        }
        if (n2 <= string.length()) {
            l = this.parsePositiveLong(string.substring(n2));
            authorEntry = this.authorsById.get(l);
            if (authorEntry == null) {
                this.notFound.put("a" + l, "setMedi - author not found with id: " + l);
                if (this.nullAuth.isAccepted()) {
                    arrayList.add(l);
                }
            } else if (authorEntry.isAccepted()) {
                arrayList.add(l);
            }
        }
        return arrayList;
    }

    private int parsePositiveInteger(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') continue;
            n = n * 10 + (c - 48);
        }
        return n;
    }

    private long parsePositiveLong(String string) {
        long l = 0L;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') continue;
            l = l * 10L + (long)(c - 48);
        }
        return l;
    }

    private void setMediWeight(boolean bl) {
        FileCsv fileCsv = RepUtil.openTabbedFile(this.location, "remlist");
        boolean bl2 = User.instance().getProperty("allAuthors", false);
        if (fileCsv.isOpenRead()) {
            List<String> list = fileCsv.readCSVList();
            while (list != null) {
                long l = this.parsePositiveLong(list.get(0));
                long l2 = this.parsePositiveLong(list.get(1));
                int n = this.parsePositiveInteger(list.get(2));
                if (!bl) {
                    ++n;
                }
                MainEntry mainEntry = this.mainById.get(l);
                MediEntry mediEntry = this.mediById.get(l2);
                if (mainEntry == null) {
                    Log.write(2, this.getClass().getName(), "setMediWeight: Entry by Id not found. mainId: " + l + ", mediId: " + l2);
                } else if (mediEntry == null) {
                    Log.write(2, this.getClass().getName(), "setMediWeight: Medi by Id not found. mainId: " + l + ", mediId: " + l2);
                } else {
                    List<Long> list2 = list.size() > 5 && list.get(5).length() > 0 ? this.hasAcceptedAuthors(list.get(5)) : (list.size() > 4 && list.get(4).length() > 0 ? this.hasAcceptedAuthors(list.get(4)) : this.hasAcceptedAuthors("0"));
                    if (list2.size() > 0 || bl2) {
                        mainEntry.setValue(n, mediEntry.getPos(), this.mediList.size(), list2);
                        int n2 = mediEntry.getPos();
                        this.localMediCount[n2] = this.localMediCount[n2] + 1;
                        if (this.doLog) {
                            this.timeProbe.partEnds(29, "set cr medi value");
                        }
                    }
                    if (this.doLog) {
                        this.timeProbe.partEnds(30, "checked cr medi value");
                    }
                }
                list = fileCsv.readCSVList();
            }
        }
    }

    private void adaptMediNames() {
        String[] stringArray = this.getMediArray();
        for (int i = 0; i < this.localMediCount.length; ++i) {
            if (this.localMediCount[i] > 1000) {
                stringArray[i] = stringArray[i].toUpperCase();
                continue;
            }
            if (this.localMediCount[i] <= 100) continue;
            stringArray[i] = Character.toUpperCase(stringArray[i].charAt(0)) + stringArray[i].substring(1);
        }
    }

    private void readXref() {
        FileCsv fileCsv = RepUtil.openTabbedFile(this.location, "xrefs");
        if (fileCsv.isOpenRead()) {
            List<String> list = fileCsv.readCSVList();
            while (list != null) {
                long l = this.parsePositiveLong(list.get(0));
                long l2 = this.parsePositiveLong(list.get(1));
                MainEntry mainEntry = this.mainById.get(l);
                if (mainEntry == null) {
                    this.notFound.put("x" + l, "XRef: main entry with id " + l + " does not exist, XRef ignored");
                } else {
                    mainEntry.addXref(l2);
                }
                if (this.doLog) {
                    this.timeProbe.partEnds(45, "added xref");
                }
                list = fileCsv.readCSVList();
            }
        }
    }

    private void setRepIds(MainEntry mainEntry, String string, int n, int n2, boolean bl) {
        int n3 = 1;
        if (n2 >= 10) {
            n3 = 2;
        }
        if (n2 >= 100) {
            n3 = 3;
        }
        if (n2 >= 1000) {
            n3 = 4;
        }
        if (n2 >= 10000) {
            n3 = 5;
        }
        StringBuilder stringBuilder = new StringBuilder("" + n);
        while (stringBuilder.length() < n3) {
            stringBuilder.insert(0, '0');
        }
        if (bl) {
            stringBuilder.insert(0, string + " ");
        } else {
            stringBuilder.insert(0, string + "-");
        }
        mainEntry.setRepId(stringBuilder.toString());
        if (this.doLog) {
            this.timeProbe.partEnds(31, "set cr rep id");
        }
        if (mainEntry.getChildren() != null) {
            int n4 = 1;
            for (MainEntry mainEntry2 : mainEntry.getChildren()) {
                this.setRepIds(mainEntry2, stringBuilder.toString(), n4, mainEntry.getChildren().size(), false);
                ++n4;
            }
        }
    }

    public String[] getMediArray() {
        if (this.localMediArray == null) {
            this.localMediArray = new String[this.mediList.size()];
            int n = 0;
            for (MediEntry mediEntry : this.mediList) {
                this.localMediArray[n++] = mediEntry.getAbbrev();
            }
            this.localMediArray[0] = null;
        }
        return this.localMediArray;
    }

    @Override
    public List<Rubric> getRepEntries() {
        ArrayList<Rubric> arrayList = new ArrayList<Rubric>();
        String[] stringArray = this.getMediArray();
        for (MainEntry mainEntry : this.mainList) {
            this.buildOneEntry(mainEntry, stringArray, arrayList);
        }
        return arrayList;
    }

    private void buildOneEntry(MainEntry mainEntry, String[] stringArray, List<Rubric> list) {
        if (mainEntry.getChildren() != null || "0".equals(mainEntry.getStat()) || mainEntry.getValueCount() > 0) {
            String string = mainEntry.getRubricId();
            MediValues mediValues = new MediValues(mainEntry.getMediValues());
            Rubric rubric = new Rubric(mainEntry.getId(), this.repIndex, string, mediValues, stringArray);
            mainEntry.clearMediValues();
            list.add(rubric);
            if (this.doLog) {
                this.timeProbe.partEnds(32, "added rubric");
            }
            if (mainEntry.getChildren() != null) {
                int n = list.size();
                for (MainEntry mainEntry2 : mainEntry.getChildren()) {
                    this.buildOneEntry(mainEntry2, stringArray, list);
                }
                if (list.size() == n && mainEntry.getValueCount() == 0) {
                    list.remove(list.size() - 1);
                    if (this.doLog) {
                        this.timeProbe.partEnds(33, "removed rubric");
                    }
                }
            }
        }
    }

    public List<String> getLinkedRubrics(Rubric rubric) {
        MainEntry mainEntry;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (rubric != null && (mainEntry = this.mainById.get(rubric.getCrDbMainEntryIndex())).getXrefs() != null) {
            for (long l : mainEntry.getXrefs()) {
                MainEntry mainEntry2 = this.mainById.get(l);
                if (mainEntry2 == null) continue;
                arrayList.add(mainEntry2.getRepId());
            }
        }
        return arrayList;
    }

    public List<String[]> getMediAndAuthors(Rubric rubric) {
        MainEntry mainEntry;
        List<long[]> list;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        if (rubric != null && (list = (mainEntry = this.mainById.get(rubric.getCrDbMainEntryIndex())).getMediPosAndAuthors()) != null) {
            for (long[] lArray : list) {
                String[] stringArray = new String[2];
                stringArray[0] = "<font face=Arial size=3 color=#0000FF>" + this.getMediArray()[(int)lArray[0]].toLowerCase() + "</font>";
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 1; i < lArray.length; ++i) {
                    if (lArray[i] == 0L) continue;
                    long l = lArray[i];
                    try {
                        stringBuilder.append(this.authorsById.get(l).getName());
                        if (i >= lArray.length - 1) continue;
                        stringBuilder.append(", ");
                        continue;
                    }
                    catch (Exception exception) {
                        Log.write(3, this.getClass().getName(), "No author " + l);
                    }
                }
                if (stringBuilder.length() <= 0) continue;
                stringArray[1] = stringBuilder.toString();
                arrayList.add(stringArray);
            }
        }
        Collections.sort(arrayList, new Comparator<String[]>(){

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                return stringArray[0].compareTo(stringArray2[0]);
            }
        });
        return arrayList;
    }

    private void logNotFound() {
        if (this.notFound.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(this.notFound.values());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            Log.write(3, this.getClass().getName(), string);
        }
    }
}

