/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.servrep;

import ch.steph.apputil.User;
import ch.steph.rep.PanelKeyListener;
import ch.steph.servrep.BrowseHtmPanel;
import ch.steph.util.AppIcon;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;

public class BrowseHtm
extends JFrame
implements PanelKeyListener {
    public static final String BROWSE_NAME = "jRep-Browser";
    private static final long serialVersionUID = 1L;
    private BrowseHtmPanel panelHtm;
    private int startX = 0;
    private int startY = 0;
    private int startW = 0;
    private int startH = 0;

    public BrowseHtm(String string) {
        Log.write(4, this.getClass().getName(), "jRep-Browser start");
        try {
            this.setIconImage(AppIcon.getIconImage(this));
            this.setTitle("jRep-Browser - " + string);
            this.setName(BROWSE_NAME);
            this.startX = User.instance().getProperty("BrowseX", 20);
            this.startY = User.instance().getProperty("BrowseY", 20);
            this.startW = User.instance().getProperty("BrowseW", 640);
            this.startH = User.instance().getProperty("BrowseH", 480);
            this.setBounds(this.startX, this.startY, this.startW, this.startH);
            this.setLayout(new BorderLayout());
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    BrowseHtm.this.exitAction();
                }
            });
            this.panelHtm = new BrowseHtmPanel();
            this.add(this.panelHtm);
            URL uRL = new URL(string);
            this.panelHtm.initPanel(this, uRL);
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "initFrame-Error", exception);
        }
    }

    protected void exitAction() {
        this.setVisible(false);
        Rectangle rectangle = this.getBounds();
        if (rectangle.x != this.startX) {
            User.instance().setProperty("BrowseX", rectangle.x);
        }
        if (rectangle.y != this.startY) {
            User.instance().setProperty("BrowseY", rectangle.y);
        }
        if (rectangle.width != this.startW) {
            User.instance().setProperty("BrowseW", rectangle.width);
        }
        if (rectangle.height != this.startH) {
            User.instance().setProperty("BrowseH", rectangle.height);
        }
        this.dispose();
        Log.write(4, this.getClass().getName(), "jRep-Browser end");
    }

    @Override
    public void mainKeyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void historyChanged(Object object, int n) {
    }

    @Override
    public void copyToClipboard() {
    }
}

