/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.servrep;

import ch.steph.rep.PanelKeyListener;
import ch.steph.servrep.BrowseEditorPane;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

public class BrowseHtmPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private PanelKeyListener parent;
    protected JScrollPane scrollPane;
    private JViewport port;
    protected BrowseEditorPane htmlPanel;
    private KeyListener mainKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            BrowseHtmPanel.this.mainKeyPressed(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }
    };
    protected String documentTitle;
    protected HTMLDocument actDocument;

    public BrowseHtmPanel() {
        super(new BorderLayout());
        this.addKeyListener(this.mainKeyListener);
        this.makeNewPanel();
    }

    private void makeNewPanel() {
        if (this.parent != null) {
            this.parent.setTitle(null);
        }
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        this.scrollPane = new JScrollPane();
        this.port = this.scrollPane.getViewport();
        this.port.addKeyListener(this.mainKeyListener);
        this.scrollPane.addKeyListener(this.mainKeyListener);
        this.htmlPanel = new BrowseEditorPane();
        this.htmlPanel.setEditorKit(new HTMLEditorKit());
        this.port.add(this.htmlPanel);
        this.htmlPanel.setEditable(false);
        this.htmlPanel.addKeyListener(this.mainKeyListener);
        this.htmlPanel.addHyperlinkListener(hyperlinkEvent -> {
            if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
                if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                    HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                    this.actDocument = (HTMLDocument)jEditorPane.getDocument();
                    this.actDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
                } else {
                    URL uRL = this.htmlPanel.getPage();
                    try {
                        this.htmlPanel.setPage(hyperlinkEvent.getURL());
                    }
                    catch (Exception exception) {
                        try {
                            if (uRL != null) {
                                this.htmlPanel.setPage(uRL);
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.htmlPanel.addPropertyChangeListener("document", propertyChangeEvent -> {
            if (propertyChangeEvent.getNewValue() instanceof HTMLDocument) {
                this.actDocument = (HTMLDocument)propertyChangeEvent.getNewValue();
                this.actDocument.addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        BrowseHtmPanel.this.actDocument = (HTMLDocument)documentEvent.getDocument();
                        BrowseHtmPanel.this.documentTitle = (String)BrowseHtmPanel.this.actDocument.getProperty("title");
                        SwingUtilities.invokeLater(() -> {
                            if (BrowseHtmPanel.this.documentTitle != null && BrowseHtmPanel.this.parent != null) {
                                BrowseHtmPanel.this.parent.setTitle(BrowseHtmPanel.this.documentTitle);
                            }
                        });
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                    }
                });
            }
        });
        this.add((Component)this.scrollPane, "Center");
    }

    public void initPanel(PanelKeyListener panelKeyListener, URL uRL) {
        this.parent = panelKeyListener;
        this.show();
        try {
            this.htmlPanel.setPage(uRL);
        }
        catch (Exception exception) {
            Log.write(3, this.getClass().getName(), "initPanel", exception);
        }
    }

    protected void mainKeyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            this.parent.mainKeyPressed(keyEvent);
        }
    }

    @Override
    public void requestFocus() {
        if (this.htmlPanel != null) {
            this.htmlPanel.requestFocus();
        } else if (this.scrollPane != null) {
            this.scrollPane.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public void doPgUp() {
        SwingUtilities.invokeLater(() -> {
            KeyEvent keyEvent = new KeyEvent(this.port.getView(), 401, System.currentTimeMillis(), 0, 33, '\uffff');
            this.port.getView().dispatchEvent(keyEvent);
            this.port.getView().requestFocus();
        });
    }

    public void doPgDown() {
        SwingUtilities.invokeLater(() -> {
            KeyEvent keyEvent = new KeyEvent(this.port.getView(), 401, System.currentTimeMillis(), 0, 34, '\uffff');
            this.port.getView().dispatchEvent(keyEvent);
            this.port.getView().requestFocus();
        });
    }
}

