/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.tableview;

import ch.steph.apputil.StringResource;
import ch.steph.util.FileCsv;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class TableEditModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private int headerLines;
    private List<List<String>> tableValues;

    public TableEditModel(List<List<String>> list, boolean bl) {
        this.tableValues = list;
        this.headerLines = this.getHeaderLineCount();
        if (bl) {
            List<String> list2 = this.getEmptyLine();
            list2.set(0, StringResource.getString("case_result_line"));
            list.add(list2);
        }
    }

    private List<String> getEmptyLine() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.tableValues.get(0).size(); ++i) {
            arrayList.add("");
        }
        return arrayList;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.tableValues.get(n + 1).get(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = (String)object;
        string = this.replaceForbiddenCharacters(string);
        this.tableValues.get(n + 1).set(n2, string);
    }

    @Override
    public int getColumnCount() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        return this.tableValues.get(0).size();
    }

    @Override
    public int getRowCount() {
        if (this.tableValues == null || this.tableValues.size() == 0) {
            return 0;
        }
        return this.tableValues.size() - 1;
    }

    @Override
    public String getColumnName(int n) {
        if (n == 0) {
            return "";
        }
        return this.tableValues.get(0).get(n);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n >= this.headerLines;
    }

    public int getHeaderLines() {
        return this.headerLines;
    }

    public void deleteLine(int n) {
        this.tableValues.remove(n + 1);
        this.headerLines = this.getHeaderLineCount();
        this.fireTableRowsDeleted(n + 1, 0);
    }

    public void addLine(int n) {
        List<String> list = this.getEmptyLine();
        this.tableValues.add(n + 2, list);
        this.headerLines = this.getHeaderLineCount();
        this.fireTableRowsInserted(n + 2, 0);
    }

    public void saveTable(FileCsv fileCsv) {
        for (List<String> list : this.tableValues) {
            fileCsv.writeCSVline(list);
        }
    }

    private String replaceForbiddenCharacters(String string) {
        string = string.replace(';', ',');
        return string;
    }

    private int getHeaderLineCount() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.tableValues.size()) {
            if (!(this.tableValues.get(n2).get(0).startsWith(StringResource.getString("result_c0_r1")) || this.tableValues.get(n2).get(0).startsWith(StringResource.getString("result_c0_r2")) || this.tableValues.get(n2).get(0).startsWith(StringResource.getString("result_c0_r3")))) {
                return n;
            }
            n = n2++;
        }
        return n;
    }
}

