/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.tableview;

import ch.steph.reputil.FontUtil;
import ch.steph.tableview.TableEditModel;
import ch.steph.util.Log;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.JTextComponent;

public class TableEditTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private TableEditModel tableEditModel;
    private boolean tableEdited;

    public TableEditTable(TableEditModel tableEditModel) {
        super(tableEditModel);
        this.tableEditModel = tableEditModel;
        this.setAutoResizeMode(4);
        this.setSelectionMode(0);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setShowGrid(true);
        this.setRowHeight(this.getFont().getSize() + (this.getRowMargin() + 1) * 2 + 2);
        this.setIntercellSpacing(new Dimension(5, 1));
        JTableHeader jTableHeader = this.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.setResizingAllowed(true);
        this.resizeColumns();
        TableColumnModel tableColumnModel = super.getColumnModel();
        for (int i = 0; i < super.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.setCellEditor(new SelectingEditor(new JTextField()));
        }
        this.tableEdited = false;
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
        JLabel jLabel = (JLabel)((Object)tableCellRenderer);
        if (n < this.tableEditModel.getHeaderLines()) {
            jLabel.setBackground(UIManager.getColor("TableHeader.background"));
        } else {
            jLabel.setBackground(UIManager.getColor("Table.background"));
        }
        if (n2 == 0) {
            if (n < this.tableEditModel.getHeaderLines()) {
                jLabel.setHorizontalAlignment(4);
            } else {
                jLabel.setHorizontalAlignment(2);
            }
        } else if (n < this.tableEditModel.getHeaderLines()) {
            jLabel.setHorizontalAlignment(0);
        } else {
            jLabel.setHorizontalAlignment(2);
        }
        return tableCellRenderer;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.tableEditModel != null) {
            this.resizeColumns();
            this.tableEdited = true;
        }
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        super.editingStopped(changeEvent);
        this.resizeColumns();
        this.tableEdited = true;
    }

    public boolean isTableEdited() {
        return this.tableEdited;
    }

    public void setTableEdited(boolean bl) {
        this.tableEdited = bl;
    }

    private void resizeColumns() {
        JTableHeader jTableHeader = this.getTableHeader();
        FontMetrics fontMetrics = this.getFontMetrics(FontUtil.getBoldChangedFont());
        Insets insets = new Insets(1, 1, 1, 1);
        try {
            insets = UIManager.getBorder("TableHeader.cellBorder").getBorderInsets(jTableHeader);
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "UI-Manager problem");
        }
        int n = 4 + 2 * (insets.left + insets.right);
        int n2 = fontMetrics.stringWidth("MMM") + n;
        int n3 = fontMetrics.stringWidth("MMM4567890123456789012345678901234567890") + n;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn;
            if (this.getColumnModel() == null || (tableColumn = this.getColumnModel().getColumn(i)) == null) continue;
            int n4 = n2;
            for (int j = 0; j < this.getRowCount(); ++j) {
                int n5 = fontMetrics.stringWidth((String)this.tableEditModel.getValueAt(j, i));
                if (n5 <= n4) continue;
                n4 = n5;
            }
            if (i != 0 && (n4 += n) > n3) {
                n4 = n3;
            }
            tableColumn.setMinWidth(n2);
            tableColumn.setPreferredWidth(n4);
            if (i == 0) {
                tableColumn.setMaxWidth(n4 + n3);
                continue;
            }
            tableColumn.setMaxWidth(n3);
        }
    }

    class SelectingEditor
    extends DefaultCellEditor {
        public SelectingEditor(JTextField jTextField) {
            super(jTextField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component = super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            if (component instanceof JTextComponent) {
                JTextComponent jTextComponent = (JTextComponent)component;
                jTextComponent.setCaretPosition(jTextComponent.getText().length());
            }
            return component;
        }
    }
}

