/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.tableview;

import ch.steph.apputil.MdiMainFrame;
import ch.steph.apputil.MdiNormalFrame;
import ch.steph.apputil.StringResource;
import ch.steph.apputil.User;
import ch.steph.repui.RepMainMenu;
import ch.steph.reputil.PatientUtil;
import ch.steph.tableview.TableEditModel;
import ch.steph.tableview.TableEditTable;
import ch.steph.util.FileCsv;
import ch.steph.util.FileProcOld;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import ch.steph.util.IconUtil;
import ch.steph.util.Log;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;

public class TableEditWindow
extends MdiNormalFrame {
    private static final long serialVersionUID = 1L;
    protected JScrollPane scrollPane;
    private TableEditModel tableEditModel;
    private TableEditTable tableEditTable;
    private String fileName;
    private static FileFilter csvFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(".csv");
        }

        @Override
        public String getDescription() {
            return "jRep   *.csv";
        }
    };

    public TableEditWindow(String string, List<List<String>> list) {
        super(true, string + " " + StringResource.getString("rubric_title_plus"), 14, "tableEdit");
        this.fileName = string;
        this.initWindow(list, true);
        this.tableEditTable.setTableEdited(true);
    }

    public TableEditWindow(String string, String string2) {
        super(true, string + " " + StringResource.getString("rubric_title_plus"), 14, "tableEdit");
        this.fileName = string;
        ArrayList<List<String>> arrayList = new ArrayList<List<String>>();
        FileCsv fileCsv = new FileCsv();
        try {
            fileCsv.openRead(FileProcedures.nameToUrl(string2).openStream());
            int n = -1;
            List<String> list = fileCsv.readCSVList();
            while (list != null) {
                if (n < 0) {
                    n = list.size();
                } else {
                    while (list.size() < n) {
                        list.add("");
                    }
                }
                arrayList.add(list);
                list = fileCsv.readCSVList();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initWindow(arrayList, false);
    }

    private void initWindow(List<List<String>> list, boolean bl) {
        this.setFrameIcon(IconUtil.getImageIcon(this, "icon/jRepSmall.gif"));
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                Log.write(5, this.getClass().getName(), keyEvent.paramString());
                TableEditWindow.this.mainKeyPressed(keyEvent);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        };
        this.getContentPane().addKeyListener(keyListener);
        this.addKeyListener(keyListener);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridLayout(1, 5));
        JButton jButton = new JButton(StringResource.getString("te_add_line"));
        jButton.addActionListener(actionEvent -> this.addLine());
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jPanel.add(jButton);
        jButton = new JButton(StringResource.getString("te_delete_line"));
        jButton.addActionListener(actionEvent -> this.deleteLine());
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jPanel.add(jButton);
        jButton = new JButton(StringResource.getString("te_clipboard"));
        jButton.addActionListener(actionEvent -> this.copy());
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jPanel.add(jButton);
        jButton = new JButton(StringResource.getString("te_save"));
        jButton.addActionListener(actionEvent -> this.save());
        jButton.setEnabled(true);
        jButton.setMargin(new Insets(2, 2, 2, 2));
        jPanel.add(jButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.scrollPane = new JScrollPane();
        this.scrollPane.addKeyListener(keyListener);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.tableEditModel = new TableEditModel(list, bl);
        this.tableEditTable = new TableEditTable(this.tableEditModel);
        this.tableEditTable.addKeyListener(keyListener);
        this.scrollPane.setViewportView(this.tableEditTable);
    }

    @Override
    public void requestFocus() {
        Log.write(5, this.getClass().getName(), "requestFocus ");
        super.requestFocus();
    }

    public void mainKeyTyped(KeyEvent keyEvent) {
    }

    public void mainKeyPressed(KeyEvent keyEvent) {
        try {
            char c;
            if (!(keyEvent.isConsumed() || keyEvent.isControlDown() || keyEvent.isAltDown() || (c = Character.toUpperCase(keyEvent.getKeyChar())) != '\u001b')) {
                keyEvent.consume();
                this.closeAction();
            }
            if ((c = RepMainMenu.mainMenuGetCtrlChar(keyEvent)) > '\u0000') {
                if (c == 'C') {
                    keyEvent.consume();
                    this.copy();
                } else if (c == 'S') {
                    keyEvent.consume();
                    this.save();
                } else {
                    RepMainMenu.mainMenuActionDone(keyEvent, c);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "mainKey", exception);
        }
    }

    private void copy() {
        int n = User.instance().getProperty("caseResultTyp", 0);
        if (n == 0) {
            this.copyFrameToClipboard();
        } else {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            for (n2 = 0; n2 < this.tableEditModel.getColumnCount(); ++n2) {
                stringBuilder.append(this.tableEditModel.getColumnName(n2));
                stringBuilder.append("\t");
            }
            stringBuilder.append("\n");
            for (n2 = 0; n2 < this.tableEditModel.getRowCount(); ++n2) {
                for (int i = 0; i < this.tableEditModel.getColumnCount(); ++i) {
                    stringBuilder.append(this.tableEditModel.getValueAt(n2, i));
                    stringBuilder.append("\t");
                }
                stringBuilder.append("\n");
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
        }
    }

    private void save() {
        JFileChooser jFileChooser = new JFileChooser(PatientUtil.getActPatDir());
        jFileChooser.addChoosableFileFilter(csvFileFilter);
        jFileChooser.setFileFilter(csvFileFilter);
        jFileChooser.setDialogTitle("Speichere Tabelle");
        File file = FileProcOld.getFile(PatientUtil.getActPatDir(), this.fileName + ".csv");
        if (!file.exists()) {
            file = FileProcOld.getFile(PatientUtil.getActPatDir(), this.fileName);
        }
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(MdiMainFrame.getInstance().getDesktop());
        if (n == 0) {
            FileCsv fileCsv;
            PatientUtil.setActPatDir(jFileChooser.getSelectedFile().getParent());
            Object object = jFileChooser.getSelectedFile().getName();
            if (!((String)object).endsWith(".csv")) {
                object = (String)object + ".csv";
            }
            if ((fileCsv = GetDataFile.getCaseDataWr(FileProcedures.addDirName(PatientUtil.getActPatDir(), (String)object), false)).isOpenWrite()) {
                this.setNewTitle(((String)object).substring(0, ((String)object).length() - ".csv".length()));
                this.tableEditModel.saveTable(fileCsv);
                fileCsv.close();
                this.tableEditTable.setTableEdited(false);
            }
            Log.write(4, this.getClass().getName(), "saved table: " + PatientUtil.getActPatDir() + ", " + (String)object);
        }
    }

    @Override
    public void closeAction() {
        if (this.tableEditTable.isTableEdited()) {
            int n = 0;
            String[] stringArray = new String[]{StringResource.getString("ask_not_saved_3"), StringResource.getString("ask_not_saved_2")};
            int n2 = JOptionPane.showConfirmDialog(MdiMainFrame.getInstance().getDesktop(), stringArray, "jRep", n);
            if (n2 == 0) {
                this.save();
            }
        }
        super.closeAction();
    }

    private void setNewTitle(String string) {
        this.fileName = string;
        this.setTitle(string + " " + StringResource.getString("rubric_title_plus"));
    }

    private void addLine() {
        int n = this.tableEditTable.getSelectedRow();
        this.tableEditModel.addLine(n);
    }

    private void deleteLine() {
        int n = this.tableEditTable.getSelectedRow();
        this.tableEditModel.deleteLine(n);
    }
}

