/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.tableview;

import ch.steph.util.FileCsv;

public class TableToHtml {
    public static final String HTML_START = "<html><head><style type=\"text/css\">body{font-family:sans-serif;}td{text-align:left;vertical-align:top;}</style></head><body>";
    public static final String HTML_END = "</body></html>";

    public static String convert(FileCsv fileCsv) {
        if (fileCsv != null) {
            Object object = "<table>";
            String[] stringArray = fileCsv.readCSVLine();
            while (stringArray != null && ((String)object).length() < 0x100000) {
                object = (String)object + TableToHtml.addLine(stringArray);
                stringArray = fileCsv.readCSVLine();
            }
            object = (String)object + "</table>";
            return object;
        }
        return "";
    }

    private static String addLine(String[] stringArray) {
        Object object = "<tr>";
        for (String string : stringArray) {
            object = (String)object + "<td valign=top>" + TableToHtml.escapeToXmlString(string) + "</td>";
        }
        object = (String)object + "</tr>";
        return object;
    }

    private static String escapeToXmlString(String string) {
        if (string != null && string.length() > 0) {
            string = string.replace("&", "&amp;");
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
            string = string.replace("\"", "&quot;");
        }
        return string;
    }
}

