/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.apputil.StringResource;
import ch.steph.util.FileProcedures;
import ch.steph.util.GetDataFile;
import java.io.File;
import java.net.URL;
import java.util.Date;

public class Constants {
    public static final String APP_NAME = "jRep";
    public static final String APP_VERSION = "6.2";
    public static final int VERSION_KEY = 70;
    public static final int APP_YEAR_TEST = 2025;
    public static final String VERSION_ADDON = ".y";
    public static final String REP_NAME_INT = "Rep";
    public static final String POLAR_NAME = "Polar";
    public static final String REP_NAME_EXT = "Repert";
    public static final String REP_EXPORT = "Rep-Export.csv";
    public static final String ABBR_FILE = "abk-namen";
    public static final String RUBRIC_CHANGE_FILE = "RubricChange";
    public static final String RUBRIC_CHANGE_PRIVATE = "SearchChanged";
    public static final String REP_EXTENSION_FILE = "ExtensionChanged";
    public static final String REP_MEDI_FILE = "ExtensionMedi";
    public static final String APP_HELP = StringResource.getString("app_help");
    public static final String DATA_HELP = StringResource.getString("rep_info");
    public static final String EXTERN_PREFIX = "extern-";
    public static final String MM_INFO = "MM-Info";
    public static final String RUBR_INFO = "rub_info";
    public static final String MM_TEMPLATE = "MM-Template";
    public static final String COPY_LIST = "copylist.txt";
    public static final String FIRST_INI = "first-ini";
    public static final String MEDI_ALL = "arzneien";
    public static final String HELP_FILES = "helpfiles";
    public static final String REP_LINKS = "rep-links";
    public static final String MM_LINKS = "mm-links";
    public static final String NOTE_NAME = "Notiz";
    public static final String NOTE_NO = "note-no-template";
    public static final String NOTE_YES = "note-yes-template";
    public static final String NOTE_KONSULT = "consult-template";
    public static final String PAT_DEFAULT_DIR = "Auswertungen";
    public static final String PAT_DIR0 = StringResource.getString("pat_dir0");
    public static final String PAT_DIR1 = StringResource.getString("pat_dir1");
    public static final String PAT_DIR2 = StringResource.getString("pat_dir2");
    public static final String FORM_DEFAULT_DIR = "Formulare";
    public static final String MM_MEDI = "mm-medi.csv";
    public static final String MM_ADDON = "mmaddon.txt";
    public static final String REP_IDENT_SEPARATOR = " ";
    public static final int REP_IDENT_MIN_LEN = 2;
    public static final String RUBRIC_IDENT_SEPARATOR = "  ";
    public static final String RUBRIC_CHANGE_IDENT = "++";
    public static final String MY_RUBRIC_IDENT = "MyRub";
    public static final String RUBRIC_WITH_NEXT_HIERARCHIE = "+ ";
    public static final char RUBRIC_REP_CHAR = '{';
    public static final String RUBRIC_HIERARCHIC_SEPARATOR = " \u00a6 ";
    public static final int REP_MIN_INDEX = 1;
    public static final int REP_MAX_INT_INDEX = 41;
    public static final int REP_MAX_INDEX = 62;
    public static final boolean ONLY_ONE_SEARCHSTRING = false;
    public static final int REP_MIN_DEFAULT_LOAD = 3;
    public static final int MM_ALL_MEDI = 0;
    public static final int MM_MIN_INDEX = 1;
    public static final int MM_MAX_INT_INDEX = 41;
    public static final int MM_MAX_INDEX = 62;
    public static final String MM_DIR = "mm";
    public static final int PAT_MAX_INDEX = 4;
    public static final String DIR_SEP = "/";
    public static final String DIR_DATA = "jrepdata";
    public static final String DIR_MMA = "jrmma";
    public static final String DIR_RUBR = "rubr";
    public static final String DIR_RUBA = "jruba";
    public static final String DIR_EXMP = "eigene";
    public static final String EXTENSION_CSV_INT = ".jrr";
    public static final String EXTENSION_CSV_EXT = ".csv";
    public static final String EXTENSION_TXT_INT = ".jrt";
    public static final String EXTENSION_TXT_EXT = ".txt";
    public static final String EXTENSION_HTM_INT = ".jrh";
    public static final String EXTENSION_HTM_EXT = ".htm";
    public static final String EXTENSION_RTF = ".rtf";
    public static final String EXTENSION_PDF = ".pdf";
    public static final String EXTENSION_REP = ".rep";
    public static final String EXTENSION_REP_ALL = "*.rep";
    public static final String ADD_TO_EXTENSION = "   *";
    public static final String SDF_DATETIME_PATTERN = "dd.MM.yyyy HH:mm";
    public static final String SDF_DATE_PATTERN = "EE dd.MM.yyyy";
    public static final String SDF_TIME_PATTERN = "HH:mm";
    public static final String EXTENSION_FORM_EXT = ".jform";
    public static final String USER_DATA_DEFAULT = "jRepData";
    public static final String CRYPT_HASH = "S!.Rae$$?";
    public static final String FORM_HASH = "form crypt for jRep";
    public static final int DIFF_NO_DIFF = 99999;
    public static final int MAX_LIST_LEN = 250000;
    public static final int MAX_COPY_LEN = 100;
    public static final int MAX_RESULT_LEN = 2000;
    public static final int RESULT_VALUE_MAX = 99;
    public static final String CASE_DATE_FORMAT = "yyyy-MM-dd";
    public static final String CASE_DATE_PREFIX = "yyyy-MM-dd ";
    public static final int MAX_HIGHLIGHTED = 1000;
    public static String[] imgExt = new String[]{"jpg", "jpeg", "gif", "png", "tif", "tiff"};

    private Constants() {
    }

    public static String getVersion() {
        return APP_VERSION;
    }

    public static String getFullVersion() {
        return "6.2.y";
    }

    public static boolean isEncryptedFile(String string) {
        if (string.toLowerCase().endsWith(EXTENSION_TXT_INT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(EXTENSION_CSV_INT)) {
            return true;
        }
        return string.toLowerCase().endsWith(EXTENSION_HTM_INT);
    }

    public static boolean isKnownTxtFile(String string) {
        if (string.toLowerCase().endsWith(EXTENSION_TXT_INT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(EXTENSION_CSV_INT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(EXTENSION_TXT_EXT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(EXTENSION_CSV_EXT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(EXTENSION_REP)) {
            return true;
        }
        return string.toLowerCase().endsWith(EXTENSION_FORM_EXT);
    }

    public static boolean isKnownHtmFile(String string) {
        if (string.toLowerCase().endsWith(EXTENSION_HTM_INT)) {
            return true;
        }
        if (string.toLowerCase().endsWith(EXTENSION_HTM_EXT)) {
            return true;
        }
        return string.toLowerCase().endsWith(".html");
    }

    public static boolean isKnownRtfFile(String string) {
        return string.toLowerCase().endsWith(EXTENSION_RTF);
    }

    public static boolean isKnownImageFile(String string) {
        for (String string2 : imgExt) {
            if (!string.toLowerCase().endsWith("." + string2)) continue;
            return true;
        }
        return false;
    }

    public static String getImageFileExtensions() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : imgExt) {
            stringBuilder.append(ADD_TO_EXTENSION);
            stringBuilder.append('.');
            stringBuilder.append(string);
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static Date getBuildTime() {
        long l = 0L;
        try {
            Object object;
            URL uRL = ClassLoader.getSystemResource(Constants.class.getName() + ".class");
            if (uRL == null) {
                object = new Object(){}.getClass().getEnclosingClass();
                uRL = ((Class)object).getResource(((Class)object).getSimpleName() + ".class");
            }
            if (uRL != null && (l = FileProcedures.getFileDate(uRL)) == 0L) {
                switch (uRL.getProtocol()) {
                    case "jar": {
                        String string = uRL.getPath();
                        l = FileProcedures.getFile(string.substring(5, string.indexOf("!"))).lastModified();
                        break;
                    }
                    case "zip": {
                        String string = uRL.getPath();
                        l = FileProcedures.getFile(string.substring(0, string.indexOf("!"))).lastModified();
                        break;
                    }
                }
            }
            if (l == 0L && ((File)(object = GetDataFile.getTestFileObject())).exists()) {
                l = ((File)object).lastModified();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Date(l);
    }
}

