/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.util.Base64UrlCoder;
import ch.steph.util.CryptService;
import ch.steph.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public final class CryptBase64Service
implements CryptService {
    private static CryptBase64Service instance;
    private static String lastHash;
    private static final byte[] salt;
    private static final int ITERATIONS = 19;
    private static final String DATA_ENCRIPT_METHOD = "PBEWithSHA1AndDESede";
    private Cipher cipher;
    private Cipher decipher;

    private CryptBase64Service() throws Exception {
        throw new Exception("Initialize only with hash value");
    }

    private CryptBase64Service(String object) throws Exception {
        object = "n3-" + (String)object + "d3v3l0p3r-fr0m";
        char[] cArray = ((String)object).toCharArray();
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray, salt, 19);
        SecretKey secretKey = SecretKeyFactory.getInstance(DATA_ENCRIPT_METHOD).generateSecret(pBEKeySpec);
        this.cipher = Cipher.getInstance(secretKey.getAlgorithm());
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(salt, 19);
        this.cipher.init(1, (Key)secretKey, pBEParameterSpec);
        pBEKeySpec = new PBEKeySpec(cArray, salt, 19);
        secretKey = SecretKeyFactory.getInstance(DATA_ENCRIPT_METHOD).generateSecret(pBEKeySpec);
        this.decipher = Cipher.getInstance(secretKey.getAlgorithm());
        pBEParameterSpec = new PBEParameterSpec(salt, 19);
        this.decipher.init(2, (Key)secretKey, pBEParameterSpec);
    }

    public static synchronized CryptBase64Service getInstance(String string) {
        if (instance == null || !string.equals(lastHash)) {
            lastHash = string;
            try {
                instance = new CryptBase64Service(string);
                Log.write(5, "CryptBase64Service", "init " + lastHash);
            }
            catch (Exception exception) {
                Log.write(2, "CryptService", "init failed cause: ", exception);
            }
        }
        return instance;
    }

    @Override
    public synchronized byte[] encrypt(String string) throws Exception {
        if (string != null && this.cipher != null) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            return this.cipher.doFinal(byArray);
        }
        return null;
    }

    @Override
    public synchronized String decrypt(byte[] byArray) throws Exception {
        if (byArray != null && this.decipher != null) {
            byte[] byArray2 = this.decipher.doFinal(byArray);
            return new String(byArray2, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public synchronized byte[] encryptBytes(byte[] byArray) throws Exception {
        if (byArray != null && this.cipher != null) {
            return this.cipher.doFinal(byArray);
        }
        return null;
    }

    @Override
    public synchronized byte[] decryptBytes(byte[] byArray) throws Exception {
        if (byArray != null && this.decipher != null) {
            return this.decipher.doFinal(byArray);
        }
        return null;
    }

    @Override
    public synchronized String encryptAsString(String string) throws Exception {
        if (string != null && this.cipher != null) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            byte[] byArray2 = this.cipher.doFinal(byArray);
            return new String(Base64UrlCoder.encode(byArray2));
        }
        return null;
    }

    @Override
    public synchronized String decryptFromString(String string) throws Exception {
        if (string != null && this.decipher != null) {
            byte[] byArray = Base64UrlCoder.decode(string);
            byte[] byArray2 = this.decipher.doFinal(byArray);
            return new String(byArray2, StandardCharsets.UTF_8);
        }
        return null;
    }

    public synchronized String encryptAsString(byte[] byArray) throws Exception {
        if (byArray != null && this.cipher != null) {
            byte[] byArray2 = this.cipher.doFinal(byArray);
            return new String(Base64UrlCoder.encode(byArray2));
        }
        return null;
    }

    public synchronized byte[] decryptFromStringAsByte(String string) throws Exception {
        if (string != null && this.decipher != null) {
            byte[] byArray = Base64UrlCoder.decode(string);
            return this.decipher.doFinal(byArray);
        }
        return null;
    }

    static {
        lastHash = "";
        salt = new byte[]{-87, -101, -24, 18, 86, 53, -109, 3};
    }
}

