/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.util.CryptService;
import ch.steph.util.Log;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class CryptHexService
implements CryptService {
    private static CryptHexService instance;
    private static String lastHash;
    private static final String DATA_ENCRIPT_METHOD = "DESede/CBC/PKCS5Padding";
    private static Cipher cipher;
    private static Cipher decipher;

    private CryptHexService() throws Exception {
        throw new Exception("Initialize only with hash value");
    }

    private CryptHexService(String object) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("md5");
        object = (String)object + "CryptHexService";
        byte[] byArray = messageDigest.digest(((String)object).getBytes(StandardCharsets.UTF_8));
        cipher = Cipher.getInstance(DATA_ENCRIPT_METHOD);
        cipher.init(1, (Key)CryptHexService.getSecretKey(byArray), CryptHexService.getIV(cipher.getBlockSize()));
        decipher = Cipher.getInstance(DATA_ENCRIPT_METHOD);
        decipher.init(2, (Key)CryptHexService.getSecretKey(byArray), CryptHexService.getIV(decipher.getBlockSize()));
    }

    private static SecretKey getSecretKey(byte[] byArray) {
        byte[] byArray2 = new byte[24];
        int n = 0;
        while (n < 16) {
            byArray2[n++] = byArray[n++];
        }
        n = 0;
        int n2 = 16;
        while (n < 8) {
            byArray2[n2++] = byArray2[n++];
        }
        return new SecretKeySpec(byArray2, "DESede");
    }

    private static IvParameterSpec getIV(int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return new IvParameterSpec(byArray);
    }

    public static synchronized CryptService getInstance(String string) {
        if (instance == null || !string.equals(lastHash)) {
            lastHash = string;
            try {
                instance = new CryptHexService(string);
                Log.write(5, "CryptHexService", "init " + lastHash);
            }
            catch (Exception exception) {
                Log.write(2, "CryptService", "init failed cause: ", exception);
            }
        }
        return instance;
    }

    @Override
    public synchronized byte[] encrypt(String string) throws Exception {
        if (string != null && cipher != null && decipher != null) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            return cipher.doFinal(byArray);
        }
        return null;
    }

    @Override
    public synchronized String decrypt(byte[] byArray) throws Exception {
        if (byArray != null && cipher != null && decipher != null) {
            byte[] byArray2 = decipher.doFinal(byArray);
            return new String(byArray2, StandardCharsets.UTF_8);
        }
        return null;
    }

    @Override
    public synchronized byte[] encryptBytes(byte[] byArray) throws Exception {
        if (byArray != null && cipher != null && decipher != null) {
            return cipher.doFinal(byArray);
        }
        return null;
    }

    @Override
    public synchronized byte[] decryptBytes(byte[] byArray) throws Exception {
        if (byArray != null && cipher != null && decipher != null) {
            return decipher.doFinal(byArray);
        }
        return null;
    }

    @Override
    public synchronized String encryptAsString(String string) throws Exception {
        if (string != null && cipher != null && decipher != null) {
            byte[] byArray = string.getBytes(StandardCharsets.UTF_8);
            byte[] byArray2 = cipher.doFinal(byArray);
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray2) {
                stringBuilder.append(Integer.toString((by & 0xFF) + 256, 16).substring(1));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    @Override
    public synchronized String decryptFromString(String string) throws Exception {
        if (string != null && cipher != null && decipher != null) {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)Integer.parseInt("" + string.charAt(i * 2) + string.charAt(i * 2 + 1), 16);
            }
            byte[] byArray2 = decipher.doFinal(byArray);
            return new String(byArray2, StandardCharsets.UTF_8);
        }
        return null;
    }

    static {
        lastHash = "";
        cipher = null;
        decipher = null;
    }
}

