/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.repdata.FileSynch;
import ch.steph.util.ConstStr;
import ch.steph.util.Constants;
import ch.steph.util.Fset;
import ch.steph.util.Log;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class FileLn {
    private static final int READ_BUFFER_LEN = 8192;
    private static final int OUT_BUFFER_MIN = 1024;
    private static final int OUT_BUFFER_ADD = 4096;
    protected static final String EMPTY_STRING = "";
    protected static final String LINE_SEPARATOR = ConstStr.LINE_SEPARATOR;
    protected InputStream inStream = null;
    protected OutputStream outStream = null;
    private String fileName;
    protected boolean fset = false;
    protected boolean utf8;
    protected byte[] rdBuffer = new byte[8192];
    protected byte[] outBuffer = new byte[1024];
    protected byte endLnChar;
    protected int rdPtr = 0;
    protected int endPtr = 0;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.fset = Constants.isEncryptedFile(string);
    }

    public String toString() {
        return this.fileName;
    }

    public boolean isUtf8() {
        return this.utf8;
    }

    public void setUtf8(boolean bl) {
        this.utf8 = bl;
    }

    public void close() {
        boolean bl = false;
        try {
            if (this.inStream != null) {
                this.inStream.close();
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Error Close: ", exception);
        }
        try {
            if (this.outStream != null) {
                this.outStream.close();
                bl = true;
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Error Close: ", exception);
        }
        if (this.outBuffer.length > 5120) {
            Log.write(5, this.getClass().getName(), "line bigger than 5120Bytes. Buffer is: " + this.outBuffer.length);
            this.outBuffer = new byte[1024];
        }
        this.rdPtr = 0;
        this.endPtr = 0;
        this.endLnChar = 0;
        this.inStream = null;
        this.outStream = null;
        if (bl && this.fileName != null && this.fileName.length() > 0) {
            FileSynch.instance().checkFile(this.fileName);
        }
        this.fileName = null;
    }

    public boolean openRead(InputStream inputStream) {
        try {
            if (inputStream != null) {
                this.inStream = inputStream;
                if (this.fileName == null) {
                    Log.write(3, this.getClass().getName(), "FileName/Encryption (a) unknown ");
                }
                if (this.fset) {
                    Log.write(5, this.getClass().getName(), "File open read (I): " + this.fileName);
                } else {
                    Log.write(5, this.getClass().getName(), "File open read (n): " + this.fileName);
                }
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Error openRead url: ", exception);
            this.inStream = null;
            return false;
        }
        this.utf8 = true;
        this.endLnChar = 0;
        return true;
    }

    public boolean openReadWithInputString(String string) {
        try {
            if (string != null) {
                this.inStream = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
                if (this.fileName == null) {
                    Log.write(3, this.getClass().getName(), "FileName/Encryption (b) unknown ");
                }
                if (this.fset) {
                    Log.write(5, this.getClass().getName(), "File open read (I): " + this.fileName);
                } else {
                    Log.write(5, this.getClass().getName(), "File open read (n): " + this.fileName);
                }
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Error openRead stream: ", exception);
            this.inStream = null;
            return false;
        }
        this.utf8 = true;
        this.endLnChar = 0;
        return true;
    }

    public boolean openReadWithInputBytes(byte[] byArray) {
        try {
            if (byArray != null) {
                this.inStream = new ByteArrayInputStream(byArray);
                if (this.fileName == null) {
                    Log.write(3, this.getClass().getName(), "FileName/Encryption (c) unknown ");
                }
                if (this.fset) {
                    Log.write(5, this.getClass().getName(), "File open read (I): " + this.fileName);
                } else {
                    Log.write(5, this.getClass().getName(), "File open read (n): " + this.fileName);
                }
            }
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Error openRead stream: ", exception);
            this.inStream = null;
            return false;
        }
        this.utf8 = true;
        this.endLnChar = 0;
        return true;
    }

    public boolean isOpenRead() {
        return this.inStream != null;
    }

    public String readLn() {
        String string;
        Object object;
        byte by = 0;
        byte by2 = 0;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            by2 = by;
            if (this.rdPtr < this.endPtr) {
                by = this.fset ? Fset.changeRead(this.rdBuffer[this.rdPtr]) : this.rdBuffer[this.rdPtr];
            } else {
                try {
                    this.endPtr = this.inStream.read(this.rdBuffer, 0, this.rdBuffer.length - 1);
                }
                catch (Exception exception) {
                    Log.write(5, this.getClass().getName(), "ReadLn", exception);
                    this.endPtr = 0;
                }
                this.rdPtr = 0;
                if (this.endPtr <= 0) {
                    if (n <= 0) {
                        return null;
                    }
                    bl = true;
                } else {
                    by = this.fset ? Fset.changeRead(this.rdBuffer[this.rdPtr]) : this.rdBuffer[this.rdPtr];
                }
            }
            if (this.rdPtr >= this.endPtr) continue;
            if (n == this.outBuffer.length) {
                int n2 = this.outBuffer.length;
                object = this.outBuffer;
                this.outBuffer = new byte[n2 + 4096];
                System.arraycopy(object, 0, this.outBuffer, 0, n2);
            }
            if (this.utf8) {
                if ((by & 0x80) == 128) {
                    if ((by & 0xC0) == 192) {
                        if ((by2 & 0xC0) == 192) {
                            this.utf8 = false;
                        }
                    } else if ((by & 0xC0) == 128) {
                        if ((by2 & 0xC0) == 192) {
                            this.utf8 = true;
                        } else if ((by2 & 0xC0) != 128) {
                            this.utf8 = false;
                        }
                    }
                } else if ((by2 & 0xC0) == 192) {
                    this.utf8 = false;
                }
            }
            switch (by) {
                case 10: 
                case 13: {
                    if (this.endLnChar == 0) {
                        this.endLnChar = by;
                    }
                    if (by != this.endLnChar) break;
                    bl = true;
                    break;
                }
                default: {
                    this.outBuffer[n] = by;
                    ++n;
                }
            }
            ++this.rdPtr;
        }
        try {
            object = StandardCharsets.ISO_8859_1;
            if (this.utf8) {
                object = StandardCharsets.UTF_8;
            }
            string = new String(this.outBuffer, 0, n, (Charset)object);
        }
        catch (Exception exception) {
            Log.write(5, this.getClass().getName(), "ReadLn ret", exception);
            string = EMPTY_STRING;
        }
        return string;
    }

    public String getDataAsString() {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string = this.readLn();
            while (string != null) {
                stringBuilder.append(string).append("\n");
                string = this.readLn();
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            Log.write(5, this.getClass().getName(), "getDataAsString", exception);
            return null;
        }
    }

    public boolean openWrite(OutputStream outputStream) {
        this.outStream = outputStream;
        return true;
    }

    public boolean isOpenWrite() {
        return this.outStream != null;
    }

    public boolean write(String string) {
        try {
            Charset charset = StandardCharsets.ISO_8859_1;
            if (this.utf8) {
                charset = StandardCharsets.UTF_8;
            }
            byte[] byArray = string.getBytes(charset);
            if (this.fset) {
                for (int i = 0; i < byArray.length; ++i) {
                    byArray[i] = Fset.changeWrite(byArray[i]);
                }
            }
            this.outStream.write(byArray);
            return true;
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Error write: ", exception);
            return false;
        }
    }

    public boolean writeLn(String string) {
        try {
            Charset charset = StandardCharsets.ISO_8859_1;
            if (this.utf8) {
                charset = StandardCharsets.UTF_8;
            }
            byte[] byArray = string.getBytes(charset);
            if (this.fset) {
                int n;
                for (n = 0; n < byArray.length; ++n) {
                    byArray[n] = Fset.changeWrite(byArray[n]);
                }
                this.outStream.write(byArray);
                byArray = LINE_SEPARATOR.getBytes();
                for (n = 0; n < byArray.length; ++n) {
                    byArray[n] = Fset.changeWrite(byArray[n]);
                }
                this.outStream.write(byArray);
            } else {
                this.outStream.write(byArray);
                this.outStream.write(LINE_SEPARATOR.getBytes());
            }
            return true;
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Error writeLn: ", exception);
            return false;
        }
    }
}

