/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.util.FileLn;
import ch.steph.util.FileProcedures;
import ch.steph.util.Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

public class FileLnProcedures {
    private static final String CLASS_NAME = "FileLnProcedures";

    private FileLnProcedures() {
    }

    public static FileLn getDiskFileRd(URL uRL) {
        FileLn fileLn = new FileLn();
        if (uRL != null) {
            try {
                fileLn.setFileName(uRL.getFile());
                fileLn.openRead(uRL.openStream());
                Log.write(5, CLASS_NAME, "File open read: " + fileLn.getFileName());
            }
            catch (IOException iOException) {
                Log.write(3, CLASS_NAME, "IOException in: " + fileLn.getFileName());
            }
        }
        return fileLn;
    }

    private static FileLn getDiskFileWr(String string) {
        FileLn fileLn = new FileLn();
        try {
            fileLn.setFileName(string);
            FileOutputStream fileOutputStream = new FileOutputStream(fileLn.getFileName(), false);
            fileLn.openWrite(fileOutputStream);
            Log.write(4, CLASS_NAME, "File open write: " + fileLn.getFileName());
        }
        catch (IOException iOException) {
            Log.write(3, CLASS_NAME, "IOException in: " + fileLn.getFileName());
        }
        return fileLn;
    }

    public static void removeLinesStartingWith(String string, String string2) {
        try {
            Log.write(5, "FileLn", "removeLines path " + string + " starting: " + string2);
            String string3 = string + ".tmp";
            FileProcedures.rename(string, string3);
            FileLn fileLn = FileLnProcedures.getDiskFileRd(FileProcedures.nameToUrl(string3));
            if (fileLn.isOpenRead()) {
                FileLn fileLn2 = FileLnProcedures.getDiskFileWr(string);
                if (fileLn2.isOpenWrite()) {
                    String string4 = fileLn.readLn();
                    while (string4 != null) {
                        if (!string4.startsWith(string2)) {
                            fileLn2.writeLn(string4);
                        }
                        string4 = fileLn.readLn();
                    }
                    fileLn2.close();
                }
                fileLn.close();
                FileProcedures.delete(string3);
            }
        }
        catch (Exception exception) {
            Log.write(4, CLASS_NAME, "removeLinesStartingWith: " + string + ", " + string2, exception);
        }
    }
}

