/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.repdata.FileSynch;
import ch.steph.util.FileLnProcedures;
import ch.steph.util.FileProcedures;
import ch.steph.util.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class FileProcSync {
    public static boolean makeDir(String string) {
        Log.write(5, "FileProcSync", "makeDir " + string);
        boolean bl = FileProcedures.makeDir(string);
        FileSynch.instance().checkFile(string);
        return bl;
    }

    public static boolean makeDir(String string, String string2) {
        Log.write(5, "FileProcSync", "makeDir in " + string + " as " + string2);
        boolean bl = FileProcedures.makeDir(string, string2);
        FileSynch.instance().checkFile(FileProcedures.addDirName(string, string2));
        return bl;
    }

    public static boolean copy(URL uRL, String string, String string2) {
        Log.write(5, "FileProcSync", "copy url " + String.valueOf(uRL) + " to " + string + " as " + string2);
        boolean bl = FileProcedures.copy(uRL, string, string2);
        FileSynch.instance().checkFile(FileProcedures.addDirName(string, string2));
        return bl;
    }

    public static boolean rename(String string, String string2) {
        Log.write(5, "FileProcSync", "rename " + string + " to " + string2);
        boolean bl = FileProcedures.rename(string, string2);
        FileSynch.instance().checkDeleteFile(string);
        FileSynch.instance().checkFile(string2);
        return bl;
    }

    public static boolean delete(String string, String string2) {
        Log.write(5, "FileProcSync", "delete in " + string + " - " + string2);
        boolean bl = FileProcedures.delete(string, string2);
        FileSynch.instance().checkDeleteFile(FileProcedures.addDirName(string, string2));
        return bl;
    }

    public static boolean delete(String string) {
        Log.write(5, "FileProcSync", "delete " + string);
        boolean bl = FileProcedures.delete(string);
        FileSynch.instance().checkDeleteFile(string);
        return bl;
    }

    public static boolean delete(URL uRL) {
        Log.write(5, "FileProcSync", "delete url " + String.valueOf(uRL));
        boolean bl = FileProcedures.delete(uRL);
        FileSynch.instance().checkDeleteFile(FileProcedures.urlToName(uRL));
        return bl;
    }

    public static boolean deleteAll(String string) {
        Log.write(5, "FileProcSync", "delete all " + string);
        boolean bl = true;
        Path path = Paths.get(string, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path2 : directoryStream) {
                    if (FileProcSync.deleteAll(path2.toString())) continue;
                    bl = false;
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!FileProcSync.delete(string)) {
                bl = false;
            }
        } else {
            try {
                if (!Files.isWritable(path)) {
                    File file = path.toFile();
                    file.setWritable(true);
                }
            }
            catch (Exception exception) {
                return false;
            }
            return FileProcSync.delete(string);
        }
        return bl;
    }

    public static void removeLinesStartingWith(String string, String string2) {
        FileLnProcedures.removeLinesStartingWith(string, string2);
        FileSynch.instance().checkFile(string);
    }
}

