/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;

public class FileProcedures {
    private static final char FILE_SEPARATOR = System.getProperty("file.separator").charAt(0);

    private FileProcedures() {
    }

    public static File getFile(String string) {
        return Paths.get(string, new String[0]).toFile();
    }

    public static File getFile(String string, String ... stringArray) {
        return Paths.get(string, stringArray).toFile();
    }

    public static String addDirName(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        if (string.charAt(string.length() - 1) == FILE_SEPARATOR) {
            return string + string2;
        }
        return string + FILE_SEPARATOR + string2;
    }

    public static String addDirName(String string, String string2, String string3) {
        return FileProcedures.addDirName(FileProcedures.addDirName(string, string2), string3);
    }

    public static String addDirName(String string, String string2, String string3, String string4) {
        return FileProcedures.addDirName(FileProcedures.addDirName(FileProcedures.addDirName(string, string2), string3), string4);
    }

    public static String getParentPath(String string) {
        Path path = Paths.get(string, new String[0]);
        return path.getParent().toString();
    }

    public static boolean makeDir(String string) {
        try {
            Files.createDirectory(Paths.get(string, new String[0]), new FileAttribute[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean makeDir(String string, String string2) {
        try {
            Files.createDirectory(Paths.get(string, string2), new FileAttribute[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static URL nameToUrl(String string) {
        URL uRL = null;
        if (string.length() > 0) {
            try {
                if (FileProcedures.exists(string)) {
                    if (FILE_SEPARATOR != '/') {
                        string = string.replace(FILE_SEPARATOR, '/');
                    }
                    uRL = new URL("file", "", string);
                }
            }
            catch (Exception exception) {
                Log.write(5, "FileProcedures", "nameToUrl", exception);
                uRL = null;
            }
        }
        return uRL;
    }

    public static URL nameDirToUrl(String string, String string2) {
        return FileProcedures.nameToUrl(FileProcedures.addDirName(string, string2));
    }

    public static URL nameDirToUrl(String string, String string2, String string3) {
        return FileProcedures.nameToUrl(FileProcedures.addDirName(string, string2, string3));
    }

    public static URL nameDirToUrl(String string, String string2, String string3, String string4) {
        return FileProcedures.nameToUrl(FileProcedures.addDirName(string, string2, string3, string4));
    }

    public static String urlToName(URL uRL) {
        if (uRL != null) {
            try {
                return uRL.getFile().replace('/', FILE_SEPARATOR);
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public static String getFileName(URL uRL) {
        if (uRL != null) {
            int n;
            String string = uRL.getFile();
            if (string.charAt(string.length() - 1) == '/') {
                string = string.substring(0, string.length() - 1);
            }
            if ((n = string.lastIndexOf(47)) > 0) {
                string = string.substring(n + 1);
            }
            return string;
        }
        return "";
    }

    public static String getFileName(String string) {
        return FileProcedures.getFileName(FileProcedures.nameToUrl(string));
    }

    public static URL systemResourceToUrl(String string) {
        try {
            return ClassLoader.getSystemResource(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getUrlAsStringRelativeInJar(URL uRL) {
        String string = "";
        if (uRL != null) {
            String string2 = uRL.toString();
            if (string2.toLowerCase().startsWith("jar:")) {
                int n = string2.toLowerCase().indexOf(".jar!");
                if (n > 0) {
                    string = string2.substring(n + 6);
                }
            } else {
                string = uRL.toString();
            }
        }
        return string;
    }

    public static boolean exists(String string, String string2) {
        return FileProcedures.exists(FileProcedures.addDirName(string, string2));
    }

    public static boolean exists(String string) {
        try {
            File file = new File(string);
            return file.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean canRead(String string) {
        try {
            return Files.isReadable(Paths.get(string, new String[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean copy(String string, String string2) {
        try {
            Files.copy(Paths.get(string, new String[0]), Paths.get(string2, new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean copy(URL uRL, String string) {
        boolean bl;
        block8: {
            InputStream inputStream = uRL.openStream();
            try {
                Files.copy(inputStream, Paths.get(string, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public static boolean copy(URL uRL, String string, String string2) {
        boolean bl;
        block8: {
            InputStream inputStream = uRL.openStream();
            try {
                Files.copy(inputStream, Paths.get(string, string2), StandardCopyOption.REPLACE_EXISTING);
                bl = true;
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            inputStream.close();
        }
        return bl;
    }

    public static long copy(InputStream inputStream, String string) {
        try {
            return Files.copy(inputStream, Paths.get(string, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static boolean rename(String string, String string2) {
        try {
            Files.move(Paths.get(string, new String[0]), Paths.get(string2, new String[0]), new CopyOption[0]);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int countDir(String string) {
        int n = 0;
        for (String string2 : FileProcedures.getDirNames(string)) {
            if (string2.startsWith(".")) continue;
            ++n;
        }
        return n;
    }

    public static boolean delete(String string, String string2) {
        try {
            return Files.deleteIfExists(Paths.get(string, string2));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean delete(String string) {
        try {
            return Files.deleteIfExists(Paths.get(string, new String[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean delete(URL uRL) {
        try {
            return Files.deleteIfExists(Paths.get(FileProcedures.urlToName(uRL), new String[0]));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean deleteAll(String string) {
        boolean bl = true;
        Path path = Paths.get(string, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path);){
                for (Path path2 : directoryStream) {
                    if (FileProcedures.deleteAll(path2.toString())) continue;
                    bl = false;
                }
            }
            catch (IOException iOException) {
                bl = false;
            }
            if (!FileProcedures.delete(string)) {
                bl = false;
            }
        } else {
            try {
                if (!Files.isWritable(path)) {
                    File file = path.toFile();
                    file.setWritable(true);
                }
            }
            catch (Exception exception) {
                return false;
            }
            return FileProcedures.delete(string);
        }
        return bl;
    }

    public static void createAllDir(String string) {
        if (FileProcedures.exists(string)) {
            return;
        }
        try {
            Files.createDirectories(Paths.get(string, new String[0]), new FileAttribute[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static long getFileDate(URL uRL) {
        return FileProcedures.getFileDate(FileProcedures.urlToName(uRL));
    }

    public static long getFileDate(String string, String string2) {
        try {
            return Files.getLastModifiedTime(Paths.get(string, string2), new LinkOption[0]).toMillis();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static long getFileDate(String string) {
        try {
            return Files.getLastModifiedTime(Paths.get(string, new String[0]), new LinkOption[0]).toMillis();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static boolean setFileDate(URL uRL, long l) {
        return FileProcedures.setFileDate(FileProcedures.urlToName(uRL), l);
    }

    public static boolean setFileDate(String string, String string2, long l) {
        try {
            Files.setLastModifiedTime(Paths.get(string, string2), FileTime.fromMillis(l));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean setFileDate(String string, long l) {
        try {
            Files.setLastModifiedTime(Paths.get(string, new String[0]), FileTime.fromMillis(l));
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static long getFileSize(String string, String string2) {
        try {
            return Files.size(Paths.get(string, string2));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long getFileSize(String string) {
        try {
            return Files.size(Paths.get(string, new String[0]));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static long getFileSize(URL uRL) {
        try {
            return Files.size(Paths.get(FileProcedures.urlToName(uRL), new String[0]));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static List<String> getDirNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) throws IOException {
                    return Files.isDirectory(path, new LinkOption[0]);
                }
            };
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path path2 : directoryStream) {
                    arrayList.add(path2.getFileName().toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static List<String> getFileNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) throws IOException {
                    return !Files.isDirectory(path, new LinkOption[0]);
                }
            };
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path path2 : directoryStream) {
                    arrayList.add(path2.getFileName().toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static List<String> getFileNames(String string, final String string2, final String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        if (Files.isDirectory(path, new LinkOption[0])) {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) throws IOException {
                    if (!Files.isDirectory(path, new LinkOption[0])) {
                        String string = path.getFileName().toString();
                        return string.startsWith(string2) && string.endsWith(string3);
                    }
                    return false;
                }
            };
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path, (DirectoryStream.Filter<? super Path>)filter);){
                for (Path path2 : directoryStream) {
                    arrayList.add(path2.getFileName().toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static byte[] getFileContent(String string, String ... stringArray) {
        try {
            return Files.readAllBytes(Paths.get(string, stringArray));
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static byte[] getFileContent(String string) {
        try {
            return Files.readAllBytes(Paths.get(string, new String[0]));
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public static void putFileContent(String string, String string2, byte[] byArray) {
        FileProcedures.putFileContent(FileProcedures.addDirName(string, string2), byArray);
    }

    public static void putFileContent(String string, byte[] byArray) {
        try {
            Files.write(Paths.get(string, new String[0]), byArray, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

