/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.util.FileProcedures;
import ch.steph.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class FileSyncher {
    private static final String PROP_FILE = ".FileSynch.properties";
    private boolean noSynchWhileInit = true;
    private boolean notAgainSynching = true;
    private int directoryLevel = 0;
    private ArrayList<SynchPair> synchList = new ArrayList();
    private ArrayList<String> ignoredFiles = new ArrayList();

    public FileSyncher(boolean bl, boolean bl2, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; i += 2) {
            String string;
            int n = 1;
            SynchPair synchPair = new SynchPair(bl, stringArray[i], stringArray[i + 1]);
            String string2 = synchPair.aDir.getRootUrl().toLowerCase().replace('\\', '/');
            if (string2.startsWith(string = synchPair.bDir.getRootUrl().toLowerCase().replace('\\', '/') + "/")) {
                n = 0;
                Log.write(3, this.getClass().getName(), "No synch in synch from " + stringArray[i] + " to " + stringArray[i + 1]);
            }
            if ((string2 = synchPair.bDir.getRootUrl().toLowerCase().replace('\\', '/')).startsWith(string = synchPair.aDir.getRootUrl().toLowerCase().replace('\\', '/') + "/")) {
                n = 0;
                Log.write(3, this.getClass().getName(), "No synch in synch from " + stringArray[i] + " to " + stringArray[i + 1]);
            }
            if (n != 0) {
                for (SynchPair synchPair2 : this.synchList) {
                    if (!bl2) continue;
                    if (synchPair2.isAffected(synchPair.aDir.rootURL)) {
                        n = 0;
                        Log.write(3, this.getClass().getName(), "No (double) synch from " + stringArray[i] + " to " + stringArray[i + 1]);
                    }
                    if (!synchPair2.isAffected(synchPair.bDir.rootURL)) continue;
                    n = 0;
                    Log.write(3, this.getClass().getName(), "No (double) synch from " + stringArray[i] + " to " + stringArray[i + 1]);
                }
            }
            if (n == 0) continue;
            Log.write(4, this.getClass().getName(), "FileSynchPair from " + stringArray[i] + " to " + stringArray[i + 1]);
            this.synchList.add(synchPair);
        }
        this.ignoredFiles.add(PROP_FILE.toLowerCase());
        Log.write(4, this.getClass().getName(), "No file synch for .FileSynch.properties");
        if (stringArray2 != null) {
            for (String string2 : stringArray2) {
                this.ignoredFiles.add(string2.toLowerCase());
                Log.write(4, this.getClass().getName(), "No file synch for " + string2);
            }
        }
        this.noSynchWhileInit = false;
    }

    public int getSynchDirCount() {
        int n = 0;
        for (SynchPair synchPair : this.synchList) {
            n += synchPair.aDir.checkDirCounter;
            n += synchPair.bDir.checkDirCounter;
        }
        return n;
    }

    public int getSynchFileCount() {
        int n = 0;
        for (SynchPair synchPair : this.synchList) {
            n += synchPair.aDir.checkFileCounter;
            n += synchPair.bDir.checkFileCounter;
        }
        return n;
    }

    public void synchronize() {
        if (this.noSynchWhileInit) {
            return;
        }
        for (SynchPair synchPair : this.synchList) {
            this.notAgainSynching = true;
            synchPair.synchronizeAll();
            synchPair.saveProperties();
            this.notAgainSynching = false;
        }
    }

    public void checkFile(URL uRL) {
        if (this.notAgainSynching) {
            return;
        }
        if (this.noSynchWhileInit) {
            return;
        }
        this.notAgainSynching = true;
        for (SynchPair synchPair : this.synchList) {
            if (!synchPair.isAffected(uRL)) continue;
            synchPair.checkFile(uRL);
            synchPair.saveProperties();
        }
        this.notAgainSynching = false;
    }

    public void checkDeleteFile(String string) {
        if (this.notAgainSynching) {
            return;
        }
        if (this.noSynchWhileInit) {
            return;
        }
        this.notAgainSynching = true;
        for (SynchPair synchPair : this.synchList) {
            synchPair.checkDeleteFile(string);
            synchPair.saveProperties();
        }
        this.notAgainSynching = false;
    }

    private class SynchPair {
        private RootDir aDir;
        private RootDir bDir;
        private boolean masterSlave;

        public SynchPair(boolean bl, String string, String string2) {
            this.masterSlave = bl;
            this.aDir = new RootDir(string);
            this.bDir = new RootDir(string2);
        }

        private boolean isAffected(URL uRL) {
            return this.aDir.isAffected(uRL) || this.bDir.isAffected(uRL);
        }

        private void synchronizeAll() {
            if (this.aDir.rootPath != null && this.bDir.rootPath != null) {
                if (this.masterSlave) {
                    Log.write(4, this.getClass().getName(), "synchronizeDeleteInSrc source: " + this.bDir.rootPath + ", dest: " + this.aDir.rootPath);
                    this.synchronizeDeleteInSrc(this.aDir, this.bDir.rootPath, this.aDir.rootPath);
                    Log.write(4, this.getClass().getName(), "synchronizeAll source: " + this.aDir.rootPath + ", dest: " + this.bDir.rootPath);
                    this.synchronizeAll(this.aDir, this.aDir.rootPath, this.bDir.rootPath);
                    Log.write(4, this.getClass().getName(), this.aDir.toString());
                } else {
                    if (this.aDir.lastSynch != 0L && this.bDir.lastSynch != 0L) {
                        if (this.aDir.lastSynch > this.bDir.lastSynch) {
                            Log.write(4, this.getClass().getName(), "synchronizeDeleteInSrc source: " + this.bDir.rootPath + ", dest: " + this.aDir.rootPath);
                            this.synchronizeDeleteInSrc(this.aDir, this.bDir.rootPath, this.aDir.rootPath);
                        } else if (this.bDir.lastSynch > this.aDir.lastSynch) {
                            Log.write(4, this.getClass().getName(), "synchronizeDeleteInSrc source: " + this.aDir.rootPath + ", dest: " + this.bDir.rootPath);
                            this.synchronizeDeleteInSrc(this.bDir, this.aDir.rootPath, this.bDir.rootPath);
                        } else {
                            Log.write(4, this.getClass().getName(), "synchronizeDeleteInSrc source: " + this.bDir.rootPath + ", dest: " + this.aDir.rootPath);
                            this.synchronizeDeleteInSrc(this.aDir, this.bDir.rootPath, this.aDir.rootPath);
                        }
                    }
                    Log.write(4, this.getClass().getName(), "synchronizeAll source: " + this.aDir.rootPath + ", dest: " + this.bDir.rootPath);
                    this.synchronizeAll(this.aDir, this.aDir.rootPath, this.bDir.rootPath);
                    Log.write(4, this.getClass().getName(), this.aDir.toString());
                    Log.write(4, this.getClass().getName(), "synchronizeAll source: " + this.bDir.rootPath + ", dest: " + this.aDir.rootPath);
                    this.synchronizeAll(this.bDir, this.bDir.rootPath, this.aDir.rootPath);
                    Log.write(4, this.getClass().getName(), this.bDir.toString());
                }
            }
        }

        private void checkFile(URL uRL) {
            if (this.aDir.isAffected(uRL)) {
                String string = FileProcedures.getFileName(uRL);
                String string2 = FileProcedures.getParentPath(FileProcedures.urlToName(uRL));
                String string3 = string2.replace(this.aDir.rootPath, this.bDir.rootPath);
                FileProcedures.createAllDir(string3);
                this.synchOneFile(this.aDir, string2, string3, string);
            } else if (this.bDir.isAffected(uRL)) {
                String string = FileProcedures.getFileName(uRL);
                String string4 = FileProcedures.getParentPath(FileProcedures.urlToName(uRL));
                String string5 = string4.replace(this.bDir.rootPath, this.aDir.rootPath);
                FileProcedures.createAllDir(string5);
                this.synchOneFile(this.bDir, string4, string5, string);
            }
        }

        private void checkDeleteFile(String string) {
            if (!FileProcedures.exists(string)) {
                if (string.startsWith(this.aDir.rootPath)) {
                    String string2 = string.replace(this.aDir.rootPath, this.bDir.rootPath);
                    FileProcedures.delete(string2);
                } else if (string.startsWith(this.bDir.rootPath)) {
                    String string3 = string.replace(this.bDir.rootPath, this.aDir.rootPath);
                    FileProcedures.delete(string3);
                }
            }
        }

        private void synchronizeAll(RootDir rootDir, String string, String string2) {
            if (FileSyncher.this.directoryLevel < 64) {
                File[] fileArray = FileProcedures.getFile(string).listFiles();
                File[] fileArray2 = FileProcedures.getFile(string2).listFiles();
                if (fileArray == null) {
                    return;
                }
                if (fileArray2 == null) {
                    return;
                }
                for (File file : fileArray) {
                    if (this.isIdentical(rootDir, file, fileArray2) || this.ignoreFile(file.getName())) continue;
                    if (file.isDirectory()) {
                        this.synchOneDir(rootDir, string, string2, file.getName());
                        continue;
                    }
                    this.synchOneFile(rootDir, string, string2, file.getName());
                }
                for (File file : fileArray) {
                    String string3 = file.getName();
                    String string4 = FileProcedures.addDirName(string, string3);
                    String string5 = FileProcedures.addDirName(string2, string3);
                    if (!file.isDirectory() || this.ignoreFile(file.getName())) continue;
                    ++FileSyncher.this.directoryLevel;
                    this.synchronizeAll(rootDir, string4, string5);
                    --FileSyncher.this.directoryLevel;
                }
            } else {
                Log.write(3, this.getClass().getName(), "No synch for directory level " + FileSyncher.this.directoryLevel + ", path: " + string);
            }
        }

        private boolean ignoreFile(String string) {
            return FileSyncher.this.ignoredFiles.contains(string.toLowerCase());
        }

        private void synchronizeDeleteInSrc(RootDir rootDir, String string, String string2) {
            File[] fileArray = FileProcedures.getFile(string).listFiles();
            File[] fileArray2 = FileProcedures.getFile(string2).listFiles();
            if (fileArray == null) {
                return;
            }
            if (fileArray2 == null) {
                return;
            }
            for (File file : fileArray) {
                if (file.isDirectory() || this.isInDestList(rootDir, file, fileArray2)) continue;
                this.deleteOneFile(string, string2, file.getName());
                ++rootDir.deleteCounter;
            }
            for (File file : fileArray) {
                if (!file.isDirectory()) continue;
                String string3 = file.getName();
                String string4 = FileProcedures.addDirName(string, string3);
                String string5 = FileProcedures.addDirName(string2, string3);
                if (FileProcedures.exists(string5)) {
                    this.synchronizeDeleteInSrc(rootDir, string4, string5);
                    continue;
                }
                this.deleteOneDir(string4);
            }
        }

        private boolean isIdentical(RootDir rootDir, File file, File[] fileArray) {
            boolean bl = false;
            if (file.isDirectory()) {
                ++rootDir.checkDirCounter;
            } else {
                ++rootDir.checkFileCounter;
            }
            String string = file.getName();
            for (int i = 0; i < fileArray.length && !bl; ++i) {
                if (!fileArray[i].getName().equals(string)) continue;
                if (file.isDirectory()) {
                    bl = true;
                    if (this.isSameDate(fileArray[i], file)) continue;
                    long l = file.lastModified();
                    fileArray[i].setLastModified(l);
                    continue;
                }
                if (fileArray[i].length() != file.length() || !this.isSameDate(fileArray[i], file)) continue;
                bl = true;
            }
            return bl;
        }

        private boolean isInDestList(RootDir rootDir, File file, File[] fileArray) {
            boolean bl = false;
            String string = file.getName();
            for (int i = 0; i < fileArray.length && !bl; ++i) {
                if (!fileArray[i].getName().equals(string)) continue;
                bl = true;
            }
            return bl;
        }

        private boolean isSameDate(File file, File file2) {
            long l = file2.lastModified() - file.lastModified();
            if (l < 0L) {
                l = -1L * l;
            }
            return l < 2000L;
        }

        private void synchOneDir(RootDir rootDir, String string, String string2, String string3) {
            String string4 = FileProcedures.addDirName(string, string3);
            String string5 = FileProcedures.addDirName(string2, string3);
            long l = FileProcedures.getFileDate(string);
            long l2 = FileProcedures.getFileDate(string4);
            FileProcedures.makeDir(string5);
            FileProcedures.setFileDate(string5, l2);
            FileProcedures.setFileDate(string2, l);
            ++rootDir.copyDirCounter;
        }

        private void synchOneFile(RootDir rootDir, String string, String string2, String string3) {
            long l;
            String string4 = FileProcedures.addDirName(string, string3);
            String string5 = FileProcedures.addDirName(string2, string3);
            long l2 = FileProcedures.getFileDate(string4);
            if (l2 > (l = FileProcedures.getFileDate(string5)) || this.masterSlave) {
                long l3 = FileProcedures.getFileDate(string);
                FileProcedures.copy(string4, string5);
                FileProcedures.setFileDate(string5, l2);
                FileProcedures.setFileDate(string2, l3);
                Log.write(5, this.getClass().getName(), "copy to: " + string5);
            } else {
                long l4 = FileProcedures.getFileDate(string);
                FileProcedures.copy(string5, string4);
                FileProcedures.setFileDate(string4, l);
                FileProcedures.setFileDate(string, l4);
                Log.write(5, this.getClass().getName(), "copy to: " + string4);
            }
            ++rootDir.copyFileCounter;
        }

        private void deleteOneFile(String string, String string2, String string3) {
            long l = FileProcedures.getFileDate(string2);
            FileProcedures.delete(string, string3);
            FileProcedures.setFileDate(string, l);
            Log.write(5, this.getClass().getName(), "delete file: " + FileProcedures.addDirName(string, string3));
        }

        private void deleteOneDir(String string) {
            if (!FileProcedures.deleteAll(string)) {
                Log.write(3, this.getClass().getName(), "check and delete dir: " + string);
            } else {
                Log.write(4, this.getClass().getName(), "delete dir: " + string);
            }
        }

        private void saveProperties() {
            if (!this.masterSlave) {
                long l = new Date().getTime();
                this.aDir.saveState(l);
                this.bDir.saveState(l);
            }
        }
    }

    private class RootDir {
        private URL rootURL;
        private String rootPath = null;
        private long lastSynch;
        private int checkDirCounter = 0;
        private int checkFileCounter = 0;
        private int copyDirCounter = 0;
        private int copyFileCounter = 0;
        private int deleteCounter = 0;

        private RootDir(String string) {
            this.rootURL = FileProcedures.nameToUrl(string);
            if (this.rootURL == null) {
                FileProcedures.makeDir(string);
                this.rootURL = FileProcedures.nameToUrl(string);
            }
            try {
                if (this.rootURL != null) {
                    this.rootPath = FileProcedures.urlToName(this.rootURL);
                    Log.write(4, this.getClass().getName(), "Root path: " + this.rootPath);
                    this.lastSynch = this.readPropFile();
                } else {
                    Log.write(4, this.getClass().getName(), "Root url for " + string + " is null");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private String getRootUrl() {
            return this.rootURL.toExternalForm();
        }

        private boolean isAffected(URL uRL) {
            if (uRL != null && uRL.toExternalForm().contains(this.rootURL.toExternalForm())) {
                Log.write(5, this.getClass().getName(), this.rootURL.toExternalForm() + " affects " + uRL.toExternalForm());
                return true;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long readPropFile() {
            File file = FileProcedures.getFile(this.rootPath, FileSyncher.PROP_FILE);
            if (!file.exists()) return 0L;
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                Properties properties = new Properties();
                properties.load(fileInputStream);
                String string = properties.getProperty("LastDate");
                if (string == null) return 0L;
                long l = Long.parseLong(string);
                return l;
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "ini file error", exception);
            }
            return 0L;
        }

        private void saveState(long l) {
            File file = FileProcedures.getFile(this.rootPath, FileSyncher.PROP_FILE);
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                try {
                    Properties properties = new Properties();
                    properties.setProperty("LastDate", "" + l);
                    properties.store(fileOutputStream, "MaxCheckedDate");
                }
                catch (Exception exception) {
                    Log.write(2, this.getClass().getName(), "ini stream error", exception);
                }
            }
            catch (Exception exception) {
                Log.write(2, this.getClass().getName(), "ini write error", exception);
            }
            file.setLastModified(l);
        }

        public String toString() {
            return "RootDir [rootPath=" + this.rootPath + ", lastSynch=" + this.lastSynch + ", checkDirCounter=" + this.checkDirCounter + ", checkFileCounter=" + this.checkFileCounter + ", copyDirCounter=" + this.copyDirCounter + ", copyFileCounter=" + this.copyFileCounter + ", deleteCounter=" + this.deleteCounter + "]";
        }
    }
}

