/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.rep.Rep;
import ch.steph.util.Constants;
import ch.steph.util.FsetHtmlLoader;
import ch.steph.util.FsetRtfLoader;
import ch.steph.util.FsetTextLoader;
import ch.steph.util.Log;
import java.awt.Color;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;

public class FsetJEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private URL loadedUrl = null;

    public void setFsetPage(URL uRL) {
        if (uRL == null) {
            try {
                Document document = this.getDocument();
                document.remove(0, document.getLength());
                this.loadedUrl = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Log.write(5, this.getClass().getName(), "url is null");
            return;
        }
        if (this.loadedUrl != null && this.loadedUrl.sameFile(uRL) && uRL.getRef() != null) {
            this.loadedUrl = uRL;
            Log.write(5, this.getClass().getName(), "same file, but ref " + String.valueOf(this.loadedUrl));
            SwingUtilities.invokeLater(this::loadWithRef);
            return;
        }
        String string = uRL.getFile();
        this.loadedUrl = uRL;
        if (Constants.isKnownTxtFile(string)) {
            Rep.getExecutor().execute(() -> this.setTextDocument());
        } else if (Constants.isKnownHtmFile(string)) {
            Rep.getExecutor().execute(() -> this.setHTMLDocument());
        } else if (Constants.isKnownRtfFile(string)) {
            Rep.getExecutor().execute(() -> this.setRtfDocument());
        } else {
            Rep.getExecutor().execute(() -> this.setNormalDocument());
        }
    }

    protected void setHTMLDocument() {
        try {
            this.setBackground(Color.WHITE);
            this.setContentType("text/html");
            HTMLDocument hTMLDocument = new FsetHtmlLoader().loadDocument(this.loadedUrl);
            this.setDocument(hTMLDocument);
            if (this.loadedUrl.getRef() != null) {
                Log.write(5, this.getClass().getName(), "ref in loaded file " + String.valueOf(this.loadedUrl));
                SwingUtilities.invokeLater(this::loadWithRef);
            } else {
                this.firePropertyChange("page", null, hTMLDocument);
            }
        }
        catch (IOException iOException) {
            Log.write(4, this.getClass().getName(), "HTML-File not loaded: " + String.valueOf(this.loadedUrl));
            this.loadedUrl = null;
            this.firePropertyChange("page", null, "");
        }
    }

    protected void setRtfDocument() {
        try {
            this.setBackground(Color.WHITE);
            this.setContentType("text/rtf");
            StyledDocument styledDocument = new FsetRtfLoader().loadDocument(this.loadedUrl);
            this.setDocument(styledDocument);
            this.firePropertyChange("page", null, styledDocument);
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "RTF-File not loaded: " + String.valueOf(this.loadedUrl));
            this.loadedUrl = null;
            this.firePropertyChange("page", null, "");
        }
    }

    protected void setTextDocument() {
        this.setBackground(Color.WHITE);
        try {
            this.setContentType("text/plain");
            Document document = new FsetTextLoader().loadDocument(this.loadedUrl);
            this.setDocument(document);
            this.firePropertyChange("page", null, document);
        }
        catch (Exception exception) {
            Log.write(4, this.getClass().getName(), "Text-File not loaded: " + String.valueOf(this.loadedUrl));
            this.loadedUrl = null;
            this.firePropertyChange("page", null, "");
        }
    }

    protected void setNormalDocument() {
        this.setBackground(Color.WHITE);
        try {
            super.setPage(this.loadedUrl);
        }
        catch (IOException iOException) {
            Log.write(4, this.getClass().getName(), "X-File not loaded: " + String.valueOf(this.loadedUrl));
            this.loadedUrl = null;
            this.firePropertyChange("page", null, "");
        }
    }

    protected void loadWithRef() {
        try {
            this.getDocument().putProperty("stream", this.loadedUrl);
            super.setPage(this.loadedUrl);
        }
        catch (IOException iOException) {
            Log.write(4, this.getClass().getName(), "LoadWithRef failed: " + String.valueOf(this.loadedUrl));
            this.loadedUrl = null;
            this.firePropertyChange("page", null, "");
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBackground(Color.WHITE);
    }
}

