/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.apputil.User;
import ch.steph.util.ConstStr;
import ch.steph.util.FileCsv;
import ch.steph.util.FileCsvKey;
import ch.steph.util.FileLn;
import ch.steph.util.FileProcSync;
import ch.steph.util.FileProcedures;
import ch.steph.util.Log;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;

public class GetDataFile {
    private static final String USER_HOME = System.getProperty("user.home");
    private static final String USER_DIR = System.getProperty("user.dir");
    private static String userPath = null;
    private static String localDataPath = null;
    private static String propFile = "";
    private static String testFile = "";
    private static String masterFile = "";
    private static String addonProps = "";
    private static GetDataFile instance = null;
    private static final String TEST_FILE = "verserid.bid";
    private static final String PROPERTY_DIR = ".jRep";

    private GetDataFile() {
    }

    private static GetDataFile instance() {
        if (instance == null) {
            instance = new GetDataFile();
            userPath = FileProcedures.exists(USER_HOME) ? (USER_HOME.charAt(USER_HOME.length() - 1) == ConstStr.FILE_SEPARATOR.charAt(0) ? USER_HOME : USER_HOME + ConstStr.FILE_SEPARATOR) : (FileProcedures.exists(USER_DIR) ? (USER_DIR.charAt(USER_DIR.length() - 1) == ConstStr.FILE_SEPARATOR.charAt(0) ? USER_DIR : USER_DIR + ConstStr.FILE_SEPARATOR) : "");
            propFile = userPath + ".jRep.properties";
            masterFile = userPath + "jRepDef.properties";
            testFile = userPath + ".verserid.bid";
            if (userPath.length() < 3) {
                propFile = userPath + "jRep.properties";
                masterFile = userPath + "jRepDef.properties";
                testFile = userPath + TEST_FILE;
                if (FileProcedures.exists("c:\\System\\Data")) {
                    propFile = "c:\\System\\Data\\jRep.properties";
                    masterFile = "c:\\System\\Data\\jRepDef.properties";
                    testFile = "c:\\System\\Data\\verserid.bid";
                }
            } else {
                if (FileProcedures.exists(userPath, "UserData")) {
                    testFile = FileProcedures.addDirName(userPath, "UserData", TEST_FILE);
                } else if (FileProcedures.exists(userPath, "Anwendungsdaten")) {
                    testFile = FileProcedures.addDirName(userPath, "Anwendungsdaten", TEST_FILE);
                } else if (FileProcedures.exists(userPath, "Application Data")) {
                    testFile = FileProcedures.addDirName(userPath, "Application Data", TEST_FILE);
                }
                FileProcedures.makeDir(userPath, PROPERTY_DIR);
                String string = FileProcedures.addDirName(userPath, PROPERTY_DIR);
                if (FileProcedures.exists(string)) {
                    userPath = string;
                    String string2 = FileProcedures.addDirName(string, "jRep.properties");
                    if (FileProcedures.exists(propFile)) {
                        FileProcedures.rename(propFile, string2);
                    }
                    propFile = string2;
                    User.instance().reloadProperties();
                    String string3 = FileProcedures.addDirName(string, "jRepDef.properties");
                    if (FileProcedures.exists(masterFile)) {
                        FileProcedures.rename(masterFile, string3);
                    }
                    masterFile = string3;
                    localDataPath = User.instance().getProperty("DataDir", "");
                    if (localDataPath.length() == 0) {
                        localDataPath = FileProcedures.addDirName(System.getProperty("user.home"), "jRepData");
                        FileProcSync.makeDir(localDataPath);
                        if (FileProcedures.exists(localDataPath)) {
                            User.instance().setProperty("DataDir", localDataPath);
                        }
                    }
                    if (localDataPath.length() > 0) {
                        addonProps = FileProcedures.addDirName(localDataPath, "jRepAddon.properties");
                    }
                }
            }
            Log.write(4, "jRep", "properties in: '" + propFile + "'");
        }
        return instance;
    }

    public static String getUserPath() {
        GetDataFile.instance();
        return userPath;
    }

    public static String getDataPath() {
        GetDataFile.instance();
        return localDataPath;
    }

    public static String getTempRoot() {
        return User.instance().getProperty("tempRoot", "c:\\temp\\");
    }

    public static void setDataPath(String string) {
        File file;
        if (string.length() > 2 && (file = FileProcedures.getFile(string)).isDirectory()) {
            User.instance().setProperty("DataDir", string);
            localDataPath = string;
        }
    }

    public static String getPropertyFile() {
        GetDataFile.instance();
        return propFile;
    }

    public static String getAddonPropertyFile() {
        GetDataFile.instance();
        return addonProps;
    }

    public static String getMasterFile() {
        GetDataFile.instance();
        return masterFile;
    }

    public static String getTestFile() {
        GetDataFile.instance();
        return testFile;
    }

    public static File getTestFileObject() {
        GetDataFile.instance();
        return FileProcedures.getFile(testFile);
    }

    public static FileLn getDataFileRd(URL uRL) {
        GetDataFile.instance();
        FileLn fileLn = new FileLn();
        if (uRL != null) {
            try {
                fileLn.setFileName(uRL.getFile());
                fileLn.openRead(new BufferedInputStream(uRL.openStream()));
            }
            catch (IOException iOException) {
                Log.write(3, instance.getClass().getName(), "IOException in: " + fileLn.getFileName());
            }
        }
        return fileLn;
    }

    public static FileCsv getCsvFileRd(URL uRL) {
        GetDataFile.instance();
        FileCsv fileCsv = new FileCsv();
        if (uRL != null) {
            try {
                fileCsv.setFileName(uRL.getFile());
                fileCsv.openRead(new BufferedInputStream(uRL.openStream()));
            }
            catch (IOException iOException) {
                Log.write(3, instance.getClass().getName(), "IOException in: " + fileCsv.getFileName());
            }
        }
        return fileCsv;
    }

    public static FileCsv getTabbedFileRd(URL uRL) {
        GetDataFile.instance();
        FileCsv fileCsv = new FileCsv('\t');
        if (uRL != null) {
            try {
                fileCsv.setFileName(uRL.getFile());
                fileCsv.openRead(new BufferedInputStream(uRL.openStream()));
            }
            catch (IOException iOException) {
                Log.write(3, instance.getClass().getName(), "IOException in: " + fileCsv.getFileName());
            }
        }
        return fileCsv;
    }

    public static FileCsv getCsvFileWr(String string, boolean bl) {
        GetDataFile.instance();
        FileCsv fileCsv = new FileCsv();
        if (string != null) {
            try {
                fileCsv.setFileName(string);
                fileCsv.openWrite(new FileOutputStream(string, bl));
            }
            catch (IOException iOException) {
                Log.write(3, instance.getClass().getName(), "IOException in: " + fileCsv.getFileName());
            }
        }
        return fileCsv;
    }

    public static FileCsvKey getKeyFileRd(URL uRL) {
        GetDataFile.instance();
        FileCsvKey fileCsvKey = new FileCsvKey();
        if (uRL != null) {
            try {
                fileCsvKey.setFileName(uRL.getFile());
                fileCsvKey.openRead(new BufferedInputStream(uRL.openStream()));
            }
            catch (IOException iOException) {
                Log.write(3, instance.getClass().getName(), "IOException in: " + fileCsvKey.getFileName());
            }
        }
        return fileCsvKey;
    }

    private static FileCsv getDiskFileWr(String string, boolean bl) {
        GetDataFile.instance();
        FileCsv fileCsv = new FileCsv();
        try {
            fileCsv.setFileName(string);
            FileOutputStream fileOutputStream = new FileOutputStream(fileCsv.getFileName(), bl);
            fileCsv.openWrite(fileOutputStream);
        }
        catch (IOException iOException) {
            Log.write(3, instance.getClass().getName(), "IOException in: " + fileCsv.getFileName());
        }
        return fileCsv;
    }

    private static FileCsvKey getDiskKeyFileWr(String string, boolean bl) {
        GetDataFile.instance();
        FileCsvKey fileCsvKey = new FileCsvKey();
        try {
            fileCsvKey.setFileName(string);
            FileOutputStream fileOutputStream = new FileOutputStream(fileCsvKey.getFileName(), bl);
            fileCsvKey.openWrite(fileOutputStream);
        }
        catch (IOException iOException) {
            Log.write(3, instance.getClass().getName(), "IOException in: " + fileCsvKey.getFileName());
        }
        return fileCsvKey;
    }

    public static String getDataDirOrUserPath() {
        String string = GetDataFile.getDataPath();
        String string2 = string != null ? string : GetDataFile.getUserPath();
        return string2;
    }

    public static FileLn getExmpFileRd(String string) {
        URL uRL = FileProcedures.systemResourceToUrl("eigene/" + string);
        return GetDataFile.getDataFileRd(uRL);
    }

    public static FileLn getDataDirFileRd(String string) {
        URL uRL = FileProcedures.systemResourceToUrl("jrepdata/" + string);
        return GetDataFile.getDataFileRd(uRL);
    }

    public static FileCsv getUserDataRd(String string) {
        String string2 = GetDataFile.getUserPath();
        URL uRL = FileProcedures.nameDirToUrl(string2, string);
        return GetDataFile.getCsvFileRd(uRL);
    }

    public static FileCsvKey getCaseDataRd(String string) {
        URL uRL = FileProcedures.nameToUrl(string);
        return GetDataFile.getKeyFileRd(uRL);
    }

    public static FileCsv getCaseDataWr(String string, boolean bl) {
        return GetDataFile.getDiskFileWr(string, bl);
    }

    public static FileLn getRepExportWr() {
        String string = GetDataFile.getDataPath();
        string = string != null ? FileProcedures.addDirName(string, "Rep-Export.csv") : "Rep-Export.csv";
        return GetDataFile.getDiskFileWr(string, false);
    }

    public static FileLn getMmHtmlWr(String string) {
        return GetDataFile.getDiskFileWr(string, false);
    }

    public static FileLn getRubricHtmlWr(String string) {
        return GetDataFile.getDiskFileWr(string, false);
    }

    public static FileLn getNoteFileWr(String string) {
        return GetDataFile.getDiskFileWr(string, false);
    }

    public static FileCsv getFormFileWr(String string) {
        return GetDataFile.getDiskFileWr(string, false);
    }

    public static FileCsv getFormFileRd(String string) {
        URL uRL = FileProcedures.nameToUrl(string);
        return GetDataFile.getCsvFileRd(uRL);
    }

    private static String rubricPublicFileName(int n) {
        String string = GetDataFile.getDataPath();
        if (string != null) {
            String string2 = "RubricChange" + n + ".csv";
            return FileProcedures.addDirName(string, string2);
        }
        return "";
    }

    private static String rubricPrivateFileName(int n, String string) {
        String string2 = GetDataFile.getUserPath();
        String string3 = string + n + ".jrr";
        if (string2.length() > 2) {
            return FileProcedures.addDirName(string2, string3);
        }
        return "";
    }

    public static FileCsvKey getRubricPublicRd(int n) {
        URL uRL = FileProcedures.nameToUrl(GetDataFile.rubricPublicFileName(n));
        return GetDataFile.getKeyFileRd(uRL);
    }

    public static FileCsv getRubricPublicWr(int n) {
        String string = GetDataFile.rubricPublicFileName(n);
        return GetDataFile.getDiskFileWr(string, false);
    }

    public static void removeLinesStartingWithInPublicFile(int n, String string) {
        String string2 = GetDataFile.rubricPublicFileName(n);
        FileProcSync.removeLinesStartingWith(string2, string);
    }

    public static FileCsvKey getRubricPrivateRd(int n, String string) {
        String string2 = GetDataFile.getDataPath();
        if (string2 != null && User.instance().getProperty("externalRubric", true)) {
            URL uRL = FileProcedures.nameToUrl(GetDataFile.rubricPrivateFileName(n, string));
            return GetDataFile.getKeyFileRd(uRL);
        }
        return new FileCsvKey();
    }

    public static FileCsvKey getRubricPrivateWr(int n, String string) {
        String string2 = GetDataFile.rubricPrivateFileName(n, string);
        return GetDataFile.getDiskKeyFileWr(string2, false);
    }

    public static FileCsvKey getMmMediRd() {
        String string = GetDataFile.getUserPath();
        if (string.length() > 2) {
            URL uRL = FileProcedures.nameToUrl(FileProcedures.addDirName(string, "mm-medi.csv"));
            return GetDataFile.getKeyFileRd(uRL);
        }
        return new FileCsvKey();
    }

    public static FileCsvKey getMmMediWr() {
        String string = GetDataFile.getUserPath();
        if (string.length() > 2) {
            String string2 = FileProcedures.addDirName(string, "mm-medi.csv");
            return GetDataFile.getDiskKeyFileWr(string2, false);
        }
        return new FileCsvKey();
    }

    private static String ownRepFileName(int n) {
        String string = GetDataFile.getDataPath();
        if (string != null && n > 41 && User.instance().getProperty("externalRubric", true)) {
            String string2 = "Repert" + (n - 41) + ".csv";
            return FileProcedures.addDirName(string, string2);
        }
        return "";
    }

    public static FileCsvKey getOwnRepRd(int n) {
        URL uRL = FileProcedures.nameToUrl(GetDataFile.ownRepFileName(n));
        return GetDataFile.getKeyFileRd(uRL);
    }

    public static FileCsvKey getOwnRepWr(int n) {
        String string = GetDataFile.ownRepFileName(n);
        return GetDataFile.getDiskKeyFileWr(string, false);
    }
}

