/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.util.FileProcedures;
import ch.steph.util.Log;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class IconUtil {
    public static final String APP_ICON_SMALL = "icon/jRepSmall.gif";
    public static final String START_ICON = "icon/start.jpg";
    public static final String PROG1_ICON = "icon/prog1.jpg";
    public static final String PROG2_ICON = "icon/prog2.jpg";
    public static final String PROG3_ICON = "icon/prog3.jpg";
    public static final String PROG4_ICON = "icon/prog4.jpg";
    public static final String ICON_INPUT = "icon/1.gif";
    public static final String ICON_RUBRIC = "icon/2.gif";
    public static final String ICON_CASE = "icon/3.gif";
    public static final String ICON_CASE_RO = "icon/3-2.gif";
    public static final String ICON_MM = "icon/4.gif";

    public static ImageIcon getImageIcon(Component component, String string) {
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            if (uRL != null) {
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                MediaTracker mediaTracker = new MediaTracker(component);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                    return new ImageIcon(image);
                }
                catch (InterruptedException interruptedException) {
                    Log.write(5, IconUtil.class.getName(), "getImageIcon", interruptedException);
                }
            }
        }
        catch (Exception exception) {
            Log.write(5, IconUtil.class.getName(), "getImageIcon", exception);
        }
        return null;
    }

    public static ImageIcon getImageIconExtern(Component component, URL uRL) {
        try {
            if (uRL != null) {
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                MediaTracker mediaTracker = new MediaTracker(component);
                mediaTracker.addImage(image, 0);
                try {
                    mediaTracker.waitForAll();
                    return new ImageIcon(image);
                }
                catch (InterruptedException interruptedException) {
                    Log.write(5, IconUtil.class.getName(), "getImageIconExtern", interruptedException);
                }
            }
        }
        catch (Exception exception) {
            Log.write(5, IconUtil.class.getName(), "getImageIconExtern", exception);
        }
        return null;
    }

    public static BufferedImage getBufferedImageExtern(URL uRL) {
        try {
            if (uRL != null) {
                try {
                    return ImageIO.read(uRL);
                }
                catch (Exception exception) {
                    Log.write(4, IconUtil.class.getName(), "getBufferedImageExtern", exception);
                }
            }
        }
        catch (Exception exception) {
            Log.write(5, IconUtil.class.getName(), "getImageIconExtern", exception);
        }
        return null;
    }

    public static ImageIcon downsizeImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage != null) {
            return new ImageIcon(IconUtil.downsizeBufferedImage(bufferedImage, n, n2));
        }
        return null;
    }

    public static BufferedImage downsizeBufferedImage(BufferedImage bufferedImage, int n, int n2) {
        if (bufferedImage != null) {
            float f;
            float f2;
            int n3 = bufferedImage.getWidth();
            int n4 = bufferedImage.getHeight();
            boolean bl = false;
            if (n3 > n) {
                f2 = (float)n3 / (float)n;
                n3 = n;
                f = (float)n4 / f2;
                n4 = Float.valueOf(f).intValue();
                bl = true;
            }
            if (n4 > n2) {
                f2 = (float)n4 / (float)n2;
                n4 = n2;
                f = (float)n3 / f2;
                n3 = Float.valueOf(f).intValue();
                bl = true;
            }
            if (bl) {
                BufferedImage bufferedImage2 = new BufferedImage(n3, n4, 1);
                Graphics2D graphics2D = bufferedImage2.createGraphics();
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.drawImage(bufferedImage, 0, 0, n3, n4, null);
                return bufferedImage2;
            }
        }
        return bufferedImage;
    }

    public static boolean saveReduced(BufferedImage bufferedImage, int n, int n2, String string) {
        try {
            String string2 = string.substring(string.length() - 3);
            BufferedImage bufferedImage2 = IconUtil.downsizeBufferedImage(bufferedImage, n, n2);
            File file = FileProcedures.getFile(string);
            ImageIO.write((RenderedImage)bufferedImage2, string2, file);
            return true;
        }
        catch (Exception exception) {
            Log.write(4, IconUtil.class.getName(), "problem save image: ", exception);
            return false;
        }
    }
}

