/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ImageTransferable
implements Transferable {
    private BufferedImage image;

    public ImageTransferable(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return this.image;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor == DataFlavor.imageFlavor;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{DataFlavor.imageFlavor};
    }

    public byte[] getPng() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(byteArrayOutputStream);
        ImageIO.write((RenderedImage)this.image, "png", memoryCacheImageOutputStream);
        return byteArrayOutputStream.toByteArray();
    }
}

