/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.rep.Rep;
import ch.steph.util.FileProcedures;
import ch.steph.util.IniChangeListener;
import ch.steph.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.Vector;

public class IniBase
extends Properties {
    private static final long serialVersionUID = 6904550214994732440L;
    private Vector<IniChangeListener> notifyList;
    private String iniFileName;
    private Object startLock = new Object();

    public IniBase(String string) {
        this.iniFileName = string;
        this.notifyList = new Vector();
        if (this.iniFileName.length() == 0) {
            this.iniFileName = "default.properties";
            Log.write(2, this.getClass().getName(), "No Filename defined");
        }
        try {
            File file = FileProcedures.getFile(this.iniFileName);
            if (file.exists()) {
                if (!file.canRead()) {
                    Log.write(2, this.getClass().getName(), "Test: Can't read file");
                }
                if (!file.canWrite()) {
                    Log.write(2, this.getClass().getName(), "Test: Can't write file");
                }
                FileInputStream fileInputStream = new FileInputStream(this.iniFileName);
                try {
                    this.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    Log.write(2, this.getClass().getName(), "Test: stream read error", exception);
                }
            }
        }
        catch (Exception exception) {
            Log.write(2, this.getClass().getName(), "Test: file read error", exception);
        }
    }

    public void addChangeListener(IniChangeListener iniChangeListener) {
        this.notifyList.addElement(iniChangeListener);
    }

    public void removeChangeListener(IniChangeListener iniChangeListener) {
        this.notifyList.addElement(iniChangeListener);
    }

    public boolean getBoolean(String string, boolean bl) {
        if (!this.containsKey(string)) {
            return bl;
        }
        String string2 = "0";
        if (bl) {
            string2 = "1";
        }
        if ("1".equals(string2 = this.getProperty(string, string2))) {
            return true;
        }
        if ("0".equals(string2)) {
            return false;
        }
        return bl;
    }

    public void setBoolean(String string, boolean bl) {
        if (this.getBoolean(string, !bl) != bl) {
            String string2 = "0";
            if (bl) {
                string2 = "1";
            }
            this.put(string, string2);
            this.saveToDisk();
        }
    }

    public int getInteger(String string, int n) {
        int n2;
        if (!this.containsKey(string)) {
            return n;
        }
        String string2 = Integer.toString(n);
        string2 = this.getProperty(string, string2);
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    public void setInteger(String string, int n) {
        if (this.getInteger(string, n + 1) != n) {
            String string2 = Integer.toString(n);
            this.put(string, string2);
            this.saveToDisk();
            for (int i = 0; i < this.notifyList.size(); ++i) {
                IniChangeListener iniChangeListener = this.notifyList.elementAt(i);
                iniChangeListener.IniItemChanged(string);
            }
        }
    }

    public long getLong(String string, long l) {
        long l2;
        if (!this.containsKey(string)) {
            return l;
        }
        String string2 = Long.toString(l);
        string2 = this.getProperty(string, string2);
        try {
            l2 = Long.parseLong(string2);
        }
        catch (Exception exception) {
            l2 = l;
        }
        return l2;
    }

    public void setLong(String string, long l) {
        if (this.getLong(string, l + 1L) != l) {
            String string2 = Long.toString(l);
            this.put(string, string2);
            this.saveToDisk();
        }
    }

    public String getString(String string, String string2) {
        if (!this.containsKey(string)) {
            return string2;
        }
        return this.getProperty(string, string2);
    }

    public void setString(String string, String string2) {
        if (!this.getString(string, string2 + "-").equals(string2)) {
            this.put(string, string2);
            this.saveToDisk();
            for (int i = 0; i < this.notifyList.size(); ++i) {
                IniChangeListener iniChangeListener = this.notifyList.elementAt(i);
                iniChangeListener.IniItemChanged(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDisk() {
        Object object = this.startLock;
        synchronized (object) {
            Rep.getExecutor().execute(() -> {
                try {
                    Thread.sleep(13L);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.iniFileName);
                    try {
                        this.store(fileOutputStream, "properties");
                        fileOutputStream.flush();
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        Log.write(2, this.getClass().getName(), "saveThread: stream write error", exception);
                    }
                }
                catch (Exception exception) {
                    Log.write(2, this.getClass().getName(), "Test: file write error", exception);
                }
            });
        }
    }
}

