/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.apputil.User;
import ch.steph.util.ConstStr;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    public static final int SEV_DEBUG = 5;
    public static final int SEV_INFO = 4;
    public static final int SEV_WARN = 3;
    public static final int SEV_ERROR = 2;
    public static final int SEV_FATAL = 1;
    private static final String[] SEV_STRING = new String[]{"NONE", "FATAL", "ERROR", "WARN ", "INFO ", "DEBUG"};
    static final String SYS_OUT_DATE_FORMAT = "dd HH:mm:ss";
    private static Log instance = null;
    private int maxSeverity = User.instance().getProperty("LogSeverity", 4);
    private String LogFilePathName = User.instance().getProperty("LogFilePathNameWithoutExt", "");
    private static final int LogFileCount = User.instance().getProperty("LogFileCount", 4);
    private static final int LogFileSize = User.instance().getProperty("LogFileSize", 99999);
    private static final String LOG_EXTENSION = ".log";

    private Log() {
    }

    private static Log instance() {
        if (instance == null) {
            instance = new Log();
        }
        return instance;
    }

    public static void writeSystemConstants(int n, Component component) {
        Log.instance();
        if (n <= Log.instance().maxSeverity) {
            try {
                Runtime.getRuntime().gc();
                Log.write(0, "jRep", "Total Memory:   " + Runtime.getRuntime().totalMemory() / 1024L + " kByte");
                Log.write(0, "jRep", "Free Memory:    " + Runtime.getRuntime().freeMemory() / 1024L + " kByte");
                Log.write(0, "jRep", "Max. Memory:    " + Runtime.getRuntime().maxMemory() / 1024L + " kByte");
                Log.write(0, "jRep", "Processors:     " + Runtime.getRuntime().availableProcessors() + " cores");
                Log.write(0, "jRep", "os.name:        " + System.getProperty("os.name"));
                Log.write(0, "jRep", "os.arch:        " + System.getProperty("os.arch"));
                Log.write(0, "jRep", "os.version:     " + System.getProperty("os.version"));
                Log.write(0, "jRep", "java.vendor:    " + System.getProperty("java.vendor"));
                Log.write(0, "jRep", "java.version:   " + System.getProperty("java.version"));
                Log.write(0, "jRep", "java.home:      " + System.getProperty("java.home"));
                Log.write(0, "jRep", "java.class:     " + System.getProperty("java.class.version"));
                Log.write(0, "jRep", "java.path:      " + System.getProperty("java.class.path"));
                Log.write(0, "jRep", "file.separator: " + System.getProperty("file.separator"));
                Log.write(0, "jRep", "path.separator: " + System.getProperty("path.separator"));
                Log.write(0, "jRep", "user.name:      " + System.getProperty("user.name"));
                Log.write(0, "jRep", "user.home:      " + System.getProperty("user.home"));
                Log.write(0, "jRep", "user.dir:       " + System.getProperty("user.dir"));
                String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i = 0; i < stringArray.length && i < 12; ++i) {
                    Log.write(0, "jRep", "GraphicsEnvironment Fonts:  " + stringArray[i]);
                }
            }
            catch (Error error) {
                Log.write(3, "jRep", "Error in writeSystemConstants: ", error);
            }
            try {
                if (component != null) {
                    Log.write(0, "jRep", "Screensize:     " + String.valueOf(component.getToolkit().getScreenSize()));
                    Log.write(0, "jRep", "Resolution:     " + component.getToolkit().getScreenResolution());
                    Log.write(0, "jRep", "MaximumSize:    " + String.valueOf(component.getMaximumSize()));
                    Log.write(0, "jRep", "Size:           " + String.valueOf(component.getSize()));
                    Log.write(0, "jRep", "MinimumSize:    " + String.valueOf(component.getMinimumSize()));
                    Log.write(0, "jRep", "Bounds:         " + String.valueOf(component.getBounds()));
                    Log.write(0, "jRep", "Font:           " + String.valueOf(component.getFont()));
                }
            }
            catch (Error error) {
                Log.write(3, "jRep", "Error in writeSystemConstants component: ", error);
            }
        }
    }

    public static void write(int n, String string, String string2) {
        Log.instance();
        if (n <= Log.instance().maxSeverity) {
            Log.write(n, string, string2, null);
        }
    }

    public static void writeWithStack(int n, String string, String string2) {
        Log.instance();
        if (n <= Log.instance().maxSeverity) {
            Log.write(n, string, string2, new Exception("stack trace"));
        }
    }

    public static void write(int n, String string, String string2, Throwable throwable) {
        Log.instance();
        if (n <= Log.instance().maxSeverity) {
            String string3 = throwable != null ? Log.instance().getTimeStamp() + " " + Log.instance().getSeverityString(n) + " " + string + " " + string2 + " " + throwable.toString() : Log.instance().getTimeStamp() + " " + Log.instance().getSeverityString(n) + " " + string + " " + string2;
            System.out.println(string3);
            Log.instance().writeLn(string3);
            if (throwable != null) {
                throwable.printStackTrace();
                Log.instance().writeEx(throwable);
            }
        }
    }

    public static void setPath(String string) {
        Log.instance();
        Log.instance().LogFilePathName = string;
        User.instance().setProperty("LogFilePathNameWithoutExt", string);
    }

    public static void stopLogging() {
        Log.instance();
        Log.instance().maxSeverity = 0;
        User.instance().setProperty("LogSeverity", 0);
    }

    public static void setMaxSeverity(int n) {
        Log.instance();
        if (Log.instance().maxSeverity != n) {
            Log.instance().maxSeverity = n;
            User.instance().setProperty("LogSeverity", n);
        }
    }

    public static String getTypeString(int n) {
        Log.instance();
        if (n >= 0 && n <= 5) {
            return SEV_STRING[n];
        }
        return "";
    }

    private String getTimeStamp() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SYS_OUT_DATE_FORMAT);
        return simpleDateFormat.format(new Date());
    }

    private String getSeverityString(int n) {
        if (n < 0 || n >= SEV_STRING.length) {
            n = 0;
        }
        return SEV_STRING[n];
    }

    private void writeLn(String string) {
        if (this.LogFilePathName.length() <= 0) {
            return;
        }
        this.checkFileSize(this.LogFilePathName);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.LogFilePathName + LOG_EXTENSION, true);
            fileOutputStream.write(string.getBytes(StandardCharsets.ISO_8859_1));
            fileOutputStream.write(ConstStr.LINE_SEPARATOR.getBytes());
            fileOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeEx(Throwable throwable) {
        if (this.LogFilePathName.length() <= 0) {
            return;
        }
        this.checkFileSize(this.LogFilePathName);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.LogFilePathName + LOG_EXTENSION, true);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void checkFileSize(String string) {
        block7: {
            try {
                File file;
                File file2 = new File(string + LOG_EXTENSION);
                if (file2.length() <= (long)LogFileSize) break block7;
                try {
                    file2 = new File(string + (LogFileCount - 1) + LOG_EXTENSION);
                    file2.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (int i = LogFileCount - 1; i > 0; --i) {
                    try {
                        file2 = new File(string + i + LOG_EXTENSION);
                        file = new File(string + (i - 1) + LOG_EXTENSION);
                        file.renameTo(file2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                file2 = new File(string + "0.log");
                file = new File(string + LOG_EXTENSION);
                file.renameTo(file2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

