/*
 * Decompiled with CFR 0.152.
 */
package ch.steph.util;

import ch.steph.util.Log;
import ch.steph.util.ZipUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class MemCache {
    private static final long WEEK_SECONDS = 604800L;
    private static final long MONTH_SECONDS = 2678400L;
    private static MemCache[] instance = new MemCache[CacheType.values().length];
    private Hashtable<String, IntObject> cacheService = new Hashtable();
    private CacheType cacheType;
    private long expiration;
    private boolean clone;
    private boolean compress;
    private boolean remove = false;
    private int hitCount = 0;
    private int missCount = 0;
    private int removeRun = 0;
    private int removeCount = 0;

    private MemCache(CacheType cacheType) {
        this.cacheType = cacheType;
        this.expiration = 2678400L;
        this.clone = false;
        this.compress = false;
        switch (cacheType) {
            default: {
                break;
            }
            case SESSION: {
                this.expiration = 604800L;
                break;
            }
            case REP: {
                this.clone = false;
                this.compress = false;
            }
        }
    }

    public static MemCache getInstance(CacheType cacheType) {
        if (instance[cacheType.ordinal()] == null) {
            MemCache.instance[cacheType.ordinal()] = new MemCache(cacheType);
        }
        instance[cacheType.ordinal()].removeOldValues();
        return instance[cacheType.ordinal()];
    }

    public static String getLogString() {
        StringBuilder stringBuilder = new StringBuilder("MemCache Statistics");
        for (CacheType cacheType : CacheType.values()) {
            if (instance[cacheType.ordinal()] == null) continue;
            stringBuilder.append("\n").append(instance[cacheType.ordinal()].getStatisticLog());
        }
        return stringBuilder.toString();
    }

    private String genKey(Object object) {
        return String.valueOf(object) + "-x-" + this.cacheType.name();
    }

    public boolean containsKey(Object object) {
        String string = this.genKey(object);
        return this.cacheService.containsKey(string);
    }

    public Object get(Object object) throws IOException, ClassNotFoundException {
        String string;
        IntObject intObject;
        if (this.remove) {
            this.removeOldValues();
        }
        if ((intObject = this.cacheService.get(string = this.genKey(object))) != null) {
            ++this.hitCount;
            intObject.touch();
            return intObject.getData();
        }
        ++this.missCount;
        return null;
    }

    public synchronized void put(Object object, Object object2) throws IOException {
        if (this.remove) {
            this.removeOldValues();
        }
        IntObject intObject = new IntObject(this.clone, this.compress, this.genKey(object), object2);
        this.cacheService.put(intObject.key, intObject);
    }

    public synchronized void delete(Object object) {
        String string = this.genKey(object);
        this.cacheService.remove(string);
    }

    public int size() {
        return this.cacheService.size();
    }

    public synchronized void removeAll() {
        this.cacheService.clear();
    }

    private synchronized void removeOldValues() {
        long l = new Date().getTime();
        Iterator<String> iterator = this.cacheService.keySet().iterator();
        ++this.removeRun;
        while (iterator.hasNext()) {
            String string = iterator.next();
            IntObject intObject = this.cacheService.get(string);
            if (intObject.touchTime + this.expiration * 1000L >= l) continue;
            iterator.remove();
            ++this.removeCount;
        }
    }

    public synchronized void checkMemory() {
        long l;
        long l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        if (l2 > (l = Runtime.getRuntime().maxMemory()) * 17L / 20L) {
            this.removeOldValues();
            l2 = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            Log.write(5, this.getClass().getName(), "Remove old values. Used mem: " + l2 / 1024L / 1000L + "MB");
        }
    }

    public String getStatisticLog() {
        if (this.cacheService == null) {
            return "not used";
        }
        Iterator<String> iterator = this.cacheService.keySet().iterator();
        int n = 0;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        while (iterator.hasNext()) {
            String string = iterator.next();
            IntObject intObject = this.cacheService.get(string);
            int n4 = intObject.getSize();
            n += n4;
            if (n4 > n2) {
                n2 = n4;
            }
            if (n4 >= n3) continue;
            n3 = n4;
        }
        return this.cacheType.name() + " objects: " + this.cacheService.size() + ", hit: " + this.hitCount + ", missed: " + this.missCount + ", size: " + n + ", max: " + n2 + ", min: " + n3 + ", RemoveRuns: " + this.removeRun + ", removeCount: " + this.removeCount;
    }

    public static enum CacheType implements Serializable
    {
        SESSION,
        PROPERTY,
        REP,
        REP_UTIL,
        RUBRIC_UTIL,
        POLAR;

    }

    private static class IntObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String key;
        public long touchTime;
        private byte[] dataArray;
        private Object dataObject;
        private boolean compress;

        public IntObject(boolean bl, boolean bl2, String string, Object object) throws IOException {
            this.compress = bl2;
            this.key = string;
            this.touchTime = new Date().getTime();
            if (!bl) {
                this.dataObject = object;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(object);
                objectOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream = null;
                objectOutputStream = null;
                this.dataArray = bl2 ? ZipUtil.compressBytesFast(byArray) : byArray;
            }
        }

        public void touch() {
            this.touchTime = new Date().getTime();
        }

        public int getSize() {
            if (this.dataArray != null) {
                return this.dataArray.length;
            }
            return 0;
        }

        public Object getData() throws IOException, ClassNotFoundException {
            Object object = null;
            if (this.dataObject != null) {
                object = this.dataObject;
            } else {
                ByteArrayInputStream byteArrayInputStream = null;
                byteArrayInputStream = this.compress ? new ByteArrayInputStream(ZipUtil.decompressBytes(this.dataArray)) : new ByteArrayInputStream(this.dataArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                object = objectInputStream.readObject();
                objectInputStream.close();
            }
            return object;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof IntObject) {
                IntObject intObject = (IntObject)object;
                return this.key.equalsIgnoreCase(intObject.key);
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

